/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.coloc;

import ch.epfl.biop.coloc.utils.ImageColocalizer;
import ch.epfl.biop.coloc.utils.Utils;
import ch.epfl.biop.montage.StackMontage;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Roi;
import ij.plugin.MontageMaker;
import ij.plugin.PlugIn;
import ij.plugin.StackCombiner;
import ij.plugin.Thresholder;
import ij.plugin.frame.RoiManager;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.imagej.ImageJ;

public class JACoP_B
implements PlugIn {
    private static final String PREFIX = "jacop.b.";
    int nImages;
    int channelA;
    int channelB;
    String thrA;
    String thrB;
    int mThrA;
    int mThrB;
    Boolean doCostesThr = false;
    Boolean doPearsons = false;
    Boolean doSpearmanRank = false;
    Boolean doOverlap = false;
    Boolean doManders = false;
    Boolean doFluorogram = false;
    Boolean doICA = false;
    Boolean doRandomCostes = false;
    Boolean doRandomCostesMask = false;
    Boolean showCostesPlot = false;
    Boolean showCostesRandomImage = false;
    Integer randCostesBlockSize;
    Integer randCostesShuffleNumber;
    File imageFolder = null;
    Boolean doSeparateZ;
    Boolean doCropRois;
    Boolean hasRoiSets = false;
    ImagePlus imp = null;
    private boolean is_stack_hist_z;
    private Roi roi;
    private String imageName;
    private boolean is_montage_vertical;
    private boolean use_advanced;
    private boolean is_auto_fluo = true;
    private int fluo_bins = 256;
    private int fluo_min = 0;
    private int fluo_max = 255;
    int costesBlockSize = 5;
    int costesShufflingNumber = 100;
    boolean set_costes_graph_bounds = false;
    double xmin_costes_graph;
    double xmax_costes_graph;
    boolean hide_masks;
    float stroke_width = 2.0f;

    public void run(String arg) {
        this.nImages = WindowManager.getImageCount();
        if (!this.mainDialog().booleanValue()) {
            return;
        }
        if (this.imageFolder != null) {
            String[] files;
            for (String file : files = this.imageFolder.list()) {
                this.imp = IJ.openImage((String)new File(this.imageFolder, file).getAbsolutePath());
                if ((this.doRandomCostes.booleanValue() || this.doRandomCostesMask.booleanValue()) && this.imp.getNSlices() > 1 && !this.doSeparateZ.booleanValue()) {
                    IJ.error((String)"Costes only works if 'consider Z as separate slices' is checked");
                    continue;
                }
                this.runColoc();
            }
        } else {
            this.imp = IJ.getImage();
            if ((this.doRandomCostes.booleanValue() || this.doRandomCostesMask.booleanValue()) && this.imp.getNSlices() > 1 && !this.doSeparateZ.booleanValue()) {
                IJ.error((String)"Costes only works if 'consider Z as separate slices' is checked");
            } else {
                this.runColoc();
            }
        }
    }

    private void runColoc() {
        RoiManager rm;
        if (this.thrA.matches("Use Manual Threshold Below")) {
            this.thrA = String.valueOf(this.mThrA);
        }
        if (this.thrB.matches("Use Manual Threshold Below")) {
            this.thrB = String.valueOf(this.mThrB);
        }
        if (this.thrA.matches("Costes Auto-Threshold") || this.thrB.matches("Costes Auto-Threshold")) {
            this.doCostesThr = true;
        }
        ArrayList<ImagePlus> results = new ArrayList<ImagePlus>();
        if (this.imp.getRoi() != null) {
            this.roi = (Roi)this.imp.getRoi().clone();
        }
        if ((rm = RoiManager.getInstance()) == null) {
            rm = new RoiManager(false);
        }
        if (rm.getCount() > 0) {
            this.hasRoiSets = true;
        }
        int rcount = rm.getCount() > 0 ? rm.getCount() : 1;
        for (int r = 0; r < rcount; ++r) {
            if (this.hasRoiSets.booleanValue()) {
                this.roi = (Roi)rm.getRoi(r).clone();
            }
            if (this.roi != null) {
                String roiName = this.roi.getName();
                if (roiName == null) {
                    roiName = "ROI";
                }
                this.imageName = this.imp.getTitle() + " (" + roiName + ")";
            } else {
                this.imageName = this.imp.getTitle();
            }
            this.imp.setRoi(this.roi);
            int nT = this.imp.getNFrames();
            for (int t = 1; t <= nT; ++t) {
                ImageColocalizer ic;
                ImagePlus singleTimeImp = Utils.cropTime(this.imp, this.roi, t, this.doCropRois);
                if (this.roi != null && this.doCropRois.booleanValue()) {
                    this.roi = (Roi)singleTimeImp.getRoi().clone();
                }
                ImagePlus[] zImages = Utils.cropSlices(singleTimeImp, this.roi, this.doSeparateZ);
                int thrAH = 0;
                int thrBH = 0;
                if (this.is_stack_hist_z) {
                    ic = new ImageColocalizer(singleTimeImp, this.channelA, this.channelB);
                    if (this.doCostesThr.booleanValue()) {
                        ic.CostesAutoThr();
                    } else {
                        ic.setThresholds(this.thrA, this.thrB);
                    }
                    thrAH = ic.getThresholdA();
                    thrBH = ic.getThresholdB();
                    IJ.log((String)("Stack Histogram Threshold B Set: " + this.thrB));
                    IJ.log((String)("Calculated Stack Histogram Threshold B: " + thrBH));
                    ic.removeLastRow();
                }
                ImageStack res = null;
                ImagePlus tmp = null;
                for (int i = 0; i < zImages.length; ++i) {
                    if (this.roi != null) {
                        this.roi.setPosition(0);
                        zImages[i].setRoi(this.roi);
                    }
                    ic = new ImageColocalizer(zImages[i], this.channelA, this.channelB);
                    if (this.doCostesThr.booleanValue()) {
                        ic.CostesAutoThr();
                    } else {
                        ic.setThresholds(this.thrA, this.thrB);
                    }
                    if (this.is_stack_hist_z) {
                        ic.setThresholds(thrAH, thrBH);
                        ic.addResult("Using Stack Histogram", "True");
                    } else {
                        ic.addResult("Using Stack Histogram", "False");
                    }
                    tmp = this.runAnalysis(ic);
                    if (i == 0) {
                        res = tmp.createEmptyStack();
                    }
                    if (zImages.length > 1) {
                        res.addSlice(tmp.getProcessor());
                    } else {
                        res = tmp.getStack();
                    }
                    ic.addResult("Timepoint", t);
                    if (zImages.length > 1) {
                        ic.addResult("Slice", i + 1);
                    }
                    ic.showResults();
                }
                tmp = new ImagePlus(tmp.getTitle(), res);
                results.add(tmp);
            }
        }
        for (ImagePlus i : results) {
            i.show();
        }
    }

    private ImagePlus runAnalysis(ImageColocalizer ic) {
        ImagePlus montage;
        ImagePlus resizedImg;
        ImageProcessor resizedProcessor;
        if (this.doPearsons.booleanValue()) {
            ic.Pearson();
        }
        if (this.doSpearmanRank.booleanValue()) {
            ic.SpearmanRank();
        }
        if (this.doManders.booleanValue()) {
            ic.MM();
        }
        if (this.doOverlap.booleanValue()) {
            ic.Overlap();
        }
        if (this.doICA.booleanValue()) {
            ic.ICA();
        }
        if (this.doFluorogram.booleanValue()) {
            ic.CytoFluo();
        }
        if (this.doRandomCostes.booleanValue()) {
            ic.RandomCostes2D(false, this.costesBlockSize, this.costesShufflingNumber, this.showCostesPlot, this.showCostesRandomImage, this.set_costes_graph_bounds, this.xmin_costes_graph, this.xmax_costes_graph);
        }
        if (this.doRandomCostesMask.booleanValue()) {
            ic.RandomCostes2D(true, this.costesBlockSize, this.costesShufflingNumber, this.showCostesPlot, this.showCostesRandomImage, this.set_costes_graph_bounds, this.xmin_costes_graph, this.xmax_costes_graph);
        }
        ic.Areas();
        int rows = -1;
        int columns = -1;
        ArrayList<ImagePlus> imgs = new ArrayList<ImagePlus>();
        if (this.is_montage_vertical) {
            rows = 3;
            columns = 2;
            imgs.add(ic.getRGBImageA(false, this.stroke_width));
            if (!this.hide_masks) {
                imgs.add(ic.getRGBMaskA(this.stroke_width));
            }
            imgs.add(ic.getRGBImageB(false, this.stroke_width));
            if (!this.hide_masks) {
                imgs.add(ic.getRGBMaskB(this.stroke_width));
            }
            imgs.add(ic.getRGBColocImage(this.stroke_width));
            if (!this.hide_masks) {
                imgs.add(ic.getRGBANDMask(this.stroke_width));
            }
            if (this.showCostesRandomImage.booleanValue() && this.doRandomCostes.booleanValue()) {
                imgs.add(ic.getRGBImage(ic.randomCostesExampleShuffledImg, false, this.stroke_width));
            }
            if (this.showCostesRandomImage.booleanValue() && this.doRandomCostesMask.booleanValue() && !this.hide_masks) {
                imgs.add(ic.getRGBImage(ic.randomCostesMaskExampleShuffledImg, false, this.stroke_width));
            }
            if (this.showCostesPlot.booleanValue() && this.doRandomCostes.booleanValue()) {
                resizedProcessor = ic.randomCostesPlot.getProcessor().resize(ic.getRGBMaskA(this.stroke_width).getWidth(), ic.getRGBMaskA(this.stroke_width).getHeight(), true);
                resizedImg = new ImagePlus();
                resizedProcessor.invert();
                resizedProcessor.setColor(Color.WHITE);
                resizedProcessor.setLineWidth(3);
                resizedProcessor.drawString("Mask", 0, 0);
                resizedImg.setProcessor(resizedProcessor);
                imgs.add(resizedImg);
            }
            if (this.showCostesPlot.booleanValue() && this.doRandomCostesMask.booleanValue()) {
                resizedProcessor = ic.randomCostesMaskPlot.getProcessor().resize(ic.getRGBMaskA(this.stroke_width).getWidth(), ic.getRGBMaskA(this.stroke_width).getHeight(), true);
                resizedImg = new ImagePlus();
                resizedProcessor.invert();
                resizedProcessor.setColor(Color.WHITE);
                resizedProcessor.setLineWidth(3);
                resizedProcessor.drawString("Mask", 50, 50);
                resizedImg.setProcessor(resizedProcessor);
                imgs.add(resizedImg);
            }
            if (this.showCostesPlot.booleanValue()) {
                ++rows;
            }
            if (this.showCostesRandomImage.booleanValue()) {
                ++rows;
            }
        } else {
            columns = 3;
            rows = 2;
            if (this.hide_masks) {
                rows = 1;
            }
            imgs.add(ic.getRGBImageA(false, this.stroke_width));
            imgs.add(ic.getRGBImageB(false, this.stroke_width));
            imgs.add(ic.getRGBColocImage(this.stroke_width));
            if (this.showCostesRandomImage.booleanValue() && this.doRandomCostes.booleanValue()) {
                imgs.add(ic.getRGBImage(ic.randomCostesExampleShuffledImg, false, this.stroke_width));
            }
            if (this.showCostesPlot.booleanValue() && this.doRandomCostes.booleanValue()) {
                resizedProcessor = ic.randomCostesPlot.getProcessor().resize(ic.getRGBMaskA(this.stroke_width).getWidth(), ic.getRGBMaskA(this.stroke_width).getHeight(), true);
                resizedImg = new ImagePlus();
                resizedProcessor.invert();
                resizedProcessor.setColor(Color.WHITE);
                resizedProcessor.setLineWidth(3);
                resizedProcessor.drawString("No Mask", 50, 50);
                resizedImg.setProcessor(resizedProcessor);
                imgs.add(resizedImg);
            }
            if (!this.hide_masks) {
                imgs.add(ic.getRGBMaskA(this.stroke_width));
                imgs.add(ic.getRGBMaskB(this.stroke_width));
                imgs.add(ic.getRGBANDMask(this.stroke_width));
                if (this.showCostesRandomImage.booleanValue() && this.doRandomCostesMask.booleanValue()) {
                    imgs.add(ic.getRGBImage(ic.randomCostesMaskExampleShuffledImg, false, this.stroke_width));
                }
            }
            if (this.showCostesPlot.booleanValue() && this.doRandomCostesMask.booleanValue()) {
                resizedProcessor = ic.randomCostesMaskPlot.getProcessor().resize(ic.getRGBMaskA(this.stroke_width).getWidth(), ic.getRGBMaskA(this.stroke_width).getHeight(), true);
                resizedImg = new ImagePlus();
                resizedProcessor.invert();
                resizedProcessor.setColor(Color.WHITE);
                resizedProcessor.setLineWidth(3);
                resizedProcessor.drawString("Mask", 50, 50);
                resizedImg.setProcessor(resizedProcessor);
                imgs.add(resizedImg);
            }
            if (this.showCostesPlot.booleanValue()) {
                ++columns;
            }
            if (this.showCostesRandomImage.booleanValue()) {
                ++columns;
            }
        }
        if (((ImagePlus)imgs.get(0)).getNSlices() == 1) {
            ImageStack montagestk = ((ImagePlus)imgs.get(0)).createEmptyStack();
            for (ImagePlus i : imgs) {
                montagestk.addSlice(i.getProcessor());
            }
            MontageMaker mm = new MontageMaker();
            montage = mm.makeMontage2(new ImagePlus("for montage", montagestk), columns, rows, 1.0, 1, imgs.size(), 1, 0, false);
        } else {
            montage = StackMontage.montageImages(imgs, (int)rows, (int)columns);
        }
        if (this.doFluorogram.booleanValue()) {
            ImagePlus fluo = this.is_auto_fluo ? ic.getFluorogramImage() : ic.getFluorogramImage(this.fluo_bins, this.fluo_min, this.fluo_max);
            ImagePlus scaledFluo = this.is_montage_vertical ? Utils.scale(fluo, montage.getWidth()) : Utils.scale(fluo, montage.getHeight());
            ImageStack flst = scaledFluo.getStack();
            for (int i = 1; i < montage.getStackSize(); ++i) {
                flst.addSlice(scaledFluo.getProcessor().duplicate());
            }
            scaledFluo.setStack(flst);
            StackCombiner sc = new StackCombiner();
            ImageStack montagefluo = this.is_montage_vertical ? sc.combineVertically(montage.getStack(), scaledFluo.getStack()) : sc.combineHorizontally(montage.getStack(), scaledFluo.getStack());
            montage = new ImagePlus(this.imageName + " Report", montagefluo);
        }
        montage.setTitle(this.imageName + " Report");
        return montage;
    }

    private Boolean mainDialog() {
        if (this.nImages == 0) {
            this.imageFolder = new File(Prefs.get((String)"jacop.b.imagefolder", (String)""));
        }
        this.channelA = (int)Prefs.get((String)"jacop.b.channelA", (double)1.0);
        this.channelB = (int)Prefs.get((String)"jacop.b.channelB", (double)1.0);
        this.thrA = Prefs.get((String)"jacop.b.thrA", (String)"Otsu");
        this.thrB = Prefs.get((String)"jacop.b.thrB", (String)"Otsu");
        this.mThrA = (int)Prefs.get((String)"jacop.b.mThrA", (double)0.0);
        this.mThrB = (int)Prefs.get((String)"jacop.b.mThrB", (double)0.0);
        this.costesBlockSize = Prefs.getInt((String)"jacop.b.costesBlockSize", (int)0);
        this.costesShufflingNumber = Prefs.getInt((String)"jacop.b.costesShufflingNumber", (int)0);
        this.doCropRois = Prefs.get((String)"jacop.b.doCropRois", (boolean)false);
        this.doSeparateZ = Prefs.get((String)"jacop.b.doSeparateZ", (boolean)false);
        this.is_stack_hist_z = Prefs.get((String)"jacop.b.is_stack_hist_z", (boolean)false);
        this.doPearsons = Prefs.get((String)"jacop.b.doPearsons", (boolean)false);
        this.doSpearmanRank = Prefs.get((String)"jacop.b.doSpearmanRank", (boolean)false);
        this.doManders = Prefs.get((String)"jacop.b.doManders", (boolean)false);
        this.doOverlap = Prefs.get((String)"jacop.b.doOverlap", (boolean)false);
        this.doICA = Prefs.get((String)"jacop.b.doICA", (boolean)false);
        this.doFluorogram = Prefs.get((String)"jacop.b.doFluorogram", (boolean)false);
        this.is_montage_vertical = Prefs.get((String)"jacop.b.is_montage_vertical", (boolean)false);
        this.doRandomCostes = Prefs.get((String)"jacop.b.doRandomCostes", (boolean)false);
        this.doRandomCostesMask = Prefs.get((String)"jacop.b.doRandomCostesMask", (boolean)false);
        this.showCostesPlot = Prefs.get((String)"jacop.b.showCostesPlot", (boolean)false);
        this.showCostesRandomImage = Prefs.get((String)"jacop.b.showCostesRandomImage", (boolean)false);
        this.randCostesBlockSize = (int)Prefs.get((String)"jacop.b.randCostesBlockSize", (double)5.0);
        this.randCostesShuffleNumber = (int)Prefs.get((String)"jacop.b.randCostesShuffleNumber", (double)100.0);
        this.use_advanced = Prefs.get((String)"jacop.b.use_advanced", (boolean)false);
        GenericDialogPlus d = new GenericDialogPlus("Colocalization Parameters");
        if (this.nImages == 0) {
            d.addDirectoryField("Image_Folder", "");
        }
        d.addNumericField("Channel_A", (double)this.channelA, 0);
        d.addNumericField("Channel_B", (double)this.channelB, 0);
        ArrayList<String> thrs = new ArrayList<String>(Arrays.asList(Thresholder.methods));
        thrs.add("Costes Auto-Threshold");
        thrs.add("Use Manual Threshold Below");
        String[] thrsArr = new String[thrs.size()];
        thrsArr = thrs.toArray(thrsArr);
        d.addChoice("Threshold_for_Channel_A", thrsArr, this.thrA);
        d.addChoice("Threshold_for_Channel_B", thrsArr, this.thrB);
        d.addNumericField("Manual_Threshold_A", (double)this.mThrA, 0);
        d.addNumericField("Manual_Threshold_B", (double)this.mThrB, 0);
        d.addCheckbox("Crop_ROIs", this.doCropRois.booleanValue());
        d.addCheckbox("Consider_Z_Slices_Separately", this.doSeparateZ.booleanValue());
        d.addCheckbox("Set_Auto_Thresholds_On_Stack_Histogram", this.is_stack_hist_z);
        d.addMessage("Colocalization Result Options");
        d.addCheckbox("Get_Pearsons Correlation", this.doPearsons.booleanValue());
        d.addCheckbox("Get_SpearmanRank Correlation", this.doSpearmanRank.booleanValue());
        d.addCheckbox("Get_Manders Coefficients", this.doManders.booleanValue());
        d.addCheckbox("Get_Overlap Coefficients", this.doOverlap.booleanValue());
        d.addCheckbox("Get_Li_ICA", this.doICA.booleanValue());
        d.addCheckbox("Get_Fluorogram", this.doFluorogram.booleanValue());
        d.addCheckbox("Report_As_Vertical_Montage", this.is_montage_vertical);
        d.addCheckbox("Perform_Costes_Randomization (2D, BIOP implementation, No Threshold)", this.doRandomCostes.booleanValue());
        d.addCheckbox("Perform_Costes_Randomization_Mask (2D, BIOP implementation, With Threshold)", this.doRandomCostesMask.booleanValue());
        d.addCheckbox("Show_Costes_Plot", this.showCostesPlot.booleanValue());
        d.addCheckbox("Show_Costes_Random_Image", this.showCostesRandomImage.booleanValue());
        d.addNumericField("Costes_Block_Size (pixel)", (double)this.randCostesBlockSize.intValue(), 0);
        d.addNumericField("Costes_Number_Of_Shuffling", (double)this.randCostesShuffleNumber.intValue(), 0);
        d.addCheckbox("Set Advanced Parameters", this.use_advanced);
        d.showDialog();
        if (d.wasCanceled()) {
            return false;
        }
        if (this.nImages == 0) {
            this.imageFolder = new File(d.getNextString());
        }
        this.channelA = (int)d.getNextNumber();
        this.channelB = (int)d.getNextNumber();
        this.thrA = d.getNextChoice();
        this.thrB = d.getNextChoice();
        this.mThrA = (int)d.getNextNumber();
        this.mThrB = (int)d.getNextNumber();
        this.doCropRois = d.getNextBoolean();
        this.doSeparateZ = d.getNextBoolean();
        this.is_stack_hist_z = d.getNextBoolean();
        this.doPearsons = d.getNextBoolean();
        this.doSpearmanRank = d.getNextBoolean();
        this.doManders = d.getNextBoolean();
        this.doOverlap = d.getNextBoolean();
        this.doICA = d.getNextBoolean();
        this.doFluorogram = d.getNextBoolean();
        this.is_montage_vertical = d.getNextBoolean();
        this.doRandomCostes = d.getNextBoolean();
        this.doRandomCostesMask = d.getNextBoolean();
        this.showCostesPlot = d.getNextBoolean();
        this.showCostesRandomImage = d.getNextBoolean();
        this.costesBlockSize = (int)d.getNextNumber();
        this.costesShufflingNumber = (int)d.getNextNumber();
        this.use_advanced = d.getNextBoolean();
        if (this.imageFolder != null) {
            Prefs.set((String)"jacop.b.imagefolder", (String)this.imageFolder.getAbsolutePath());
        }
        Prefs.set((String)"jacop.b.channelA", (int)this.channelA);
        Prefs.set((String)"jacop.b.channelB", (int)this.channelB);
        Prefs.set((String)"jacop.b.thrA", (String)this.thrA);
        Prefs.set((String)"jacop.b.thrB", (String)this.thrB);
        Prefs.set((String)"jacop.b.mThrA", (int)this.mThrA);
        Prefs.set((String)"jacop.b.mThrB", (int)this.mThrB);
        Prefs.set((String)"jacop.b.doCropRois", (boolean)this.doCropRois);
        Prefs.set((String)"jacop.b.doSeparateZ", (boolean)this.doSeparateZ);
        Prefs.set((String)"jacop.b.is_stack_hist_z", (boolean)this.is_stack_hist_z);
        Prefs.set((String)"jacop.b.doPearsons", (boolean)this.doPearsons);
        Prefs.set((String)"jacop.b.doSpearmanRank", (boolean)this.doSpearmanRank);
        Prefs.set((String)"jacop.b.doManders", (boolean)this.doManders);
        Prefs.set((String)"jacop.b.doOverlap", (boolean)this.doOverlap);
        Prefs.set((String)"jacop.b.doICA", (boolean)this.doICA);
        Prefs.set((String)"jacop.b.doFluorogram", (boolean)this.doFluorogram);
        Prefs.set((String)"jacop.b.is_montage_vertical", (boolean)this.is_montage_vertical);
        Prefs.set((String)"jacop.b.doRandomCostes", (boolean)this.doRandomCostes);
        Prefs.set((String)"jacop.b.doRandomCostesMask", (boolean)this.doRandomCostesMask);
        Prefs.set((String)"jacop.b.showCostesPlot", (boolean)this.showCostesPlot);
        Prefs.set((String)"jacop.b.showCostesRandomImage", (boolean)this.showCostesRandomImage);
        Prefs.set((String)"jacop.b.costesBlockSize", (int)this.costesBlockSize);
        Prefs.set((String)"jacop.b.costesShufflingNumber", (int)this.costesShufflingNumber);
        Prefs.set((String)"jacop.b.randCostesBlockSize", (int)this.randCostesBlockSize);
        Prefs.set((String)"jacop.b.randCostesShuffleNumber", (int)this.randCostesShuffleNumber);
        Prefs.set((String)"jacop.b.use_advanced", (boolean)this.use_advanced);
        if (this.use_advanced) {
            return this.advancedDialog();
        }
        return true;
    }

    private Boolean advancedDialog() {
        this.is_auto_fluo = Prefs.get((String)"jacop.b.is_auto_fluo", (boolean)this.is_auto_fluo);
        this.fluo_bins = Prefs.getInt((String)"jacop.b.fluo_bins", (int)this.fluo_bins);
        this.fluo_min = Prefs.getInt((String)"jacop.b.fluo_min", (int)this.fluo_min);
        this.fluo_max = Prefs.getInt((String)"jacop.b.fluo_max", (int)this.fluo_max);
        this.set_costes_graph_bounds = Prefs.getBoolean((String)"jacop.b.set_costes_graph_bounds", (boolean)false);
        this.xmin_costes_graph = Prefs.get((String)"jacop.b.xmin_costes_graph", (double)-1.0);
        this.xmax_costes_graph = Prefs.get((String)"jacop.b.xmax_costes_graph", (double)1.0);
        this.hide_masks = Prefs.get((String)"jacop.b.hide_masks", (boolean)this.hide_masks);
        this.stroke_width = (float)Prefs.getDouble((String)"jacop.b.stroke_width", (double)this.stroke_width);
        GenericDialogPlus d = new GenericDialogPlus("Advanced Parameters");
        d.addCheckbox("Auto-Adjust Fluorogram Per Image", true);
        d.addMessage("Otherwise, use parameters below");
        d.addNumericField("Fluorogram_Bins", (double)this.fluo_bins, 0);
        d.addNumericField("Fluorogram_Min", (double)this.fluo_min, 0);
        d.addNumericField("Fluorogram_Max", (double)this.fluo_max, 0);
        d.addCheckbox("set_costes_graph_bounds", this.set_costes_graph_bounds);
        d.addNumericField("xmin_costes_graph", this.xmin_costes_graph, 3);
        d.addNumericField("xmax_costes_graph", this.xmax_costes_graph, 3);
        d.addCheckbox("hide_masks", this.hide_masks);
        d.addNumericField("stroke_width", (double)this.stroke_width, 3);
        d.showDialog();
        if (d.wasCanceled()) {
            return false;
        }
        this.is_auto_fluo = d.getNextBoolean();
        this.fluo_bins = (int)d.getNextNumber();
        this.fluo_min = (int)d.getNextNumber();
        this.fluo_max = (int)d.getNextNumber();
        this.set_costes_graph_bounds = d.getNextBoolean();
        this.xmin_costes_graph = d.getNextNumber();
        this.xmax_costes_graph = d.getNextNumber();
        this.hide_masks = d.getNextBoolean();
        this.stroke_width = (float)d.getNextNumber();
        Prefs.set((String)"jacop.b.is_auto_fluo", (boolean)this.is_auto_fluo);
        Prefs.set((String)"jacop.b.fluo_bins", (int)this.fluo_bins);
        Prefs.set((String)"jacop.b.fluo_min", (int)this.fluo_min);
        Prefs.set((String)"jacop.b.fluo_max", (int)this.fluo_max);
        Prefs.set((String)"jacop.b.set_costes_graph_bounds", (boolean)this.set_costes_graph_bounds);
        Prefs.set((String)"jacop.b.xmin_costes_graph", (double)this.xmin_costes_graph);
        Prefs.set((String)"jacop.b.xmax_costes_graph", (double)this.xmax_costes_graph);
        Prefs.set((String)"jacop.b.hide_masks", (boolean)this.hide_masks);
        Prefs.set((String)"jacop.b.stroke_width", (double)this.stroke_width);
        return true;
    }

    public static void main(String[] args) {
        Class<JACoP_B> clazz = JACoP_B.class;
        String url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString();
        String pluginsDir = url.substring("file:".length(), url.length() - clazz.getName().length() - ".class".length());
        System.setProperty("plugins.dir", pluginsDir);
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
    }
}

