/*
 * Decompiled with CFR 0.152.
 */
package spimdata.util;

import bdv.viewer.SourceAndConverter;
import mpicbg.spim.data.generic.base.NamedEntity;
import net.imglib2.display.ColorConverter;
import net.imglib2.type.numeric.ARGBType;

public class Displaysettings
extends NamedEntity
implements Comparable<Displaysettings> {
    public int[] color = new int[]{255, 255, 255, 0};
    public double min = 0.0;
    public double max = 255.0;
    public boolean isSet = false;
    public String projectionMode = "Sum";

    public Displaysettings(int id, String name) {
        super(id, name);
    }

    public Displaysettings(int id) {
        this(id, Integer.toString(id));
    }

    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public int compareTo(Displaysettings o) {
        return this.getId() - o.getId();
    }

    protected Displaysettings() {
    }

    public String toString() {
        String str = "";
        str = str + "set = " + this.isSet + ", ";
        if (this.projectionMode != null) {
            str = str + "set = " + this.projectionMode + ", ";
        }
        if (this.color != null) {
            str = str + "color = ";
            for (int j : this.color) {
                str = str + j + ", ";
            }
        }
        str = str + "min = " + this.min + ", ";
        str = str + "max = " + this.max;
        return str;
    }

    @Deprecated
    public static void GetDisplaySettingsFromCurrentConverter(SourceAndConverter<?> sac, Displaysettings ds) {
        Displaysettings.getDisplaySettingsFromCurrentConverter(sac, ds);
    }

    public static void getDisplaySettingsFromCurrentConverter(SourceAndConverter<?> sac, Displaysettings ds) {
        if (sac.getConverter() instanceof ColorConverter) {
            ColorConverter cc = (ColorConverter)sac.getConverter();
            ds.setName("vs:" + ds.getId());
            int colorCode = cc.getColor().get();
            ds.color = new int[]{ARGBType.red((int)colorCode), ARGBType.green((int)colorCode), ARGBType.blue((int)colorCode), ARGBType.alpha((int)colorCode)};
            ds.min = cc.getMin();
            ds.max = cc.getMax();
            ds.isSet = true;
        } else {
            System.err.println("Converter is of class :" + sac.getConverter().getClass().getSimpleName() + " -> Display settings cannot be stored.");
        }
    }

    public static String pullDisplaySettings(SourceAndConverter<?> sac, Displaysettings ds) {
        if (ds.isSet) {
            if (sac.getConverter() instanceof ColorConverter) {
                ColorConverter cc = (ColorConverter)sac.getConverter();
                cc.setColor(new ARGBType(ARGBType.rgba((int)ds.color[0], (int)ds.color[1], (int)ds.color[2], (int)ds.color[3])));
                cc.setMin(ds.min);
                cc.setMax(ds.max);
                if (sac.asVolatile() != null) {
                    cc = (ColorConverter)sac.asVolatile().getConverter();
                    cc.setColor(new ARGBType(ARGBType.rgba((int)ds.color[0], (int)ds.color[1], (int)ds.color[2], (int)ds.color[3])));
                    cc.setMin(ds.min);
                    cc.setMax(ds.max);
                }
            } else {
                System.err.println("Converter is of class :" + sac.getConverter().getClass().getSimpleName() + " -> Display settings cannot be reapplied.");
            }
            return ds.projectionMode;
        }
        return null;
    }

    @Deprecated
    public static String PullDisplaySettings(SourceAndConverter<?> sac, Displaysettings ds) {
        return Displaysettings.pullDisplaySettings(sac, ds);
    }

    public static void applyDisplaysettings(SourceAndConverter<?>[] sacs, Displaysettings ds) {
        if (sacs != null && ds != null) {
            for (SourceAndConverter<?> sac : sacs) {
                Displaysettings.applyDisplaysettings(sac, ds);
            }
        }
    }

    public static void applyDisplaysettings(SourceAndConverter<?> sac, Displaysettings ds) {
        if (sac != null && ds != null && sac.getConverter() instanceof ColorConverter) {
            ColorConverter cc = (ColorConverter)sac.getConverter();
            cc.setMin(ds.min);
            cc.setMax(ds.max);
            cc.setColor(new ARGBType(ARGBType.rgba((int)ds.color[0], (int)ds.color[1], (int)ds.color[2], (int)ds.color[3])));
            if (sac.asVolatile() != null) {
                cc = (ColorConverter)sac.asVolatile().getConverter();
                cc.setMin(ds.min);
                cc.setMax(ds.max);
                cc.setColor(new ARGBType(ARGBType.rgba((int)ds.color[0], (int)ds.color[1], (int)ds.color[2], (int)ds.color[3])));
            }
        }
    }
}

