/*
 * Decompiled with CFR 0.152.
 */
package volumeCalculator;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.Duplicator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.ContentNode;
import ij3d.Image3DUniverse;
import ij3d.behaviors.InteractiveBehavior;
import java.awt.Color;
import java.awt.Component;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Vector3d;
import volumeCalculator.AnalyzedGraph;
import volumeCalculator.CustomVolumeBehavior2;
import volumeCalculator.GraphContentNode;
import volumeCalculator.Volumes;
import volumeCalculator.VolumesPanel;

public class Volume_Calculator
implements PlugInFilter {
    public static final Vector3d INITIAL_SCALING = new Vector3d(0.05, 0.05, 0.05);
    public static final float TRANSPARENCY = 0.4f;
    public static final Color3f TRANSPARENCY_COLOR = new Color3f(Color.gray);
    private AnalyzedGraph vasculature;
    private Image3DUniverse universe;
    private ImagePlus imagePlus;
    private ImageProcessor ip;
    private Content content;
    private VolumesPanel volumesPanel;
    private ImagePlus originalImage;

    public int setup(String string, ImagePlus imagePlus) {
        this.imagePlus = imagePlus;
        if (null != imagePlus) {
            this.originalImage = new Duplicator().run(imagePlus);
        }
        return 2049;
    }

    public void run(ImageProcessor ip) {
        this.ip = ip;
        this.vasculature = new AnalyzedGraph();
        this.vasculature.init(this.imagePlus);
        this.vasculature.getSceneGraph().compile();
        this.universe = new Image3DUniverse();
        this.universe.show();
        GraphContentNode contentNode = this.vasculature.getSceneGraph();
        this.content = new Content("VoCal Network");
        this.content.setUserData((Object)this.vasculature);
        this.content.display((ContentNode)contentNode);
        this.universe.addContent(this.content);
        Calibration calibration = this.imagePlus.getCalibration();
        Volumes volumes = new Volumes(calibration);
        this.volumesPanel = new VolumesPanel(volumes, this.vasculature, this.universe);
        this.universe.setInteractiveBehavior((InteractiveBehavior)new CustomVolumeBehavior2(this.universe, this.content, volumes, this.volumesPanel, this.imagePlus, this.originalImage));
        this.universe.setShowBoundingBoxUponSelection(false);
        this.universe.getWindow().add((Component)this.volumesPanel, (Object)"South");
        this.universe.getWindow().pack();
    }

    public static void main(String[] args) {
        ImageJ imageJ = null;
        try {
            imageJ = new ImageJ();
            IJ.run((String)"Open...");
            Volume_Calculator volume_calculator = new Volume_Calculator();
            volume_calculator.setup("", IJ.getImage());
            volume_calculator.run(volume_calculator.imagePlus.getProcessor());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            IJ.showMessage((String)e.getLocalizedMessage());
            System.out.println("" + e.getLocalizedMessage());
            imageJ.quit();
        }
    }
}

