/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.ui;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.listen.ClusterStateListener;
import edu.utexas.clm.archipelago.network.server.ArchipelagoServer;
import edu.utexas.clm.archipelago.ui.ArchipelagoUI;
import edu.utexas.clm.archipelago.ui.ClusterNodeStatusUI;
import edu.utexas.clm.archipelago.ui.ClusterXML;
import edu.utexas.clm.archipelago.ui.NodeConfigurationUI;
import edu.utexas.clm.archipelago.ui.RootNodeConfigDialog;
import edu.utexas.clm.archipelago.util.NullLogger;
import edu.utexas.clm.archipelago.util.PrintStreamLogger;
import ij.IJ;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BoxLayout;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ClusterUI
implements ClusterStateListener,
ArchipelagoUI {
    private final Cluster cluster;
    private final Frame frame;
    private final AtomicBoolean isConfigured;
    private final CUIMainPanel mainPanel;
    private final ClusterNodeStatusUI nodeStatusUI;
    private final AtomicBoolean active;
    private final ClusterUI self = this;
    private final RootNodeConfigDialog rncd;
    public static String[] shellClasses = new String[]{"edu.utexas.clm.archipelago.network.shell.SocketNodeShell"};

    public static boolean started(Cluster c) {
        Cluster.ClusterState state = c.getState();
        return state != Cluster.ClusterState.INSTANTIATED && state != Cluster.ClusterState.INITIALIZED;
    }

    public static void doRowPanelLayout(Container container, float containerWidth, int height, float[] weights, Component ... components) {
        float totalWeight = 0.0f;
        int x = 0;
        for (float weight : weights) {
            totalWeight += weight;
        }
        for (int i = 0; i < components.length && i < weights.length; ++i) {
            int w = (int)(containerWidth * weights[i] / totalWeight);
            int h = 24;
            Component c = components[i];
            Dimension d = new Dimension(w, height);
            container.add(c);
            c.setMaximumSize(d);
            c.setPreferredSize(d);
            c.setSize(d);
            c.setBounds(x, 0, w, 24);
            x += w;
        }
        container.validate();
    }

    public ClusterUI(Cluster c) {
        this.cluster = c;
        this.isConfigured = new AtomicBoolean(ClusterUI.started(c));
        this.mainPanel = new CUIMainPanel();
        this.nodeStatusUI = new ClusterNodeStatusUI(this.cluster, this);
        this.active = new AtomicBoolean(true);
        this.rncd = new RootNodeConfigDialog(this.cluster, this.isConfigured);
        this.frame = new Frame();
        this.frame.add(this.mainPanel);
        this.frame.setSize(new Dimension(300, 300));
        this.frame.addWindowListener(new WindowCloseAdapter());
        this.frame.validate();
        for (String className : shellClasses) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.cluster.registerUI(this);
        this.cluster.addStateListener(this);
        this.frame.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                try {
                    while (ClusterUI.this.active.get()) {
                        Thread.sleep(1000L);
                        ClusterUI.this.updateUI();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    public ClusterUI() {
        this(Cluster.getCluster());
    }

    public void updateUI() {
        if (this.frame.isVisible()) {
            this.mainPanel.update();
            this.nodeStatusUI.update();
        }
    }

    @Override
    public synchronized void stateChanged(Cluster c) {
        if (c == this.cluster) {
            FijiArchipelago.debug("UI: Got changed state for cluster. New state: " + Cluster.stateString(this.cluster.getState()));
            this.nodeStatusUI.stateChanged();
            this.updateUI();
        }
    }

    private void configError(String file, String erStr) {
        IJ.error((String)("Error loading file " + file + ":" + erStr));
    }

    public synchronized boolean loadFromFile(String file) {
        try {
            ArrayList<Exception> nodeExceptions = new ArrayList<Exception>();
            this.isConfigured.set(ClusterXML.loadClusterFile(new File(file), this.cluster, nodeExceptions));
            if (nodeExceptions.size() > 0) {
                FijiArchipelago.err("Could not load " + nodeExceptions.size() + " nodes. See log for details");
                for (Exception e : nodeExceptions) {
                    FijiArchipelago.log("Could not load node: " + e);
                    FijiArchipelago.debug("Could not load node: ", e);
                }
            }
            if (!this.isConfigured.get()) {
                this.configError(file, "Could not configure Cluster");
            }
        }
        catch (ParserConfigurationException pce) {
            this.configError(file, pce.toString());
        }
        catch (SAXException se) {
            this.configError(file, se.toString());
        }
        catch (IOException ioe) {
            this.configError(file, ioe.toString());
        }
        this.updateUI();
        return this.isConfigured.get();
    }

    private void toggleStatsWindow() {
        this.nodeStatusUI.toggleVisible();
        this.updateUI();
    }

    private void configureRootNode() {
        FijiArchipelago.debug("Creating and showing root node configuration");
        this.rncd.show();
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        private WindowCloseAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            boolean ok;
            Cluster.ClusterState state = ClusterUI.this.cluster.getState();
            if (state == Cluster.ClusterState.STOPPED || state == Cluster.ClusterState.STOPPING) {
                ok = true;
            } else {
                GenericDialog gd = new GenericDialog("Shutdown?");
                gd.addMessage("Really Close?");
                gd.showDialog();
                ok = gd.wasOKed();
            }
            if (ok) {
                ClusterUI.this.cluster.shutdownNow();
                ClusterUI.this.frame.setVisible(false);
                ClusterUI.this.frame.removeAll();
                ClusterUI.this.nodeStatusUI.stop();
                ClusterUI.this.active.set(false);
                ClusterUI.this.cluster.removeStateListener(ClusterUI.this.self);
            }
        }
    }

    private class ClusterConfigPanel
    extends Panel
    implements ActionListener {
        private final Button loadButton = new Button("Load Configuration File...");
        private final Button saveButton = new Button("Save to Configuration File...");
        private final Button rootButton = new Button("Configure Root Node...");
        private final Button nodeButton = new Button("Configure Cluster Nodes...");

        public ClusterConfigPanel() {
            super.setLayout(new BoxLayout(this, 1));
            super.add(this.loadButton);
            super.add(this.saveButton);
            super.add(this.rootButton);
            super.add(this.nodeButton);
            this.loadButton.setActionCommand("load");
            this.saveButton.setActionCommand("save");
            this.rootButton.setActionCommand("rootconfig");
            this.nodeButton.setActionCommand("nodeconfig");
            this.loadButton.addActionListener(this);
            this.saveButton.addActionListener(this);
            this.rootButton.addActionListener(this);
            this.nodeButton.addActionListener(this);
            super.setVisible(true);
        }

        public void setActive(boolean active) {
            this.loadButton.setEnabled(active);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("load")) {
                OpenDialog od = new OpenDialog("Select a .arc file to load", null);
                String dirName = od.getDirectory();
                String fileName = od.getFileName();
                if (fileName != null) {
                    ClusterUI.this.loadFromFile(dirName + fileName);
                }
            } else if (ae.getActionCommand().equals("save")) {
                OpenDialog od = new OpenDialog("Select a .arc file to save", null);
                String dirName = od.getDirectory();
                String fileName = od.getFileName();
                if (fileName != null) {
                    File f = new File(dirName + fileName);
                    if (f.exists()) {
                        GenericDialog gd = new GenericDialog("File Exists");
                        gd.addMessage(fileName + " already exists. Overwrite?");
                        gd.showDialog();
                        if (gd.wasCanceled()) {
                            return;
                        }
                    }
                    ClusterXML.saveToFile(ClusterUI.this.cluster, new File(dirName + fileName));
                }
            } else if (ae.getActionCommand().equals("rootconfig")) {
                if (ClusterUI.started(ClusterUI.this.cluster)) {
                    GenericDialog whoaDialog = new GenericDialog("Whoa");
                    whoaDialog.addMessage("Changing the root node configuration of a runningcluster may result in inexplicable errors. Continue anyway?");
                    whoaDialog.showDialog();
                    if (whoaDialog.wasCanceled()) {
                        return;
                    }
                }
                ClusterUI.this.configureRootNode();
            } else if (ae.getActionCommand().equals("nodeconfig")) {
                FijiArchipelago.debug("Node config");
                NodeConfigurationUI.nodeConfigurationUI(ClusterUI.this.cluster);
            }
        }
    }

    private class CUIMainPanel
    extends Panel
    implements ActionListener {
        final Button statButton;
        final Button startStopButton;
        final Button serverButton;
        final Checkbox debugCheck;
        final StateLabel clusterLabel;
        final StateLabel queueLabel;
        final StateLabel runningLabel;
        final StateLabel nodesLabel;
        final ClusterConfigPanel configPanel;
        final ReentrantLock updateLock;
        final NullLogger nullLogger;
        final PrintStreamLogger sysoutLogger;
        ArchipelagoServer server = null;

        public CUIMainPanel() {
            GridBagConstraints gbc = new GridBagConstraints();
            this.nullLogger = new NullLogger();
            this.sysoutLogger = new PrintStreamLogger(System.out);
            this.updateLock = new ReentrantLock();
            this.configPanel = new ClusterConfigPanel();
            this.statButton = new Button("Show Node Statistics");
            this.startStopButton = new Button("Start Cluster");
            this.serverButton = new Button("Start Insecure Server (At Your Own Risk)");
            this.clusterLabel = new StateLabel("Cluster is");
            this.queueLabel = new StateLabel("Jobs in queue:");
            this.runningLabel = new StateLabel("Running jobs: ");
            this.nodesLabel = new StateLabel("Active nodes: ");
            this.debugCheck = new Checkbox("Debug output", false);
            this.debugCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (CUIMainPanel.this.debugCheck.getState()) {
                        FijiArchipelago.setDebugLogger(CUIMainPanel.this.sysoutLogger);
                    } else {
                        FijiArchipelago.setDebugLogger(CUIMainPanel.this.nullLogger);
                    }
                }
            });
            FijiArchipelago.setDebugLogger(this.nullLogger);
            super.setLayout(new GridBagLayout());
            gbc.fill = 1;
            gbc.weightx = 0.0;
            gbc.gridwidth = 0;
            super.add((Component)this.configPanel, gbc);
            super.add((Component)this.clusterLabel, gbc);
            super.add((Component)this.queueLabel, gbc);
            super.add((Component)this.runningLabel, gbc);
            super.add((Component)this.nodesLabel, gbc);
            super.add((Component)this.statButton, gbc);
            super.add((Component)this.startStopButton, gbc);
            super.add((Component)this.serverButton, gbc);
            super.add((Component)this.debugCheck, gbc);
            this.statButton.setActionCommand("stats");
            this.startStopButton.setActionCommand("");
            this.serverButton.setActionCommand("server-start");
            this.statButton.addActionListener(this);
            this.startStopButton.addActionListener(this);
            this.serverButton.addActionListener(this);
            this.startStopButton.setEnabled(false);
            this.update();
            super.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("configure")) {
                ClusterUI.this.configureRootNode();
            } else if (ae.getActionCommand().equals("stats")) {
                ClusterUI.this.toggleStatsWindow();
            } else if (ae.getActionCommand().equals("start")) {
                ClusterUI.this.cluster.start();
            } else if (ae.getActionCommand().equals("stop")) {
                GenericDialog gd = new GenericDialog("Really?");
                gd.addMessage("Really stop server?");
                gd.showDialog();
                if (gd.wasOKed()) {
                    ClusterUI.this.cluster.shutdown();
                }
            } else if (ae.getActionCommand().equals("server-start")) {
                this.server = ArchipelagoServer.getServer(ClusterUI.this.cluster.getNodeCoordinator());
                if (!this.server.active()) {
                    this.server.start();
                }
                this.serverButton.setActionCommand("server-stop");
                this.serverButton.setLabel("Stop Insecure Server");
            } else if (ae.getActionCommand().equals("server-stop") && this.server != null) {
                GenericDialog gd = new GenericDialog("Stop Server?");
                gd.addMessage("Really Stop Server?");
                gd.showDialog();
                if (gd.wasOKed()) {
                    this.server.close();
                    this.serverButton.setActionCommand("server-start");
                    this.serverButton.setLabel("Start Insecure Server (At Your Own Risk)");
                }
            }
        }

        private String clusterStateString() {
            switch (ClusterUI.this.cluster.getState()) {
                case RUNNING: {
                    return "active.";
                }
                case STARTED: {
                    return "started.";
                }
                case STOPPING: {
                    return "waiting for termination.";
                }
                case STOPPED: {
                    return "terminated.";
                }
                case INSTANTIATED: {
                    return "waiting for initialization";
                }
                case INITIALIZED: {
                    if (ClusterUI.this.isConfigured.get()) {
                        return "ready to start.";
                    }
                    return "in need of configuration.";
                }
            }
            return "partying like its 1999";
        }

        public void update() {
            if (!this.updateLock.tryLock()) {
                FijiArchipelago.debug("UI: Could not acquire main panel update lock");
                return;
            }
            if (ClusterUI.this.nodeStatusUI != null && ClusterUI.this.nodeStatusUI.isVisible()) {
                this.statButton.setLabel("Hide Node Statistics");
            } else {
                this.statButton.setLabel("Show Node Statistics");
            }
            if (ClusterUI.this.cluster != null) {
                Cluster.ClusterState state = ClusterUI.this.cluster.getState();
                if (ClusterUI.this.isConfigured.get() && state != Cluster.ClusterState.STOPPING && state != Cluster.ClusterState.STOPPED) {
                    this.startStopButton.setEnabled(true);
                } else {
                    this.startStopButton.setEnabled(false);
                }
                this.clusterLabel.update(this.clusterStateString());
                this.queueLabel.update(ClusterUI.this.cluster.getQueuedJobCount());
                this.runningLabel.update(ClusterUI.this.cluster.getRunningJobCount());
                this.nodesLabel.update(ClusterUI.this.cluster.countReadyNodes());
                switch (state) {
                    case INSTANTIATED: {
                        this.startStopButton.setEnabled(false);
                        this.configPanel.setActive(true);
                        this.serverButton.setEnabled(false);
                        break;
                    }
                    case INITIALIZED: {
                        this.startStopButton.setEnabled(true);
                        this.startStopButton.setLabel("Start Cluster");
                        this.startStopButton.setActionCommand("start");
                        this.configPanel.setActive(true);
                        this.serverButton.setEnabled(false);
                        break;
                    }
                    case RUNNING: 
                    case STARTED: {
                        this.startStopButton.setEnabled(true);
                        this.startStopButton.setLabel("Stop Cluster");
                        this.startStopButton.setActionCommand("stop");
                        this.configPanel.setActive(true);
                        this.serverButton.setEnabled(true);
                        break;
                    }
                    case STOPPING: 
                    case STOPPED: {
                        this.startStopButton.setEnabled(false);
                        this.startStopButton.setLabel("Stop Cluster");
                        this.startStopButton.setActionCommand("");
                        this.configPanel.setActive(false);
                        this.serverButton.setEnabled(false);
                    }
                }
            } else {
                this.clusterLabel.update("is null");
                this.queueLabel.update(0);
                this.runningLabel.update(0);
                this.nodesLabel.update(0);
                this.startStopButton.setEnabled(false);
            }
            this.updateLock.unlock();
        }
    }

    private class StateLabel
    extends Label {
        private final String stateString;

        public StateLabel(String stateString) {
            this.stateString = stateString;
            this.update("");
        }

        public void update(Object o) {
            super.setText(this.stateString + " " + o.toString());
        }
    }
}

