/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.gateway.model.DataObject;

public class SearchResult {
    private int scopeId;
    private Class<? extends DataObject> type;
    private long objectId = -1L;
    private long groupId = -1L;
    private DataObject object;
    private boolean idMatch = false;

    public SearchResult() {
    }

    public SearchResult(int scopeId, Class<? extends DataObject> type, long objectId, long groupId) {
        this.scopeId = scopeId;
        this.type = type;
        this.objectId = objectId;
        this.groupId = groupId;
    }

    public int getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(int scopeId) {
        this.scopeId = scopeId;
    }

    public Class<? extends DataObject> getType() {
        return this.type;
    }

    public void setType(Class<? extends DataObject> type) {
        this.type = type;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public DataObject getObject() {
        return this.object;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public boolean isIdMatch() {
        return this.idMatch;
    }

    public void setIdMatch(boolean idMatch) {
        this.idMatch = idMatch;
    }

    public void setObject(DataObject object) {
        if (this.objectId >= 0L) {
            if (object.getId() != this.objectId) {
                throw new IllegalArgumentException("objectId does not match the object!");
            }
        } else {
            this.objectId = object.getId();
        }
        if (this.type != null) {
            if (!object.getClass().equals(this.type)) {
                throw new IllegalArgumentException("Cannot add a " + object.getClass().getSimpleName() + " to a SearchResult intended for " + this.type.getSimpleName() + "!");
            }
        } else {
            this.type = object.getClass();
        }
        if (this.groupId >= 0L) {
            if (object.getGroupId() != this.groupId) {
                throw new IllegalArgumentException("The object's groupId (" + object.getGroupId() + ") does not match the previous set groupId (" + this.groupId + ") !");
            }
        } else {
            this.groupId = object.getGroupId();
        }
        this.object = object;
    }

    public String toString() {
        return "SearchResult [scopeId=" + this.scopeId + ", type=" + (this.type != null ? this.type.getSimpleName() : "null") + ", objectId=" + this.objectId + ", groupId=" + this.groupId + "]";
    }
}

