/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import omero.RType;
import omero.api.IQueryPrx;
import omero.api.RawFileStorePrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.model.ImageData;
import omero.model.Fileset;
import omero.model.FilesetEntry;
import omero.model.IObject;
import omero.model.OriginalFile;
import omero.rtypes;
import omero.sys.ParametersI;
import org.apache.commons.collections.CollectionUtils;

public class TransferFacilityHelper {
    private static final int INC = 262144;
    private BrowseFacility browse;
    private Gateway gateway;

    TransferFacilityHelper(Gateway gateway) throws ExecutionException {
        this.gateway = gateway;
        this.browse = gateway.getFacility(BrowseFacility.class);
    }

    List<File> downloadImage(SecurityContext context, String targetPath, long imageId) throws DSAccessException, DSOutOfServiceException {
        List<IObject> filesets;
        ArrayList<File> files = new ArrayList<File>();
        ImageData image = this.browse.findObject(context, ImageData.class, imageId, true);
        try {
            String query;
            long id;
            IQueryPrx service = this.gateway.getQueryService(context);
            ParametersI param = new ParametersI();
            if (image.isFSImage()) {
                id = image.getId();
                ArrayList<RType> l = new ArrayList<RType>();
                l.add(rtypes.rlong(id));
                param.add("imageIds", rtypes.rlist(l));
                query = this.createFileSetQuery();
            } else if (image.isArchived()) {
                StringBuffer buffer = new StringBuffer();
                id = image.getDefaultPixels().getId();
                buffer.append("select ofile from OriginalFile as ofile ");
                buffer.append("join fetch ofile.hasher ");
                buffer.append("left join ofile.pixelsFileMaps as pfm ");
                buffer.append("left join pfm.child as child ");
                buffer.append("where child.id = :id");
                param.map.put("id", rtypes.rlong(id));
                query = buffer.toString();
            } else {
                return null;
            }
            filesets = service.findAllByQuery(query, param);
        }
        catch (Exception e) {
            throw new DSAccessException("Cannot retrieve original file", e);
        }
        HashMap result = new HashMap();
        if (CollectionUtils.isEmpty(filesets)) {
            return files;
        }
        ArrayList<File> downloaded = new ArrayList<File>();
        ArrayList<String> notDownloaded = new ArrayList<String>();
        result.put(true, downloaded);
        result.put(false, notDownloaded);
        if (image.isFSImage()) {
            for (IObject tmp : filesets) {
                Fileset fs = (Fileset)tmp;
                String fs_dir = "Fileset_" + fs.getId().getValue();
                String repoPath = fs.getTemplatePrefix().getValue();
                for (FilesetEntry fse : fs.copyUsedFiles()) {
                    OriginalFile of = fse.getOriginalFile();
                    String ofDir = of.getPath().getValue().replace(repoPath, "");
                    File outDir = new File(targetPath + File.separator + ofDir + File.separator + fs_dir);
                    outDir.mkdirs();
                    File saved = this.saveOriginalFile(context, of, outDir);
                    if (saved != null) {
                        downloaded.add(saved);
                        continue;
                    }
                    notDownloaded.add(of.getName().getValue());
                }
            }
        } else {
            for (IObject tmp : filesets) {
                File outDir;
                OriginalFile of = (OriginalFile)tmp;
                File saved = this.saveOriginalFile(context, of, outDir = new File(targetPath));
                if (saved != null) {
                    downloaded.add(saved);
                    continue;
                }
                notDownloaded.add(of.getName().getValue());
            }
        }
        return downloaded;
    }

    private File saveOriginalFile(SecurityContext ctx, OriginalFile of, File dir) {
        File out = new File(dir, of.getName().getValue());
        if (out.exists()) {
            return null;
        }
        try {
            RawFileStorePrx store = this.gateway.getRawFileService(ctx);
            store.setFileId(of.getId().getValue());
            long size = of.getSize().getValue();
            long offset = 0L;
            try (FileOutputStream stream = new FileOutputStream(out);){
                offset = 0L;
                while (offset + 262144L < size) {
                    stream.write(store.read(offset, 262144));
                    offset += 262144L;
                }
                stream.write(store.read(offset, (int)(size - offset)));
            }
        }
        catch (Exception e) {
            return null;
        }
        return out;
    }

    private String createFileSetQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("select fs from Fileset as fs ");
        buffer.append("join fetch fs.images as image ");
        buffer.append("left outer join fetch fs.usedFiles as usedFile ");
        buffer.append("join fetch usedFile.originalFile as f ");
        buffer.append("join fetch f.hasher ");
        buffer.append("where image.id in (:imageIds)");
        return buffer.toString();
    }
}

