/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import omero.IllegalArgumentException;
import omero.ServerError;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.DataManagerFacility;
import omero.gateway.facility.Facility;
import omero.gateway.facility.MetadataFacility;
import omero.gateway.facility.TablesFacilityHelper;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.TableData;
import omero.gateway.model.TableDataColumn;
import omero.gateway.util.Pojos;
import omero.grid.Column;
import omero.grid.Data;
import omero.grid.SharedResourcesPrx;
import omero.grid.TablePrx;
import omero.model.FileAnnotationI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;

public class TablesFacility
extends Facility {
    public static final String TABLES_MIMETYPE = "OMERO.tables";
    public static final int DEFAULT_MAX_ROWS_TO_FETCH = 1000;

    TablesFacility(Gateway gateway) {
        super(gateway);
    }

    public TableData addTable(SecurityContext ctx, DataObject target, String name, TableData data) throws DSOutOfServiceException, DSAccessException {
        return this.addTable(ctx, target, name, null, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableData addTable(SecurityContext ctx, DataObject target, String name, String ns, TableData data) throws DSOutOfServiceException, DSAccessException {
        if (!Pojos.hasID(target)) {
            return null;
        }
        TablePrx table = null;
        try {
            if (name == null) {
                name = UUID.randomUUID().toString();
            }
            TablesFacilityHelper helper = new TablesFacilityHelper(this, ctx);
            helper.parseTableData(data);
            SharedResourcesPrx sr = this.gateway.getSharedResources(ctx);
            if (!sr.areTablesEnabled()) {
                throw new DSAccessException("Tables feature is not enabled on this server!");
            }
            long repId = sr.repositories().descriptions.get(0).getId().getValue();
            table = sr.newTable(repId, name);
            table.initialize(helper.getGridColumns());
            table.addData(helper.getGridColumns());
            DataManagerFacility dm = this.gateway.getFacility(DataManagerFacility.class);
            BrowseFacility browse = this.gateway.getFacility(BrowseFacility.class);
            OriginalFile file = table.getOriginalFile();
            file = (OriginalFile)browse.findIObject(ctx, file);
            FileAnnotationI anno = new FileAnnotationI();
            anno.setFile(file);
            FileAnnotationData annotation = new FileAnnotationData(anno);
            annotation.setDescription(name);
            if (ns != null && ns.trim().length() > 0) {
                annotation.setNameSpace(ns);
            }
            annotation = (FileAnnotationData)dm.saveAndReturnObject(ctx, annotation);
            dm.attachAnnotation(ctx, annotation, target);
            data.setOriginalFileId(file.getId().getValue());
            data.setNumberOfRows(table.getNumberOfRows());
        }
        catch (Exception e) {
            this.handleException(this, e, "Could not add table");
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (ServerError e) {
                    this.logError(this, "Could not close table", (Throwable)((Object)e));
                }
            }
        }
        return data;
    }

    public TableData getTableInfo(SecurityContext ctx, long fileId) throws DSOutOfServiceException, DSAccessException {
        return this.getTable(ctx, fileId, 0L, 0L, new int[0]);
    }

    public TableData getTable(SecurityContext ctx, long fileId) throws DSOutOfServiceException, DSAccessException {
        return this.getTable(ctx, fileId, 0L, 999L, new int[0]);
    }

    public TableData getTable(SecurityContext ctx, long fileId, long rowFrom, long rowTo, int ... columns) throws DSOutOfServiceException, DSAccessException {
        long[] lcolumns = null;
        if (columns != null) {
            lcolumns = new long[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                lcolumns[i] = columns[i];
            }
        }
        return this.getTable(ctx, fileId, rowFrom, rowTo, lcolumns);
    }

    public long[] query(SecurityContext ctx, long fileId, String condition) throws DSOutOfServiceException, DSAccessException {
        return this.query(ctx, fileId, condition, 0L, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] query(SecurityContext ctx, long fileId, String condition, long start, long stop, long step) throws DSOutOfServiceException, DSAccessException {
        if (fileId < 0L) {
            return new long[0];
        }
        TablePrx table = null;
        try {
            OriginalFileI file = new OriginalFileI(fileId, false);
            SharedResourcesPrx sr = this.gateway.getSharedResources(ctx);
            if (!sr.areTablesEnabled()) {
                throw new DSAccessException("Tables feature is not enabled on this server!");
            }
            table = sr.openTable(file);
            if (start < 0L) {
                start = 0L;
            }
            if (stop <= 0L) {
                stop = table.getNumberOfRows();
            }
            if (step < 0L) {
                step = 0L;
            }
            if (start > stop) {
                throw new IllegalArgumentException("start value can't be greater than stop value");
            }
            if (start + step > stop) {
                throw new IllegalArgumentException("step value is greater than the specified range");
            }
            long[] lArray = table.getWhereList(condition, null, start, stop, step);
            return lArray;
        }
        catch (Exception e) {
            this.handleException(this, e, "Could not load table data");
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (ServerError e) {
                    this.logError(this, "Could not close table", (Throwable)((Object)e));
                }
            }
        }
        return new long[0];
    }

    public TableData getTable(SecurityContext ctx, long fileId, List<Long> rows) throws DSOutOfServiceException, DSAccessException {
        long[] rowsArray = new long[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            rowsArray[i] = rows.get(i);
        }
        return this.getTable(ctx, fileId, rowsArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableData getTable(SecurityContext ctx, long fileId, long ... rows) throws DSOutOfServiceException, DSAccessException {
        if (fileId < 0L) {
            return null;
        }
        TablePrx table = null;
        try {
            OriginalFileI file = new OriginalFileI(fileId, false);
            SharedResourcesPrx sr = this.gateway.getSharedResources(ctx);
            if (!sr.areTablesEnabled()) {
                throw new DSAccessException("Tables feature is not enabled on this server!");
            }
            table = sr.openTable(file);
            Data data = table.readCoordinates(rows);
            Column[] cols = table.getHeaders();
            TableDataColumn[] header = new TableDataColumn[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                header[i] = new TableDataColumn(cols[i].name, cols[i].description, i, Object.class);
            }
            TablesFacilityHelper helper = new TablesFacilityHelper(this, ctx);
            helper.parseData(data, header);
            TableData result = new TableData(header, helper.getDataArray());
            result.setOriginalFileId(fileId);
            result.setNumberOfRows(helper.getNRows());
            TableData tableData = result;
            return tableData;
        }
        catch (Exception e) {
            this.handleException(this, e, "Could not load table data");
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (ServerError e) {
                    this.logError(this, "Could not close table", (Throwable)((Object)e));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableData getTable(SecurityContext ctx, long fileId, long rowFrom, long rowTo, long ... columns) throws DSOutOfServiceException, DSAccessException {
        if (fileId < 0L) {
            return null;
        }
        TablePrx table = null;
        try {
            OriginalFileI file = new OriginalFileI(fileId, false);
            SharedResourcesPrx sr = this.gateway.getSharedResources(ctx);
            if (!sr.areTablesEnabled()) {
                throw new DSAccessException("Tables feature is not enabled on this server!");
            }
            table = sr.openTable(file);
            Column[] cols = table.getHeaders();
            if (columns == null || columns.length == 0) {
                columns = new long[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    columns[i] = i;
                }
            }
            TableDataColumn[] header = new TableDataColumn[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                int columnIndex = (int)columns[i];
                header[i] = new TableDataColumn(cols[columnIndex].name, cols[columnIndex].description, columnIndex, Object.class);
            }
            if (table.getNumberOfRows() == 0L) {
                TableData i = new TableData(header, new Object[columns.length][0]);
                return i;
            }
            if (rowFrom < 0L) {
                rowFrom = 0L;
            }
            long maxRow = table.getNumberOfRows() - 1L;
            if (rowTo < 0L) {
                rowTo = rowFrom + 1000L;
            }
            if (rowTo > maxRow) {
                rowTo = maxRow;
            }
            if (rowTo - rowFrom > Integer.MAX_VALUE) {
                throw new Exception("Can't fetch more than 2147483646 rows at once.");
            }
            TableData result = null;
            Data data = table.read(columns, rowFrom, rowTo + 1L);
            TablesFacilityHelper helper = new TablesFacilityHelper(this, ctx);
            helper.parseData(data, header);
            result = new TableData(header, helper.getDataArray());
            result.setOffset(rowFrom);
            result.setOriginalFileId(fileId);
            result.setNumberOfRows(maxRow + 1L);
            TableData tableData = result;
            return tableData;
        }
        catch (Exception e) {
            this.handleException(this, e, "Could not load table data");
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (ServerError e) {
                    this.logError(this, "Could not close table", (Throwable)((Object)e));
                }
            }
        }
        return null;
    }

    public Collection<FileAnnotationData> getAvailableTables(SecurityContext ctx, DataObject parent) throws DSOutOfServiceException, DSAccessException {
        if (!Pojos.hasID(parent)) {
            return Collections.emptyList();
        }
        ArrayList<FileAnnotationData> result = new ArrayList<FileAnnotationData>();
        try {
            MetadataFacility mf = this.gateway.getFacility(MetadataFacility.class);
            ArrayList<Class<? extends AnnotationData>> types = new ArrayList<Class<? extends AnnotationData>>(1);
            types.add(FileAnnotationData.class);
            List<AnnotationData> annos = mf.getAnnotations(ctx, parent, types, null);
            for (AnnotationData anno : annos) {
                FileAnnotationData fad = (FileAnnotationData)anno;
                if (!fad.getOriginalMimetype().equals(TABLES_MIMETYPE)) continue;
                result.add(fad);
            }
        }
        catch (Exception e) {
            this.handleException(this, e, "Could not load tables");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void updateTable(SecurityContext ctx, TableData data) throws DSOutOfServiceException, DSAccessException {
        TablePrx table = null;
        try {
            if (data.getOriginalFileId() < 0L) {
                throw new IllegalArgumentException("This TableData object is not associated with a table yet, use addTable method instead.");
            }
            OriginalFileI file = new OriginalFileI(data.getOriginalFileId(), false);
            SharedResourcesPrx sr = this.gateway.getSharedResources(ctx);
            if (!sr.areTablesEnabled()) {
                throw new DSAccessException("Tables feature is not enabled on this server!");
            }
            table = sr.openTable(file);
            long[] colIndex = new long[data.getColumns().length];
            for (int i = 0; i < data.getColumns().length; ++i) {
                colIndex[i] = data.getColumns()[i].getIndex();
            }
            Data toUpdate = table.read(colIndex, data.getOffset(), data.getOffset() + (long)data.getData()[0].length);
            TablesFacilityHelper.updateData(toUpdate, data);
            table.update(toUpdate);
        }
        catch (Exception e) {
            this.handleException(this, e, "Could not udpate table");
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (ServerError e) {
                    this.logError(this, "Could not close table", (Throwable)((Object)e));
                }
            }
        }
    }
}

