/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import omero.ServerError;
import omero.api.IContainerPrx;
import omero.api.IUpdatePrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.cmd.Chgrp2;
import omero.cmd.CmdCallbackI;
import omero.cmd.Delete2;
import omero.cmd.Request;
import omero.cmd.graphs.ChildOption;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.Facility;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FolderData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.gateway.util.Links;
import omero.gateway.util.PojoMapper;
import omero.gateway.util.Pojos;
import omero.gateway.util.Requests;
import omero.model.ChecksumAlgorithmI;
import omero.model.DatasetAnnotationLink;
import omero.model.DatasetAnnotationLinkI;
import omero.model.DatasetImageLinkI;
import omero.model.FileAnnotation;
import omero.model.FileAnnotationI;
import omero.model.IObject;
import omero.model.ImageAnnotationLink;
import omero.model.ImageAnnotationLinkI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.model.PlateAnnotationLink;
import omero.model.PlateAnnotationLinkI;
import omero.model.ProjectAnnotationLink;
import omero.model.ProjectAnnotationLinkI;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectDatasetLinkI;
import omero.model.ScreenAnnotationLink;
import omero.model.ScreenAnnotationLinkI;
import omero.model.WellAnnotationLink;
import omero.model.WellAnnotationLinkI;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import org.apache.commons.collections.CollectionUtils;

public class DataManagerFacility
extends Facility {
    private BrowseFacility browse;
    private int INC = 262144;

    DataManagerFacility(Gateway gateway) throws ExecutionException {
        super(gateway);
        this.browse = gateway.getFacility(BrowseFacility.class);
    }

    public CmdCallbackI delete(SecurityContext ctx, IObject object) throws DSOutOfServiceException, DSAccessException {
        return this.delete(ctx, Collections.singletonList(object));
    }

    public CmdCallbackI deleteFolders(SecurityContext ctx, Collection<FolderData> folders, boolean includeSubFolders, boolean includeContent) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(folders)) {
            return null;
        }
        try {
            HashMap<String, ArrayList<Long>> targetObjects = new HashMap<String, ArrayList<Long>>();
            targetObjects.put(PojoMapper.getGraphType(FolderData.class), new ArrayList<Long>(Pojos.extractIds(folders)));
            ArrayList<String> inc = new ArrayList<String>();
            ArrayList<String> ex = new ArrayList<String>();
            if (includeSubFolders) {
                inc.add(PojoMapper.getGraphType(FolderData.class));
            } else {
                ex.add(PojoMapper.getGraphType(FolderData.class));
            }
            if (includeContent) {
                inc.add(PojoMapper.getGraphType(ROIData.class));
                inc.add(PojoMapper.getGraphType(ImageData.class));
            } else {
                ex.add(PojoMapper.getGraphType(ROIData.class));
                ex.add(PojoMapper.getGraphType(ImageData.class));
            }
            Delete2 del = (Delete2)((Object)((Requests.Delete2Builder)((Requests.Delete2Builder)Requests.delete().target(targetObjects)).option(new ChildOption(inc, ex, null, null))).build());
            return this.gateway.submit(ctx, del);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot delete the object.");
            return null;
        }
    }

    public CmdCallbackI delete(SecurityContext ctx, List<IObject> objects) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(objects)) {
            return null;
        }
        try {
            Requests.Delete2Builder request = Requests.delete();
            for (IObject object : objects) {
                request.target(object);
            }
            return this.gateway.submit(ctx, (Request)((Object)request.build()));
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot delete the object.");
            return null;
        }
    }

    public IObject saveAndReturnObject(SecurityContext ctx, IObject object, Map options) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            return null;
        }
        try {
            IUpdatePrx service = this.gateway.getUpdateService(ctx);
            if (options == null) {
                return service.saveAndReturnObject(object);
            }
            return service.saveAndReturnObject(object, options);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot update the object.");
            return null;
        }
    }

    public DataObject saveAndReturnObject(SecurityContext ctx, DataObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            return null;
        }
        return PojoMapper.asDataObject(this.saveAndReturnObject(ctx, object.asIObject()));
    }

    public IObject saveAndReturnObject(SecurityContext ctx, IObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            return null;
        }
        try {
            IUpdatePrx service = this.gateway.getUpdateService(ctx);
            IObject result = service.saveAndReturnObject(object);
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot update the object.");
            return null;
        }
    }

    public IObject saveAndReturnObject(SecurityContext ctx, IObject object, Map options, String userName) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            return null;
        }
        try {
            IUpdatePrx service = this.gateway.getUpdateService(ctx, userName);
            if (options == null) {
                return service.saveAndReturnObject(object);
            }
            return service.saveAndReturnObject(object, options);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot update the object.");
            return null;
        }
    }

    public DataObject saveAndReturnObject(SecurityContext ctx, DataObject object, String userName) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            return null;
        }
        return PojoMapper.asDataObject(this.saveAndReturnObject(ctx, object.asIObject(), userName));
    }

    public IObject saveAndReturnObject(SecurityContext ctx, IObject object, String userName) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            return null;
        }
        try {
            IUpdatePrx service = this.gateway.getUpdateService(ctx, userName);
            IObject result = service.saveAndReturnObject(object);
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot update the object.");
            return null;
        }
    }

    public List<IObject> saveAndReturnObject(SecurityContext ctx, List<IObject> objects, Map options, String userName) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(objects)) {
            return Collections.emptyList();
        }
        try {
            IUpdatePrx service = this.gateway.getUpdateService(ctx, userName);
            return service.saveAndReturnArray(objects);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot update the object.");
            return new ArrayList<IObject>();
        }
    }

    public IObject updateObject(SecurityContext ctx, IObject object, Parameters options) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            return null;
        }
        try {
            IContainerPrx service = this.gateway.getPojosService(ctx);
            IObject r = service.updateDataObject(object, options);
            return this.browse.findIObject(ctx, r);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot update the object.");
            return null;
        }
    }

    public List<IObject> updateObjects(SecurityContext ctx, List<IObject> objects, Parameters options) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(objects)) {
            return Collections.emptyList();
        }
        try {
            IContainerPrx service = this.gateway.getPojosService(ctx);
            List<IObject> l = service.updateDataObjects(objects, options);
            if (l == null) {
                return l;
            }
            Iterator<IObject> i = l.iterator();
            ArrayList<IObject> r = new ArrayList<IObject>(l.size());
            while (i.hasNext()) {
                IObject io = this.browse.findIObject(ctx, i.next());
                if (io == null) continue;
                r.add(io);
            }
            return r;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot update the object.");
            return new ArrayList<IObject>();
        }
    }

    public void addImageToDataset(SecurityContext ctx, ImageData image, DatasetData ds) throws DSOutOfServiceException, DSAccessException {
        if (image == null || ds == null) {
            return;
        }
        ArrayList<ImageData> l = new ArrayList<ImageData>(1);
        l.add(image);
        this.addImagesToDataset(ctx, l, ds);
    }

    public void addImagesToDataset(SecurityContext ctx, Collection<ImageData> images, DatasetData ds) throws DSOutOfServiceException, DSAccessException {
        if (ds == null || CollectionUtils.isEmpty(images)) {
            return;
        }
        ArrayList<IObject> links = new ArrayList<IObject>();
        for (ImageData img : images) {
            DatasetImageLinkI l = new DatasetImageLinkI();
            l.setParent(ds.asDataset());
            l.setChild(img.asImage());
            links.add(l);
        }
        this.updateObjects(ctx, links, null);
    }

    public DatasetData createDataset(SecurityContext ctx, DatasetData dataset, ProjectData project) throws DSOutOfServiceException, DSAccessException {
        if (dataset == null) {
            return null;
        }
        if (project != null) {
            if (project.getId() >= 0L) {
                project = this.browse.findObject(ctx, ProjectData.class, project.getId());
            }
            ProjectDatasetLink link = new ProjectDatasetLinkI();
            link = new ProjectDatasetLinkI();
            link.setChild(dataset.asDataset());
            link.setParent(project.asProject());
            link = (ProjectDatasetLink)this.saveAndReturnObject(ctx, link);
            return new DatasetData(link.getChild());
        }
        return (DatasetData)this.saveAndReturnObject(ctx, dataset);
    }

    public Future<FileAnnotationData> attachFile(final SecurityContext ctx, final File file, String mimetype, final String description, final String namespace, final DataObject target) {
        String mime;
        if (file == null || target == null) {
            return null;
        }
        final String name = file.getName();
        String absolutePath = file.getAbsolutePath();
        final String path = absolutePath.substring(0, absolutePath.length() - name.length());
        if (mimetype == null) {
            try {
                mimetype = Files.probeContentType(Paths.get(file.toURI()));
            }
            catch (IOException e) {
                mimetype = null;
            }
            mime = mimetype != null ? mimetype : "application/octet-stream";
        } else {
            mime = mimetype;
        }
        Callable<FileAnnotationData> c = new Callable<FileAnnotationData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public FileAnnotationData call() throws Exception {
                StatefulServiceInterfacePrx rawFileStore = null;
                FileInputStream stream = null;
                try {
                    int rlen;
                    OriginalFile originalFile = new OriginalFileI();
                    originalFile.setName(rtypes.rstring(name));
                    originalFile.setPath(rtypes.rstring(path));
                    originalFile.setSize(rtypes.rlong(file.length()));
                    ChecksumAlgorithmI checksumAlgorithm = new ChecksumAlgorithmI();
                    checksumAlgorithm.setValue(rtypes.rstring("SHA1-160"));
                    originalFile.setHasher(checksumAlgorithm);
                    originalFile.setMimetype(rtypes.rstring(mime));
                    originalFile = (OriginalFile)DataManagerFacility.this.saveAndReturnObject(ctx, originalFile);
                    rawFileStore = DataManagerFacility.this.gateway.getRawFileService(ctx);
                    rawFileStore.setFileId(originalFile.getId().getValue());
                    stream = new FileInputStream(file);
                    long pos = 0L;
                    byte[] buf = new byte[DataManagerFacility.this.INC];
                    while ((rlen = stream.read(buf)) > 0) {
                        if (Thread.currentThread().isInterrupted()) {
                            stream.close();
                            try {
                                rawFileStore.close();
                            }
                            catch (ServerError serverError) {
                                // empty catch block
                            }
                            FileAnnotationData fileAnnotationData = null;
                            return fileAnnotationData;
                        }
                        rawFileStore.write(buf, pos, rlen);
                        pos += (long)rlen;
                        ByteBuffer bbuf = ByteBuffer.wrap(buf);
                        bbuf.limit(rlen);
                    }
                    originalFile = rawFileStore.save();
                    FileAnnotation fa = new FileAnnotationI();
                    fa.setFile(originalFile);
                    if (description != null) {
                        fa.setDescription(rtypes.rstring(description));
                    }
                    fa.setNs(rtypes.rstring(namespace));
                    fa = (FileAnnotation)DataManagerFacility.this.saveAndReturnObject(ctx, fa);
                    if (target != null) {
                        FileAnnotationData fileAnnotationData = DataManagerFacility.this.attachAnnotation(ctx, new FileAnnotationData(fa), target);
                        return fileAnnotationData;
                    }
                    FileAnnotationData fileAnnotationData = new FileAnnotationData(fa);
                    return fileAnnotationData;
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                    if (rawFileStore != null) {
                        try {
                            rawFileStore.close();
                        }
                        catch (ServerError serverError) {}
                    }
                }
            }
        };
        return this.gateway.submit(c);
    }

    public <T extends AnnotationData> T attachAnnotation(SecurityContext ctx, T annotation, DataObject target) throws DSOutOfServiceException, DSAccessException {
        if (annotation == null) {
            return null;
        }
        if (target != null) {
            if (target instanceof ProjectData) {
                ProjectData project = this.browse.findObject(ctx, ProjectData.class, target.getId());
                ProjectAnnotationLink link = new ProjectAnnotationLinkI();
                link.setChild(annotation.asAnnotation());
                link.setParent(project.asProject());
                link = (ProjectAnnotationLink)this.saveAndReturnObject(ctx, link);
                return (T)((AnnotationData)PojoMapper.asDataObject(link.getChild()));
            }
            if (target instanceof DatasetData) {
                DatasetData ds = this.browse.findObject(ctx, DatasetData.class, target.getId());
                DatasetAnnotationLink link = new DatasetAnnotationLinkI();
                link.setChild(annotation.asAnnotation());
                link.setParent(ds.asDataset());
                link = (DatasetAnnotationLink)this.saveAndReturnObject(ctx, link);
                return (T)((AnnotationData)PojoMapper.asDataObject(link.getChild()));
            }
            if (target instanceof ScreenData) {
                ScreenData s = this.browse.findObject(ctx, ScreenData.class, target.getId());
                ScreenAnnotationLink link = new ScreenAnnotationLinkI();
                link.setChild(annotation.asAnnotation());
                link.setParent(s.asScreen());
                link = (ScreenAnnotationLink)this.saveAndReturnObject(ctx, link);
                return (T)((AnnotationData)PojoMapper.asDataObject(link.getChild()));
            }
            if (target instanceof PlateData) {
                PlateData p = this.browse.findObject(ctx, PlateData.class, target.getId());
                PlateAnnotationLink link = new PlateAnnotationLinkI();
                link.setChild(annotation.asAnnotation());
                link.setParent(p.asPlate());
                link = (PlateAnnotationLink)this.saveAndReturnObject(ctx, link);
                return (T)((AnnotationData)PojoMapper.asDataObject(link.getChild()));
            }
            if (target instanceof WellData) {
                WellData w = this.browse.findObject(ctx, WellData.class, target.getId());
                WellAnnotationLink link = new WellAnnotationLinkI();
                link.setChild(annotation.asAnnotation());
                link.setParent(w.asWell());
                link = (WellAnnotationLink)this.saveAndReturnObject(ctx, link);
                return (T)((AnnotationData)PojoMapper.asDataObject(link.getChild()));
            }
            if (target instanceof ImageData) {
                ImageData i = this.browse.findObject(ctx, ImageData.class, target.getId());
                ImageAnnotationLink link = new ImageAnnotationLinkI();
                link.setChild(annotation.asAnnotation());
                link.setParent(i.asImage());
                link = (ImageAnnotationLink)this.saveAndReturnObject(ctx, link);
                return (T)((AnnotationData)PojoMapper.asDataObject(link.getChild()));
            }
            if (target instanceof WellSampleData) {
                WellSampleData w = this.browse.findObject(ctx, WellSampleData.class, target.getId());
                ImageData i = this.browse.findObject(ctx, ImageData.class, w.getImage().getId());
                ImageAnnotationLink link = new ImageAnnotationLinkI();
                link.setChild(annotation.asAnnotation());
                link.setParent(i.asImage());
                link = (ImageAnnotationLink)this.saveAndReturnObject(ctx, link);
                return (T)((AnnotationData)PojoMapper.asDataObject(link.getChild()));
            }
        } else {
            return (T)((AnnotationData)this.saveAndReturnObject(ctx, annotation));
        }
        return null;
    }

    public void move(SecurityContext ctx, List<? extends DataObject> objects, DataObject from, DataObject to) throws DSOutOfServiceException, DSAccessException {
        try {
            if (from.getClass() != to.getClass()) {
                throw new IllegalArgumentException("Source and target object need to be the same type!");
            }
            if (objects.isEmpty()) {
                return;
            }
            Class<? extends IObject> type = Links.getLinkClass(from.getClass(), objects.get(0).getClass());
            if (type == null) {
                throw new IllegalArgumentException("Can't determine the link type for this class");
            }
            String query = "select link from " + PojoMapper.getHQLEntityName(type) + " link join fetch link.child as c join fetch link.parent as p where c.id in (:ids) and p.id = :parentId";
            ParametersI params = new ParametersI();
            Collection ids = objects.stream().map(obj -> obj.getId()).collect(Collectors.toList());
            params.addIds(ids);
            params.add("parentId", rtypes.rlong(from.getId()));
            List<IObject> links = this.gateway.getQueryService(ctx).findAllByQuery(query, params);
            for (IObject link : links) {
                Links.setObjects(link, to, null);
            }
            this.updateObjects(ctx, links, null);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot move the object.");
        }
    }

    public void changeGroup(SecurityContext ctx, List<? extends DataObject> objects, long groupId) throws DSAccessException, DSOutOfServiceException {
        try {
            String type = PojoMapper.getGraphType(objects.iterator().next().getClass());
            Collection ids = objects.stream().map(o -> o.getId()).collect(Collectors.toList());
            Chgrp2 chgrp2 = (Chgrp2)((Object)((Requests.Chgrp2Builder)((Requests.Chgrp2Builder)Requests.chgrp().target(type)).id(ids)).toGroup(groupId).build());
            CmdCallbackI cb = this.gateway.submit(ctx, chgrp2);
            cb.loop(30, 500L);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Change group failed.");
        }
    }
}

