/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway;

import java.net.URI;
import java.net.URISyntaxException;
import omero.gateway.LoginCredentials;

public class ServerInformation {
    private URI uri;

    public ServerInformation() {
        try {
            this.uri = new URI(null, null, null, -1, null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public ServerInformation(String hostname) {
        this(hostname, -1);
    }

    public ServerInformation(String hostname, int port) {
        block7: {
            try {
                if (hostname.contains(":/")) {
                    this.uri = new URI(hostname);
                    if (port >= 0 && this.uri.getPort() < 0) {
                        this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), port, this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
                    }
                    break block7;
                }
                if (port < 0 && hostname.contains(":")) {
                    try {
                        String[] parts = hostname.split(":");
                        port = Integer.parseInt(parts[parts.length - 1]);
                        hostname = parts[parts.length - 2];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.uri = new URI(null, null, hostname, port, null, null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public String getHost() {
        if (this.uri.isAbsolute()) {
            return this.uri.toString();
        }
        return this.uri.getHost();
    }

    public void setHost(String host) {
        block8: {
            try {
                if (host.contains(":/")) {
                    int port = this.uri.getPort();
                    this.uri = new URI(host);
                    if (this.uri.getPort() < 0) {
                        if (port <= 0) {
                            port = LoginCredentials.DefaultPort.fromProtocol((String)this.getProtocol()).port;
                        }
                        this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), port, this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
                    }
                    break block8;
                }
                int port = this.uri.getPort();
                if (host.contains(":")) {
                    try {
                        String[] parts = host.split(":");
                        port = Integer.parseInt(parts[parts.length - 1]);
                        host = parts[parts.length - 2];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), host, port, this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public String getHostname() {
        return this.uri.getHost();
    }

    @Deprecated
    public void setHostname(String hostname) {
        this.setHost(hostname);
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public void setPort(int port) {
        try {
            this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), port, this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public boolean isURL() {
        return this.uri.isAbsolute();
    }

    public String getProtocol() {
        if (this.isURL()) {
            return this.uri.getScheme().toLowerCase();
        }
        return "";
    }

    public String toString() {
        return "ServerInformation [uri=" + this.uri.toString() + "]";
    }
}

