/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import mpicbg.ij.blockmatching.BlockMatching;
import mpicbg.ij.plugin.AbstractBlockMatching;
import mpicbg.models.AbstractModel;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.SpringMesh;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.Vertex;
import mpicbg.trakem2.align.Util;
import net.imglib2.IterableRealInterval;
import net.imglib2.KDTree;
import net.imglib2.RealPoint;
import net.imglib2.RealPointSampleList;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.neighborsearch.NearestNeighborSearchOnKDTree;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;

public class BlockMatching_ExtractPoinRoi
extends AbstractBlockMatching {
    protected ImagePlus imp1;
    protected ImagePlus imp2;
    protected static boolean exportPointRoi = true;
    protected static boolean exportDisplacementVectors = false;

    protected final boolean setup() {
        int[] ids = WindowManager.getIDList();
        if (ids == null || ids.length < 2) {
            IJ.showMessage((String)"You should have at least two images open.");
            return false;
        }
        String[] titles = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            titles[i] = WindowManager.getImage((int)ids[i]).getTitle();
        }
        GenericDialog gdBlockMatching = new GenericDialog("Block Matching");
        gdBlockMatching.addMessage("Image Selection:");
        String current = WindowManager.getCurrentImage().getTitle();
        gdBlockMatching.addChoice("source_image", titles, current);
        gdBlockMatching.addChoice("target_image", titles, current.equals(titles[0]) ? titles[1] : titles[0]);
        this.addFields(gdBlockMatching);
        gdBlockMatching.addMessage("Export:");
        gdBlockMatching.addCheckbox("export point correspondences", exportPointRoi);
        gdBlockMatching.addCheckbox("export colorized displacement vectors", exportDisplacementVectors);
        gdBlockMatching.showDialog();
        if (gdBlockMatching.wasCanceled()) {
            return false;
        }
        this.imp1 = WindowManager.getImage((int)ids[gdBlockMatching.getNextChoiceIndex()]);
        this.imp2 = WindowManager.getImage((int)ids[gdBlockMatching.getNextChoiceIndex()]);
        this.readFields(gdBlockMatching);
        exportPointRoi = gdBlockMatching.getNextBoolean();
        exportDisplacementVectors = gdBlockMatching.getNextBoolean();
        return true;
    }

    public void run(String arg) {
        if (!this.setup()) {
            return;
        }
        SpringMesh mesh = new SpringMesh(meshResolution, (double)this.imp1.getWidth(), (double)this.imp1.getHeight(), 1.0, 1000.0, (double)0.9f);
        ArrayList vertices = mesh.getVertices();
        RealPointSampleList maskSamples = new RealPointSampleList(2);
        for (Vertex vertex : vertices) {
            maskSamples.add(new RealPoint(vertex.getL()), (Object)new ARGBType(-1));
        }
        ArrayList<PointMatch> pm12 = new ArrayList<PointMatch>();
        ArrayList v1 = mesh.getVertices();
        FloatProcessor ip1 = (FloatProcessor)this.imp1.getProcessor().convertToFloat().duplicate();
        FloatProcessor ip2 = (FloatProcessor)this.imp2.getProcessor().convertToFloat().duplicate();
        FloatProcessor ip1Mask = BlockMatching_ExtractPoinRoi.createMask((ColorProcessor)this.imp1.getProcessor().convertToRGB());
        FloatProcessor ip2Mask = BlockMatching_ExtractPoinRoi.createMask((ColorProcessor)this.imp2.getProcessor().convertToRGB());
        TranslationModel2D ct = new TranslationModel2D();
        try {
            BlockMatching.matchByMaximalPMCC((FloatProcessor)ip1, (FloatProcessor)ip2, (FloatProcessor)ip1Mask, (FloatProcessor)ip2Mask, (double)scale, (CoordinateTransform)ct, (int)blockRadius, (int)blockRadius, (int)searchRadius, (int)searchRadius, (float)minR, (float)rodR, (float)maxCurvatureR, (Collection)v1, pm12, (ErrorStatistic)new ErrorStatistic(1));
        }
        catch (InterruptedException e) {
            IJ.log((String)"Block Matching interrupted.");
            return;
        }
        catch (ExecutionException e) {
            IJ.log((String)"Execution Exception occured during Block Matching.");
            e.printStackTrace();
            return;
        }
        IJ.log((String)(pm12.size() + " blockmatch candidates found."));
        if (useLocalSmoothnessFilter) {
            AbstractModel<?> model = Util.createModel(localModelIndex);
            try {
                model.localSmoothnessFilter(pm12, pm12, (double)localRegionSigma, (double)maxLocalEpsilon, (double)maxLocalTrust);
            }
            catch (NotEnoughDataPointsException e) {
                pm12.clear();
            }
            catch (IllDefinedDataPointsException e) {
                pm12.clear();
            }
            IJ.log((String)(pm12.size() + " blockmatch candidates passed local smoothness filter."));
        }
        if (exportPointRoi) {
            ArrayList pm12Sources = new ArrayList();
            ArrayList pm12Targets = new ArrayList();
            PointMatch.sourcePoints(pm12, pm12Sources);
            PointMatch.targetPoints(pm12, pm12Targets);
            PointRoi roi1 = mpicbg.ij.util.Util.pointsToPointRoi(pm12Sources);
            PointRoi roi2 = mpicbg.ij.util.Util.pointsToPointRoi(pm12Targets);
            this.imp1.setRoi((Roi)roi1);
            this.imp2.setRoi((Roi)roi2);
        }
        if (exportDisplacementVectors) {
            ArrayList pm12Targets = new ArrayList();
            PointMatch.targetPoints(pm12, pm12Targets);
            RealPointSampleList maskSamples2 = new RealPointSampleList(2);
            for (Point point : pm12Targets) {
                maskSamples2.add(new RealPoint(point.getW()), (Object)new ARGBType(-1));
            }
            ImagePlusImgFactory factory = new ImagePlusImgFactory();
            KDTree kdtreeMatches = new KDTree(BlockMatching_ExtractPoinRoi.matches2ColorSamples(pm12));
            KDTree kdtreeMask = new KDTree((IterableRealInterval)maskSamples);
            ImagePlusImg img = factory.create(new long[]{this.imp1.getWidth(), this.imp1.getHeight()}, (NativeType)new ARGBType());
            BlockMatching_ExtractPoinRoi.drawNearestNeighbor(img, new NearestNeighborSearchOnKDTree(kdtreeMatches), new NearestNeighborSearchOnKDTree(kdtreeMask));
            try {
                img.getImagePlus().show();
            }
            catch (ImgLibException e) {
                IJ.log((String)"ImgLib2 Exception, vectors could not be painted.");
                e.printStackTrace();
            }
        }
    }
}

