/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.roi;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.ImageJService;
import net.imagej.roi.DefaultROITree;
import net.imagej.roi.ROITree;
import net.imglib2.Interval;
import net.imglib2.KDTree;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPointSampleList;
import net.imglib2.RealRandomAccessible;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.roi.Mask;
import net.imglib2.roi.MaskInterval;
import net.imglib2.roi.MaskPredicate;
import net.imglib2.roi.RealMask;
import net.imglib2.roi.RealMaskRealInterval;
import net.imglib2.roi.geom.GeomMasks;
import net.imglib2.roi.geom.real.RealPointCollection;
import net.imglib2.roi.geom.real.WritableBox;
import net.imglib2.roi.geom.real.WritableEllipsoid;
import net.imglib2.roi.geom.real.WritableLine;
import net.imglib2.roi.geom.real.WritablePointMask;
import net.imglib2.roi.geom.real.WritablePolygon2D;
import net.imglib2.roi.geom.real.WritablePolyline;
import net.imglib2.roi.geom.real.WritableRealPointCollection;
import net.imglib2.roi.geom.real.WritableSphere;
import net.imglib2.roi.geom.real.WritableSuperEllipsoid;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.type.logic.BoolType;
import org.scijava.util.DefaultTreeNode;
import org.scijava.util.TreeNode;

public interface ROIService
extends ImageJService {
    public static final String ROI_PROPERTY = "rois";

    default public ROITree getROIs(Dataset img) {
        Object o = img.getProperties().get(ROI_PROPERTY);
        return o instanceof ROITree ? (ROITree)o : null;
    }

    default public void add(Object roi, Object img) {
        if (!(roi instanceof MaskPredicate)) {
            throw new IllegalArgumentException(roi.getClass() + " is not a supported ROI type");
        }
        if (!(img instanceof Dataset)) {
            throw new IllegalArgumentException(img.getClass() + " is not a supported image type");
        }
        Dataset d = (Dataset)img;
        MaskPredicate mp = (MaskPredicate)roi;
        if (d.getProperties().get(ROI_PROPERTY) != null) {
            ROITree rp = (ROITree)d.getProperties().get(ROI_PROPERTY);
            rp.children().add(new DefaultTreeNode((Object)mp, (TreeNode)rp));
        } else {
            DefaultROITree rp = new DefaultROITree();
            rp.addROIs(Collections.singletonList(mp));
            d.getProperties().put(ROI_PROPERTY, rp);
        }
    }

    default public boolean hasROIs(Object o) {
        if (o instanceof Dataset) {
            return ((Dataset)o).getProperties().get(ROI_PROPERTY) != null;
        }
        return o instanceof MaskPredicate;
    }

    default public void clear(Dataset img) {
        img.getProperties().put(ROI_PROPERTY, null);
    }

    public Mask toMask(Object var1);

    public MaskInterval toMaskInterval(Object var1);

    public RealMask toRealMask(Object var1);

    public RealMaskRealInterval toRealMaskRealInterval(Object var1);

    public MaskPredicate<?> toMaskPredicate(Object var1);

    public RandomAccessible<BoolType> toRandomAcessible(Object var1);

    public RandomAccessibleInterval<BoolType> toRandomAccessibleInterval(Object var1);

    public RealRandomAccessible<BoolType> toRealRandomAccessible(Object var1);

    public RealRandomAccessibleRealInterval<BoolType> toRealRandomAccessibleRealInterval(Object var1);

    default public WritableBox closedBox(double[] min, double[] max) {
        return GeomMasks.closedBox(min, max);
    }

    default public WritableBox openBox(double[] min, double[] max) {
        return GeomMasks.openBox(min, max);
    }

    default public WritableEllipsoid closedEllipsoid(double[] center, double[] semiAxisLengths) {
        return GeomMasks.closedEllipsoid(center, semiAxisLengths);
    }

    default public WritableEllipsoid openEllipsoid(double[] center, double[] semiAxisLengths) {
        return GeomMasks.openEllipsoid(center, semiAxisLengths);
    }

    default public WritableLine line(RealLocalizable pointOne, RealLocalizable pointTwo) {
        return GeomMasks.line(pointOne, pointTwo);
    }

    default public WritableLine line(double[] pointOne, double[] pointTwo, boolean copy) {
        return GeomMasks.line(pointOne, pointTwo, copy);
    }

    default public WritablePointMask pointMask(double[] point) {
        return GeomMasks.pointMask(point);
    }

    default public WritablePointMask pointMask(RealLocalizable point) {
        return GeomMasks.pointMask(point);
    }

    default public WritablePolygon2D polygon2D(List<? extends RealLocalizable> vertices) {
        return GeomMasks.polygon2D(vertices);
    }

    default public WritablePolygon2D polygon2D(double[] x, double[] y) {
        return GeomMasks.polygon2D(x, y);
    }

    default public WritablePolygon2D closedPolygon2D(List<? extends RealLocalizable> vertices) {
        return GeomMasks.closedPolygon2D(vertices);
    }

    default public WritablePolygon2D closedPolygon2D(double[] x, double[] y) {
        return GeomMasks.closedPolygon2D(x, y);
    }

    default public WritablePolygon2D openPolygon2D(List<? extends RealLocalizable> vertices) {
        return GeomMasks.openPolygon2D(vertices);
    }

    default public WritablePolygon2D openPolygon2D(double[] x, double[] y) {
        return GeomMasks.openPolygon2D(x, y);
    }

    default public WritablePolyline polyline(List<? extends RealLocalizable> vertices) {
        return GeomMasks.polyline(vertices);
    }

    default public <L extends RealLocalizable> WritableRealPointCollection<L> realPointCollection(HashMap<TDoubleArrayList, L> points) {
        return GeomMasks.realPointCollection(points);
    }

    default public <L extends RealLocalizable> WritableRealPointCollection<L> realPointCollection(Collection<L> points) {
        return GeomMasks.realPointCollection(points);
    }

    default public <L extends RealLocalizable> RealPointCollection<L> kDTreeRealPointCollection(KDTree<L> tree) {
        return GeomMasks.kDTreeRealPointCollection(tree);
    }

    default public <L extends RealLocalizable> RealPointCollection<L> kDTreeRealPointCollection(Collection<L> points) {
        return GeomMasks.kDTreeRealPointCollection(points);
    }

    default public <L extends RealLocalizable> WritableRealPointCollection<L> realPointSampleListRealPointCollection(RealPointSampleList<L> points) {
        return GeomMasks.realPointSampleListRealPointCollection(points);
    }

    default public <L extends RealLocalizable> WritableRealPointCollection<L> realPointSampleListRealPointCollection(Collection<L> points) {
        return GeomMasks.realPointSampleListRealPointCollection(points);
    }

    default public WritableSphere closedSphere(double[] center, double radius) {
        return GeomMasks.closedSphere(center, radius);
    }

    default public WritableSphere openSphere(double[] center, double radius) {
        return GeomMasks.openSphere(center, radius);
    }

    default public WritableSuperEllipsoid closedSuperEllipsoid(double[] center, double[] semiAxisLengths, double exponent) {
        return GeomMasks.closedSuperEllipsoid(center, semiAxisLengths, exponent);
    }

    default public WritableSuperEllipsoid openSuperEllipsoid(double[] center, double[] semiAxisLengths, double exponent) {
        return GeomMasks.openSuperEllipsoid(center, semiAxisLengths, exponent);
    }

    default public ImgLabeling<?, ?> toImgLabeling(Dataset dataset) {
        return this.toImgLabeling(this.getROIs(dataset), (Interval)dataset);
    }

    public ImgLabeling<?, ?> toImgLabeling(ROITree var1, Interval var2);
}

