/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imagej.ChannelCollection;
import net.imagej.Data;
import net.imagej.Dataset;
import net.imagej.DrawingTool;
import net.imagej.Position;
import net.imagej.display.DataView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayInfoList;
import net.imagej.display.OverlayService;
import net.imagej.display.OverlayView;
import net.imagej.options.OptionsOverlay;
import net.imagej.overlay.CompositeOverlay;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.OverlaySettings;
import net.imagej.render.RenderingService;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.roi.RegionOfInterest;
import net.imglib2.type.logic.BitType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;
import net.imglib2.view.Views;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.object.ObjectService;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.RealRect;

@Plugin(type=Service.class)
public final class DefaultOverlayService
extends AbstractService
implements OverlayService {
    @Parameter
    private ObjectService objectService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private OptionsService optionsService;
    @Parameter
    private RenderingService renderingService;
    private OverlaySettings defaultSettings;
    private OverlayInfoList overlayInfo;

    @Override
    public ObjectService getObjectService() {
        return this.objectService;
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.objectService.getObjects(Overlay.class);
    }

    @Override
    public List<Overlay> getOverlays(ImageDisplay display, boolean selectedOnly) {
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        Iterator iterator = display.iterator();
        while (iterator.hasNext()) {
            Data data;
            DataView view = (DataView)iterator.next();
            if (selectedOnly && !view.isSelected() || !((data = view.getData()) instanceof Overlay)) continue;
            Overlay overlay = (Overlay)data;
            overlays.add(overlay);
        }
        return overlays;
    }

    @Override
    public List<Overlay> getOverlays(ImageDisplay display) {
        return this.getOverlays(display, false);
    }

    @Override
    public void addOverlays(ImageDisplay display, List<? extends Overlay> overlays) {
        for (Overlay overlay : overlays) {
            display.display(overlay);
        }
    }

    @Override
    public void removeOverlay(ImageDisplay display, Overlay overlay) {
        ArrayList<DataView> overlayViews = new ArrayList<DataView>();
        ImageDisplay views = display;
        Iterator iterator = views.iterator();
        while (iterator.hasNext()) {
            DataView view = (DataView)iterator.next();
            Data data = view.getData();
            if (data != overlay) continue;
            overlayViews.add(view);
        }
        for (DataView view : overlayViews) {
            display.remove(view);
            view.dispose();
        }
        display.update();
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        List imgDisps = this.objectService.getObjects(ImageDisplay.class);
        for (ImageDisplay disp : imgDisps) {
            this.removeOverlay(disp, overlay);
        }
    }

    @Override
    public RealRect getSelectionBounds(ImageDisplay display) {
        double temp;
        double xMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        Iterator iterator = display.iterator();
        while (iterator.hasNext()) {
            DataView view = (DataView)iterator.next();
            if (!view.isSelected()) continue;
            Data data = view.getData();
            double min0 = data.realMin(0);
            double max0 = data.realMax(0);
            double min1 = data.realMin(1);
            double max1 = data.realMax(1);
            if (min0 < xMin) {
                xMin = min0;
            }
            if (max0 > xMax) {
                xMax = max0;
            }
            if (min1 < yMin) {
                yMin = min1;
            }
            if (!(max1 > yMax)) continue;
            yMax = max1;
        }
        double totalMinX = display.realMin(0);
        double totalMaxX = display.realMax(0);
        double totalMinY = display.realMin(1);
        double totalMaxY = display.realMax(1);
        if (xMin < totalMinX || xMin > totalMaxX) {
            xMin = totalMinX;
        }
        if (xMax < totalMinX || xMax > totalMaxX) {
            xMax = totalMaxX;
        }
        if (yMin < totalMinY || yMin > totalMaxY) {
            yMin = totalMinY;
        }
        if (yMax < totalMinY || yMax > totalMaxY) {
            yMax = totalMaxY;
        }
        if (xMin > xMax) {
            temp = xMin;
            xMin = xMax;
            xMax = temp;
        }
        if (yMin > yMax) {
            temp = yMin;
            yMin = yMax;
            yMax = temp;
        }
        return new RealRect(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    @Override
    public OverlaySettings getDefaultSettings() {
        if (this.defaultSettings == null) {
            this.defaultSettings = new OverlaySettings();
            OptionsOverlay overlayOptions = (OptionsOverlay)this.optionsService.getOptions(OptionsOverlay.class);
            overlayOptions.updateSettings(this.defaultSettings);
        }
        return this.defaultSettings;
    }

    @Override
    public void drawOverlay(Overlay o, ImageDisplay display, ChannelCollection channels) {
        this.draw(o, this.imageDisplayService.getActiveDataset(display), this.imageDisplayService.getActivePosition(display), channels, new OverlayOutliner());
    }

    @Override
    public void drawOverlay(Overlay o, Dataset ds, Position position, ChannelCollection channels) {
        this.draw(o, ds, position, channels, new OverlayOutliner());
    }

    @Override
    public void fillOverlay(Overlay o, ImageDisplay display, ChannelCollection channels) {
        this.draw(o, this.imageDisplayService.getActiveDataset(display), this.imageDisplayService.getActivePosition(display), channels, new OverlayFiller());
    }

    @Override
    public void fillOverlay(Overlay o, Dataset ds, Position position, ChannelCollection channels) {
        this.draw(o, ds, position, channels, new OverlayFiller());
    }

    @Override
    public ImageDisplay getFirstDisplay(Overlay o) {
        List displays = this.displayService.getDisplays();
        for (Display display : displays) {
            List<Overlay> displayOverlays;
            if (!(display instanceof ImageDisplay) || !(displayOverlays = this.getOverlays((ImageDisplay)display)).contains(o)) continue;
            return (ImageDisplay)display;
        }
        return null;
    }

    @Override
    public List<ImageDisplay> getDisplays(Overlay o) {
        ArrayList<ImageDisplay> containers = new ArrayList<ImageDisplay>();
        List displays = this.displayService.getDisplays();
        for (Display display : displays) {
            if (!(display instanceof ImageDisplay)) continue;
            ImageDisplay imageDisplay = (ImageDisplay)display;
            Iterator iterator = imageDisplay.iterator();
            while (iterator.hasNext()) {
                Overlay overlay;
                DataView view = (DataView)iterator.next();
                Data data = view.getData();
                if (!(data instanceof Overlay) || (overlay = (Overlay)data) != o) continue;
                containers.add(imageDisplay);
            }
        }
        return containers;
    }

    @Override
    public Overlay getActiveOverlay(ImageDisplay disp) {
        Iterator iterator = disp.iterator();
        while (iterator.hasNext()) {
            DataView view = (DataView)iterator.next();
            if (!view.isSelected() || !(view instanceof OverlayView)) continue;
            return ((OverlayView)view).getData();
        }
        return null;
    }

    @Override
    public OverlayInfoList getOverlayInfo() {
        if (this.overlayInfo == null) {
            this.overlayInfo = new OverlayInfoList();
        }
        return this.overlayInfo;
    }

    @Override
    public void divideCompositeOverlay(CompositeOverlay overlay) {
        List<Overlay> subcomponents = overlay.getSubcomponents();
        List<ImageDisplay> owners = this.getDisplays(overlay);
        for (ImageDisplay owner : owners) {
            boolean changes = false;
            List<Overlay> displayOverlays = this.getOverlays(owner);
            for (Overlay subcomponent : subcomponents) {
                if (displayOverlays.contains(subcomponent)) continue;
                owner.display(subcomponent);
                changes = true;
            }
            if (!changes) continue;
            owner.update();
        }
        this.removeOverlay(overlay);
    }

    private void draw(Overlay o, Dataset ds, Position position, ChannelCollection channels, Drawer drawer) {
        if (ds == null) {
            return;
        }
        DrawingTool tool = new DrawingTool(ds, this.renderingService);
        long[] pp = new long[position.numDimensions()];
        position.localize(pp);
        long[] fullPos = new long[pp.length + 2];
        for (int i = 2; i < fullPos.length; ++i) {
            fullPos[i] = pp[i - 2];
        }
        tool.setPosition(fullPos);
        tool.setChannels(channels);
        drawer.draw(o, tool);
        ds.update();
    }

    private static <T> IterableInterval<T> iterableInterval(RealRandomAccessibleRealInterval<T> realInterval) {
        RandomAccessibleOnRealRandomAccessible raster = Views.raster(realInterval);
        IntervalView interval = Views.interval((RandomAccessible)raster, (long[])DefaultOverlayService.findMin(realInterval), (long[])DefaultOverlayService.findMax(realInterval));
        return Views.iterable((RandomAccessibleInterval)interval);
    }

    private static long[] findMin(RealInterval realInterval) {
        long[] boundMin = new long[realInterval.numDimensions()];
        for (int i = 0; i < boundMin.length; ++i) {
            boundMin[i] = (long)Math.floor(realInterval.realMin(i));
        }
        return boundMin;
    }

    private static long[] findMax(RealInterval realInterval) {
        long[] boundMax = new long[realInterval.numDimensions()];
        for (int i = 0; i < boundMax.length; ++i) {
            boundMax[i] = (long)Math.ceil(realInterval.realMax(i));
        }
        return boundMax;
    }

    private static class OverlayFiller
    implements Drawer {
        private OverlayFiller() {
        }

        @Override
        public void draw(Overlay o, DrawingTool tool) {
            RegionOfInterest region = o.getRegionOfInterest();
            Cursor cursor = DefaultOverlayService.iterableInterval(region).localizingCursor();
            long[] pos = new long[region.numDimensions()];
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.localize(pos);
                if (!((BitType)cursor.get()).get()) continue;
                tool.drawPixel(pos[0], pos[1]);
            }
        }
    }

    private static class OverlayOutliner
    implements Drawer {
        private OverlayOutliner() {
        }

        @Override
        public void draw(Overlay o, DrawingTool tool) {
            RegionOfInterest region = o.getRegionOfInterest();
            IterableInterval ii = DefaultOverlayService.iterableInterval(region);
            long[] max = new long[region.numDimensions()];
            ii.max(max);
            Cursor cursor = ii.localizingCursor();
            RealRandomAccess accessor = region.realRandomAccess();
            long[] pos = new long[region.numDimensions()];
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.localize(pos);
                accessor.setPosition(pos);
                if (!((BitType)accessor.get()).get() || !this.isBorderPixel((RealRandomAccess<BitType>)accessor, pos, max[0], max[1])) continue;
                tool.drawPixel(pos[0], pos[1]);
            }
        }

        private boolean isBorderPixel(RealRandomAccess<BitType> accessor, long[] pos, long maxX, long maxY) {
            if (pos[0] == 0L) {
                return true;
            }
            if (pos[0] == maxX) {
                return true;
            }
            if (pos[1] == 0L) {
                return true;
            }
            if (pos[1] == maxY) {
                return true;
            }
            accessor.setPosition(pos[0] - 1L, 0);
            if (!((BitType)accessor.get()).get()) {
                return true;
            }
            accessor.setPosition(pos[0] + 1L, 0);
            if (!((BitType)accessor.get()).get()) {
                return true;
            }
            accessor.setPosition(pos[0], 0);
            accessor.setPosition(pos[1] - 1L, 1);
            if (!((BitType)accessor.get()).get()) {
                return true;
            }
            accessor.setPosition(pos[1] + 1L, 1);
            return !((BitType)accessor.get()).get();
        }
    }

    private static interface Drawer {
        public void draw(Overlay var1, DrawingTool var2);
    }
}

