/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.render.RenderingService;
import net.imagej.render.TextRenderer;
import net.imglib2.RandomAccess;
import net.imglib2.type.numeric.RealType;

public class DrawingTool {
    private final Dataset dataset;
    private int uAxis;
    private int vAxis;
    private int channelAxis;
    private long preferredChannel;
    private final RandomAccess<? extends RealType<?>> accessor;
    private long lineWidth;
    private long u0;
    private long v0;
    private long maxU;
    private long maxV;
    private ChannelCollection channels;
    private double intensity;
    private TextRenderer textRenderer;

    public DrawingTool(Dataset ds, RenderingService service) {
        this.dataset = ds;
        this.accessor = ds.getImgPlus().randomAccess();
        this.channels = new ChannelCollection();
        this.lineWidth = 1L;
        this.intensity = 1.0;
        this.textRenderer = service.getTextRenderer();
        this.u0 = 0L;
        this.v0 = 0L;
        this.preferredChannel = -1L;
        this.initAxisVariables();
    }

    public void setPreferredChannel(long channelNumber) {
        if (channelNumber > 0L) {
            boolean invalid;
            boolean bl = invalid = this.channelAxis < 0;
            if (!invalid) {
                boolean bl2 = invalid = channelNumber >= this.dataset.dimension(this.channelAxis);
            }
            if (invalid) {
                throw new IllegalArgumentException("preferred channel outside valid range");
            }
        }
        this.preferredChannel = channelNumber;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setUAxis(int axisNum) {
        this.checkAxisValid(axisNum);
        this.uAxis = axisNum;
        this.maxU = this.dataset.dimension(this.uAxis) - 1L;
    }

    public int getUAxis() {
        return this.uAxis;
    }

    public void setVAxis(int axisNum) {
        this.checkAxisValid(axisNum);
        this.vAxis = axisNum;
        this.maxV = this.dataset.dimension(this.vAxis) - 1L;
    }

    public int getVAxis() {
        return this.vAxis;
    }

    public void setPosition(long[] position) {
        this.accessor.setPosition(position);
    }

    public void getPosition(long[] position) {
        for (int i = 0; i < this.accessor.numDimensions(); ++i) {
            position[i] = this.accessor.getLongPosition(i);
        }
    }

    public ChannelCollection getChannels() {
        return this.channels;
    }

    public void setChannels(ChannelCollection chans) {
        this.channels = chans;
    }

    public void setLineWidth(long lineWidth) {
        this.lineWidth = lineWidth;
    }

    public long getLineWidth() {
        return this.lineWidth;
    }

    public void setTextRenderer(TextRenderer renderer) {
        this.textRenderer = renderer;
    }

    public void setFontFamily(TextRenderer.FontFamily family) {
        this.textRenderer.setFontFamily(family);
    }

    public TextRenderer.FontFamily getFontFamily() {
        return this.textRenderer.getFontFamily();
    }

    public void setFontStyle(TextRenderer.FontStyle style) {
        this.textRenderer.setFontStyle(style);
    }

    public TextRenderer.FontStyle getFontStyle() {
        return this.textRenderer.getFontStyle();
    }

    public void setFontSize(int size) {
        this.textRenderer.setFontSize(size);
    }

    public int getFontSize() {
        return this.textRenderer.getFontSize();
    }

    public void setTextAntialiasing(boolean value) {
        this.textRenderer.setAntialiasing(value);
    }

    public boolean getTextAntialiasing() {
        return this.textRenderer.getAntialiasing();
    }

    public void drawPixel(long u, long v) {
        if (u < 0L) {
            return;
        }
        if (v < 0L) {
            return;
        }
        if (u > this.maxU) {
            return;
        }
        if (v > this.maxV) {
            return;
        }
        this.accessor.setPosition(u, this.uAxis);
        this.accessor.setPosition(v, this.vAxis);
        if (this.preferredChannel >= 0L) {
            double value = this.intensity * this.channels.getChannelValue(this.preferredChannel);
            if (this.channelAxis != -1) {
                this.accessor.setPosition(this.preferredChannel, this.channelAxis);
            }
            ((RealType)this.accessor.get()).setReal(value);
        } else {
            long numChannels = 1L;
            if (this.channelAxis != -1) {
                numChannels = this.dataset.dimension(this.channelAxis);
            }
            for (long c = 0L; c < numChannels; ++c) {
                double value = this.intensity * this.channels.getChannelValue(c);
                if (this.channelAxis != -1) {
                    this.accessor.setPosition(c, this.channelAxis);
                }
                ((RealType)this.accessor.get()).setReal(value);
            }
        }
        this.dataset.setDirty(true);
    }

    public void drawDot(long u, long v) {
        if (this.lineWidth == 1L) {
            this.drawPixel(u, v);
        } else if (this.lineWidth == 2L) {
            this.drawPixel(u, v);
            this.drawPixel(u, v - 1L);
            this.drawPixel(u - 1L, v);
            this.drawPixel(u - 1L, v - 1L);
        } else {
            this.fillCircle(u, v);
        }
    }

    public void moveTo(long u, long v) {
        this.u0 = u;
        this.v0 = v;
    }

    public void lineTo(long u1, long v1) {
        long du = u1 - this.u0;
        long dv = v1 - this.v0;
        long absdu = du >= 0L ? du : -du;
        long absdv = dv >= 0L ? dv : -dv;
        long n = absdv > absdu ? absdv : absdu;
        double uinc = (double)du / (double)n;
        double vinc = (double)dv / (double)n;
        double u = this.u0;
        double v = this.v0;
        ++n;
        this.u0 = u1;
        this.v0 = v1;
        do {
            this.drawDot(Math.round(u), Math.round(v));
            u += uinc;
            v += vinc;
        } while (--n > 0L);
    }

    public void drawLine(long u1, long v1, long u2, long v2) {
        this.moveTo(u1, v1);
        this.lineTo(u2, v2);
    }

    public void fillCircle(long uc, long vc) {
        double r = (double)this.lineWidth / 2.0;
        long umin = (long)((double)uc - r + 0.5);
        long vmin = (long)((double)vc - r + 0.5);
        long umax = umin + this.lineWidth;
        long vmax = vmin + this.lineWidth;
        double r2 = r * r;
        double uoffset = (double)umin + (r -= 0.5);
        double voffset = (double)vmin + r;
        for (long v = vmin; v < vmax; ++v) {
            for (long u = umin; u < umax; ++u) {
                double uu = (double)u - uoffset;
                double vv = (double)v - voffset;
                if (!(uu * uu + vv * vv <= r2)) continue;
                this.drawPixel(u, v);
            }
        }
    }

    public void drawRect(long uOrg, long vOrg, long w, long h) {
        this.drawLine(uOrg, vOrg, uOrg, vOrg + h - 1L);
        this.drawLine(uOrg, vOrg, uOrg + w - 1L, vOrg);
        this.drawLine(uOrg + w - 1L, vOrg + h - 1L, uOrg, vOrg + h - 1L);
        this.drawLine(uOrg + w - 1L, vOrg + h - 1L, uOrg + w - 1L, vOrg);
    }

    public void fillRect(long uOrigin, long vOrigin, long w, long h) {
        for (long du = 0L; du < w; ++du) {
            for (long dv = 0L; dv < h; ++dv) {
                this.drawPixel(uOrigin + du, vOrigin + dv);
            }
        }
    }

    public void fill() {
        this.fillRect(0L, 0L, this.maxU + 1L, this.maxV + 1L);
    }

    public void drawText(long anchorU, long anchorV, String text, TextRenderer.TextJustification just) {
        long originV;
        long originU;
        this.textRenderer.renderText(text);
        int bufferSizeU = this.textRenderer.getPixelsWidth();
        int bufferSizeV = this.textRenderer.getPixelsHeight();
        int[] buffer = this.textRenderer.getPixels();
        int minu = Integer.MAX_VALUE;
        int minv = Integer.MAX_VALUE;
        int maxu = Integer.MIN_VALUE;
        int maxv = Integer.MIN_VALUE;
        for (int u = 0; u < bufferSizeU; ++u) {
            for (int v = 0; v < bufferSizeV; ++v) {
                int index = v * bufferSizeU + u;
                if (buffer[index] == 0) continue;
                if (u < minu) {
                    minu = u;
                }
                if (u > maxu) {
                    maxu = u;
                }
                if (v < minv) {
                    minv = v;
                }
                if (v <= maxv) continue;
                maxv = v;
            }
        }
        switch (just) {
            case CENTER: {
                originU = anchorU - (long)((maxu - minu + 1) / 2);
                originV = anchorV - (long)((maxv - minv + 1) / 2);
                break;
            }
            case RIGHT: {
                originU = anchorU - (long)(maxu - minu + 1);
                originV = anchorV - (long)(maxv - minv + 1);
                break;
            }
            default: {
                originU = anchorU;
                originV = anchorV;
            }
        }
        for (int u = minu; u <= maxu; ++u) {
            for (int v = minv; v <= maxv; ++v) {
                int index = v * bufferSizeU + u;
                if (buffer[index] == 0) continue;
                double pixVal = buffer[index] & 0xFF;
                this.intensity = pixVal / 255.0;
                this.drawPixel(originU + (long)u - (long)minu, originV + (long)v - (long)minv);
            }
        }
        this.intensity = 1.0;
    }

    private void initAxisVariables() {
        this.channelAxis = this.dataset.dimensionIndex(Axes.CHANNEL);
        this.uAxis = -1;
        this.vAxis = -1;
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            if (i == this.channelAxis) continue;
            if (this.uAxis == -1) {
                this.uAxis = i;
                continue;
            }
            if (this.vAxis != -1) continue;
            this.vAxis = i;
        }
        if (this.uAxis == -1 || this.vAxis == -1) {
            throw new IllegalArgumentException("DrawingTool cannot find appropriate default UV axes");
        }
        this.maxU = this.dataset.dimension(this.uAxis) - 1L;
        this.maxV = this.dataset.dimension(this.vAxis) - 1L;
    }

    private void checkAxisValid(int axisNum) {
        if (axisNum == this.channelAxis) {
            throw new IllegalArgumentException("DrawingTool misconfiguration. The tool fills multiple channels at once. Cannot use a channel plane as working plane.");
        }
    }
}

