/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.imagej.updater.util.DropboxURLMapper;
import net.imagej.updater.util.FilterManifest;
import net.imagej.updater.util.HTTPSUtil;
import net.imagej.updater.util.SkipHashedLines;
import org.scijava.log.LogService;
import org.scijava.log.StderrLogService;

public class UpdaterUtil {
    public static String MAIN_URL = HTTPSUtil.getProtocol() + "update.imagej.net/";
    public static String UPDATE_DIRECTORY = "/home/imagej/update-site";
    public static String SSH_HOST = "update.imagej.net";
    public static final String XML_COMPRESSED = "db.xml.gz";
    public static final String PREFS_USER = "imagej.updater.login";
    public static final String macPrefix = "Contents/MacOS/";
    public final String platform = UpdaterUtil.getPlatform();
    public final String[] platforms = new String[]{"linux32", "linux64", "macosx", "tiger", "win32", "win64"};
    public final String[] launchers;
    protected final Set<String> updateablePlatforms;
    protected final DropboxURLMapper dropboxURLMapper;
    public static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] months = new String[]{"Zero", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static Set<File> protectedFiles;
    private static final Pattern majorVersionPattern;

    public UpdaterUtil(File imagejRoot) {
        int macIndex = 2;
        Arrays.sort(this.platforms);
        this.launchers = (String[])this.platforms.clone();
        for (int i = 0; i < this.launchers.length; ++i) {
            this.launchers[i] = (i == 2 || i == 3 ? macPrefix : "") + "ImageJ-" + this.platforms[i] + (this.platforms[i].startsWith("win") ? ".exe" : "");
        }
        Arrays.sort(this.launchers);
        this.updateablePlatforms = new HashSet<String>();
        this.updateablePlatforms.add(this.platform);
        if (imagejRoot != null && new File(imagejRoot, this.launchers[2]).exists()) {
            this.updateablePlatforms.add("macosx");
        }
        String[] files = imagejRoot == null ? null : imagejRoot.list();
        for (String name : files == null ? new String[]{} : files) {
            if (!name.startsWith("ImageJ-")) continue;
            this.updateablePlatforms.add(UpdaterUtil.platformForLauncher(name));
        }
        this.dropboxURLMapper = new DropboxURLMapper(this);
    }

    public static String platformForLauncher(String fileName) {
        int dash = fileName.lastIndexOf(45);
        if (dash < 0) {
            return null;
        }
        String name = fileName.substring(dash + 1);
        if (name.endsWith(".exe")) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.equals("tiger") || name.equals("panther")) {
            name = "macosx";
        } else if (name.equals("linux")) {
            name = "linux32";
        }
        return name;
    }

    public static String stripSuffix(String string, String suffix) {
        if (!string.endsWith(suffix)) {
            return string;
        }
        return string.substring(0, string.length() - suffix.length());
    }

    public static String stripPrefix(String string, String prefix) {
        if (!string.startsWith(prefix)) {
            return string;
        }
        return string.substring(prefix.length());
    }

    public static String getPlatform() {
        boolean is64bit = System.getProperty("os.arch", "").indexOf("64") >= 0;
        String osName = System.getProperty("os.name", "<unknown>");
        if (osName.equals("Linux")) {
            return "linux" + (is64bit ? "64" : "32");
        }
        if (osName.equals("Mac OS X")) {
            return "macosx";
        }
        if (osName.startsWith("Windows")) {
            return "win" + (is64bit ? "64" : "32");
        }
        return osName.toLowerCase();
    }

    public static String getDigest(String path, File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException, UnsupportedEncodingException {
        if (path.endsWith(".jar")) {
            return UpdaterUtil.getJarDigest(file);
        }
        MessageDigest digest = UpdaterUtil.getDigest();
        digest.update(path.getBytes("ASCII"));
        if (file != null) {
            UpdaterUtil.updateDigest(new FileInputStream(file), digest);
        }
        return UpdaterUtil.toHex(digest.digest());
    }

    public static MessageDigest getDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-1");
    }

    public static List<String> getObsoleteDigests(String path, File file) throws FileNotFoundException, IOException {
        if (!path.endsWith(".jar")) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(UpdaterUtil.getJarDigest(file, true, true, false));
        result.add(UpdaterUtil.getJarDigest(file, true, false, false));
        result.add(UpdaterUtil.getJarDigest(file, false, false, false));
        return result;
    }

    public static void updateDigest(InputStream input, MessageDigest digest) throws IOException {
        byte[] buffer = new byte[65536];
        DigestInputStream digestStream = new DigestInputStream(input, digest);
        while (digestStream.read(buffer) >= 0) {
        }
        digestStream.close();
    }

    public static String toHex(byte[] bytes) {
        char[] buffer = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            buffer[i * 2] = hex[(bytes[i] & 0xF0) >> 4];
            buffer[i * 2 + 1] = hex[bytes[i] & 0xF];
        }
        return new String(buffer);
    }

    public static String getJarDigest(File file) throws FileNotFoundException, IOException {
        return UpdaterUtil.getJarDigest(file, true, true, true);
    }

    public static String getJarDigest(File file, boolean treatPropertiesSpecially, boolean treatManifestsSpecially) throws FileNotFoundException, IOException {
        return UpdaterUtil.getJarDigest(file, treatPropertiesSpecially, treatManifestsSpecially, false);
    }

    public static String getJarDigest(File file, boolean treatPropertiesSpecially, boolean treatManifestsSpecially, boolean keepOnlyMainClassInManifest) throws FileNotFoundException, IOException {
        MessageDigest digest = null;
        try {
            digest = UpdaterUtil.getDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (file != null) {
            JarFile jar = new JarFile(file);
            ArrayList<JarEntry> list = Collections.list(jar.entries());
            Collections.sort(list, new JarEntryComparator());
            for (JarEntry entry : list) {
                digest.update(entry.getName().getBytes("ASCII"));
                InputStream inputStream = jar.getInputStream(entry);
                if (treatPropertiesSpecially && entry.getName().endsWith(".properties")) {
                    inputStream = new SkipHashedLines(inputStream);
                }
                if (treatManifestsSpecially && entry.getName().equals("META-INF/MANIFEST.MF")) {
                    inputStream = new FilterManifest(inputStream, keepOnlyMainClassInManifest);
                }
                UpdaterUtil.updateDigest(inputStream, digest);
            }
            jar.close();
        }
        return UpdaterUtil.toHex(digest.digest());
    }

    public static long currentTimestamp() {
        return Long.parseLong(UpdaterUtil.timestamp(Calendar.getInstance()));
    }

    public static long getTimestamp(File file) {
        long modified = file.lastModified();
        return Long.parseLong(UpdaterUtil.timestamp(modified));
    }

    public static String timestamp(long millis) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(millis);
        return UpdaterUtil.timestamp(date);
    }

    public static String timestamp(Calendar date) {
        DecimalFormat format = new DecimalFormat("00");
        int month = date.get(2) + 1;
        int day = date.get(5);
        int hour = date.get(11);
        int minute = date.get(12);
        int second = date.get(13);
        return "" + date.get(1) + format.format(month) + format.format(day) + format.format(hour) + format.format(minute) + format.format(second);
    }

    public static long timestamp2millis(long timestamp) {
        return UpdaterUtil.timestamp2millis("" + timestamp);
    }

    public static long timestamp2millis(String timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(timestamp.substring(0, 4)), Integer.parseInt(timestamp.substring(4, 6)) - 1, Integer.parseInt(timestamp.substring(6, 8)), Integer.parseInt(timestamp.substring(8, 10)), Integer.parseInt(timestamp.substring(10, 12)), Integer.parseInt(timestamp.substring(12, 14)));
        return calendar.getTimeInMillis();
    }

    public static String prettyPrintTimestamp(long timestamp) {
        String t = "" + timestamp + "00000000000000";
        return t.substring(6, 8) + " " + months[Integer.parseInt(t.substring(4, 6))] + " " + t.substring(0, 4) + " " + t.substring(8, 10) + ":" + t.substring(10, 12) + ":" + t.substring(12, 14);
    }

    public boolean isLauncher(String filename) {
        return Arrays.binarySearch(this.launchers, filename) >= 0;
    }

    public boolean isUpdateablePlatform(String platform) {
        return this.updateablePlatforms.contains(platform);
    }

    public void setUpdateablePlatforms(String ... platforms) {
        this.updateablePlatforms.clear();
        for (String platform : platforms) {
            if (platform == null) continue;
            if ("all".equals(platform = platform.trim())) {
                this.updateablePlatforms.add(this.platform);
                this.updateablePlatforms.addAll(Arrays.asList(this.platforms));
                continue;
            }
            this.updateablePlatforms.add(platform);
        }
    }

    public boolean isMacOSX() {
        return this.platform.equals("macosx");
    }

    public static <T> String join(String delimiter, Iterable<T> list) {
        StringBuilder builder = new StringBuilder();
        for (T object : list) {
            builder.append((builder.length() > 0 ? delimiter : "") + object.toString());
        }
        return builder.toString();
    }

    public static void useSystemProxies() {
        String osName = System.getProperty("os.name", "<unknown>");
        if (osName.equals("Linux") && GraphicsEnvironment.isHeadless()) {
            return;
        }
        System.setProperty("java.net.useSystemProxies", "true");
    }

    @Deprecated
    public static long getLastModified(String url) {
        try {
            return new UpdaterUtil(null).getLastModified(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public long getLastModified(URL url) {
        try {
            URLConnection connection = this.openConnection(url);
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
            }
            connection.setUseCaches(false);
            long lastModified = connection.getLastModified();
            connection.getInputStream().close();
            return lastModified;
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("Server returned HTTP response code: 407")) {
                return -111381L;
            }
            if (e.getMessage().startsWith("Server returned HTTP response code: 405")) {
                try {
                    URLConnection connection = this.openConnection(url);
                    connection.setUseCaches(false);
                    long lastModified = connection.getLastModified();
                    connection.getInputStream().close();
                    return lastModified;
                }
                catch (IOException e2) {
                    e.printStackTrace();
                    e2.printStackTrace();
                }
            }
            return -1L;
        }
    }

    public InputStream openStream(URL url) throws IOException {
        return this.openConnection(url).getInputStream();
    }

    public URLConnection openConnection(URL url) throws IOException {
        URLConnection connection = this.dropboxURLMapper.get(url).openConnection();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)connection;
            String javaVmVersion = System.getProperty("java.runtime.version");
            String javaVersion = javaVmVersion != null ? javaVmVersion : System.getProperty("java.version");
            String osVersion = System.getProperty("os.version");
            String os = "" + System.getProperty("os.name") + "-" + (osVersion != null ? osVersion + "-" : "") + System.getProperty("os.arch");
            http.setRequestProperty("User-Agent", "curl/7.22.0 compatible ImageJ updater/2.0.0-SNAPSHOT (Java " + javaVersion + "/" + os + ")");
        }
        return connection;
    }

    public static byte[] readStreamAsBytes(InputStream input) throws IOException {
        byte[] buffer = new byte[1024];
        int offset = 0;
        int len = 0;
        while (true) {
            if (offset == buffer.length) {
                buffer = UpdaterUtil.realloc(buffer, 2 * buffer.length);
            }
            if ((len = input.read(buffer, offset, buffer.length - offset)) < 0) {
                return UpdaterUtil.realloc(buffer, offset);
            }
            offset += len;
        }
    }

    private static byte[] realloc(byte[] buffer, int newLength) {
        if (newLength == buffer.length) {
            return buffer;
        }
        byte[] newBuffer = new byte[newLength];
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(newLength, buffer.length));
        return newBuffer;
    }

    protected static String readFile(File file) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            builder.append(line).append('\n');
        }
        reader.close();
        return builder.toString();
    }

    protected static void writeFile(File file, String contents) throws IOException {
        File result = new File(file.getAbsoluteFile().getParentFile(), file.getName() + ".new");
        FileOutputStream out = new FileOutputStream(result);
        out.write(contents.getBytes());
        out.close();
        result.renameTo(file);
    }

    public static boolean canExecute(File file) {
        try {
            return file.canExecute();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isGPRActivated(File ijRoot) {
        String path = ijRoot.getAbsolutePath();
        return path.matches("^/private/var/folders/.*/AppTranslocation/.*");
    }

    public static boolean isProtectedLocation(File ijRoot) {
        if (UpdaterUtil.getPlatform().startsWith("win")) {
            String osVersion = System.getProperty("os.version");
            if (osVersion == null) {
                return false;
            }
            Matcher matcher = majorVersionPattern.matcher(osVersion);
            if (!matcher.matches() || Integer.parseInt(matcher.group(1)) < 6) {
                return false;
            }
            try {
                if (protectedFiles == null) {
                    protectedFiles = new HashSet<File>();
                    for (String key : new String[]{"PROGRAMFILES", "PROGRAMFILES(X86)", "SystemRoot", "ALLUSERSPROFILE"}) {
                        File f;
                        String path = System.getenv(key);
                        if (path == null || (f = new File(path).getCanonicalFile()).canWrite()) continue;
                        protectedFiles.add(f);
                    }
                }
                for (File dir = ijRoot.getCanonicalFile(); dir != null; dir = dir.getParentFile()) {
                    if (!protectedFiles.contains(dir)) continue;
                    protectedFiles.add(ijRoot);
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean patchInfoPList(File infoPList, String executable) throws IOException {
        if (!infoPList.exists()) {
            return false;
        }
        String contents = UpdaterUtil.readFile(infoPList);
        Pattern pattern = Pattern.compile(".*<key>CFBundleExecutable</key>[^<]*<string>([^<]*).*", 40);
        Matcher matcher = pattern.matcher(contents);
        if (!matcher.matches()) {
            return false;
        }
        contents = contents.substring(0, matcher.start(1)) + executable + contents.substring(matcher.end(1));
        UpdaterUtil.writeFile(infoPList, contents);
        return true;
    }

    public static <T> Iterable<T> iterate(final Enumeration<T> en) {
        final Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public T next() {
                return en.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static LogService getLogService() {
        return new StderrLogService();
    }

    public static String toCamelCase(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        boolean upCase = true;
        for (char ch : string.toCharArray()) {
            if (Character.isLetterOrDigit(ch)) {
                builder.append(upCase ? Character.toUpperCase(ch) : Character.toLowerCase(ch));
                upCase = false;
                continue;
            }
            upCase = true;
        }
        return builder.toString();
    }

    static {
        majorVersionPattern = Pattern.compile("([0-9]+).*");
    }

    private static class JarEntryComparator
    implements Comparator<JarEntry> {
        private JarEntryComparator() {
        }

        @Override
        public int compare(JarEntry entry1, JarEntry entry2) {
            String name1 = entry1.getName();
            String name2 = entry2.getName();
            return name1.compareTo(name2);
        }
    }
}

