/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.imagej.updater.util.UpdaterUtil;

public class DropboxURLMapper {
    private Map<URL, URL> map = new HashMap<URL, URL>();
    protected final UpdaterUtil util;
    private static final Pattern urlPattern = Pattern.compile("^(https?://www.dropbox.com/sh/[^/]*/[^/]*)(/.*)?$");

    protected DropboxURLMapper(UpdaterUtil util) {
        this.util = util;
    }

    public URL get(URL url) throws IOException {
        if (!DropboxURLMapper.isDropBoxURL(url)) {
            return url;
        }
        URL result = this.map.get(url);
        if (result != null) {
            return result;
        }
        Matcher matcher = urlPattern.matcher(url.toString());
        if (!matcher.matches() || matcher.group(2) == null) {
            this.map.put(url, url);
            return url;
        }
        try {
            this.parseParent(url);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        result = this.map.get(url);
        if (result != null) {
            return result;
        }
        throw new FileNotFoundException(url.toString());
    }

    public static boolean isDropBoxURL(URL url) {
        String host = url.getHost();
        return host.endsWith(".dropbox.com");
    }

    private void parseParent(URL url) throws IOException, MalformedURLException {
        String urlString = url.toString();
        int slash = urlString.lastIndexOf(47);
        if (slash < 0) {
            throw new IOException("No slash in " + urlString);
        }
        String parentURLString = urlString.substring(0, slash);
        URL parentURLWithSlash = new URL(urlString.substring(0, slash + 1));
        if (this.map.containsKey(parentURLWithSlash)) {
            return;
        }
        URL parentURL = new URL(urlString.substring(0, slash));
        Matcher matcher = urlPattern.matcher(parentURLString);
        if (!matcher.matches()) {
            return;
        }
        if (matcher.group(2) == null) {
            this.map.put(parentURL, parentURL);
        } else {
            this.parseParent(parentURL);
        }
        StringBuilder builder = this.read(this.map.get(parentURL));
        int offset = builder.indexOf("<ol class=\"browse-files");
        if (offset < 0) {
            throw new IOException("DropBox changed the URL format again!");
        }
        while (offset > 0) {
            String anchor = "<a href=\"";
            if ((offset = builder.indexOf("<a href=\"", offset)) < 0) break;
            int quote = builder.indexOf("\"", offset += "<a href=\"".length());
            if (quote < 0) {
                throw new IOException("Invalid HTML: " + builder.substring(offset - "<a href=\"".length()));
            }
            String urlString2 = builder.substring(offset, quote);
            if (!urlPattern.matcher(urlString2).matches()) continue;
            int slash2 = urlString2.lastIndexOf(47);
            if (slash2 < 0) {
                throw new IOException("Unexpected URL: " + urlString2);
            }
            URL targetURL = new URL(urlString2);
            this.map.put(targetURL, targetURL);
            this.map.put(new URL(parentURLString + urlString2.substring(slash)), targetURL);
            offset = quote;
        }
        this.map.put(parentURLWithSlash, this.map.get(parentURL));
    }

    protected StringBuilder read(URL url) throws IOException {
        int count;
        InputStreamReader reader = new InputStreamReader(this.util.openStream(url));
        char[] buffer = new char[65536];
        StringBuilder builder = new StringBuilder();
        while ((count = reader.read(buffer)) >= 0) {
            builder.append(buffer, 0, count);
        }
        ((Reader)reader).close();
        return builder;
    }
}

