/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.XMLFileErrorHandler;
import net.imagej.updater.util.UpdaterUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLFileReader
extends DefaultHandler {
    private final FilesCollection files;
    private String updateSite;
    private Set<FileObject> filesFromThisSite = new HashSet<FileObject>();
    private long newTimestamp;
    private StringBuffer warnings = new StringBuffer();
    private FileObject current;
    private String currentTag;
    private String body;

    public XMLFileReader(FilesCollection files) {
        this.files = files;
    }

    public String getWarnings() {
        return this.warnings.toString();
    }

    public void read(String updateSite) throws ParserConfigurationException, IOException, SAXException {
        UpdateSite site = this.files.getUpdateSite(updateSite, false);
        if (site == null) {
            throw new IOException("Unknown update site: " + site);
        }
        URL url = new URL(site.getURL() + "db.xml.gz");
        URLConnection connection = this.files.util.openConnection(url);
        long lastModified = connection.getLastModified();
        this.read(updateSite, new GZIPInputStream(connection.getInputStream()), site.getTimestamp());
        site.setTimestamp(Long.parseLong(UpdaterUtil.timestamp(lastModified)));
    }

    public void read(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        this.read(null, new GZIPInputStream(in), Long.MAX_VALUE);
    }

    public void read(String updateSite, InputStream in, long timestamp) throws ParserConfigurationException, IOException, SAXException {
        this.updateSite = updateSite;
        this.filesFromThisSite.clear();
        this.newTimestamp = timestamp;
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        XMLReader xr = parser.getXMLReader();
        xr.setContentHandler(this);
        xr.setErrorHandler(new XMLFileErrorHandler());
        xr.parse(inputSource);
    }

    @Override
    public void startDocument() {
        this.body = "";
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        this.currentTag = "".equals(uri) ? qName : name;
        if (this.currentTag.equals("plugin")) {
            String updateSite = this.updateSite;
            if (updateSite == null && (updateSite = atts.getValue("update-site")) == null) {
                updateSite = "Fiji";
            }
            this.current = new FileObject(updateSite, atts.getValue("filename"), -1L, null, 0L, FileObject.Status.NOT_INSTALLED);
            String executable = atts.getValue("executable");
            if ("true".equalsIgnoreCase(executable)) {
                this.current.executable = true;
            }
        } else if (this.currentTag.equals("previous-version")) {
            this.current.addPreviousVersion(atts.getValue("checksum"), this.getLong(atts, "timestamp"), atts.getValue("filename"), this.getLong(atts, "timestamp-obsolete"));
        } else if (this.currentTag.equals("version")) {
            this.current.setVersion(atts.getValue("checksum"), this.getLong(atts, "timestamp"));
            this.current.filesize = this.getLong(atts, "filesize");
        } else if (this.currentTag.equals("dependency")) {
            String overrides = atts.getValue("overrides");
            this.current.addDependency(atts.getValue("filename"), this.getLong(atts, "timestamp"), overrides != null && overrides.equals("true"));
        } else if (this.updateSite == null && (this.currentTag.equals("update-site") || this.currentTag.equals("disabled-update-site"))) {
            String keepURL;
            UpdateSite site = new UpdateSite(atts.getValue("name"), atts.getValue("url"), atts.getValue("ssh-host"), atts.getValue("upload-directory"), atts.getValue("description"), atts.getValue("maintainer"), Long.parseLong(atts.getValue("timestamp")));
            String official = atts.getValue("official");
            if (official != null) {
                site.setOfficial(Boolean.valueOf(official));
            }
            if ((keepURL = atts.getValue("keep-url")) == null) {
                site.setKeepURL(false);
            }
            site.setKeepURL(Boolean.valueOf(keepURL));
            site.setActive(this.currentTag.equals("update-site"));
            this.files.addUpdateSite(site);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        String tagName = "".equals(uri) ? qName : name;
        if (tagName.equals("description")) {
            this.current.description = this.body;
        } else if (tagName.equals("author")) {
            this.current.addAuthor(this.body);
        } else if (tagName.equals("platform")) {
            this.current.addPlatform(this.body);
        } else if (tagName.equals("category")) {
            this.current.addCategory(this.body);
        } else if (tagName.equals("link")) {
            this.current.addLink(this.body);
        } else if (tagName.equals("plugin")) {
            XMLFileReader.fillPreviousFilenames(this.current);
            if (this.current.current == null) {
                this.current.setStatus(FileObject.Status.OBSOLETE_UNINSTALLED);
            } else if (this.current.isNewerThan(this.newTimestamp)) {
                this.current.setStatus(FileObject.Status.NEW);
                this.current.setAction(this.files, this.current.isUpdateablePlatform(this.files) ? FileObject.Action.INSTALL : FileObject.Action.NEW);
            }
            FileObject file = this.files.get(this.current.filename);
            if (this.updateSite != null || this.current.updateSite == null || this.files.getUpdateSite(this.current.updateSite, false) != null) {
                if (file == null) {
                    this.files.add(this.current);
                    this.filesFromThisSite.add(this.current);
                } else if (this.filesFromThisSite.contains(file)) {
                    if (file.isObsolete()) {
                        this.files.remove(file.filename);
                        FileObject swap = file;
                        file = this.current;
                        this.current = swap;
                        this.files.add(file);
                        this.filesFromThisSite.add(file);
                    }
                    XMLFileReader.addPreviousVersions(this.current, file);
                } else if (file.isObsolete()) {
                    if (file.updateSite != null) {
                        for (String site : file.overriddenUpdateSites.keySet()) {
                            this.current.overriddenUpdateSites.put(site, file.overriddenUpdateSites.get(site));
                        }
                        this.current.overriddenUpdateSites.put(file.updateSite, file);
                    }
                    this.files.add(this.current);
                    this.filesFromThisSite.add(this.current);
                } else if (this.current.isObsolete()) {
                    if (this.current.updateSite != null) {
                        file.overriddenUpdateSites.put(this.current.updateSite, this.current);
                    }
                } else if (this.getRank(this.files, this.updateSite) >= this.getRank(this.files, file.updateSite)) {
                    if (!(this.updateSite != null && this.updateSite.equals(file.updateSite) || this.updateSite == null && file.updateSite == null)) {
                        for (String site : file.overriddenUpdateSites.keySet()) {
                            this.current.overriddenUpdateSites.put(site, file.overriddenUpdateSites.get(site));
                        }
                        if (file.updateSite != null && !file.updateSite.equals(this.updateSite)) {
                            this.current.overriddenUpdateSites.put(file.updateSite, file);
                        }
                    }
                    if (file.localFilename != null) {
                        this.current.localFilename = file.localFilename;
                    }
                    this.current.completeMetadataFrom(file);
                    this.files.add(this.current);
                    this.filesFromThisSite.add(this.current);
                    if (this.updateSite != null && file.updateSite != null && this.getRank(this.files, this.updateSite) > this.getRank(this.files, file.updateSite)) {
                        this.files.log.debug((Object)("'" + this.current.filename + "' from update site '" + this.current.updateSite + "' shadows the one from update site '" + file.updateSite + "'"));
                    }
                } else {
                    file.overriddenUpdateSites.put(this.updateSite, this.current);
                    if (this.updateSite != null && file.updateSite != null && this.getRank(this.files, file.updateSite) > this.getRank(this.files, this.updateSite)) {
                        this.files.log.debug((Object)("'" + file.filename + "' from update site '" + file.updateSite + "' shadows the one from update site '" + this.current.updateSite + "'"));
                    }
                }
            }
            this.current = null;
        }
        this.body = "";
    }

    private static void fillPreviousFilenames(FileObject file) {
        ArrayList<FileObject.Version> versions = new ArrayList<FileObject.Version>();
        if (file.current != null) {
            versions.add(file.current);
        }
        for (FileObject.Version version : file.previous) {
            versions.add(version);
        }
        Collections.sort(versions, new Comparator<FileObject.Version>(){

            @Override
            public int compare(FileObject.Version v1, FileObject.Version v2) {
                long diff = v1.timestamp - v2.timestamp;
                return diff > 0L ? -1 : (diff < 0L ? 1 : 0);
            }
        });
        String filename = file.filename;
        for (FileObject.Version version : versions) {
            if (version.filename != null) {
                filename = version.filename;
                continue;
            }
            version.filename = filename;
        }
    }

    private static void addPreviousVersions(FileObject from, FileObject to) {
        if (from.current != null) {
            to.addPreviousVersion(from.current.checksum, from.current.timestamp, from.getLocalFilename(false), 0L);
        }
        for (FileObject.Version version : from.previous) {
            to.addPreviousVersion(version);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.body = this.body + new String(ch, start, length);
    }

    private long getLong(Attributes attributes, String key) {
        String value = attributes.getValue(key);
        return value == null ? 0L : Long.parseLong(value);
    }

    private int getRank(FilesCollection files, String updateSite) {
        if (updateSite == null || files == null) {
            return -1;
        }
        UpdateSite site = files.getUpdateSite(updateSite, false);
        return site == null ? -1 : site.getRank();
    }
}

