/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.XMLFileReader;
import net.imagej.updater.util.AbstractProgressable;

public class XMLFileDownloader
extends AbstractProgressable {
    private FilesCollection files;
    private Collection<String> updateSites;
    private StringBuilder warnings;

    public XMLFileDownloader(FilesCollection files) {
        this(files, files.getUpdateSiteNames(false));
    }

    public XMLFileDownloader(FilesCollection files, Collection<String> updateSites) {
        this.files = files;
        this.updateSites = updateSites;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean closeProgressAtEnd) {
        if (this.updateSites == null || this.updateSites.size() == 0) {
            return;
        }
        this.setTitle("Updating the index of available files");
        XMLFileReader reader = new XMLFileReader(this.files);
        boolean current = false;
        int total = this.updateSites.size();
        if (this.warnings == null) {
            this.warnings = new StringBuilder();
        } else {
            this.warnings.setLength(0);
        }
        for (String name : this.updateSites) {
            UpdateSite updateSite = this.files.getUpdateSite(name, true);
            String title = "Updating from " + (name.equals("") ? "main" : name) + " site: " + updateSite.getURL();
            this.addItem(title);
            this.setCount(0, total);
            try {
                URLConnection connection = this.files.util.openConnection(new URL(updateSite.getURL() + "db.xml.gz"));
                long lastModified = connection.getLastModified();
                int fileSize = connection.getContentLength();
                InputStream in = this.getInputStream(new GZIPInputStream(connection.getInputStream()), fileSize);
                reader.read(name, in, updateSite.getTimestamp());
                in.close();
                updateSite.setLastModified(lastModified);
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    updateSite.setLastModified(0L);
                    this.files.log.debug((Throwable)e);
                } else {
                    this.files.log.error((Throwable)e);
                }
                this.appendWarning("Could not update from site '" + name + "': " + e);
            }
            this.itemDone(title);
        }
        if (closeProgressAtEnd) {
            this.done();
        }
        this.appendWarning(reader.getWarnings());
    }

    public String getWarnings() {
        return this.warnings.toString();
    }

    public InputStream getInputStream(final InputStream in, final int fileSize) {
        return new InputStream(){
            int current = 0;

            @Override
            public int read() throws IOException {
                int result = in.read();
                XMLFileDownloader.this.setItemCount(++this.current, fileSize);
                return result;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int result = in.read(b);
                if (result > 0) {
                    this.current += result;
                    XMLFileDownloader.this.setItemCount(this.current, fileSize);
                }
                return result;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int result = in.read(b, off, len);
                if (result > 0) {
                    this.current += result;
                    XMLFileDownloader.this.setItemCount(this.current, fileSize);
                }
                return result;
            }

            @Override
            public void close() throws IOException {
                in.close();
            }
        };
    }

    private void appendWarning(String s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        this.warnings.append(s);
        this.warnings.append(System.getProperty("line.separator"));
    }
}

