/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.Uploadable;

public class UploadableFile
implements Uploadable {
    protected FileObject file;
    private String permissions;
    protected String filename;
    protected File source;
    protected long filesize;

    public UploadableFile(FilesCollection files, FileObject file) {
        this(files.prefix(file), file.getFilename() + "-" + file.getTimestamp());
        this.file = file;
    }

    public UploadableFile(File source, String target) {
        this(source, target, "C0644");
    }

    public UploadableFile(File source, String target, String permissions) {
        this.source = source;
        this.filename = target;
        this.permissions = permissions;
        this.filesize = source.exists() ? source.length() : 0L;
    }

    protected void updateFilesize() {
        this.filesize = this.source.length();
    }

    @Override
    public long getFilesize() {
        return this.filesize;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getPermissions() {
        return this.permissions;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return new FileInputStream(this.source);
        }
        catch (FileNotFoundException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    public String toString() {
        return this.filename;
    }
}

