/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.AvailableSites;
import net.imagej.updater.util.HTTPSUtil;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.util.AppUtils;
import org.scijava.util.Prefs;
import org.xml.sax.SAXException;

public class UpToDate {
    private static final String KEY = "latestNag";
    private static final long REMINDER_INTERVAL = 86400L;
    private static final long FOUR_O_SEVEN = -111381L;

    public static Result check() throws IOException, ParserConfigurationException, SAXException {
        return UpToDate.check(AppUtils.getBaseDirectory((String)"ij.dir", UpToDate.class, (String)"updater"));
    }

    public static Result check(File ijRoot) throws IOException, ParserConfigurationException, SAXException {
        if (UpToDate.neverRemind()) {
            return Result.CHECK_TURNED_OFF;
        }
        if (UpToDate.shouldRemindLater()) {
            return Result.REMIND_LATER;
        }
        if (UpdaterUtil.isGPRActivated(ijRoot)) {
            return Result.GPR_ACTIVATED;
        }
        if (UpdaterUtil.isProtectedLocation(ijRoot)) {
            return Result.PROTECTED_LOCATION;
        }
        if (!UpToDate.canWrite(ijRoot)) {
            return Result.READ_ONLY;
        }
        if (UpToDate.isDeveloper()) {
            return Result.DEVELOPER;
        }
        if (!UpToDate.haveNetworkConnection()) {
            return Result.OFFLINE;
        }
        FilesCollection plugins = new FilesCollection(ijRoot);
        try {
            try {
                plugins.read();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            HTTPSUtil.checkHTTPSSupport(null);
            if (HTTPSUtil.noConnection()) {
                return Result.OFFLINE;
            }
            if (AvailableSites.hasUpdateSiteURLUpdates(plugins)) {
                return Result.UPDATEABLE;
            }
            for (String name : plugins.getUpdateSiteNames(false)) {
                UpdateSite updateSite = plugins.getUpdateSite(name, true);
                long lastModified = UpToDate.getLastModified(updateSite.getURL() + "db.xml.gz");
                if (lastModified == -111381L) {
                    return Result.PROXY_NEEDS_AUTHENTICATION;
                }
                if (lastModified < 0L) {
                    return Result.OFFLINE;
                }
                if (updateSite.isLastModified(lastModified)) continue;
                UpToDate.setLatestNag();
                return Result.UPDATEABLE;
            }
        }
        catch (FileNotFoundException | UnknownHostException iOException) {
            // empty catch block
        }
        UpToDate.setLatestNag(-1L);
        return Result.UP_TO_DATE;
    }

    public static long now() {
        return new Date().getTime() / 1000L;
    }

    public static boolean neverRemind() {
        String latestNag = Prefs.get(UpToDate.class, (String)KEY);
        if (latestNag == null || latestNag.equals("")) {
            return false;
        }
        long time = Long.parseLong(latestNag);
        return time == Long.MAX_VALUE;
    }

    public static boolean shouldRemindLater() {
        String latestNag = Prefs.get(UpToDate.class, (String)KEY);
        if (latestNag == null || latestNag.equals("")) {
            return false;
        }
        return UpToDate.now() - Long.parseLong(latestNag) < 86400L;
    }

    public static boolean isDeveloper() {
        return System.getProperty("imagej.dir") == null;
    }

    public static boolean canWrite(File ijRoot) {
        return ijRoot.canWrite();
    }

    public static boolean haveNetworkConnection() {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                Enumeration<InetAddress> addresses = ifaces.nextElement().getInetAddresses();
                while (addresses.hasMoreElements()) {
                    if (addresses.nextElement().isLoopbackAddress()) continue;
                    return true;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return false;
    }

    public static long getLastModified(String url) {
        try {
            URLConnection connection = new UpdaterUtil(null).openConnection(new URL(url));
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
            }
            connection.setUseCaches(false);
            long lastModified = connection.getLastModified();
            connection.getInputStream().close();
            return lastModified;
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("Server returned HTTP response code: 407")) {
                return -111381L;
            }
            return -1L;
        }
    }

    public static void setLatestNag() {
        UpToDate.setLatestNag(UpToDate.now());
    }

    public static void setLatestNag(long ticks) {
        Prefs.put(UpToDate.class, (String)KEY, (String)(ticks < 0L ? "" : "" + ticks));
    }

    public static enum Result {
        UP_TO_DATE,
        UPDATEABLE,
        PROXY_NEEDS_AUTHENTICATION,
        OFFLINE,
        REMIND_LATER,
        CHECK_TURNED_OFF,
        READ_ONLY,
        UPDATES_MANAGED_DIFFERENTLY,
        DEVELOPER,
        PROTECTED_LOCATION,
        GPR_ACTIVATED;

    }
}

