/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Frame;

public class Dichromacy_
implements PlugIn {
    public void run(String arg) {
        ImageProcessor ip;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.error((String)"No image!");
            return;
        }
        int width = imp.getWidth();
        int height = imp.getHeight();
        String title = imp.getTitle();
        if (imp.getBitDepth() != 24) {
            IJ.run((ImagePlus)imp, (String)"RGB Color", (String)"");
        }
        boolean createWindow = true;
        GenericDialog gd = new GenericDialog("Dichromacy v1.0", (Frame)IJ.getInstance());
        String[] type = new String[]{"Protanope", "Deuteranope", "Tritanope"};
        gd.addChoice("Simulate", type, type[1]);
        gd.addCheckbox("Create New Window", createWindow);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int deficiency = gd.getNextChoiceIndex();
        createWindow = gd.getNextBoolean();
        double[] rgb2lms = new double[9];
        double[] lms2rgb = new double[9];
        double[] gammaRGB = new double[3];
        double a1 = 0.0;
        double b1 = 0.0;
        double c1 = 0.0;
        double a2 = 0.0;
        double b2 = 0.0;
        double c2 = 0.0;
        double inflection = 0.0;
        rgb2lms[0] = 0.05059983;
        rgb2lms[1] = 0.08585369;
        rgb2lms[2] = 0.0095242;
        rgb2lms[3] = 0.01893033;
        rgb2lms[4] = 0.08925308;
        rgb2lms[5] = 0.01370054;
        rgb2lms[6] = 0.00292202;
        rgb2lms[7] = 0.00975732;
        rgb2lms[8] = 0.07145979;
        lms2rgb[0] = 30.830854;
        lms2rgb[1] = -29.832659;
        lms2rgb[2] = 1.610474;
        lms2rgb[3] = -6.481468;
        lms2rgb[4] = 17.715578;
        lms2rgb[5] = -2.532642;
        lms2rgb[6] = -0.37569;
        lms2rgb[7] = -1.199062;
        lms2rgb[8] = 14.273846;
        gammaRGB[0] = 2.0;
        gammaRGB[1] = 2.0;
        gammaRGB[2] = 2.0;
        double[] anchor_e = new double[3];
        double[] anchor = new double[]{0.08008, 0.1579, 0.5897, 0.1284, 0.2237, 0.3636, 0.9856, 0.7325, 0.001079, 0.0914, 0.007009, 0.0};
        anchor_e[0] = rgb2lms[0] + rgb2lms[1] + rgb2lms[2];
        anchor_e[1] = rgb2lms[3] + rgb2lms[4] + rgb2lms[5];
        anchor_e[2] = rgb2lms[6] + rgb2lms[7] + rgb2lms[8];
        ImagePlus imp2 = null;
        if (createWindow) {
            imp2 = new ImagePlus(title + "-" + type[deficiency], imp.getProcessor().duplicate());
            ip = imp2.getProcessor();
        } else {
            ip = imp.getProcessor();
            ip.snapshot();
            Undo.setup((int)1, (ImagePlus)imp);
        }
        switch (deficiency) {
            case 1: {
                a1 = anchor_e[1] * anchor[8] - anchor_e[2] * anchor[7];
                b1 = anchor_e[2] * anchor[6] - anchor_e[0] * anchor[8];
                c1 = anchor_e[0] * anchor[7] - anchor_e[1] * anchor[6];
                a2 = anchor_e[1] * anchor[2] - anchor_e[2] * anchor[1];
                b2 = anchor_e[2] * anchor[0] - anchor_e[0] * anchor[2];
                c2 = anchor_e[0] * anchor[1] - anchor_e[1] * anchor[0];
                inflection = anchor_e[2] / anchor_e[0];
                break;
            }
            case 0: {
                a1 = anchor_e[1] * anchor[8] - anchor_e[2] * anchor[7];
                b1 = anchor_e[2] * anchor[6] - anchor_e[0] * anchor[8];
                c1 = anchor_e[0] * anchor[7] - anchor_e[1] * anchor[6];
                a2 = anchor_e[1] * anchor[2] - anchor_e[2] * anchor[1];
                b2 = anchor_e[2] * anchor[0] - anchor_e[0] * anchor[2];
                c2 = anchor_e[0] * anchor[1] - anchor_e[1] * anchor[0];
                inflection = anchor_e[2] / anchor_e[1];
                break;
            }
            case 2: {
                a1 = anchor_e[1] * anchor[11] - anchor_e[2] * anchor[10];
                b1 = anchor_e[2] * anchor[9] - anchor_e[0] * anchor[11];
                c1 = anchor_e[0] * anchor[10] - anchor_e[1] * anchor[9];
                a2 = anchor_e[1] * anchor[5] - anchor_e[2] * anchor[4];
                b2 = anchor_e[2] * anchor[3] - anchor_e[0] * anchor[5];
                c2 = anchor_e[0] * anchor[4] - anchor_e[1] * anchor[3];
                inflection = anchor_e[1] / anchor_e[0];
            }
        }
        int imagesize = width * height;
        int[] pixels = (int[])ip.getPixels();
        IJ.showStatus((String)"Dichromacy...");
        IJ.showProgress((double)0.5);
        for (int j = 0; j < imagesize; ++j) {
            int i = pixels[j];
            double red = (i & 0xFF0000) >> 16;
            double green = (i & 0xFF00) >> 8;
            double blue = i & 0xFF;
            red = Math.pow(red / 255.0, gammaRGB[0]);
            green = Math.pow(green / 255.0, gammaRGB[1]);
            blue = Math.pow(blue / 255.0, gammaRGB[2]);
            double redOld = red;
            double greenOld = green;
            red = redOld * rgb2lms[0] + greenOld * rgb2lms[1] + blue * rgb2lms[2];
            green = redOld * rgb2lms[3] + greenOld * rgb2lms[4] + blue * rgb2lms[5];
            blue = redOld * rgb2lms[6] + greenOld * rgb2lms[7] + blue * rgb2lms[8];
            switch (deficiency) {
                case 1: {
                    double tmp = blue / red;
                    if (tmp < inflection) {
                        green = -(a1 * red + c1 * blue) / b1;
                        break;
                    }
                    green = -(a2 * red + c2 * blue) / b2;
                    break;
                }
                case 0: {
                    double tmp = blue / green;
                    if (tmp < inflection) {
                        red = -(b1 * green + c1 * blue) / a1;
                        break;
                    }
                    red = -(b2 * green + c2 * blue) / a2;
                    break;
                }
                case 2: {
                    double tmp = green / red;
                    blue = tmp < inflection ? -(a1 * red + b1 * green) / c1 : -(a2 * red + b2 * green) / c2;
                }
            }
            redOld = red;
            greenOld = green;
            red = redOld * lms2rgb[0] + greenOld * lms2rgb[1] + blue * lms2rgb[2];
            green = redOld * lms2rgb[3] + greenOld * lms2rgb[4] + blue * lms2rgb[5];
            blue = redOld * lms2rgb[6] + greenOld * lms2rgb[7] + blue * lms2rgb[8];
            int ired = (int)Math.round(Math.pow(red, 1.0 / gammaRGB[0]) * 255.0);
            int igreen = (int)Math.round(Math.pow(green, 1.0 / gammaRGB[1]) * 255.0);
            int iblue = (int)Math.round(Math.pow(blue, 1.0 / gammaRGB[2]) * 255.0);
            int n = ired > 255 ? 255 : (ired = ired < 0 ? 0 : ired);
            int n2 = igreen > 255 ? 255 : (igreen = igreen < 0 ? 0 : igreen);
            iblue = iblue > 255 ? 255 : (iblue < 0 ? 0 : iblue);
            pixels[j] = ((ired & 0xFF) << 16) + ((igreen & 0xFF) << 8) + (iblue & 0xFF);
        }
        IJ.showProgress((double)1.0);
        if (createWindow) {
            imp2.show();
            imp2.updateAndDraw();
        } else {
            imp.updateAndDraw();
        }
    }
}

