/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import omero.model.Point;
import omero.model.PointI;
import omero.model.SmartShape;
import omero.rtypes;

public class SmartPointI
extends PointI
implements SmartShape {
    @Override
    public void areaPoints(SmartShape.PointCallback cb) {
        try {
            double point_x = this.x.getValue();
            double point_y = this.y.getValue();
            if (this.transform != null) {
                AffineTransform t = SmartShape.Util.getAwtTransform(this.transform);
                Point2D p = t.transform(new Point2D.Double(point_x, point_y), null);
                point_x = p.getX();
                point_y = p.getY();
            }
            cb.handle((int)point_x, (int)point_y);
        }
        catch (NullPointerException npe) {
            return;
        }
    }

    @Override
    public Shape asAwtShape() {
        List<Point> points = this.asPoints();
        if (points == null) {
            return null;
        }
        String path = SmartShape.Util.pointsToPath(points, true);
        return SmartShape.Util.parseAwtPath(path);
    }

    @Override
    public List<Point> asPoints() {
        if (this.x == null || this.y == null) {
            return null;
        }
        List<Point> points = Arrays.asList(this);
        assert (SmartShape.Util.checkNonNull(points)) : "Null points in " + this;
        return points;
    }

    @Override
    public void randomize(Random random) {
        if (this.roi != null) {
            throw new UnsupportedOperationException("Roi-based values unsupported");
        }
        this.x = rtypes.rdouble(random.nextInt(100));
        this.y = rtypes.rdouble(random.nextInt(100));
    }
}

