/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Medium;
import omero.model.Objective;
import omero.model.ObjectiveSettings;
import omero.rtypes;
import omero.util.IceMapper;

public class ObjectiveSettingsI
extends ObjectiveSettings
implements ModelBased {
    public static final String CORRECTIONCOLLAR = "ome.model.acquisition.ObjectiveSettings_correctionCollar";
    public static final String MEDIUM = "ome.model.acquisition.ObjectiveSettings_medium";
    public static final String REFRACTIVEINDEX = "ome.model.acquisition.ObjectiveSettings_refractiveIndex";
    public static final String OBJECTIVE = "ome.model.acquisition.ObjectiveSettings_objective";
    public static final String DETAILS = "ome.model.acquisition.ObjectiveSettings_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public ObjectiveSettingsI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ObjectiveSettingsI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ObjectiveSettingsI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadCorrectionCollar();
        this.unloadMedium();
        this.unloadRefractiveIndex();
        this.unloadObjective();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ObjectiveSettingsI copy = new ObjectiveSettingsI();
        copy.id = this.id;
        copy.version = this.version;
        copy.correctionCollar = this.correctionCollar;
        copy.medium = this.medium == null ? null : (Medium)this.medium.proxy();
        copy.refractiveIndex = this.refractiveIndex;
        copy.objective = this.objective == null ? null : (Objective)this.objective.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ObjectiveSettingsI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadCorrectionCollar() {
        this.correctionCollar = null;
    }

    @Override
    public RDouble getCorrectionCollar(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.correctionCollar;
    }

    @Override
    public void setCorrectionCollar(RDouble correctionCollar, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.correctionCollar = correctionCollar;
    }

    private void copyCorrectionCollar(ome.model.acquisition.ObjectiveSettings source, IceMapper mapper) {
        this.correctionCollar = source.getCorrectionCollar() == null ? null : rtypes.rdouble(source.getCorrectionCollar());
    }

    private void fillCorrectionCollar(ome.model.acquisition.ObjectiveSettings target, IceMapper mapper) {
        try {
            target.setCorrectionCollar((Double)mapper.fromRType(this.getCorrectionCollar()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadMedium() {
        this.medium = null;
    }

    @Override
    public Medium getMedium(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.medium;
    }

    @Override
    public void setMedium(Medium medium, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.medium = medium;
    }

    private void copyMedium(ome.model.acquisition.ObjectiveSettings source, IceMapper mapper) {
        this.medium = (Medium)mapper.findTarget(source.getMedium());
    }

    private void fillMedium(ome.model.acquisition.ObjectiveSettings target, IceMapper mapper) {
        target.putAt(MEDIUM, (Object)mapper.reverse((ModelBased)this.getMedium()));
    }

    public void unloadRefractiveIndex() {
        this.refractiveIndex = null;
    }

    @Override
    public RDouble getRefractiveIndex(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.refractiveIndex;
    }

    @Override
    public void setRefractiveIndex(RDouble refractiveIndex, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.refractiveIndex = refractiveIndex;
    }

    private void copyRefractiveIndex(ome.model.acquisition.ObjectiveSettings source, IceMapper mapper) {
        this.refractiveIndex = source.getRefractiveIndex() == null ? null : rtypes.rdouble(source.getRefractiveIndex());
    }

    private void fillRefractiveIndex(ome.model.acquisition.ObjectiveSettings target, IceMapper mapper) {
        try {
            target.setRefractiveIndex((Double)mapper.fromRType(this.getRefractiveIndex()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadObjective() {
        this.objective = null;
    }

    @Override
    public Objective getObjective(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.objective;
    }

    @Override
    public void setObjective(Objective objective, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.objective = objective;
    }

    private void copyObjective(ome.model.acquisition.ObjectiveSettings source, IceMapper mapper) {
        this.objective = (Objective)mapper.findTarget(source.getObjective());
    }

    private void fillObjective(ome.model.acquisition.ObjectiveSettings target, IceMapper mapper) {
        target.putAt(OBJECTIVE, (Object)mapper.reverse((ModelBased)this.getObjective()));
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.ObjectiveSettings) {
            ome.model.acquisition.ObjectiveSettings source = (ome.model.acquisition.ObjectiveSettings)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyCorrectionCollar(source, mapper);
                this.copyMedium(source, mapper);
                this.copyRefractiveIndex(source, mapper);
                this.copyObjective(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("ObjectiveSettings cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.ObjectiveSettings target = new ome.model.acquisition.ObjectiveSettings();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillCorrectionCollar(target, mapper);
            this.fillMedium(target, mapper);
            this.fillRefractiveIndex(target, mapper);
            this.fillObjective(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<ObjectiveSettingsI> cast(List list) {
        return list;
    }
}

