/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Fileset;
import omero.model.FilesetEntry;
import omero.model.IObject;
import omero.model.OriginalFile;
import omero.rtypes;
import omero.util.IceMapper;

public class FilesetEntryI
extends FilesetEntry
implements ModelBased {
    public static final String FILESET = "ome.model.fs.FilesetEntry_fileset";
    public static final String ORIGINALFILE = "ome.model.fs.FilesetEntry_originalFile";
    public static final String CLIENTPATH = "ome.model.fs.FilesetEntry_clientPath";
    public static final String DETAILS = "ome.model.fs.FilesetEntry_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public FilesetEntryI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public FilesetEntryI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public FilesetEntryI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadFileset();
        this.unloadOriginalFile();
        this.unloadClientPath();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        FilesetEntryI copy = new FilesetEntryI();
        copy.id = this.id;
        copy.version = this.version;
        copy.fileset = this.fileset == null ? null : (Fileset)this.fileset.proxy();
        copy.originalFile = this.originalFile == null ? null : (OriginalFile)this.originalFile.proxy();
        copy.clientPath = this.clientPath;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new FilesetEntryI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadFileset() {
        this.fileset = null;
    }

    @Override
    public Fileset getFileset(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.fileset;
    }

    @Override
    public void setFileset(Fileset fileset, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.fileset = fileset;
    }

    private void copyFileset(ome.model.fs.FilesetEntry source, IceMapper mapper) {
        this.fileset = (Fileset)mapper.findTarget(source.getFileset());
    }

    private void fillFileset(ome.model.fs.FilesetEntry target, IceMapper mapper) {
        target.putAt(FILESET, (Object)mapper.reverse((ModelBased)this.getFileset()));
    }

    public void unloadOriginalFile() {
        this.originalFile = null;
    }

    @Override
    public OriginalFile getOriginalFile(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.originalFile;
    }

    @Override
    public void setOriginalFile(OriginalFile originalFile, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.originalFile = originalFile;
    }

    private void copyOriginalFile(ome.model.fs.FilesetEntry source, IceMapper mapper) {
        this.originalFile = (OriginalFile)mapper.findTarget(source.getOriginalFile());
    }

    private void fillOriginalFile(ome.model.fs.FilesetEntry target, IceMapper mapper) {
        target.putAt(ORIGINALFILE, (Object)mapper.reverse((ModelBased)this.getOriginalFile()));
    }

    public void unloadClientPath() {
        this.clientPath = null;
    }

    @Override
    public RString getClientPath(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.clientPath;
    }

    @Override
    public void setClientPath(RString clientPath, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.clientPath = clientPath;
    }

    private void copyClientPath(ome.model.fs.FilesetEntry source, IceMapper mapper) {
        this.clientPath = source.getClientPath() == null ? null : rtypes.rstring(source.getClientPath());
    }

    private void fillClientPath(ome.model.fs.FilesetEntry target, IceMapper mapper) {
        try {
            target.setClientPath((String)mapper.fromRType(this.getClientPath()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.fs.FilesetEntry) {
            ome.model.fs.FilesetEntry source = (ome.model.fs.FilesetEntry)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyFileset(source, mapper);
                this.copyOriginalFile(source, mapper);
                this.copyClientPath(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("FilesetEntry cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.fs.FilesetEntry target = new ome.model.fs.FilesetEntry();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillFileset(target, mapper);
            this.fillOriginalFile(target, mapper);
            this.fillClientPath(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<FilesetEntryI> cast(List list) {
        return list;
    }
}

