/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import java.util.HashMap;
import java.util.Map;

class SpecificityClassifier<G, C> {
    private final ContainmentTester<G> tester;
    private final Map<G, C> classOfGroup = new HashMap<G, C>();

    SpecificityClassifier(ContainmentTester<G> tester) {
        this.tester = tester;
    }

    void addClass(C classification, Iterable<G> groupsInClass) throws IllegalArgumentException {
        for (G group : groupsInClass) {
            C previousClass = this.classOfGroup.put(group, classification);
            if (previousClass == null || previousClass.equals(classification)) continue;
            throw new IllegalArgumentException("cannot classify " + group + " as " + classification + " because it is also " + previousClass);
        }
    }

    C getClass(G group) {
        C directLookup = this.classOfGroup.get(group);
        if (directLookup != null) {
            return directLookup;
        }
        Map.Entry<G, C> bestGroupClassification = null;
        for (Map.Entry<G, C> currentGroupClassification : this.classOfGroup.entrySet()) {
            if (!this.tester.isProperSupersetOf(currentGroupClassification.getKey(), group) || bestGroupClassification != null && !this.tester.isProperSupersetOf(bestGroupClassification.getKey(), currentGroupClassification.getKey())) continue;
            bestGroupClassification = currentGroupClassification;
        }
        return bestGroupClassification == null ? null : (C)bestGroupClassification.getValue();
    }

    static interface ContainmentTester<G> {
        public boolean isProperSupersetOf(G var1, G var2);
    }
}

