/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.admin;

import java.util.HashMap;
import java.util.Map;
import ome.conditions.ApiUsageException;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.security.SecuritySystem;
import ome.security.auth.PasswordChangeException;
import ome.security.auth.PasswordProvider;
import ome.security.auth.PasswordUtil;
import ome.services.mail.MailUtil;
import ome.util.SqlAction;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.ResetPasswordRequest;
import omero.cmd.ResetPasswordResponse;
import omero.cmd.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;

public class ResetPasswordRequestI
extends ResetPasswordRequest
implements IRequest {
    private static final Logger log = LoggerFactory.getLogger(ResetPasswordRequestI.class);
    private static final long serialVersionUID = -1L;
    private final ResetPasswordResponse rsp = new ResetPasswordResponse();
    private String sender = null;
    private final MailUtil mailUtil;
    private final PasswordUtil passwordUtil;
    private final SecuritySystem sec;
    private final PasswordProvider passwordProvider;
    private Helper helper;

    public ResetPasswordRequestI(MailUtil mailUtil, PasswordUtil passwordUtil, SecuritySystem sec, PasswordProvider passwordProvider) {
        this.mailUtil = mailUtil;
        this.passwordUtil = passwordUtil;
        this.sec = sec;
        this.passwordProvider = passwordProvider;
    }

    @Override
    public Map<String, String> getCallContext() {
        HashMap<String, String> all = new HashMap<String, String>();
        all.put("omero.group", "-1");
        return all;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        this.sender = this.mailUtil.getSender();
        if (this.omename == null) {
            throw helper.cancel(new ERR(), null, "no-omename", new String[0]);
        }
        if (this.email == null) {
            throw helper.cancel(new ERR(), null, "no-email", new String[0]);
        }
        helper.allowGuests();
        this.helper.setSteps(1);
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        return this.resetPassword();
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (this.helper.isLast(step)) {
            this.helper.setResponseIfNull(this.rsp);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    private boolean resetPassword() {
        Experimenter e = null;
        try {
            e = this.helper.getServiceFactory().getAdminService().lookupExperimenter(this.omename);
        }
        catch (ApiUsageException ex) {
            throw this.helper.cancel(new ERR(), null, "unknown-user", "ApiUsageException", ex.getMessage());
        }
        SqlAction sql = this.helper.getSql();
        String emailFromDb = sql.getUserEmailByOmeName(this.omename);
        if (emailFromDb == null) {
            throw this.helper.cancel(new ERR(), null, "unknown-email", "ApiUsageException", String.format("User has no email address.", new Object[0]));
        }
        if (!emailFromDb.equals(this.email)) {
            throw this.helper.cancel(new ERR(), null, "not-match", "ApiUsageException", String.format("Email address does not match.", new Object[0]));
        }
        if (this.passwordUtil.getDnById(e.getId())) {
            throw this.helper.cancel(new ERR(), null, "ldap-user", "ApiUsageException", String.format("User is authenticated by LDAP server. You cannot reset this password.", new Object[0]));
        }
        long systemGroupId = this.sec.getSecurityRoles().getSystemGroupId();
        for (ExperimenterGroup group : e.linkedExperimenterGroupList()) {
            if (group.getId() != systemGroupId) continue;
            throw this.helper.cancel(new ERR(), null, "password-change-failed", "PasswordChangeException", "Cannot reset password of administrators. Have another administrator set the new password.");
        }
        String newPassword = this.passwordUtil.generateRandomPasswd();
        try {
            this.passwordProvider.changePassword(this.omename, newPassword);
            log.info("Changed password for user: " + this.omename);
        }
        catch (PasswordChangeException pce) {
            log.error(pce.getMessage());
            throw this.helper.cancel(new ERR(), null, "password-change-failed", "PasswordChangeException", String.format(pce.getMessage(), new Object[0]));
        }
        String prettyName = sql.getUserPrettyNameByOmeName(this.omename);
        String subject = "OMERO - Reset password";
        String body = "Dear " + prettyName + " (" + this.omename + ") your new password is: " + newPassword;
        try {
            this.mailUtil.sendEmail(this.sender, this.email, subject, body, false, null, null);
            log.info("sent new password for {} to {}", (Object)this.omename, (Object)this.email);
        }
        catch (MailException me) {
            log.error(me.getMessage());
            throw this.helper.cancel(new ERR(), null, "mail-send-failed", "MailException", String.format(me.getMessage(), new Object[0]));
        }
        return true;
    }
}

