/*
 * Decompiled with CFR 0.152.
 */
package ome.services.throttling;

import Ice.Current;
import Ice.UserException;
import ome.services.throttling.Task;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import ome.system.Principal;
import omero.util.IceMapper;
import org.springframework.util.Assert;

public class Adapter
extends Task {
    private final Executor ex;
    private final Executor.Work work;
    private final Principal p;
    private final IceMapper mapper;

    public Adapter(Object callback, Current current, IceMapper mapper, Executor ex, Principal p, Executor.Work work) {
        super(callback, current, mapper.isVoid());
        this.p = p;
        this.ex = ex;
        this.work = work;
        this.mapper = mapper;
        Assert.notNull((Object)callback, (String)"Callback null");
        Assert.notNull((Object)work, (String)"Work null");
        Assert.notNull((Object)ex, (String)"Executor null");
        Assert.notNull((Object)p, (String)"Principal null");
    }

    @Override
    public void run(OmeroContext ctx) {
        try {
            Object retVal = null;
            try {
                retVal = this.ex.execute(this.p, this.work);
            }
            catch (Throwable t) {
                UserException ue = this.mapper.handleException(t, this.ex.getContext());
                this.exception((Throwable)ue, this.ex.getContext());
                return;
            }
            if (this.mapper != null && this.mapper.canMapReturnValue()) {
                retVal = this.mapper.mapReturnValue(retVal);
            }
            this.response(retVal, ctx);
        }
        catch (Exception e) {
            this.exception(e, ctx);
        }
    }
}

