/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo.path;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.services.blitz.repo.path.FilePathRestrictionInstance;

public class FilePathRestrictions {
    private static final ImmutableSet<Integer> controlCodePoints;
    private static final Predicate<Integer> isNotControlCodePoint;
    public final ImmutableSetMultimap<Integer, Integer> transformationMatrix;
    public final ImmutableSet<String> unsafePrefixes;
    public final ImmutableSet<String> unsafeSuffixes;
    public final ImmutableSet<String> unsafeNames;
    public final ImmutableSet<Character> safeCharacters;
    public final char safeCharacter;
    public final ImmutableMap<Integer, Integer> transformationMap;

    private static FilePathRestrictions includeControlTransformations(FilePathRestrictions rules) {
        HashSet<Character> safeCharacters = new HashSet<Character>(rules.safeCharacters.size());
        HashSet<Integer> safeCodePoints = new HashSet<Integer>(rules.safeCharacters.size());
        for (Character safeCharacter : rules.safeCharacters) {
            int safeCodePoint = FilePathRestrictionInstance.getCodePoint(safeCharacter.charValue());
            if (controlCodePoints.contains((Object)safeCodePoint)) continue;
            safeCharacters.add(safeCharacter);
            safeCodePoints.add(safeCodePoint);
        }
        HashMultimap newTransformationMatrix = HashMultimap.create((Multimap)Multimaps.filterValues(rules.transformationMatrix, isNotControlCodePoint));
        UnmodifiableIterator unmodifiableIterator = controlCodePoints.iterator();
        while (unmodifiableIterator.hasNext()) {
            int controlCodePoint = (Integer)unmodifiableIterator.next();
            if (newTransformationMatrix.containsKey((Object)controlCodePoint)) continue;
            if (rules.transformationMatrix.containsKey((Object)controlCodePoint)) {
                throw new IllegalArgumentException("only control character mappings available for Unicode code point " + controlCodePoint);
            }
            newTransformationMatrix.putAll((Object)controlCodePoint, safeCodePoints);
        }
        return FilePathRestrictions.combineRules(rules, new FilePathRestrictions((SetMultimap<Integer, Integer>)newTransformationMatrix, null, null, null, safeCharacters));
    }

    private static FilePathRestrictions combineRules(FilePathRestrictions ... rules) {
        if (rules.length == 0) {
            throw new IllegalArgumentException("cannot combine an empty list of rules");
        }
        int index = 0;
        FilePathRestrictions product = rules[index++];
        while (index < rules.length) {
            boolean transitiveClosing;
            FilePathRestrictions toCombine = rules[index++];
            Sets.SetView safeCharacters = Sets.intersection(product.safeCharacters, toCombine.safeCharacters);
            if (safeCharacters.isEmpty()) {
                throw new IllegalArgumentException("cannot combine safe characters");
            }
            Sets.SetView allKeys = Sets.union((Set)product.transformationMatrix.keySet(), (Set)toCombine.transformationMatrix.keySet());
            ImmutableMap productMatrixMap = product.transformationMatrix.asMap();
            ImmutableMap toCombineMatrixMap = toCombine.transformationMatrix.asMap();
            HashMultimap newTransformationMatrix = HashMultimap.create();
            for (Integer key : allKeys) {
                Object valuesSet;
                Object values;
                if (!productMatrixMap.containsKey((Object)key)) {
                    values = (Collection)toCombineMatrixMap.get((Object)key);
                } else if (!toCombineMatrixMap.containsKey((Object)key)) {
                    values = (Collection)productMatrixMap.get((Object)key);
                } else {
                    valuesSet = new HashSet((Collection)productMatrixMap.get((Object)key));
                    valuesSet.retainAll((Collection)toCombineMatrixMap.get((Object)key));
                    if (valuesSet.isEmpty()) {
                        throw new IllegalArgumentException("cannot combine transformations for Unicode code point " + key);
                    }
                    values = valuesSet;
                }
                valuesSet = values.iterator();
                while (valuesSet.hasNext()) {
                    Integer value = (Integer)valuesSet.next();
                    newTransformationMatrix.put((Object)key, (Object)value);
                }
            }
            HashMultimap entriesRemoved = HashMultimap.create();
            block3: do {
                transitiveClosing = false;
                for (Map.Entry transformation : newTransformationMatrix.entries()) {
                    int to = (Integer)transformation.getValue();
                    if (!newTransformationMatrix.containsKey((Object)to)) continue;
                    int from = (Integer)transformation.getKey();
                    if (!entriesRemoved.put((Object)from, (Object)to)) {
                        throw new IllegalArgumentException("cyclic transformation involving Unicode code point " + from);
                    }
                    newTransformationMatrix.remove((Object)from, (Object)to);
                    newTransformationMatrix.putAll((Object)from, (Iterable)newTransformationMatrix.get((Object)to));
                    transitiveClosing = true;
                    continue block3;
                }
            } while (transitiveClosing);
            product = new FilePathRestrictions((SetMultimap<Integer, Integer>)newTransformationMatrix, (Set<String>)Sets.union(product.unsafePrefixes, toCombine.unsafePrefixes), (Set<String>)Sets.union(product.unsafeSuffixes, toCombine.unsafeSuffixes), (Set<String>)Sets.union(product.unsafeNames, toCombine.unsafeNames), (Set<Character>)safeCharacters);
        }
        return product;
    }

    public static FilePathRestrictions combineFilePathRestrictions(FilePathRestrictions ... rules) {
        return FilePathRestrictions.includeControlTransformations(FilePathRestrictions.combineRules(rules));
    }

    public FilePathRestrictions(SetMultimap<Integer, Integer> transformationMatrix, Set<String> unsafePrefixes, Set<String> unsafeSuffixes, Set<String> unsafeNames, Set<Character> safeCharacters) {
        this.transformationMatrix = transformationMatrix == null ? ImmutableSetMultimap.of() : ImmutableSetMultimap.copyOf(transformationMatrix);
        this.unsafePrefixes = unsafePrefixes == null ? ImmutableSet.of() : ImmutableSet.copyOf(unsafePrefixes);
        this.unsafeSuffixes = unsafeSuffixes == null ? ImmutableSet.of() : ImmutableSet.copyOf(unsafeSuffixes);
        this.unsafeNames = unsafeNames == null ? ImmutableSet.of() : ImmutableSet.copyOf(unsafeNames);
        this.safeCharacters = ImmutableSet.copyOf(safeCharacters);
        this.safeCharacter = ((Character)this.safeCharacters.iterator().next()).charValue();
        int safeCodePoint = FilePathRestrictionInstance.getCodePoint(this.safeCharacter);
        ImmutableMap.Builder transformationMapBuilder = ImmutableMap.builder();
        for (Map.Entry transformation : this.transformationMatrix.asMap().entrySet()) {
            Collection values = (Collection)transformation.getValue();
            Integer selectedValue = values.contains(safeCodePoint) ? Integer.valueOf(safeCodePoint) : (Integer)values.iterator().next();
            transformationMapBuilder.put(transformation.getKey(), (Object)selectedValue);
        }
        this.transformationMap = transformationMapBuilder.build();
    }

    static {
        ImmutableSet.Builder controlCodePointsBuilder = ImmutableSet.builder();
        for (int codePoint = 0; codePoint < 256; ++codePoint) {
            if (Character.getType(codePoint) != 15) continue;
            controlCodePointsBuilder.add((Object)codePoint);
        }
        controlCodePoints = controlCodePointsBuilder.build();
        isNotControlCodePoint = new Predicate<Integer>(){

            public boolean apply(Integer codePoint) {
                return !controlCodePoints.contains((Object)codePoint);
            }
        };
    }
}

