/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo.path;

import java.util.ArrayList;
import java.util.TreeSet;
import ome.services.blitz.repo.path.FilePathRestrictions;
import ome.services.blitz.repo.path.FsFile;
import omero.FilePathNamingException;

public class FilePathNamingValidator {
    protected final FilePathRestrictions rules;

    public FilePathNamingValidator(FilePathRestrictions ... rules) {
        this.rules = FilePathRestrictions.combineFilePathRestrictions(rules);
    }

    public void validateFilePathNaming(FsFile fsFile) throws FilePathNamingException {
        TreeSet<Integer> illegalCodePoints = new TreeSet<Integer>();
        TreeSet<String> illegalPrefixes = new TreeSet<String>();
        TreeSet<String> illegalSuffixes = new TreeSet<String>();
        TreeSet<String> illegalNames = new TreeSet<String>();
        for (String string : fsFile.getComponents()) {
            String ucString = string.toUpperCase();
            for (String unsafeName : this.rules.unsafeNames) {
                if (!ucString.equals(unsafeName)) continue;
                illegalNames.add(unsafeName);
            }
            for (String unsafePrefix : this.rules.unsafePrefixes) {
                if (!ucString.startsWith(unsafePrefix)) continue;
                illegalPrefixes.add(unsafePrefix);
            }
            for (String unsafeSuffix : this.rules.unsafeSuffixes) {
                if (!ucString.endsWith(unsafeSuffix)) continue;
                illegalSuffixes.add(unsafeSuffix);
            }
            int codePointCount = string.codePointCount(0, string.length());
            for (int codePointIndex = 0; codePointIndex < codePointCount; ++codePointIndex) {
                int codePoint = string.codePointAt(string.offsetByCodePoints(0, codePointIndex));
                if (!this.rules.transformationMatrix.containsKey((Object)codePoint)) continue;
                illegalCodePoints.add(codePoint);
            }
        }
        if (!(illegalCodePoints.isEmpty() && illegalPrefixes.isEmpty() && illegalSuffixes.isEmpty() && illegalNames.isEmpty())) {
            throw new FilePathNamingException(null, null, "illegal file path", fsFile.toString(), new ArrayList<Integer>(illegalCodePoints), new ArrayList<String>(illegalPrefixes), new ArrayList<String>(illegalSuffixes), new ArrayList<String>(illegalNames));
        }
    }

    public void validateFilePathNaming(String filePath) throws FilePathNamingException {
        this.validateFilePathNaming(new FsFile(filePath));
    }
}

