/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.measurements;

import omero.ServerError;
import omero.ValidationException;
import omero.grid.BoolColumn;
import omero.grid.Column;
import omero.grid.DoubleColumn;
import omero.grid.FileColumn;
import omero.grid.ImageColumn;
import omero.grid.LongColumn;
import omero.grid.RoiColumn;
import omero.grid.StringColumn;
import omero.grid.WellColumn;

public abstract class Helper {
    public static Helper fromLsid(String lsid) throws ServerError {
        if (lsid.contains("File")) {
            return new FileHelper();
        }
        if (lsid.contains("Roi")) {
            return new RoiHelper();
        }
        if (lsid.contains("Image")) {
            return new ImageHelper();
        }
        if (lsid.contains("Well")) {
            return new WellHelper();
        }
        throw new ValidationException(null, null, "Unknown id type: " + lsid);
    }

    public static Helper fromClass(Class kls) throws ServerError {
        if (Long.class.equals((Object)kls)) {
            return new LongHelper();
        }
        if (Double.class.equals((Object)kls)) {
            return new DoubleHelper();
        }
        if (Boolean.class.equals((Object)kls)) {
            return new BoolHelper();
        }
        if (String.class.equals((Object)kls)) {
            return new StringHelper();
        }
        throw new ValidationException(null, null, "Unknown column type: " + kls.getName());
    }

    abstract Column newInstance();

    abstract void setSize(Column var1, int var2);

    abstract void setValue(Column var1, int var2, Object var3);

    static class StringHelper
    extends Helper {
        StringHelper() {
        }

        @Override
        Column newInstance() {
            return new StringColumn();
        }

        @Override
        void setSize(Column col, int length) {
            ((StringColumn)col).values = new String[length];
        }

        @Override
        void setValue(Column col, int rowIdx, Object value) {
            ((StringColumn)col).values[rowIdx] = (String)value;
        }
    }

    static class LongHelper
    extends Helper {
        LongHelper() {
        }

        @Override
        Column newInstance() {
            return new LongColumn();
        }

        @Override
        void setSize(Column col, int length) {
            ((LongColumn)col).values = new long[length];
        }

        @Override
        void setValue(Column col, int rowIdx, Object value) {
            ((LongColumn)col).values[rowIdx] = (Long)value;
        }
    }

    static class DoubleHelper
    extends Helper {
        DoubleHelper() {
        }

        @Override
        Column newInstance() {
            return new DoubleColumn();
        }

        @Override
        void setSize(Column col, int length) {
            ((DoubleColumn)col).values = new double[length];
        }

        @Override
        void setValue(Column col, int rowIdx, Object value) {
            ((DoubleColumn)col).values[rowIdx] = (Double)value;
        }
    }

    static class BoolHelper
    extends Helper {
        BoolHelper() {
        }

        @Override
        Column newInstance() {
            return new BoolColumn();
        }

        @Override
        void setSize(Column col, int length) {
            ((BoolColumn)col).values = new boolean[length];
        }

        @Override
        void setValue(Column col, int rowIdx, Object value) {
            ((BoolColumn)col).values[rowIdx] = (Boolean)value;
        }
    }

    static class WellHelper
    extends Helper {
        WellHelper() {
        }

        @Override
        Column newInstance() {
            return new WellColumn();
        }

        @Override
        void setSize(Column col, int length) {
            ((WellColumn)col).values = new long[length];
        }

        @Override
        void setValue(Column col, int rowIdx, Object value) {
            ((WellColumn)col).values[rowIdx] = (Long)value;
        }
    }

    static class ImageHelper
    extends Helper {
        ImageHelper() {
        }

        @Override
        Column newInstance() {
            return new ImageColumn();
        }

        @Override
        void setSize(Column col, int length) {
            ((ImageColumn)col).values = new long[length];
        }

        @Override
        void setValue(Column col, int rowIdx, Object value) {
            ((ImageColumn)col).values[rowIdx] = (Long)value;
        }
    }

    static class RoiHelper
    extends Helper {
        RoiHelper() {
        }

        @Override
        Column newInstance() {
            return new RoiColumn();
        }

        @Override
        void setSize(Column col, int length) {
            ((RoiColumn)col).values = new long[length];
        }

        @Override
        void setValue(Column col, int rowIdx, Object value) {
            ((RoiColumn)col).values[rowIdx] = (Long)value;
        }
    }

    static class FileHelper
    extends Helper {
        FileHelper() {
        }

        @Override
        Column newInstance() {
            return new FileColumn();
        }

        @Override
        void setSize(Column col, int length) {
            ((FileColumn)col).values = new long[length];
        }

        @Override
        void setValue(Column col, int rowIdx, Object value) {
            ((FileColumn)col).values[rowIdx] = (Long)value;
        }
    }
}

