/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.targets;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.targets.TemplateImportTarget;
import omero.api.IQueryPrx;
import omero.api.IUpdatePrx;
import omero.model.DatasetI;
import omero.model.IObject;
import omero.model.ScreenI;
import omero.rtypes;
import omero.sys.ParametersI;
import org.apache.commons.lang.StringUtils;

public class ServerTemplateImportTarget
extends TemplateImportTarget {
    private final String sharedPath;

    public ServerTemplateImportTarget(String sharedPath) {
        this.sharedPath = sharedPath;
    }

    @Override
    public IObject load(OMEROMetadataStoreClient client2, ImportContainer ic) throws Exception {
        return this.load(client2, ic.getIsSPW());
    }

    public IObject load(OMEROMetadataStoreClient client2, boolean spw) throws Exception {
        List<Object> objs;
        this.log.info("Checking '{}' against '{}'", (Object)this.sharedPath, (Object)this.getTemplate());
        Pattern pattern = Pattern.compile(this.getTemplate());
        Matcher m = pattern.matcher(this.sharedPath);
        if (!m.matches()) {
            this.log.warn("No match");
            return null;
        }
        if (!this.getDiscriminator().matches("^[-+%@]?name$")) {
            this.log.warn("Invalid discriminator: {}", (Object)this.getDiscriminator());
            return null;
        }
        String name = m.group("Container1");
        if (StringUtils.isBlank((String)name)) {
            this.log.warn("Empty name");
            return null;
        }
        if (this.getDiscriminator().startsWith("@")) {
            objs = Collections.emptyList();
        } else {
            IQueryPrx query = client2.getServiceFactory().getQueryService();
            StringBuilder hql = new StringBuilder();
            hql.append("FROM ");
            hql.append(spw ? "Screen" : "Dataset");
            hql.append(" WHERE name = :name ORDER BY id");
            if (!this.getDiscriminator().startsWith("-")) {
                hql.append(" DESC");
            }
            ParametersI params = new ParametersI().add("name", rtypes.rstring(name));
            objs = query.findAllByQuery(hql.toString(), params);
            Iterator<Object> objIter = objs.iterator();
            while (objIter.hasNext()) {
                if (((IObject)objIter.next()).getDetails().getPermissions().canLink()) continue;
                objIter.remove();
            }
        }
        if (objs.isEmpty()) {
            IUpdatePrx update = client2.getServiceFactory().getUpdateService();
            if (spw) {
                ScreenI screen = new ScreenI();
                screen.setName(rtypes.rstring(name));
                return update.saveAndReturnObject(screen);
            }
            DatasetI dataset = new DatasetI();
            dataset.setName(rtypes.rstring(name));
            return update.saveAndReturnObject(dataset);
        }
        if (this.getDiscriminator().startsWith("%") && objs.size() > 1) {
            this.log.warn("No unique {} called {}", (Object)(spw ? "screen" : "dataset"), (Object)name);
            return null;
        }
        return (IObject)objs.get(0);
    }
}

