/*
 * Decompiled with CFR 0.152.
 */
package ome.formats;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;
import ome.formats.Index;
import ome.formats.OMEROMetadataStoreClientRoot;
import ome.formats.OMEXMLModelComparator;
import ome.formats.SortDatasetsByName;
import ome.formats.SortProjectsByName;
import ome.formats.enums.EnumerationProvider;
import ome.formats.enums.IQueryEnumProvider;
import ome.formats.importer.util.ClientKeepAlive;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.model.ChannelProcessor;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.InstanceProvider;
import ome.formats.model.InstrumentProcessor;
import ome.formats.model.ModelProcessor;
import ome.formats.model.PixelsProcessor;
import ome.formats.model.PlaneInfoProcessor;
import ome.formats.model.ReferenceProcessor;
import ome.formats.model.ShapeProcessor;
import ome.formats.model.TargetProcessor;
import ome.formats.model.UnitsFactory;
import ome.formats.model.WellProcessor;
import ome.model.enums.UnitsTime;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.util.LSID;
import ome.xml.meta.MetadataRoot;
import ome.xml.model.AffineTransform;
import ome.xml.model.MapPair;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Marker;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import omero.RBool;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RTime;
import omero.SecurityViolation;
import omero.ServerError;
import omero.api.IAdminPrx;
import omero.api.IContainerPrx;
import omero.api.IQueryPrx;
import omero.api.IRenderingSettingsPrx;
import omero.api.IRepositoryInfoPrx;
import omero.api.IUpdatePrx;
import omero.api.MetadataStorePrx;
import omero.api.MetadataStorePrxHelper;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceInterfacePrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.ThumbnailStorePrx;
import omero.client;
import omero.grid.InteractiveProcessorPrx;
import omero.metadatastore.IObjectContainer;
import omero.model.AffineTransformI;
import omero.model.Annotation;
import omero.model.Arc;
import omero.model.ArcType;
import omero.model.BooleanAnnotation;
import omero.model.Channel;
import omero.model.CommentAnnotation;
import omero.model.ContrastMethod;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.Detector;
import omero.model.DetectorSettings;
import omero.model.Dichroic;
import omero.model.DoubleAnnotation;
import omero.model.Ellipse;
import omero.model.Experiment;
import omero.model.ExperimenterGroup;
import omero.model.Filament;
import omero.model.FilamentType;
import omero.model.FileAnnotation;
import omero.model.FilesetJobLink;
import omero.model.Filter;
import omero.model.FilterSet;
import omero.model.Folder;
import omero.model.Format;
import omero.model.GenericExcitationSource;
import omero.model.IObject;
import omero.model.Illumination;
import omero.model.Image;
import omero.model.ImagingEnvironment;
import omero.model.Immersion;
import omero.model.Instrument;
import omero.model.Label;
import omero.model.Laser;
import omero.model.LaserMedium;
import omero.model.LightEmittingDiode;
import omero.model.LightPath;
import omero.model.LightSettings;
import omero.model.Line;
import omero.model.ListAnnotation;
import omero.model.LogicalChannel;
import omero.model.LongAnnotation;
import omero.model.MapAnnotation;
import omero.model.Mask;
import omero.model.Medium;
import omero.model.MicrobeamManipulation;
import omero.model.MicrobeamManipulationType;
import omero.model.Microscope;
import omero.model.Objective;
import omero.model.ObjectiveSettings;
import omero.model.OriginalFile;
import omero.model.Permissions;
import omero.model.Pixels;
import omero.model.PixelsType;
import omero.model.PlaneInfo;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.Point;
import omero.model.Polygon;
import omero.model.Polyline;
import omero.model.Project;
import omero.model.ProjectI;
import omero.model.Reagent;
import omero.model.Rectangle;
import omero.model.Roi;
import omero.model.Screen;
import omero.model.ScreenI;
import omero.model.StageLabel;
import omero.model.TagAnnotation;
import omero.model.TermAnnotation;
import omero.model.TimeI;
import omero.model.TimestampAnnotation;
import omero.model.TransmittanceRange;
import omero.model.TransmittanceRangeI;
import omero.model.Well;
import omero.model.WellSample;
import omero.model.XmlAnnotation;
import omero.rtypes;
import omero.sys.EventContext;
import omero.sys.ParametersI;
import omero.util.IceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMEROMetadataStoreClient
implements MetadataStore,
IMinMaxStore,
IObjectContainerStore {
    public static Integer DEFAULT_KEEP_ALIVE = 300;
    private Logger log = LoggerFactory.getLogger(OMEROMetadataStoreClient.class);
    private MetadataStorePrx delegate;
    private Long groupID = null;
    private Map<LSID, IObjectContainer> containerCache = new TreeMap<LSID, IObjectContainer>(new OMEXMLModelComparator());
    private Map<LSID, List<LSID>> referenceCache = new HashMap<LSID, List<LSID>>();
    private Map<LSID, Set<LSID>> referenceCacheCheck = new HashMap<LSID, Set<LSID>>();
    private Map<Class<? extends IObject>, Map<String, IObjectContainer>> authoritativeContainerCache = new HashMap<Class<? extends IObject>, Map<String, IObjectContainer>>();
    private Map<String, String[]> referenceStringCache;
    private LSID screenKey;
    private List<ModelProcessor> modelProcessors;
    private IFormatReader reader;
    private OMEROMetadataStoreClientRoot pixelsList = new OMEROMetadataStoreClientRoot();
    private boolean encryptedConnection = false;
    private client c;
    private ServiceFactoryPrx serviceFactory;
    private EventContext eventContext;
    private IUpdatePrx iUpdate;
    private IQueryPrx iQuery;
    private IAdminPrx iAdmin;
    private RawFileStorePrx rawFileStore;
    private RawPixelsStorePrx rawPixelStore;
    private IRepositoryInfoPrx iRepoInfo;
    private IContainerPrx iContainer;
    private IRenderingSettingsPrx iSettings;
    private ThumbnailStorePrx thumbnailStore;
    private EnumerationProvider enumProvider;
    private InstanceProvider instanceProvider;
    private Long currentPixId;
    private List<Annotation> userSpecifiedAnnotations;
    private String userSpecifiedName;
    private String userSpecifiedDescription;
    private String logFilename;
    private String token;
    private IObject userSpecifiedTarget;
    private Double[] userSpecifiedPhysicalPixelSizes;
    private double[][][] imageChannelGlobalMinMax;
    private ScheduledThreadPoolExecutor executor;
    public static final String OMERO_EMISSION_FILTER_SUFFIX = ":OMERO_EMISSION_FILTER";
    public static final String OMERO_EXCITATION_FILTER_SUFFIX = ":OMERO_EXCITATION_FILTER";
    private static final int DEFAULT_INSIGHT_THUMBNAIL_LONGEST_SIDE = 96;
    private ClientKeepAlive keepAlive;
    private boolean ownsSession = false;
    private Map<Integer, Image> existingMetadata;

    public ClientKeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    private void resetPixelsId(Long pixId) throws ServerError {
        if (pixId != null && !pixId.equals(this.currentPixId)) {
            this.rawPixelStore.setPixelsId(pixId, true);
            this.currentPixId = pixId;
        }
    }

    public void logVersionInfo(String clientVersion) throws ServerError {
        if (this.serviceFactory != null) {
            this.log.info("Server: " + this.serviceFactory.getConfigService().getVersion());
        } else {
            this.log.info("Unknown server version (no service factory)");
        }
        if (clientVersion != null) {
            this.log.info("Client: " + clientVersion);
        } else {
            this.log.info("Unknown client version (null sent)");
        }
        this.log.info("Java Version: " + System.getProperty("java.version"));
        this.log.info("OS Name: " + System.getProperty("os.name"));
        this.log.info("OS Arch: " + System.getProperty("os.arch"));
        this.log.info("OS Version: " + System.getProperty("os.version"));
    }

    private void initializeServices(boolean manageLifecycle) throws ServerError {
        this.initializeServices(DEFAULT_KEEP_ALIVE);
    }

    private void initializeServices(Integer keepAliveRate) throws ServerError {
        this.closeServices();
        HashMap<String, String> callCtx = new HashMap<String, String>();
        if (this.groupID != null) {
            callCtx.put("omero.group", this.groupID.toString());
            this.log.info(String.format("Call context: {omero.group:%s}", this.groupID));
        }
        if (this.logFilename != null) {
            callCtx.put("omero.logfilename", this.logFilename);
            callCtx.put("omero.logfilename.token", this.token);
            this.log.info(String.format("Call context: {omero.logfilename:%s}", this.logFilename));
        }
        this.iAdmin = (IAdminPrx)this.serviceFactory.getAdminService().ice_context(callCtx);
        this.iQuery = (IQueryPrx)this.serviceFactory.getQueryService().ice_context(callCtx);
        this.eventContext = this.iAdmin.getEventContext();
        this.iUpdate = (IUpdatePrx)this.serviceFactory.getUpdateService().ice_context(callCtx);
        this.rawFileStore = (RawFileStorePrx)this.serviceFactory.createRawFileStore().ice_context(callCtx);
        this.rawPixelStore = (RawPixelsStorePrx)this.serviceFactory.createRawPixelsStore().ice_context(callCtx);
        this.thumbnailStore = (ThumbnailStorePrx)this.serviceFactory.createThumbnailStore().ice_context(callCtx);
        this.iRepoInfo = (IRepositoryInfoPrx)this.serviceFactory.getRepositoryInfoService().ice_context(callCtx);
        this.iContainer = (IContainerPrx)this.serviceFactory.getContainerService().ice_context(callCtx);
        this.iSettings = (IRenderingSettingsPrx)this.serviceFactory.getRenderingSettingsService().ice_context(callCtx);
        this.delegate = (MetadataStorePrx)MetadataStorePrxHelper.checkedCast(this.serviceFactory.getByName("omero.api.MetadataStore")).ice_context(callCtx);
        this.enumProvider = new IQueryEnumProvider(this.iQuery);
        this.instanceProvider = new BlitzInstanceProvider(this.enumProvider);
        this.modelProcessors = new ArrayList<ModelProcessor>();
        this.modelProcessors.add(new PixelsProcessor());
        this.modelProcessors.add(new ChannelProcessor());
        this.modelProcessors.add(new InstrumentProcessor());
        this.modelProcessors.add(new PlaneInfoProcessor());
        this.modelProcessors.add(new WellProcessor());
        this.modelProcessors.add(new ShapeProcessor());
        this.modelProcessors.add(new TargetProcessor());
        this.modelProcessors.add(new ReferenceProcessor());
        if (keepAliveRate != null) {
            if (this.executor != null) {
                this.log.error("Executor already set!");
                this.executor.shutdown();
            }
            this.keepAlive = new ClientKeepAlive();
            this.keepAlive.setClient(this);
            this.executor = new ScheduledThreadPoolExecutor(1);
            this.executor.scheduleWithFixedDelay(this.keepAlive, keepAliveRate.intValue(), keepAliveRate.intValue(), TimeUnit.SECONDS);
            this.log.info("Pinging session every {}s.", (Object)keepAliveRate);
        }
    }

    private int getDefaultInt(String key, int def) {
        if (this.c != null) {
            try {
                return Integer.valueOf(this.c.getProperty(key));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public int getDefaultBatchSize() {
        return this.getDefaultInt("omero.batch_size", 2000);
    }

    public int getDefaultBlockSize() {
        return this.getDefaultInt("omero.block_size", 5000000);
    }

    public IQueryPrx getIQuery() {
        return this.iQuery;
    }

    public void setEncryptedConnection(boolean encryptedConnection) {
        this.encryptedConnection = encryptedConnection;
    }

    public boolean isEncryptedConnection() {
        return this.encryptedConnection;
    }

    public Long setGroup(Long groupID) {
        Long old = this.groupID;
        this.groupID = groupID;
        return old;
    }

    public void initialize(ServiceFactoryPrx serviceFactory) throws ServerError {
        if (serviceFactory == null) {
            throw new IllegalArgumentException("No factory.");
        }
        this.serviceFactory = serviceFactory;
        this.initializeServices(false);
    }

    public void initialize(client c) throws ServerError {
        this.c = c;
        c.setAgent("OMERO.importer");
        this.serviceFactory = c.getSession();
        this.initializeServices(false);
    }

    public void initialize(String username, String password, String server, int port) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.initialize(username, password, server, port, true);
    }

    public void initialize(String username, String password, String server, int port, boolean isSecure) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.initialize(username, password, server, port, null, isSecure);
    }

    public void initialize(String username, String password, String server, int port, Long group, boolean isSecure) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.initialize(username, password, server, port, group, isSecure, null);
    }

    public void initialize(String username, String password, String server, int port, Long group, boolean isSecure, Integer keepAliveRate) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.secure(server, port);
        this.serviceFactory = this.c.createSession(username, password);
        this.ownsSession = true;
        if (!isSecure) {
            this.unsecure();
        }
        if (group != null) {
            this.setGroup(group);
        }
        this.initializeServices(keepAliveRate);
    }

    public void initialize(String server, int port, String sessionKey) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.initialize(server, port, sessionKey, true);
    }

    public void initialize(String server, int port, String sessionKey, boolean isSecure) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.initialize(server, port, sessionKey, isSecure, DEFAULT_KEEP_ALIVE);
    }

    public void initialize(String server, int port, String sessionKey, boolean isSecure, Integer keepAliveRate) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.secure(server, port);
        this.serviceFactory = this.c.joinSession(sessionKey);
        this.ownsSession = true;
        if (!isSecure) {
            try {
                this.unsecure();
            }
            catch (ConnectionRefusedException cre) {
                this.log.warn("Cannot fallback. Using secure connection", (Throwable)cre);
            }
        }
        this.initializeServices(keepAliveRate);
    }

    private void secure(String server, int port) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.log.info(String.format("Attempting initial SSL connection to %s:%d", server, port));
        this.c = new client(server, port);
        this.c.setAgent("OMERO.importer");
    }

    private void unsecure() throws ServerError, CannotCreateSessionException, PermissionDeniedException {
        this.log.info("Insecure connection requested, falling back");
        client tmp = this.c.createClient(false);
        try {
            this.c.__del__();
        }
        finally {
            this.c = tmp;
        }
        this.serviceFactory = this.c.getSession();
    }

    public ServiceFactoryPrx getServiceFactory() {
        return this.serviceFactory;
    }

    public void ping() {
        try {
            this.serviceFactory.keepAllAlive(new ServiceInterfacePrx[]{this.iQuery, this.iAdmin, this.rawFileStore, this.rawPixelStore, this.thumbnailStore, this.iRepoInfo, this.iContainer, this.iUpdate, this.iSettings, this.delegate});
            this.log.debug("KeepAlive ping.");
        }
        catch (Exception e) {
            this.log.debug("KeepAlive failed.");
            throw new RuntimeException(e);
        }
    }

    public void setCurrentLogFile(String logFilename, String token) {
        this.logFilename = logFilename;
        this.token = token;
    }

    public void updateFileSize(OriginalFile file, long size) throws ServerError {
        file = (OriginalFile)this.iQuery.get("OriginalFile", file.getId().getValue());
        file.setSize(rtypes.rlong(size));
        this.iUpdate.saveObject(file);
    }

    public void setEnumerationProvider(EnumerationProvider enumProvider) {
        this.enumProvider = enumProvider;
    }

    public EnumerationProvider getEnumerationProvider() {
        return this.enumProvider;
    }

    public void setInstanceProvider(InstanceProvider instanceProvider) {
        this.instanceProvider = instanceProvider;
    }

    public InstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    public RInt toRType(Integer value) {
        return value == null ? null : rtypes.rint(value);
    }

    private omero.model.Time toRType(Time timeIncrement) {
        if (timeIncrement == null) {
            return null;
        }
        UnitsTime internal = UnitsTime.bySymbol((String)timeIncrement.unit().getSymbol());
        omero.model.enums.UnitsTime ut = omero.model.enums.UnitsTime.valueOf(internal.toString());
        TimeI t = new TimeI();
        t.setValue(timeIncrement.value().doubleValue());
        t.setUnit(ut);
        return t;
    }

    public RInt toRType(NonNegativeInteger value) {
        return value == null ? null : rtypes.rint((Integer)value.getValue());
    }

    public RLong toRType(NonNegativeLong value) {
        return value == null ? null : rtypes.rlong((Long)value.getValue());
    }

    public RDouble toRType(PositiveFloat value) {
        return value == null ? null : rtypes.rdouble((Double)value.getValue());
    }

    public RDouble toRType(PercentFraction value) {
        return value == null ? null : rtypes.rdouble(((Float)value.getValue()).floatValue());
    }

    public RLong toRType(Long value) {
        return value == null ? null : rtypes.rlong(value);
    }

    public RString toRType(String value) {
        return value == null ? null : rtypes.rstring(value);
    }

    public RBool toRType(Boolean value) {
        return value == null ? null : rtypes.rbool(value);
    }

    public RDouble toRType(Double value) {
        return value == null ? null : rtypes.rdouble(value);
    }

    public RDouble toRType(Float value) {
        return value == null ? null : rtypes.rdouble(Double.parseDouble(value.toString()));
    }

    public RTime toRType(Timestamp value) {
        return value == null ? null : rtypes.rtime(value.asInstant().getMillis());
    }

    public RString toRType(NamingConvention value) {
        return value == null ? null : rtypes.rstring(value.getValue());
    }

    public omero.model.AffineTransform toRType(AffineTransform schemaTransform) {
        if (schemaTransform == null || schemaTransform.getA00() == null || schemaTransform.getA01() == null || schemaTransform.getA02() == null || schemaTransform.getA10() == null || schemaTransform.getA11() == null || schemaTransform.getA12() == null) {
            return null;
        }
        AffineTransformI omeroTransform = new AffineTransformI();
        omeroTransform.setA00(this.toRType(schemaTransform.getA00()));
        omeroTransform.setA01(this.toRType(schemaTransform.getA01()));
        omeroTransform.setA02(this.toRType(schemaTransform.getA02()));
        omeroTransform.setA10(this.toRType(schemaTransform.getA10()));
        omeroTransform.setA11(this.toRType(schemaTransform.getA11()));
        omeroTransform.setA12(this.toRType(schemaTransform.getA12()));
        return omeroTransform;
    }

    public RInt toRType(Color value) {
        return this.toRType((Integer)value.getValue());
    }

    private void closeQuietly(StatefulServiceInterfacePrx prx) {
        if (prx != null) {
            try {
                prx.close();
            }
            catch (CommunicatorDestroyedException cde) {
                this.log.debug("Communicator already closed; cannot close " + prx);
            }
            catch (ConnectionLostException cle) {
                this.log.debug("Connection lost; cannot close " + prx);
            }
            catch (Exception e) {
                this.log.warn("Exception closing " + prx, (Throwable)e);
                this.log.debug(e.toString());
            }
        }
    }

    public void closeServices() {
        this.closeQuietly(this.rawFileStore);
        this.rawFileStore = null;
        this.closeQuietly(this.rawPixelStore);
        this.rawPixelStore = null;
        this.closeQuietly(this.thumbnailStore);
        this.thumbnailStore = null;
        this.closeQuietly(this.delegate);
        this.delegate = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        block15: {
            try {
                if (this.executor == null) break block15;
                this.log.debug("Logout called, shutting keep alive down.");
                try {
                    this.executor.shutdown();
                }
                finally {
                    if (this.keepAlive != null) {
                        this.keepAlive.notifyLogout();
                        this.keepAlive = null;
                    }
                    this.executor = null;
                }
                this.log.debug("keepalive shut down.");
            }
            finally {
                this.closeServices();
                client copy = this.c;
                if (copy != null) {
                    try {
                        if (this.ownsSession) {
                            this.log.debug("closing client session.");
                            copy.closeSession();
                            this.log.debug("client closed.");
                        } else {
                            this.log.debug("leaving client session open");
                        }
                    }
                    finally {
                        copy.__del__();
                        this.c = null;
                    }
                }
            }
        }
    }

    public void prepare(Map<Integer, Image> existingMetadata) {
        this.existingMetadata = existingMetadata;
    }

    private void prepare() {
        if (this.existingMetadata == null) {
            return;
        }
        for (Map.Entry<Integer, Image> entry : this.existingMetadata.entrySet()) {
            Image image = entry.getValue();
            Integer series = entry.getKey();
            image.setAcquisitionDate(null);
            Pixels pixels = image.getPrimaryPixels();
            LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
            indexes.put(Index.IMAGE_INDEX, series);
            IObjectContainer container = this.getIObjectContainer(Image.class, indexes);
            container.sourceObject = image;
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Prepared(%d) == %s,%s", series, container.sourceObject, container.LSID));
            }
            container = this.getIObjectContainer(Pixels.class, indexes);
            container.sourceObject = pixels;
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug(String.format("Prepared(%d) == %s,%s", series, container.sourceObject, container.LSID));
        }
    }

    public void createRoot() {
        try {
            this.log.debug("Creating root!");
            this.initializeServices(false);
            this.authoritativeContainerCache = new HashMap<Class<? extends IObject>, Map<String, IObjectContainer>>();
            this.containerCache = new TreeMap<LSID, IObjectContainer>(new OMEXMLModelComparator());
            this.referenceCache = new HashMap<LSID, List<LSID>>();
            this.referenceCacheCheck = new HashMap<LSID, Set<LSID>>();
            this.referenceStringCache = null;
            this.imageChannelGlobalMinMax = null;
            this.userSpecifiedAnnotations = null;
            this.userSpecifiedName = null;
            this.userSpecifiedDescription = null;
            this.userSpecifiedTarget = null;
            this.userSpecifiedPhysicalPixelSizes = null;
            this.delegate.createRoot();
            this.prepare();
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        finally {
            this.existingMetadata = null;
        }
    }

    public MetadataRoot getRoot() {
        return this.pixelsList;
    }

    private IObject getEnumeration(Class<? extends IObject> klass, String value) {
        return this.enumProvider.getEnumeration(klass, value, false);
    }

    private void checkDuplicateLSID(Class<? extends IObject> klass, String lsid) {
        if (this.log.isTraceEnabled()) {
            List<IObjectContainer> containers = this.getIObjectContainers(klass);
            for (IObjectContainer container : containers) {
                if (!container.LSID.equals(lsid)) continue;
                this.log.trace(String.format("Duplicate LSID %s exists in %s,%s", lsid, container.sourceObject, container.LSID));
                return;
            }
        }
    }

    @Override
    public IFormatReader getReader() {
        return this.reader;
    }

    private Format getImageFormat() {
        IFormatReader reader = this.getReader();
        if (reader instanceof ImageReader) {
            reader = ((ImageReader)reader).getReader();
        }
        String value = reader.getClass().toString();
        value = value.replace("class loci.formats.in.", "");
        value = value.replace("Reader", "");
        return (Format)this.getEnumeration(Format.class, value);
    }

    @Override
    public void setReader(IFormatReader reader) {
        this.reader = reader;
    }

    @Override
    public List<Annotation> getUserSpecifiedAnnotations() {
        return this.userSpecifiedAnnotations;
    }

    @Override
    public void setUserSpecifiedAnnotations(List<Annotation> annotations) {
        this.userSpecifiedAnnotations = annotations;
    }

    @Override
    public String getUserSpecifiedName() {
        return this.userSpecifiedName;
    }

    public String getUserSpecifiedImageName() {
        return this.userSpecifiedName;
    }

    @Override
    public void setUserSpecifiedName(String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using user specified name: " + name);
        }
        this.userSpecifiedName = name;
    }

    @Override
    public String getUserSpecifiedDescription() {
        return this.userSpecifiedDescription;
    }

    @Override
    public void setUserSpecifiedDescription(String description) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using user specified description: " + description);
        }
        this.userSpecifiedDescription = description;
    }

    @Override
    public IObject getUserSpecifiedTarget() {
        return this.userSpecifiedTarget;
    }

    @Override
    public void setUserSpecifiedTarget(IObject target) {
        if (target instanceof Screen && null != this.screenKey) {
            this.log.info("deleting screen ref in favor of user-specified one");
            this.referenceCache.remove(this.screenKey);
        }
        this.userSpecifiedTarget = target;
    }

    @Override
    public Double[] getUserSpecifiedPhysicalPixelSizes() {
        return this.userSpecifiedPhysicalPixelSizes;
    }

    @Override
    public void setUserSpecifiedPhysicalPixelSizes(Double physicalSizeX, Double physicalSizeY, Double physicalSizeZ) {
        this.userSpecifiedPhysicalPixelSizes = new Double[]{physicalSizeX, physicalSizeY, physicalSizeZ};
    }

    public List<ModelProcessor> getModelProcessors() {
        return this.modelProcessors;
    }

    public void setModelProcessors(List<ModelProcessor> modelProcessors) {
        this.modelProcessors = modelProcessors;
    }

    public void removeModelProcessor(ModelProcessor processor) {
        this.modelProcessors.remove(processor);
    }

    public boolean addModelProcessor(ModelProcessor processor) {
        return this.modelProcessors.add(processor);
    }

    @Override
    public Map<LSID, IObjectContainer> getContainerCache() {
        return this.containerCache;
    }

    @Override
    public Map<LSID, List<LSID>> getReferenceCache() {
        return Collections.unmodifiableMap(this.referenceCache);
    }

    @Override
    public Map<Class<? extends IObject>, Map<String, IObjectContainer>> getAuthoritativeContainerCache() {
        return this.authoritativeContainerCache;
    }

    private void addAuthoritativeContainer(Class<? extends IObject> klass, String lsid, IObjectContainer container) {
        Map<String, IObjectContainer> lsidContainerMap = this.authoritativeContainerCache.get(klass);
        if (lsidContainerMap == null) {
            lsidContainerMap = new HashMap<String, IObjectContainer>();
            this.authoritativeContainerCache.put(klass, lsidContainerMap);
        }
        lsidContainerMap.put(lsid, container);
    }

    @Override
    public void addReference(LSID source, LSID target) {
        List<Object> targets = null;
        Set<Object> targetsCheck = null;
        if (this.referenceCache.containsKey(source)) {
            targets = this.referenceCache.get(source);
            targetsCheck = this.referenceCacheCheck.get(source);
        } else {
            targets = new ArrayList();
            targetsCheck = new HashSet();
            this.referenceCache.put(source, targets);
            this.referenceCacheCheck.put(source, targetsCheck);
        }
        if (!targetsCheck.contains(target)) {
            targetsCheck.add(target);
            targets.add(target);
        }
    }

    @Override
    public Map<String, String[]> getReferenceStringCache() {
        return this.referenceStringCache;
    }

    @Override
    public void setReferenceStringCache(Map<String, String[]> referenceStringCache) {
        this.referenceStringCache = referenceStringCache;
    }

    private <T extends IObject> T getSourceObject(Class<T> klass, LinkedHashMap<Index, Integer> indexes) {
        return (T)this.getIObjectContainer(klass, indexes).sourceObject;
    }

    @Override
    public IObject getSourceObject(LSID LSID2) {
        IObjectContainer o = this.containerCache.get(LSID2);
        if (o == null) {
            return null;
        }
        return o.sourceObject;
    }

    @Override
    public <T extends IObject> List<T> getSourceObjects(Class<T> klass) {
        List<IObjectContainer> containers = this.getIObjectContainers(klass);
        ArrayList<IObject> toReturn = new ArrayList<IObject>(containers.size());
        for (IObjectContainer container : containers) {
            toReturn.add(container.sourceObject);
        }
        return toReturn;
    }

    @Override
    public boolean hasReference(LSID source, LSID target) {
        return this.referenceCache.containsKey(source) && this.referenceCache.get(source).contains(target);
    }

    public void setPixelsFile(long pixelsId, String file, String repo) throws ServerError {
        try {
            this.delegate.setPixelsFile(pixelsId, file, repo);
        }
        catch (Exception e) {
            this.log.error("Server error setting extended properties for Pixels:" + pixelsId + " Target file:" + file, (Throwable)e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public void setCurrentGroup(long groupID) throws ServerError {
        this.setGroup(groupID);
        this.initializeServices(false);
    }

    List<ExperimenterGroup> getUserGroups() throws ServerError {
        ArrayList<ExperimenterGroup> myGroups = new ArrayList<ExperimenterGroup>();
        ParametersI p = new ParametersI();
        p.addId(this.eventContext.userId);
        List<IObject> groups = this.iQuery.findAllByQuery("select distinct g from ExperimenterGroup as g join fetch g.groupExperimenterMap as map join fetch map.parent e left outer join fetch map.child u left outer join fetch u.groupExperimenterMap m2 left outer join fetch m2.parent p where g.id in   (select m.parent from GroupExperimenterMap m   where m.child.id = :id )", p);
        for (ExperimenterGroup experimenterGroup : groups) {
            myGroups.add(experimenterGroup);
        }
        return myGroups;
    }

    public Map<Long, String> mapUserGroups() throws ServerError {
        String dn;
        ArrayList<String> systemGroups = new ArrayList<String>();
        systemGroups.add("system");
        systemGroups.add("user");
        systemGroups.add("guest");
        LinkedHashMap<Long, String> names = new LinkedHashMap<Long, String>();
        List<ExperimenterGroup> groups = this.getUserGroups();
        if (groups == null || groups.size() == 0) {
            return null;
        }
        ExperimenterGroup currentDefaultGroup = this.iAdmin.getDefaultGroup(this.eventContext.userId);
        Iterator<ExperimenterGroup> i = groups.iterator();
        ExperimenterGroup group = null;
        while (i.hasNext()) {
            group = i.next();
            String n = group.getName() == null ? null : group.getName().getValue();
            if (systemGroups.contains(n) || group.getId().getValue() == currentDefaultGroup.getId().getValue()) continue;
            names.put(group.getId().getValue(), group.getName().getValue());
        }
        String string = dn = currentDefaultGroup.getName() == null ? null : currentDefaultGroup.getName().getValue();
        if (!systemGroups.contains(dn)) {
            names.put(currentDefaultGroup.getId().getValue(), currentDefaultGroup.getName().getValue());
        }
        if (names.size() == 0) {
            names = null;
        }
        return names;
    }

    public String getDefaultGroupName() throws ServerError {
        ExperimenterGroup currentDefaultGroup = this.iAdmin.getDefaultGroup(this.eventContext.userId);
        String dn = currentDefaultGroup.getName() == null ? "" : currentDefaultGroup.getName().getValue();
        return dn;
    }

    @Deprecated
    public int getDefaultGroupLevel() throws ServerError {
        int groupLevel = 0;
        ExperimenterGroup currentDefaultGroup = this.iAdmin.getDefaultGroup(this.eventContext.userId);
        Permissions perm = currentDefaultGroup.getDetails().getPermissions();
        groupLevel = perm.isGroupRead() ? (perm.isGroupWrite() ? 2 : 1) : (perm.isWorldRead() ? 0 : 3);
        return groupLevel;
    }

    public long getRepositorySpace() {
        try {
            return this.iRepoInfo.getFreeSpaceInKilobytes();
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public void postProcess() {
        for (ModelProcessor processor : this.modelProcessors) {
            processor.process(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, List<IObject>> saveToDB(FilesetJobLink link) {
        try {
            int batchSize;
            void var6_16;
            Collection<IObjectContainer> containers = this.containerCache.values();
            IObjectContainer[] containerArray = containers.toArray(new IObjectContainer[containers.size()]);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Starting containers....");
                for (LSID lSID : this.containerCache.keySet()) {
                    String string = String.format("%s == %s,%s", lSID, this.containerCache.get((Object)lSID).sourceObject, this.containerCache.get((Object)lSID).LSID);
                    this.log.debug(string);
                }
                this.log.debug("Starting references....");
                for (String string : this.referenceStringCache.keySet()) {
                    for (String value : this.referenceStringCache.get(string)) {
                        String s = String.format("%s == %s", string, value);
                        this.log.debug(s);
                    }
                }
                this.log.debug("containerCache contains " + this.containerCache.size() + " entries.");
                this.log.debug("referenceCache contains " + this.countCachedReferences(null, null) + " entries.");
            }
            int maxBatchSize = this.getDefaultBatchSize();
            boolean bl = false;
            boolean bl2 = false;
            this.log.info("Handling # of containers: {}", (Object)containerArray.length);
            while (var6_16 < containerArray.length) {
                void var5_11;
                int nObjects = Math.min(maxBatchSize, containerArray.length - var6_16);
                IObjectContainer[] batch = Arrays.copyOfRange(containerArray, (int)var6_16, (int)(var6_16 + nObjects));
                this.delegate.updateObjects(batch);
                var6_16 += nObjects;
                if (++var5_11 <= true) continue;
                this.log.info("Starting containerBatch #{}", (Object)((int)var5_11));
            }
            int referenceBatchCount = 0;
            String[] referenceKeys = this.referenceStringCache.keySet().toArray(new String[this.referenceStringCache.size()]);
            this.log.info("Handling # of references: {}", (Object)referenceKeys.length);
            for (int referencePointer = 0; referencePointer < referenceKeys.length; referencePointer += batchSize) {
                if (++referenceBatchCount > 1) {
                    this.log.info("Starting referenceBatch #{}", (Object)referenceBatchCount);
                }
                HashMap<String, String[]> referenceBatch = new HashMap<String, String[]>();
                batchSize = Math.min(maxBatchSize, referenceKeys.length - referencePointer);
                for (int i = 0; i < batchSize; ++i) {
                    String key = referenceKeys[referencePointer + i];
                    referenceBatch.put(key, this.referenceStringCache.get(key));
                }
                this.delegate.updateReferences(referenceBatch);
            }
            Map<String, List<IObject>> rv = this.delegate.saveToDB(link);
            this.pixelsList = new OMEROMetadataStoreClientRoot(rv.get("Pixels"));
            if (this.log.isDebugEnabled()) {
                for (Pixels pixels : this.pixelsList) {
                    long pixelsId = pixels.getId().getValue();
                    this.log.debug("Saved Pixels with ID: " + pixelsId);
                }
            }
            return rv;
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public List<InteractiveProcessorPrx> launchProcessing() {
        try {
            return this.delegate.postProcess();
        }
        catch (Exception e) {
            this.log.warn("Failed to launch post-processing", (Throwable)e);
            return null;
        }
    }

    public <T extends IObject> T getTarget(Class<T> klass, long id) {
        try {
            HashMap<String, String> allGroups = new HashMap<String, String>();
            allGroups.put("omero.group", "-1");
            IObject obj = this.iQuery.get(klass.getName(), id, allGroups);
            if (obj == null) {
                throw new RuntimeException(String.format("Cannot find target: %s:%s", klass.getName(), id));
            }
            long grpID = obj.getDetails().getGroup().getId().getValue();
            if (grpID != this.eventContext.groupId) {
                throw new RuntimeException(String.format("Target container in group: %s, not current group: %s", grpID, this.eventContext.groupId));
            }
            this.setCurrentGroup(grpID);
            return (T)obj;
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public Project getProject(long projectId) {
        try {
            return (Project)this.iQuery.get("Project", projectId);
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public Dataset addDataset(String datasetName, String datasetDescription, Project project) {
        DatasetI dataset = new DatasetI();
        if (datasetName.length() != 0) {
            dataset.setName(this.toRType(datasetName));
        }
        if (datasetDescription.length() != 0) {
            dataset.setDescription(this.toRType(datasetDescription));
        }
        if (project.getId() != null) {
            ProjectI p = new ProjectI(project.getId().getValue(), false);
            dataset.linkProject(p);
        }
        try {
            return (Dataset)this.iUpdate.saveAndReturnObject(dataset);
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public long getExperimenterID() {
        return this.eventContext.userId;
    }

    public String getConfigValue(String key) {
        try {
            return this.serviceFactory.getConfigService().getConfigValue(key);
        }
        catch (SecurityViolation sv) {
            return null;
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public List<Screen> getScreens() {
        try {
            List<IObject> objects = this.iContainer.loadContainerHierarchy(Screen.class.getName(), null, new ParametersI().exp(rtypes.rlong(this.getExperimenterID())));
            ArrayList<Screen> screens = new ArrayList<Screen>(objects.size());
            for (IObject object : objects) {
                screens.add((Screen)object);
            }
            return screens;
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public List<Project> getProjects() {
        try {
            List<IObject> objects = this.iContainer.loadContainerHierarchy(Project.class.getName(), null, new ParametersI().exp(rtypes.rlong(this.getExperimenterID())));
            ArrayList<Project> projects = new ArrayList<Project>(objects.size());
            for (IObject object : objects) {
                projects.add((Project)object);
            }
            Collections.sort(projects, new SortProjectsByName());
            return projects;
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public List<Dataset> getDatasets(Project p) {
        if (p.getId() == null || p.getId().getValue() == 0L) {
            return this.getDatasetsWithoutProjects();
        }
        try {
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(p.getId().getValue());
            List<IObject> objects = this.iContainer.loadContainerHierarchy(Project.class.getName(), ids, null);
            if (objects.size() > 0) {
                Project project = (Project)objects.get(0);
                List<Dataset> datasets = project.linkedDatasetList();
                Collections.sort(datasets, new SortDatasetsByName());
                return datasets;
            }
            return null;
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public List<Dataset> getDatasetsWithoutProjects() {
        try {
            ParametersI param = new ParametersI();
            param.exp(rtypes.rlong(this.getExperimenterID()));
            param.orphan();
            List<IObject> objects = this.iContainer.loadContainerHierarchy(Project.class.getName(), null, param);
            ArrayList<Dataset> datasets = new ArrayList<Dataset>(0);
            for (IObject object : objects) {
                if (!(object instanceof DatasetI)) continue;
                datasets.add((Dataset)object);
            }
            return datasets;
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public Project addProject(String projectName, String projectDescription) {
        ProjectI project = new ProjectI();
        if (projectName.length() != 0) {
            project.setName(this.toRType(projectName));
        }
        if (projectDescription.length() != 0) {
            project.setDescription(this.toRType(projectDescription));
        }
        try {
            return (Project)this.iUpdate.saveAndReturnObject(project);
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public Screen addScreen(String screenName, String screenDescription) {
        ScreenI screen = new ScreenI();
        if (screenName.length() != 0) {
            screen.setName(this.toRType(screenName));
        }
        if (screenDescription.length() != 0) {
            screen.setDescription(this.toRType(screenDescription));
        }
        try {
            return (Screen)this.iUpdate.saveAndReturnObject(screen);
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public void preparePixelsStore(List<Long> pixelsIds) {
        try {
            this.rawPixelStore.prepare(pixelsIds);
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public void finalizePixelStore() throws ServerError {
        if (this.rawPixelStore != null) {
            try {
                this.rawPixelStore.close();
            }
            finally {
                this.rawPixelStore = null;
            }
        }
        this.rawPixelStore = this.serviceFactory.createRawPixelsStore();
    }

    public int[] getTileSize(Long pixId) throws ServerError {
        this.resetPixelsId(pixId);
        return this.rawPixelStore.getTileSize();
    }

    public void setTile(Long pixId, byte[] arrayBuf, int z, int c, int t, int x, int y, int w, int h) throws ServerError {
        this.resetPixelsId(pixId);
        this.rawPixelStore.setTile(arrayBuf, z, c, t, x, y, w, h);
    }

    public void setPlane(Long pixId, byte[] arrayBuf, int z, int c, int t) throws ServerError {
        this.resetPixelsId(pixId);
        this.rawPixelStore.setPlane(arrayBuf, z, c, t);
    }

    public void setChannelGlobalMinMax(int channel, double minimum, double maximum, int series) {
        double[] globalMinMax;
        Object channelGlobalMinMax;
        Pixels pixels = (Pixels)this.getSourceObject(new LSID(Pixels.class, new int[]{series}));
        if (this.imageChannelGlobalMinMax == null) {
            int imageCount = this.countCachedContainers(Image.class, new int[0]);
            this.imageChannelGlobalMinMax = new double[imageCount][][];
        }
        if ((channelGlobalMinMax = this.imageChannelGlobalMinMax[series]) == null) {
            double[][] dArrayArray = new double[pixels.getSizeC().getValue()][];
            channelGlobalMinMax = dArrayArray;
            this.imageChannelGlobalMinMax[series] = dArrayArray;
        }
        if ((globalMinMax = channelGlobalMinMax[channel]) == null) {
            globalMinMax = new double[2];
            this.imageChannelGlobalMinMax[series][channel] = globalMinMax;
        }
        globalMinMax[0] = minimum;
        globalMinMax[1] = maximum;
    }

    public void updatePixels(List<Pixels> pixelsList) {
        try {
            ArrayList<IObject> objectList = new ArrayList<IObject>(pixelsList.size());
            for (Pixels pixels : pixelsList) {
                pixels.unloadPixelsFileMaps();
                pixels.unloadPlaneInfo();
                pixels.unloadSettings();
                pixels.unloadThumbnails();
                pixels.unloadDetails();
                objectList.add(pixels);
            }
            this.iUpdate.saveArray(objectList);
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public void populateMinMax() {
        try {
            this.delegate.populateMinMax(this.imageChannelGlobalMinMax);
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public void resetDefaultsAndGenerateThumbnails(List<Long> plateIds, List<Long> pixelsIds) {
        try {
            if (plateIds.size() > 0) {
                this.iSettings.resetDefaultsInSet("Plate", plateIds);
            } else {
                this.iSettings.resetDefaultsInSet("Pixels", pixelsIds);
            }
            this.thumbnailStore.createThumbnailsByLongestSideSet(rtypes.rint(96), pixelsIds);
        }
        catch (ServerError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public IObjectContainer getIObjectContainer(Class<? extends IObject> klass, LinkedHashMap<Index, Integer> indexes) {
        Collection<Integer> indexValues = indexes.values();
        int[] indexesArray = new int[indexValues.size()];
        int i = 0;
        for (Integer index : indexValues) {
            indexesArray[i] = index;
            ++i;
        }
        LSID lsid = new LSID(klass, indexesArray);
        HashMap<String, Integer> asString = new HashMap<String, Integer>();
        for (Map.Entry<Index, Integer> v : indexes.entrySet()) {
            asString.put(v.getKey().toString(), v.getValue());
        }
        if (!this.containerCache.containsKey(lsid)) {
            IObjectContainer c = new IObjectContainer();
            c.indexes = asString;
            c.LSID = lsid.toString();
            c.sourceObject = this.getSourceObjectInstance(klass);
            this.containerCache.put(lsid, c);
        }
        return this.containerCache.get(lsid);
    }

    @Override
    public void removeIObjectContainer(LSID lsid) {
        this.containerCache.remove(lsid);
    }

    @Override
    public List<IObjectContainer> getIObjectContainers(Class<? extends IObject> klass) {
        Set<LSID> keys = this.containerCache.keySet();
        ArrayList<IObjectContainer> toReturn = new ArrayList<IObjectContainer>();
        for (LSID key : keys) {
            Class keyClass = key.getJavaClass();
            if (keyClass == null || !keyClass.equals(klass)) continue;
            toReturn.add(this.containerCache.get(key));
        }
        return toReturn;
    }

    private <T extends IObject> T getSourceObjectInstance(Class<T> klass) {
        return this.instanceProvider.getInstance(klass);
    }

    @Override
    public int countCachedContainers(Class<? extends IObject> klass, int ... indexes) {
        if (klass == null) {
            return new HashSet<IObjectContainer>(this.containerCache.values()).size();
        }
        int count = 0;
        for (LSID lsid : this.containerCache.keySet()) {
            Class lsidClass = lsid.getJavaClass();
            if (lsidClass == null || !lsidClass.equals(klass)) continue;
            if (indexes == null) {
                ++count;
                continue;
            }
            int[] lsidIndexes = lsid.getIndexes();
            int n = Math.min(indexes.length, lsidIndexes.length);
            boolean match = true;
            for (int i = 0; i < n; ++i) {
                if (lsidIndexes[i] == indexes[i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countCachedReferences(Class<? extends IObject> source, Class<? extends IObject> target) {
        if (source == null && target == null) {
            int count = 0;
            for (LSID key : this.referenceCache.keySet()) {
                count += this.referenceCache.get(key).size();
            }
            return count;
        }
        int count = 0;
        if (target == null) {
            for (LSID lsid : this.referenceCache.keySet()) {
                Class containerClass = lsid.getJavaClass();
                if (!containerClass.equals(source)) continue;
                ++count;
            }
            return count;
        }
        if (source == null) {
            for (LSID sourceLSID : this.referenceCache.keySet()) {
                for (LSID targetLSID : this.referenceCache.get(sourceLSID)) {
                    Class containerClass = targetLSID.getJavaClass();
                    if (!containerClass.equals(target)) continue;
                    ++count;
                }
            }
            return count;
        }
        for (LSID sourceLSID : this.referenceCache.keySet()) {
            Class sourceClass = sourceLSID.getJavaClass();
            if (!sourceClass.equals(source)) continue;
            for (LSID targetLSID : this.referenceCache.get(sourceLSID)) {
                Class targetClass = targetLSID.getJavaClass();
                if (!targetClass.equals(target)) continue;
                ++count;
            }
        }
        return count;
    }

    private Arc getArc(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        return this.getSourceObject(Arc.class, indexes);
    }

    public void setArcID(String id, int instrumentIndex, int lightSourceIndex) {
        this.checkDuplicateLSID(Arc.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(Arc.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Arc.class, id, o);
    }

    public void setArcLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setArcManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setArcModel(String model, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setArcPower(Power power, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setPower(UnitsFactory.convertPower(power));
    }

    public void setArcSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setArcType(ome.xml.model.enums.ArcType type, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setType((ArcType)this.getEnumeration(ArcType.class, type.toString()));
    }

    public void setArcAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        LSID key = new LSID(Arc.class, new int[]{instrumentIndex, lightSourceIndex});
        this.addReference(key, new LSID(annotation));
    }

    private BooleanAnnotation getBooleanAnnotation(int booleanAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.BOOLEAN_ANNOTATION_INDEX, booleanAnnotationIndex);
        return this.getSourceObject(BooleanAnnotation.class, indexes);
    }

    public void setBooleanAnnotationID(String id, int booleanAnnotationIndex) {
        this.checkDuplicateLSID(BooleanAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.BOOLEAN_ANNOTATION_INDEX, booleanAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(BooleanAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(BooleanAnnotation.class, id, o);
    }

    public void setBooleanAnnotationNamespace(String namespace, int booleanAnnotationIndex) {
        BooleanAnnotation o = this.getBooleanAnnotation(booleanAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setBooleanAnnotationValue(Boolean value, int booleanAnnotationIndex) {
        BooleanAnnotation o = this.getBooleanAnnotation(booleanAnnotationIndex);
        o.setBoolValue(this.toRType(value));
    }

    public void setBinaryOnlyUUID(String uuid) {
        this.ignoreUnneeded("BinaryOnlyUUID", uuid);
    }

    public void setBinaryOnlyMetadataFile(String metadataFile) {
        this.ignoreUnneeded("BinaryMetadataFile", metadataFile);
    }

    public Channel getChannel(int imageIndex, int channelIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.CHANNEL_INDEX, channelIndex);
        Channel c = this.getSourceObject(Channel.class, indexes);
        c.setLogicalChannel(this.getSourceObject(LogicalChannel.class, indexes));
        return this.getSourceObject(Channel.class, indexes);
    }

    public void setChannelID(String id, int imageIndex, int channelIndex) {
        this.checkDuplicateLSID(Channel.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.CHANNEL_INDEX, channelIndex);
        IObjectContainer o = this.getIObjectContainer(Channel.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Channel.class, id, o);
    }

    public void setChannelAcquisitionMode(AcquisitionMode acquisitionMode, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setMode((omero.model.AcquisitionMode)this.getEnumeration(omero.model.AcquisitionMode.class, acquisitionMode.toString()));
    }

    public void setChannelColor(Color color, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.setRed(this.toRType(color.getRed()));
        o.setGreen(this.toRType(color.getGreen()));
        o.setBlue(this.toRType(color.getBlue()));
        o.setAlpha(this.toRType(color.getAlpha()));
    }

    public void setChannelContrastMethod(ome.xml.model.enums.ContrastMethod contrastMethod, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setContrastMethod((ContrastMethod)this.getEnumeration(ContrastMethod.class, contrastMethod.toString()));
    }

    public void setChannelEmissionWavelength(Length emissionWavelength, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setEmissionWave(UnitsFactory.convertLength(emissionWavelength));
    }

    public void setChannelExcitationWavelength(Length excitationWavelength, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setExcitationWave(UnitsFactory.convertLength(excitationWavelength));
    }

    public void setChannelFilterSetRef(String filterSet, int imageIndex, int channelIndex) {
        LSID key = new LSID(LogicalChannel.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(filterSet));
    }

    public void setChannelFluor(String fluor, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setFluor(this.toRType(fluor));
    }

    public void setChannelIlluminationType(IlluminationType illuminationType, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setIllumination((Illumination)this.getEnumeration(Illumination.class, illuminationType.toString()));
    }

    public void setChannelNDFilter(Double ndfilter, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setNdFilter(this.toRType(ndfilter));
    }

    public void setChannelName(String name, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setName(this.toRType(name));
    }

    public void setChannelPinholeSize(Length pinholeSize, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setPinHoleSize(UnitsFactory.convertLength(pinholeSize));
    }

    public void setChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setPockelCellSetting(this.toRType(pockelCellSetting));
    }

    public void setChannelSamplesPerPixel(PositiveInteger samplesPerPixel, int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        o.getLogicalChannel().setSamplesPerPixel(this.toRType((NonNegativeInteger)samplesPerPixel));
    }

    public void setChannelAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        LSID key = new LSID(Channel.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(annotation));
    }

    private LightSettings getChannelLightSourceSettings(int imageIndex, int channelIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.CHANNEL_INDEX, channelIndex);
        return this.getSourceObject(LightSettings.class, indexes);
    }

    public void setChannelLightSourceSettingsID(String id, int imageIndex, int channelIndex) {
        this.getChannelLightSourceSettings(imageIndex, channelIndex);
        LSID key = new LSID(LightSettings.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(id));
    }

    public void setChannelLightSourceSettingsAttenuation(PercentFraction attenuation, int imageIndex, int channelIndex) {
        LightSettings o = this.getChannelLightSourceSettings(imageIndex, channelIndex);
        o.setAttenuation(this.toRType(attenuation));
    }

    public void setChannelLightSourceSettingsWavelength(Length wavelength, int imageIndex, int channelIndex) {
        LightSettings o = this.getChannelLightSourceSettings(imageIndex, channelIndex);
        o.setWavelength(UnitsFactory.convertLength(wavelength));
    }

    public void setDatasetID(String id, int datasetIndex) {
        this.ignoreUnsupported("setDatasetID", id, datasetIndex);
    }

    public void setDatasetAnnotationRef(String annotation, int datasetIndex, int annotationRefIndex) {
        this.ignoreUnsupported("setDatasetAnnotationRef", annotation, datasetIndex, annotationRefIndex);
    }

    public void setDatasetDescription(String description, int datasetIndex) {
        this.ignoreUnsupported("setDatasetDescription", description, datasetIndex);
    }

    public void setDatasetExperimenterRef(String experimenter, int datasetIndex) {
        this.ignoreUnsupported("setDatasetExperimenterRef", experimenter, datasetIndex);
    }

    public void setDatasetExperimenterGroupRef(String group, int datasetIndex) {
        this.ignoreUnsupported("setDatasetExperimenterGroupRef", group, datasetIndex);
    }

    public void setDatasetName(String name, int datasetIndex) {
        this.ignoreUnsupported("setDatasetName", name, datasetIndex);
    }

    public Detector getDetector(int instrumentIndex, int detectorIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.DETECTOR_INDEX, detectorIndex);
        return this.getSourceObject(Detector.class, indexes);
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        this.checkDuplicateLSID(Detector.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.DETECTOR_INDEX, detectorIndex);
        IObjectContainer o = this.getIObjectContainer(Detector.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Detector.class, id, o);
    }

    public void setDetectorAmplificationGain(Double amplificationGain, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setAmplificationGain(this.toRType(amplificationGain));
    }

    public void setDetectorGain(Double gain, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setGain(this.toRType(gain));
    }

    public void setDetectorLotNumber(String lotNumber, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setModel(this.toRType(model));
    }

    public void setDetectorOffset(Double offset, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setOffsetValue(this.toRType(offset));
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setDetectorType(DetectorType type, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setType((omero.model.DetectorType)this.getEnumeration(omero.model.DetectorType.class, type.toString()));
    }

    public void setDetectorVoltage(ElectricPotential voltage, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setVoltage(UnitsFactory.convertElectricPotential(voltage));
    }

    public void setDetectorZoom(Double zoom, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setZoom(this.toRType(zoom));
    }

    private DetectorSettings getDetectorSettings(int imageIndex, int channelIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.CHANNEL_INDEX, channelIndex);
        return this.getSourceObject(DetectorSettings.class, indexes);
    }

    public void setDetectorSettingsID(String id, int imageIndex, int channelIndex) {
        this.getDetectorSettings(imageIndex, channelIndex);
        LSID key = new LSID(DetectorSettings.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(id));
    }

    public void setDetectorSettingsBinning(Binning binning, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setBinning((omero.model.Binning)this.getEnumeration(omero.model.Binning.class, binning.toString()));
    }

    public void setDetectorSettingsGain(Double gain, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setGain(this.toRType(gain));
    }

    public void setDetectorSettingsIntegration(PositiveInteger integration, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setIntegration(this.toRType((NonNegativeInteger)integration));
    }

    public void setDetectorSettingsOffset(Double offset, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setOffsetValue(this.toRType(offset));
    }

    public void setDetectorSettingsReadOutRate(Frequency readOutRate, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setReadOutRate(UnitsFactory.convertFrequency(readOutRate));
    }

    public void setDetectorSettingsVoltage(ElectricPotential voltage, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setVoltage(UnitsFactory.convertElectricPotential(voltage));
    }

    public void setDetectorSettingsZoom(Double zoom, int imageIndex, int channelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, channelIndex);
        o.setZoom(this.toRType(zoom));
    }

    private Dichroic getDichroic(int instrumentIndex, int dichroicIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.DICHROIC_INDEX, dichroicIndex);
        return this.getSourceObject(Dichroic.class, indexes);
    }

    public void setDichroicID(String id, int instrumentIndex, int dichroicIndex) {
        this.checkDuplicateLSID(Dichroic.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.DICHROIC_INDEX, dichroicIndex);
        IObjectContainer o = this.getIObjectContainer(Dichroic.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Dichroic.class, id, o);
    }

    public void setDichroicLotNumber(String lotNumber, int instrumentIndex, int dichroicIndex) {
        Dichroic o = this.getDichroic(instrumentIndex, dichroicIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setDichroicManufacturer(String manufacturer, int instrumentIndex, int dichroicIndex) {
        Dichroic o = this.getDichroic(instrumentIndex, dichroicIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setDichroicModel(String model, int instrumentIndex, int dichroicIndex) {
        Dichroic o = this.getDichroic(instrumentIndex, dichroicIndex);
        o.setModel(this.toRType(model));
    }

    public void setDichroicSerialNumber(String serialNumber, int instrumentIndex, int dichroicIndex) {
        Dichroic o = this.getDichroic(instrumentIndex, dichroicIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    private DoubleAnnotation getDoubleAnnotation(int doubleAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.DOUBLE_ANNOTATION_INDEX, doubleAnnotationIndex);
        return this.getSourceObject(DoubleAnnotation.class, indexes);
    }

    public void setDoubleAnnotationID(String id, int doubleAnnotationIndex) {
        this.checkDuplicateLSID(DoubleAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.DOUBLE_ANNOTATION_INDEX, doubleAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(DoubleAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(DoubleAnnotation.class, id, o);
    }

    public void setDoubleAnnotationNamespace(String namespace, int doubleAnnotationIndex) {
        DoubleAnnotation o = this.getDoubleAnnotation(doubleAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setDoubleAnnotationValue(Double value, int doubleAnnotationIndex) {
        DoubleAnnotation o = this.getDoubleAnnotation(doubleAnnotationIndex);
        o.setDoubleValue(this.toRType(value));
    }

    private Ellipse getEllipse(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Ellipse.class, indexes);
    }

    public void setEllipseID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Ellipse.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Ellipse.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Ellipse.class, id, o);
    }

    public void setEllipseFillColor(Color fill, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setFillColor(this.toRType(fill));
    }

    public void setEllipseFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setFontSize(UnitsFactory.convertLength(fontSize));
    }

    public void setEllipseText(String text, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setTextValue(this.toRType(text));
    }

    public void setEllipseRadiusX(Double radiusX, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setRadiusX(this.toRType(radiusX));
    }

    public void setEllipseRadiusY(Double radiusY, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setRadiusY(this.toRType(radiusY));
    }

    public void setEllipseStrokeColor(Color stroke, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setStrokeColor(this.toRType(stroke));
    }

    public void setEllipseStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setEllipseStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setStrokeWidth(UnitsFactory.convertLength(strokeWidth));
    }

    public void setEllipseTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setEllipseTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setEllipseTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setEllipseTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setEllipseX(Double x, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setX(this.toRType(x));
    }

    public void setEllipseY(Double y, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setY(this.toRType(y));
    }

    private Experiment getExperiment(int experimentIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        return this.getSourceObject(Experiment.class, indexes);
    }

    public void setExperimentID(String id, int experimentIndex) {
        this.checkDuplicateLSID(Experiment.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        IObjectContainer o = this.getIObjectContainer(Experiment.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Experiment.class, id, o);
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        Experiment o = this.getExperiment(experimentIndex);
        o.setDescription(this.toRType(description));
    }

    public void setExperimentExperimenterRef(String experimenter, int experimentIndex) {
        this.ignoreInsecure("setExperimenterExperiemnterRef", experimenter, experimentIndex);
    }

    public void setExperimentType(ExperimentType type, int experimentIndex) {
        Experiment o = this.getExperiment(experimentIndex);
        o.setType((omero.model.ExperimentType)this.getEnumeration(omero.model.ExperimentType.class, type.toString()));
    }

    public void setExperimenterID(String id, int experimenterIndex) {
        this.ignoreUnsupported("setExperimenterID", id, experimenterIndex);
    }

    public void setExperimenterAnnotationRef(String annotation, int experimenterIndex, int annotationRefIndex) {
        this.ignoreUnsupported("setExperimenterAnnotationRef", annotation, experimenterIndex, annotationRefIndex);
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
        this.ignoreUnsupported("setExperimenterEmail", email, experimenterIndex);
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        this.ignoreUnsupported("setExperimenterFirstName", firstName, experimenterIndex);
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        this.ignoreUnsupported("setExperimenterInstitution", institution, experimenterIndex);
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        this.ignoreUnsupported("setExperimenterLastName", lastName, experimenterIndex);
    }

    public void setExperimenterMiddleName(String middleName, int experimenterIndex) {
        this.ignoreUnsupported("setExperimenterMiddleName", middleName, experimenterIndex);
    }

    public void setExperimenterUserName(String userName, int experimenterIndex) {
        this.ignoreUnsupported("setExperimenterUserName", userName, experimenterIndex);
    }

    public Filament getFilament(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        return this.getSourceObject(Filament.class, indexes);
    }

    public void setFilamentID(String id, int instrumentIndex, int lightSourceIndex) {
        this.checkDuplicateLSID(Filament.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(Filament.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Filament.class, id, o);
    }

    public void setFilamentLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setFilamentManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setFilamentModel(String model, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setFilamentPower(Power power, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setPower(UnitsFactory.convertPower(power));
    }

    public void setFilamentSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setFilamentType(ome.xml.model.enums.FilamentType type, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setType((FilamentType)this.getEnumeration(FilamentType.class, type.toString()));
    }

    private FileAnnotation getFileAnnotation(int fileAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.FILE_ANNOTATION_INDEX, fileAnnotationIndex);
        return this.getSourceObject(FileAnnotation.class, indexes);
    }

    public void setFileAnnotationID(String id, int fileAnnotationIndex) {
        this.checkDuplicateLSID(FileAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.FILE_ANNOTATION_INDEX, fileAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(FileAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(FileAnnotation.class, id, o);
    }

    public void setFileAnnotationNamespace(String namespace, int fileAnnotationIndex) {
        FileAnnotation o = this.getFileAnnotation(fileAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    private Filter getFilter(int instrumentIndex, int filterIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.FILTER_INDEX, filterIndex);
        return this.getSourceObject(Filter.class, indexes);
    }

    public void setFilterID(String id, int instrumentIndex, int filterIndex) {
        this.checkDuplicateLSID(Filter.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.FILTER_INDEX, filterIndex);
        IObjectContainer o = this.getIObjectContainer(Filter.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Filter.class, id, o);
    }

    public void setFilterFilterWheel(String filterWheel, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setFilterWheel(this.toRType(filterWheel));
    }

    public void setFilterLotNumber(String lotNumber, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setFilterManufacturer(String manufacturer, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setFilterModel(String model, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setModel(this.toRType(model));
    }

    public void setFilterSerialNumber(String serialNumber, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setFilterType(FilterType type, int instrumentIndex, int filterIndex) {
        Filter o = this.getFilter(instrumentIndex, filterIndex);
        o.setType((omero.model.FilterType)this.getEnumeration(omero.model.FilterType.class, type.toString()));
    }

    public FilterSet getFilterSet(int instrumentIndex, int filterSetIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.FILTER_SET_INDEX, filterSetIndex);
        return this.getSourceObject(FilterSet.class, indexes);
    }

    public void setFilterSetID(String id, int instrumentIndex, int filterSetIndex) {
        this.checkDuplicateLSID(FilterSet.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.FILTER_SET_INDEX, filterSetIndex);
        IObjectContainer o = this.getIObjectContainer(FilterSet.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(FilterSet.class, id, o);
    }

    public void setFilterSetDichroicRef(String dichroic, int instrumentIndex, int filterSetIndex) {
        LSID key = new LSID(FilterSet.class, new int[]{instrumentIndex, filterSetIndex});
        this.addReference(key, new LSID(dichroic));
    }

    public void setFilterSetEmissionFilterRef(String emissionFilter, int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        emissionFilter = emissionFilter + OMERO_EMISSION_FILTER_SUFFIX;
        LSID key = new LSID(FilterSet.class, new int[]{instrumentIndex, filterSetIndex});
        this.addReference(key, new LSID(emissionFilter));
    }

    public void setFilterSetExcitationFilterRef(String excitationFilter, int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        excitationFilter = excitationFilter + OMERO_EXCITATION_FILTER_SUFFIX;
        LSID key = new LSID(FilterSet.class, new int[]{instrumentIndex, filterSetIndex});
        this.addReference(key, new LSID(excitationFilter));
    }

    public void setFilterSetLotNumber(String lotNumber, int instrumentIndex, int filterSetIndex) {
        FilterSet o = this.getFilterSet(instrumentIndex, filterSetIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setFilterSetManufacturer(String manufacturer, int instrumentIndex, int filterSetIndex) {
        FilterSet o = this.getFilterSet(instrumentIndex, filterSetIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setFilterSetModel(String model, int instrumentIndex, int filterSetIndex) {
        FilterSet o = this.getFilterSet(instrumentIndex, filterSetIndex);
        o.setModel(this.toRType(model));
    }

    public void setFilterSetSerialNumber(String serialNumber, int instrumentIndex, int filterSetIndex) {
        FilterSet o = this.getFilterSet(instrumentIndex, filterSetIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    private GenericExcitationSource getGenericExcitationSource(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        return this.getSourceObject(GenericExcitationSource.class, indexes);
    }

    private Folder getFolder(int folderIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.FOLDER_INDEX, folderIndex);
        return this.getSourceObject(Folder.class, indexes);
    }

    public void setFolderAnnotationRef(String annotation, int folderIndex, int annotationRefIndex) {
        LSID key = new LSID(Folder.class, new int[]{folderIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setFolderDescription(String description, int folderIndex) {
        Folder folder = this.getFolder(folderIndex);
        folder.setDescription(this.toRType(description));
    }

    public void setFolderFolderRef(String folder, int folderIndex, int folderRefIndex) {
        LSID key = new LSID(Folder.class, new int[]{folderIndex});
        this.addReference(key, new LSID(folder));
    }

    public void setFolderID(String id, int folderIndex) {
        this.checkDuplicateLSID(Folder.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.FOLDER_INDEX, folderIndex);
        IObjectContainer newFolder = this.getIObjectContainer(Folder.class, indexes);
        newFolder.LSID = id;
        this.addAuthoritativeContainer(Folder.class, id, newFolder);
    }

    public void setFolderImageRef(String image, int folderIndex, int imageRefIndex) {
        LSID key = new LSID(Folder.class, new int[]{folderIndex});
        this.addReference(key, new LSID(image));
    }

    public void setFolderName(String name, int folderIndex) {
        Folder folder = this.getFolder(folderIndex);
        folder.setName(this.toRType(name));
    }

    public void setFolderROIRef(String roi, int folderIndex, int ROIRefIndex) {
        LSID key = new LSID(Folder.class, new int[]{folderIndex});
        this.addReference(key, new LSID(roi));
    }

    public void setGenericExcitationSourceID(String id, int instrumentIndex, int lightSourceIndex) {
        this.checkDuplicateLSID(GenericExcitationSource.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(GenericExcitationSource.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(GenericExcitationSource.class, id, o);
    }

    public void setGenericExcitationSourceLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = this.getGenericExcitationSource(instrumentIndex, lightSourceIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setGenericExcitationSourceMap(List<MapPair> map, int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = this.getGenericExcitationSource(instrumentIndex, lightSourceIndex);
        o.setMap(IceMapper.convertMapPairs(map));
    }

    public void setGenericExcitationSourceManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = this.getGenericExcitationSource(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setGenericExcitationSourceModel(String model, int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = this.getGenericExcitationSource(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setGenericExcitationSourcePower(Power power, int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = this.getGenericExcitationSource(instrumentIndex, lightSourceIndex);
        o.setPower(UnitsFactory.convertPower(power));
    }

    public void setGenericExcitationSourceSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = this.getGenericExcitationSource(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setExperimenterGroupID(String id, int groupIndex) {
        this.ignoreInsecure("setExperimenterGroupID", id, groupIndex);
    }

    public void setExperimenterGroupDescription(String description, int groupIndex) {
        this.ignoreInsecure("setExperimenterGroupDescription", description, groupIndex);
    }

    public void setExperimenterGroupLeader(String leader, int groupIndex, int leaderIndex) {
        this.ignoreInsecure("setExperimenterGroupLeader", leader, groupIndex, leaderIndex);
    }

    public void setExperimenterGroupName(String name, int groupIndex) {
        this.ignoreInsecure("setExperimenterGroupName", name, groupIndex);
    }

    private Image getImage(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        Image o = this.getSourceObject(Image.class, indexes);
        o.setFormat(this.getImageFormat());
        return o;
    }

    public void setImageID(String id, int imageIndex) {
        this.checkDuplicateLSID(Image.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        IObjectContainer o = this.getIObjectContainer(Image.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Image.class, id, o);
    }

    public void setImageAcquisitionDate(Timestamp acquiredDate, int imageIndex) {
        if (acquiredDate == null) {
            return;
        }
        Image o = this.getImage(imageIndex);
        o.setAcquisitionDate(this.toRType(acquiredDate));
    }

    public void setImageAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setImageDescription(String description, int imageIndex) {
        Image o = this.getImage(imageIndex);
        o.setDescription(this.toRType(description));
    }

    public void setImageExperimentRef(String experiment, int imageIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(experiment));
    }

    public void setImageExperimenterRef(String experimenter, int imageIndex) {
        this.ignoreInsecure("setImageExperimenterRef", experimenter, imageIndex);
    }

    public void setImageExperimenterGroupRef(String group, int imageIndex) {
        this.ignoreInsecure("setImageExperimenterGroupRef", group, imageIndex);
    }

    public void setImageInstrumentRef(String instrument, int imageIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(instrument));
    }

    public void setImageMicrobeamManipulationRef(String microbeamManipulation, int imageIndex, int microbeamManipulationRefIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(microbeamManipulation));
    }

    public void setImageName(String name, int imageIndex) {
        Image o = this.getImage(imageIndex);
        o.setName(this.toRType(name));
    }

    public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.addReference(key, new LSID(roi));
    }

    public ObjectiveSettings getObjectiveSettings(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        return this.getSourceObject(ObjectiveSettings.class, indexes);
    }

    public void setObjectiveSettingsID(String id, int imageIndex) {
        this.getObjectiveSettings(imageIndex);
        LSID key = new LSID(ObjectiveSettings.class, new int[]{imageIndex});
        this.addReference(key, new LSID(id));
    }

    public void setObjectiveSettingsCorrectionCollar(Double correctionCollar, int imageIndex) {
        ObjectiveSettings o = this.getObjectiveSettings(imageIndex);
        o.setCorrectionCollar(this.toRType(correctionCollar));
    }

    public void setObjectiveSettingsMedium(ome.xml.model.enums.Medium medium, int imageIndex) {
        ObjectiveSettings o = this.getObjectiveSettings(imageIndex);
        o.setMedium((Medium)this.getEnumeration(Medium.class, medium.toString()));
    }

    public void setObjectiveSettingsRefractiveIndex(Double refractiveIndex, int imageIndex) {
        ObjectiveSettings o = this.getObjectiveSettings(imageIndex);
        o.setRefractiveIndex(this.toRType(refractiveIndex));
    }

    public ImagingEnvironment getImagingEnvironment(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        return this.getSourceObject(ImagingEnvironment.class, indexes);
    }

    public void setImagingEnvironmentAirPressure(Pressure airPressure, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setAirPressure(UnitsFactory.convertPressure(airPressure));
    }

    public void setImagingEnvironmentCO2Percent(PercentFraction co2percent, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setCo2percent(this.toRType(co2percent));
    }

    public void setImagingEnvironmentHumidity(PercentFraction humidity, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setHumidity(this.toRType(humidity));
    }

    public void setImagingEnvironmentMap(List<MapPair> map, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setMap(IceMapper.convertMapPairs(map));
    }

    public void setImagingEnvironmentTemperature(Temperature temperature, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setTemperature(UnitsFactory.convertTemperature(temperature));
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        this.checkDuplicateLSID(Instrument.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        IObjectContainer o = this.getIObjectContainer(Instrument.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Instrument.class, id, o);
    }

    public Laser getLaser(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        return this.getSourceObject(Laser.class, indexes);
    }

    public void setLaserID(String id, int instrumentIndex, int lightSourceIndex) {
        this.checkDuplicateLSID(Laser.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(Laser.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Laser.class, id, o);
    }

    public void setLaserFrequencyMultiplication(PositiveInteger frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setFrequencyMultiplication(this.toRType((NonNegativeInteger)frequencyMultiplication));
    }

    public void setLaserLaserMedium(ome.xml.model.enums.LaserMedium laserMedium, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setLaserMedium((LaserMedium)this.getEnumeration(LaserMedium.class, laserMedium.toString()));
    }

    public void setLaserLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setLaserManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setLaserModel(String model, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setLaserPockelCell(Boolean pockelCell, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setPockelCell(this.toRType(pockelCell));
    }

    public void setLaserPower(Power power, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setPower(UnitsFactory.convertPower(power));
    }

    public void setLaserPulse(Pulse pulse, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setPulse((omero.model.Pulse)this.getEnumeration(omero.model.Pulse.class, pulse.toString()));
    }

    public void setLaserPump(String pump, int instrumentIndex, int lightSourceIndex) {
        LSID key = new LSID(Laser.class, new int[]{instrumentIndex, lightSourceIndex});
        this.addReference(key, new LSID(pump));
    }

    public void setLaserRepetitionRate(Frequency repetitionRate, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setRepetitionRate(UnitsFactory.convertFrequency(repetitionRate));
    }

    public void setLaserSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setTuneable(this.toRType(tuneable));
    }

    public void setLaserType(LaserType type, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setType((omero.model.LaserType)this.getEnumeration(omero.model.LaserType.class, type.toString()));
    }

    public void setLaserWavelength(Length wavelength, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setWavelength(UnitsFactory.convertLength(wavelength));
    }

    public LightEmittingDiode getLightEmittingDiode(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        return this.getSourceObject(LightEmittingDiode.class, indexes);
    }

    public void setLightEmittingDiodeID(String id, int instrumentIndex, int lightSourceIndex) {
        this.checkDuplicateLSID(LightEmittingDiode.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.LIGHT_SOURCE_INDEX, lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(LightEmittingDiode.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(LightEmittingDiode.class, id, o);
    }

    public void setLightEmittingDiodeLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = this.getLightEmittingDiode(instrumentIndex, lightSourceIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setLightEmittingDiodeManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = this.getLightEmittingDiode(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setLightEmittingDiodeModel(String model, int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = this.getLightEmittingDiode(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setLightEmittingDiodePower(Power power, int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = this.getLightEmittingDiode(instrumentIndex, lightSourceIndex);
        o.setPower(UnitsFactory.convertPower(power));
    }

    public void setLightEmittingDiodeSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = this.getLightEmittingDiode(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setLightPathDichroicRef(String dichroic, int imageIndex, int channelIndex) {
        LSID key = new LSID(LightPath.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(dichroic));
    }

    public void setLightPathEmissionFilterRef(String emissionFilter, int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        emissionFilter = emissionFilter + OMERO_EMISSION_FILTER_SUFFIX;
        LSID key = new LSID(LightPath.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(emissionFilter));
    }

    public void setLightPathExcitationFilterRef(String excitationFilter, int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        excitationFilter = excitationFilter + OMERO_EXCITATION_FILTER_SUFFIX;
        LSID key = new LSID(LightPath.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(excitationFilter));
    }

    public Line getLine(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Line.class, indexes);
    }

    public void setLineID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Line.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Line.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Line.class, id, o);
    }

    public void setLineText(String text, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setTextValue(this.toRType(text));
    }

    public void setLineFillColor(Color fill, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setFillColor(this.toRType(fill));
    }

    public void setLineFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setFontSize(UnitsFactory.convertLength(fontSize));
    }

    public void setLineStrokeColor(Color stroke, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setStrokeColor(this.toRType(stroke));
    }

    public void setLineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setLineStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setStrokeWidth(UnitsFactory.convertLength(strokeWidth));
    }

    public void setLineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setLineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setLineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setLineTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setLineX1(Double x1, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setX1(this.toRType(x1));
    }

    public void setLineX2(Double x2, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setX2(this.toRType(x2));
    }

    public void setLineY1(Double y1, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setY1(this.toRType(y1));
    }

    public void setLineY2(Double y2, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setY2(this.toRType(y2));
    }

    public ListAnnotation getListAnnotation(int listAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.LIST_ANNOTATION_INDEX, listAnnotationIndex);
        return this.getSourceObject(ListAnnotation.class, indexes);
    }

    public void setListAnnotationID(String id, int listAnnotationIndex) {
        this.checkDuplicateLSID(ListAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.LIST_ANNOTATION_INDEX, listAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(ListAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(ListAnnotation.class, id, o);
    }

    public void setListAnnotationAnnotationRef(String annotation, int listAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(ListAnnotation.class, new int[]{listAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setListAnnotationNamespace(String namespace, int listAnnotationIndex) {
        ListAnnotation o = this.getListAnnotation(listAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public LongAnnotation getLongAnnotation(int longAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.LONG_ANNOTATION_INDEX, longAnnotationIndex);
        return this.getSourceObject(LongAnnotation.class, indexes);
    }

    public void setLongAnnotationID(String id, int longAnnotationIndex) {
        this.checkDuplicateLSID(LongAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.LONG_ANNOTATION_INDEX, longAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(LongAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(LongAnnotation.class, id, o);
    }

    public void setLongAnnotationNamespace(String namespace, int longAnnotationIndex) {
        LongAnnotation o = this.getLongAnnotation(longAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setLongAnnotationValue(Long value, int longAnnotationIndex) {
        LongAnnotation o = this.getLongAnnotation(longAnnotationIndex);
        o.setLongValue(this.toRType(value));
    }

    public Mask getMask(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Mask.class, indexes);
    }

    public void setMaskBinData(byte[] binData, int roiIndex, int shapeIndex) {
        Mask o = this.getMask(roiIndex, shapeIndex);
        if (o != null) {
            o.setBytes(binData);
        }
    }

    public void setMaskBinDataBigEndian(Boolean isBigEndian, int roiIndex, int shapeIndex) {
        this.ignoreMissing("setMaskBinDataBigEndian", isBigEndian, roiIndex, shapeIndex);
    }

    public void setMaskBinDataCompression(Compression compression, int roiIndex, int shapeIndex) {
        this.ignoreMissing("setMaskBinDataCompression", compression, roiIndex, shapeIndex);
    }

    public void setMaskBinDataLength(NonNegativeLong length, int roiIndex, int shapeIndex) {
        this.ignoreMissing("setMaskBinDataLength", length, roiIndex, shapeIndex);
    }

    public void setMaskText(String description, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setTextValue(this.toRType(description));
    }

    public void setMaskFillColor(Color fill, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setFillColor(this.toRType(fill));
    }

    public void setMaskFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setFontSize(UnitsFactory.convertLength(fontSize));
    }

    public void setMaskID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Mask.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Mask.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Mask.class, id, o);
    }

    public void setMaskStrokeColor(Color stroke, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setStrokeColor(this.toRType(stroke));
    }

    public void setMaskStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setMaskStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setStrokeWidth(UnitsFactory.convertLength(strokeWidth));
    }

    public void setMaskTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setMaskTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setMaskTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setMaskTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setMaskX(Double x, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setX(this.toRType(x));
    }

    public void setMaskY(Double y, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setY(this.toRType(y));
    }

    public void setMaskHeight(Double height, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setHeight(this.toRType(height));
    }

    public void setMaskWidth(Double width, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setWidth(this.toRType(width));
    }

    public MicrobeamManipulation getMicrobeamManipulation(int experimentIndex, int microbeamManipulationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        indexes.put(Index.MICROBEAM_MANIPULATION_INDEX, microbeamManipulationIndex);
        return this.getSourceObject(MicrobeamManipulation.class, indexes);
    }

    public void setMicrobeamManipulationID(String id, int experimentIndex, int microbeamManipulationIndex) {
        this.checkDuplicateLSID(MicrobeamManipulation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        indexes.put(Index.MICROBEAM_MANIPULATION_INDEX, microbeamManipulationIndex);
        IObjectContainer o = this.getIObjectContainer(MicrobeamManipulation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(MicrobeamManipulation.class, id, o);
    }

    public void setMicrobeamManipulationDescription(String description, int experimentIndex, int microbeamManipulationIndex) {
        MicrobeamManipulation o = this.getMicrobeamManipulation(experimentIndex, microbeamManipulationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setMicrobeamManipulationExperimenterRef(String experimenter, int experimentIndex, int microbeamManipulationIndex) {
    }

    public void setMicrobeamManipulationROIRef(String roi, int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        LSID key = new LSID(MicrobeamManipulation.class, new int[]{experimentIndex, microbeamManipulationIndex});
        this.addReference(key, new LSID(roi));
    }

    public void setMicrobeamManipulationType(ome.xml.model.enums.MicrobeamManipulationType type, int experimentIndex, int microbeamManipulationIndex) {
        MicrobeamManipulation o = this.getMicrobeamManipulation(experimentIndex, microbeamManipulationIndex);
        o.setType((MicrobeamManipulationType)this.getEnumeration(MicrobeamManipulationType.class, type.toString()));
    }

    public LightSettings getMicrobeamManipulationLightSourceSettings(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.EXPERIMENT_INDEX, experimentIndex);
        indexes.put(Index.MICROBEAM_MANIPULATION_INDEX, microbeamManipulationIndex);
        indexes.put(Index.LIGHT_SOURCE_SETTINGS_INDEX, lightSourceSettingsIndex);
        return this.getSourceObject(LightSettings.class, indexes);
    }

    public void setMicrobeamManipulationLightSourceSettingsID(String id, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        this.getMicrobeamManipulationLightSourceSettings(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
        LSID key = new LSID(LightSettings.class, new int[]{experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex});
        this.addReference(key, new LSID(id));
    }

    public void setMicrobeamManipulationLightSourceSettingsAttenuation(PercentFraction attenuation, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        LightSettings o = this.getMicrobeamManipulationLightSourceSettings(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
        o.setAttenuation(this.toRType(attenuation));
    }

    public void setMicrobeamManipulationLightSourceSettingsWavelength(Length wavelength, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        LightSettings o = this.getMicrobeamManipulationLightSourceSettings(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
        o.setWavelength(UnitsFactory.convertLength(wavelength));
    }

    private Microscope getMicroscope(int instrumentIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        return this.getSourceObject(Microscope.class, indexes);
    }

    public void setMicroscopeLotNumber(String lotNumber, int instrumentIndex) {
        Microscope o = this.getMicroscope(instrumentIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setMicroscopeManufacturer(String manufacturer, int instrumentIndex) {
        Microscope o = this.getMicroscope(instrumentIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setMicroscopeModel(String model, int instrumentIndex) {
        Microscope o = this.getMicroscope(instrumentIndex);
        o.setModel(this.toRType(model));
    }

    public void setMicroscopeSerialNumber(String serialNumber, int instrumentIndex) {
        Microscope o = this.getMicroscope(instrumentIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setMicroscopeType(MicroscopeType type, int instrumentIndex) {
        Microscope o = this.getMicroscope(instrumentIndex);
        o.setType((omero.model.MicroscopeType)this.getEnumeration(omero.model.MicroscopeType.class, type.toString()));
    }

    public Objective getObjective(int instrumentIndex, int objectiveIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.OBJECTIVE_INDEX, objectiveIndex);
        return this.getSourceObject(Objective.class, indexes);
    }

    public void setObjectiveCalibratedMagnification(Double calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setCalibratedMagnification(this.toRType(calibratedMagnification));
    }

    public void setObjectiveCorrection(Correction correction, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setCorrection((omero.model.Correction)this.getEnumeration(omero.model.Correction.class, correction.toString()));
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        this.checkDuplicateLSID(Objective.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
        indexes.put(Index.OBJECTIVE_INDEX, objectiveIndex);
        IObjectContainer o = this.getIObjectContainer(Objective.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Objective.class, id, o);
    }

    public void setObjectiveImmersion(ome.xml.model.enums.Immersion immersion, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setImmersion((Immersion)this.getEnumeration(Immersion.class, immersion.toString()));
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setIris(this.toRType(iris));
    }

    public void setObjectiveLensNA(Double lensNA, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setLensNA(this.toRType(lensNA));
    }

    public void setObjectiveLotNumber(String lotNumber, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setLotNumber(this.toRType(lotNumber));
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setModel(this.toRType(model));
    }

    public void setObjectiveNominalMagnification(Double nominalMagnification, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setNominalMagnification(this.toRType(nominalMagnification));
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setObjectiveWorkingDistance(Length workingDistance, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setWorkingDistance(UnitsFactory.convertLength(workingDistance));
    }

    private Pixels getPixels(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        Pixels p = this.getSourceObject(Pixels.class, indexes);
        p.setSha1(rtypes.rstring("Pending..."));
        return p;
    }

    public void setPixelsID(String id, int imageIndex) {
        this.checkDuplicateLSID(Pixels.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        IObjectContainer o = this.getIObjectContainer(Pixels.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Pixels.class, id, o);
    }

    public void setPixelsBigEndian(Boolean value, int index) {
        this.ignoreUnneeded("setPixelsBigEndian", value, index);
    }

    public void setPixelsBinData(byte[] binData, int imageIndex, int binDataIndex) {
        this.ignoreMissing("setPixelsBinData", imageIndex, binDataIndex);
    }

    public void setPixelsBinDataBigEndian(Boolean bigEndian, int imageIndex, int binDataIndex) {
        this.ignoreUnneeded("setPixelsBinDataBigEndian", bigEndian, imageIndex);
    }

    public void setPixelsBinDataCompression(Compression compression, int imageIndex, int binDataIndex) {
        this.ignoreMissing("setPixelsBinDataCompression", compression, imageIndex, binDataIndex);
    }

    public void setPixelsBinDataLength(NonNegativeLong length, int imageIndex, int binDataIndex) {
        this.ignoreMissing("setPixelsBinDataLength", length, imageIndex, binDataIndex);
    }

    public void setPixelsDimensionOrder(DimensionOrder dimensionOrder, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setDimensionOrder((omero.model.DimensionOrder)this.getEnumeration(omero.model.DimensionOrder.class, "XYZCT"));
    }

    public void setPixelsInterleaved(Boolean value, int index) {
        this.ignoreUnneeded("setPixelsInterleaved", value, index);
    }

    public void setPixelsPhysicalSizeX(Length physicalSizeX, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setPhysicalSizeX(UnitsFactory.convertLength(physicalSizeX));
    }

    public void setPixelsPhysicalSizeY(Length physicalSizeY, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setPhysicalSizeY(UnitsFactory.convertLength(physicalSizeY));
    }

    public void setPixelsPhysicalSizeZ(Length physicalSizeZ, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setPhysicalSizeZ(UnitsFactory.convertLength(physicalSizeZ));
    }

    public void setPixelsSignificantBits(PositiveInteger value, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSignificantBits(this.toRType((NonNegativeInteger)value));
    }

    public void setPixelsSizeC(PositiveInteger sizeC, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeC(this.toRType((NonNegativeInteger)sizeC));
    }

    public void setPixelsSizeT(PositiveInteger sizeT, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeT(this.toRType((NonNegativeInteger)sizeT));
    }

    public void setPixelsSizeX(PositiveInteger sizeX, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeX(this.toRType((NonNegativeInteger)sizeX));
    }

    public void setPixelsSizeY(PositiveInteger sizeY, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeY(this.toRType((NonNegativeInteger)sizeY));
    }

    public void setPixelsSizeZ(PositiveInteger sizeZ, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setSizeZ(this.toRType((NonNegativeInteger)sizeZ));
    }

    public void setPixelsTimeIncrement(Time timeIncrement, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setTimeIncrement(this.toRType(timeIncrement));
    }

    public void setPixelsType(PixelType type, int imageIndex) {
        Pixels o = this.getPixels(imageIndex);
        o.setPixelsType((PixelsType)this.getEnumeration(PixelsType.class, type.toString()));
    }

    private PlaneInfo getPlane(int imageIndex, int planeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        indexes.put(Index.PLANE_INDEX, planeIndex);
        return this.getSourceObject(PlaneInfo.class, indexes);
    }

    public void setPlaneAnnotationRef(String annotation, int imageIndex, int planeIndex, int annotationRefIndex) {
        LSID key = new LSID(PlaneInfo.class, new int[]{imageIndex, planeIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPlaneDeltaT(Time deltaT, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setDeltaT(UnitsFactory.convertTime(deltaT));
    }

    public void setPlaneExposureTime(Time exposureTime, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setExposureTime(UnitsFactory.convertTime(exposureTime));
    }

    public void setPlaneHashSHA1(String hashSHA1, int imageIndex, int planeIndex) {
        this.ignoreUnneeded("setPlaneHashSHA1", hashSHA1, imageIndex, planeIndex);
    }

    public void setPlanePositionX(Length positionX, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setPositionX(UnitsFactory.convertLength(positionX));
    }

    public void setPlanePositionY(Length positionY, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setPositionY(UnitsFactory.convertLength(positionY));
    }

    public void setPlanePositionZ(Length positionZ, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setPositionZ(UnitsFactory.convertLength(positionZ));
    }

    public void setPlaneTheC(NonNegativeInteger theC, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setPlaneTheT(NonNegativeInteger theT, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setPlaneTheZ(NonNegativeInteger theZ, int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    private PlateAcquisition getPlateAcquisition(int plateIndex, int plateAcquisitionIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.PLATE_ACQUISITION_INDEX, plateAcquisitionIndex);
        return this.getSourceObject(PlateAcquisition.class, indexes);
    }

    public void setPlateAcquisitionAnnotationRef(String annotation, int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        LSID key = new LSID(PlateAcquisition.class, new int[]{plateIndex, plateAcquisitionIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPlateAcquisitionDescription(String description, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setDescription(this.toRType(description));
    }

    public void setPlateAcquisitionEndTime(Timestamp endTime, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setEndTime(this.toRType(endTime));
    }

    public void setPlateAcquisitionID(String id, int plateIndex, int plateAcquisitionIndex) {
        this.checkDuplicateLSID(PlateAcquisition.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.PLATE_ACQUISITION_INDEX, plateAcquisitionIndex);
        IObjectContainer o = this.getIObjectContainer(PlateAcquisition.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(PlateAcquisition.class, id, o);
    }

    public void setPlateAcquisitionMaximumFieldCount(PositiveInteger maximumFieldCount, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setMaximumFieldCount(this.toRType((NonNegativeInteger)maximumFieldCount));
    }

    public void setPlateAcquisitionName(String name, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setName(this.toRType(name));
    }

    public void setPlateAcquisitionStartTime(Timestamp startTime, int plateIndex, int plateAcquisitionIndex) {
        PlateAcquisition o = this.getPlateAcquisition(plateIndex, plateAcquisitionIndex);
        o.setStartTime(this.toRType(startTime));
    }

    public void setPlateAcquisitionWellSampleRef(String wellSample, int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        LSID key = new LSID(PlateAcquisition.class, new int[]{plateIndex, plateAcquisitionIndex});
        this.addReference(key, new LSID(wellSample));
    }

    private Plate getPlate(int plateIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        return this.getSourceObject(Plate.class, indexes);
    }

    public void setPlateAnnotationRef(String annotation, int plateIndex, int annotationRefIndex) {
        LSID key = new LSID(Plate.class, new int[]{plateIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPlateColumnNamingConvention(NamingConvention columnNamingConvention, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setColumnNamingConvention(this.toRType(columnNamingConvention));
    }

    public void setPlateColumns(PositiveInteger columns, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setColumns(this.toRType((NonNegativeInteger)columns));
    }

    public void setPlateDescription(String description, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setDescription(this.toRType(description));
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setExternalIdentifier(this.toRType(externalIdentifier));
    }

    public void setPlateID(String id, int plateIndex) {
        this.checkDuplicateLSID(Plate.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        IObjectContainer o = this.getIObjectContainer(Plate.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Plate.class, id, o);
    }

    public void setPlateName(String name, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setName(this.toRType(name));
    }

    public void setPlateRowNamingConvention(NamingConvention rowNamingConvention, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setRowNamingConvention(this.toRType(rowNamingConvention));
    }

    public void setPlateRows(PositiveInteger rows, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setRows(this.toRType((NonNegativeInteger)rows));
    }

    public void setPlateStatus(String status, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setStatus(this.toRType(status));
    }

    public void setPlateWellOriginX(Length wellOriginX, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setWellOriginX(UnitsFactory.convertLength(wellOriginX));
    }

    public void setPlateWellOriginY(Length wellOriginY, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setWellOriginY(UnitsFactory.convertLength(wellOriginY));
    }

    private Point getPoint(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Point.class, indexes);
    }

    public void setPointText(String text, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setTextValue(this.toRType(text));
    }

    public void setPointFillColor(Color fill, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setFillColor(this.toRType(fill));
    }

    public void setPointFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setFontSize(UnitsFactory.convertLength(fontSize));
    }

    public void setPointID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Point.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Point.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Point.class, id, o);
    }

    public void setPointStrokeColor(Color stroke, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setStrokeColor(this.toRType(stroke));
    }

    public void setPointStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setPointStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setStrokeWidth(UnitsFactory.convertLength(strokeWidth));
    }

    public void setPointTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setPointTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setPointTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setPointTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setPointX(Double x, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setX(this.toRType(x));
    }

    public void setPointY(Double y, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setY(this.toRType(y));
    }

    private Polyline getPolyline(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Polyline.class, indexes);
    }

    public void setPolylineID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Polyline.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Polyline.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Polyline.class, id, o);
    }

    public void setPolylineText(String text, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setTextValue(this.toRType(text));
    }

    public void setPolylineFillColor(Color fill, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setFillColor(this.toRType(fill));
    }

    public void setPolylineFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setFontSize(UnitsFactory.convertLength(fontSize));
    }

    public void setPolylinePoints(String points, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setPoints(this.toRType(points));
    }

    public void setPolylineStrokeColor(Color stroke, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setStrokeColor(this.toRType(stroke));
    }

    public void setPolylineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setPolylineStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setStrokeWidth(UnitsFactory.convertLength(strokeWidth));
    }

    public void setPolylineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setPolylineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setPolylineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setPolylineTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setProjectID(String id, int projectIndex) {
        this.ignoreUnsupported("setProjectID", id, projectIndex);
    }

    public void setProjectAnnotationRef(String annotation, int projectIndex, int annotationRefIndex) {
        this.ignoreUnsupported("setProjectAnnotationRef", annotation, projectIndex, annotationRefIndex);
    }

    public void setProjectDescription(String description, int projectIndex) {
        this.ignoreUnsupported("setProjectDescription", description, projectIndex);
    }

    public void setProjectExperimenterRef(String experimenter, int projectIndex) {
        this.ignoreInsecure("setProjectExperimenterRef", experimenter, projectIndex);
    }

    public void setProjectExperimenterGroupRef(String group, int projectIndex) {
        this.ignoreInsecure("setProjectExperimenterGroupRef", group, projectIndex);
    }

    public void setProjectName(String name, int projectIndex) {
        this.ignoreInsecure("setProjectName", name, projectIndex);
    }

    private Roi getROI(int ROIIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        return this.getSourceObject(Roi.class, indexes);
    }

    public void setROIID(String id, int ROIIndex) {
        this.checkDuplicateLSID(Roi.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        IObjectContainer o = this.getIObjectContainer(Roi.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Roi.class, id, o);
    }

    public void setROIAnnotationRef(String annotation, int ROIIndex, int annotationRefIndex) {
        LSID key = new LSID(Roi.class, new int[]{ROIIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setROIDescription(String description, int ROIIndex) {
        Roi o = this.getROI(ROIIndex);
        o.setDescription(this.toRType(description));
    }

    public void setROIName(String name, int ROIIndex) {
        Roi o = this.getROI(ROIIndex);
        o.setName(this.toRType(name));
    }

    private Reagent getReagent(int screenIndex, int reagentIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.SCREEN_INDEX, screenIndex);
        indexes.put(Index.REAGENT_INDEX, reagentIndex);
        return this.getSourceObject(Reagent.class, indexes);
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        this.checkDuplicateLSID(Reagent.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.SCREEN_INDEX, screenIndex);
        indexes.put(Index.REAGENT_INDEX, reagentIndex);
        IObjectContainer o = this.getIObjectContainer(Reagent.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Reagent.class, id, o);
    }

    public void setReagentAnnotationRef(String annotation, int screenIndex, int reagentIndex, int annotationRefIndex) {
        LSID key = new LSID(Reagent.class, new int[]{screenIndex, reagentIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        Reagent o = this.getReagent(screenIndex, reagentIndex);
        o.setDescription(this.toRType(description));
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        Reagent o = this.getReagent(screenIndex, reagentIndex);
        o.setName(this.toRType(name));
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        Reagent o = this.getReagent(screenIndex, reagentIndex);
        o.setReagentIdentifier(this.toRType(reagentIdentifier));
    }

    private Rectangle getRectangle(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Rectangle.class, indexes);
    }

    public void setRectangleID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Rectangle.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Rectangle.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Rectangle.class, id, o);
    }

    public void setRectangleText(String description, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setTextValue(this.toRType(description));
    }

    public void setRectangleFillColor(Color fill, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setFillColor(this.toRType(fill));
    }

    public void setRectangleFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setFontSize(UnitsFactory.convertLength(fontSize));
    }

    public void setRectangleHeight(Double height, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setHeight(this.toRType(height));
    }

    public void setRectangleStrokeColor(Color stroke, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setStrokeColor(this.toRType(stroke));
    }

    public void setRectangleStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setRectangleStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setStrokeWidth(UnitsFactory.convertLength(strokeWidth));
    }

    public void setRectangleTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setRectangleTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setRectangleTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setRectangleTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setRectangleWidth(Double width, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setWidth(this.toRType(width));
    }

    public void setRectangleX(Double x, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setX(this.toRType(x));
    }

    public void setRectangleY(Double y, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setY(this.toRType(y));
    }

    public void setRoot(MetadataRoot root) {
        this.ignoreUnneeded("setRoot", root);
    }

    private Screen getScreen(int screenIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.SCREEN_INDEX, screenIndex);
        return this.getSourceObject(Screen.class, indexes);
    }

    public void setScreenID(String id, int screenIndex) {
        this.checkDuplicateLSID(Screen.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.SCREEN_INDEX, screenIndex);
        IObjectContainer o = this.getIObjectContainer(Screen.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Screen.class, id, o);
    }

    public void setScreenAnnotationRef(String annotation, int screenIndex, int annotationRefIndex) {
        LSID key = new LSID(Screen.class, new int[]{screenIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setScreenDescription(String description, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setDescription(this.toRType(description));
    }

    public void setScreenName(String name, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setName(this.toRType(name));
    }

    public void setScreenPlateRef(String plate, int screenIndex, int plateRefIndex) {
        this.screenKey = new LSID(Screen.class, new int[]{screenIndex});
        this.addReference(this.screenKey, new LSID(plate));
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setProtocolDescription(this.toRType(protocolDescription));
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setProtocolIdentifier(this.toRType(protocolIdentifier));
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setReagentSetDescription(this.toRType(reagentSetDescription));
    }

    public void setScreenReagentSetIdentifier(String reagentSetIdentifier, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setReagentSetIdentifier(this.toRType(reagentSetIdentifier));
    }

    public void setScreenType(String type, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setType(this.toRType(type));
    }

    private StageLabel getStageLabel(int imageIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.IMAGE_INDEX, imageIndex);
        return this.getSourceObject(StageLabel.class, indexes);
    }

    public void setStageLabelName(String name, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setName(this.toRType(name));
    }

    public void setStageLabelX(Length x, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setPositionX(UnitsFactory.convertLength(x));
    }

    public void setStageLabelY(Length y, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setPositionY(UnitsFactory.convertLength(y));
    }

    public void setStageLabelZ(Length z, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setPositionZ(UnitsFactory.convertLength(z));
    }

    private CommentAnnotation getCommentAnnotation(int commentAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.COMMENT_ANNOTATION_INDEX, commentAnnotationIndex);
        return this.getSourceObject(CommentAnnotation.class, indexes);
    }

    public void setCommentAnnotationID(String id, int commentAnnotationIndex) {
        this.checkDuplicateLSID(CommentAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.COMMENT_ANNOTATION_INDEX, commentAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(CommentAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(CommentAnnotation.class, id, o);
    }

    public void setCommentAnnotationNamespace(String namespace, int commentAnnotationIndex) {
        CommentAnnotation o = this.getCommentAnnotation(commentAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setCommentAnnotationAnnotator(String value, int index) {
        this.ignoreAnnotator("setCommentAnnotationAnnotator", value, index);
    }

    public void setCommentAnnotationValue(String value, int commentAnnotationIndex) {
        CommentAnnotation o = this.getCommentAnnotation(commentAnnotationIndex);
        o.setTextValue(this.toRType(value));
    }

    private Label getLabel(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Label.class, indexes);
    }

    public void setLabelID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Label.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Label.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Label.class, id, o);
    }

    public void setLabelText(String text, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setTextValue(this.toRType(text));
    }

    public void setLabelFillColor(Color fill, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setFillColor(this.toRType(fill));
    }

    public void setLabelFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setFontSize(UnitsFactory.convertLength(fontSize));
    }

    public void setLabelStrokeColor(Color stroke, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setStrokeColor(this.toRType(stroke));
    }

    public void setLabelStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setLabelStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setStrokeWidth(UnitsFactory.convertLength(strokeWidth));
    }

    public void setLabelTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setLabelTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setLabelTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setLabelTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setLabelX(Double x, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setX(this.toRType(x));
    }

    public void setLabelY(Double y, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setY(this.toRType(y));
    }

    public void setTiffDataFirstC(NonNegativeInteger firstC, int imageIndex, int tiffDataIndex) {
        this.ignoreUnneeded("setTiffDataFirstC", firstC, imageIndex, tiffDataIndex);
    }

    public void setTiffDataFirstT(NonNegativeInteger firstT, int imageIndex, int tiffDataIndex) {
        this.ignoreUnneeded("setTiffDataFirstT", firstT, imageIndex, tiffDataIndex);
    }

    public void setTiffDataFirstZ(NonNegativeInteger firstZ, int imageIndex, int tiffDataIndex) {
        this.ignoreUnneeded("setTiffDataFirstZ", firstZ, imageIndex, tiffDataIndex);
    }

    public void setTiffDataIFD(NonNegativeInteger ifd, int imageIndex, int tiffDataIndex) {
        this.ignoreUnneeded("setTiffDataIFD", ifd, imageIndex, tiffDataIndex);
    }

    public void setTiffDataPlaneCount(NonNegativeInteger planeCount, int imageIndex, int tiffDataIndex) {
        this.ignoreUnneeded("setTiffDataPlaneCount", planeCount, imageIndex, tiffDataIndex);
    }

    private TimestampAnnotation getTimestampAnnotation(int timestampAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TIMESTAMP_ANNOTATION_INDEX, timestampAnnotationIndex);
        return this.getSourceObject(TimestampAnnotation.class, indexes);
    }

    public void setTimestampAnnotationID(String id, int timestampAnnotationIndex) {
        this.checkDuplicateLSID(TimestampAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TIMESTAMP_ANNOTATION_INDEX, timestampAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(TimestampAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(TimestampAnnotation.class, id, o);
    }

    public void setTimestampAnnotationNamespace(String namespace, int timestampAnnotationIndex) {
        TimestampAnnotation o = this.getTimestampAnnotation(timestampAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setTimestampAnnotationValue(Timestamp value, int timestampAnnotationIndex) {
        TimestampAnnotation o = this.getTimestampAnnotation(timestampAnnotationIndex);
        o.setTimeValue(this.toRType(value));
    }

    private TransmittanceRange getTransmittanceRange(int instrumentIndex, int filterIndex) {
        Filter filter = this.getFilter(instrumentIndex, filterIndex);
        TransmittanceRange tm = filter.getTransmittanceRange();
        if (tm == null) {
            tm = new TransmittanceRangeI();
            filter.setTransmittanceRange(tm);
        }
        return tm;
    }

    public void setTransmittanceRangeCutIn(Length cutIn, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setCutIn(UnitsFactory.convertLength(cutIn));
    }

    public void setTransmittanceRangeCutInTolerance(Length cutInTolerance, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setCutInTolerance(UnitsFactory.convertLength(cutInTolerance));
    }

    public void setTransmittanceRangeCutOut(Length cutOut, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setCutOut(UnitsFactory.convertLength(cutOut));
    }

    public void setTransmittanceRangeCutOutTolerance(Length cutOutTolerance, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setCutOutTolerance(UnitsFactory.convertLength(cutOutTolerance));
    }

    public void setTransmittanceRangeTransmittance(PercentFraction transmittance, int instrumentIndex, int filterIndex) {
        TransmittanceRange o = this.getTransmittanceRange(instrumentIndex, filterIndex);
        o.setTransmittance(this.toRType(transmittance));
    }

    public void setUUID(String uuid) {
        this.ignoreUnneeded("setUUID", uuid);
    }

    public void setUUIDFileName(String fileName, int imageIndex, int tiffDataIndex) {
        this.ignoreUnneeded("setUUIDFileName", fileName, imageIndex, tiffDataIndex);
    }

    public void setUUIDValue(String fileName, int imageIndex, int tiffDataIndex) {
        this.ignoreUnneeded("setUUIDValue", fileName, imageIndex, tiffDataIndex);
    }

    private Well getWell(int plateIndex, int wellIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.WELL_INDEX, wellIndex);
        return this.getSourceObject(Well.class, indexes);
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        this.checkDuplicateLSID(Well.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.WELL_INDEX, wellIndex);
        IObjectContainer o = this.getIObjectContainer(Well.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Well.class, id, o);
    }

    public void setWellAnnotationRef(String annotation, int plateIndex, int wellIndex, int annotationRefIndex) {
        LSID key = new LSID(Well.class, new int[]{plateIndex, wellIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setWellColor(Color color, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setRed(this.toRType(color.getRed()));
        o.setGreen(this.toRType(color.getGreen()));
        o.setBlue(this.toRType(color.getBlue()));
        o.setAlpha(this.toRType(color.getAlpha()));
    }

    public void setWellColumn(NonNegativeInteger column, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setColumn(this.toRType(column));
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setExternalDescription(this.toRType(externalDescription));
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setExternalIdentifier(this.toRType(externalIdentifier));
    }

    public void setWellReagentRef(String reagent, int plateIndex, int wellIndex) {
        LSID key = new LSID(Well.class, new int[]{plateIndex, wellIndex});
        this.addReference(key, new LSID(reagent));
    }

    public void setWellRow(NonNegativeInteger row, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setRow(this.toRType(row));
    }

    private WellSample getWellSample(int plateIndex, int wellIndex, int wellSampleIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.WELL_INDEX, wellIndex);
        indexes.put(Index.WELL_SAMPLE_INDEX, wellSampleIndex);
        WellSample ws = this.getSourceObject(WellSample.class, indexes);
        return ws;
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.checkDuplicateLSID(WellSample.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        indexes.put(Index.WELL_INDEX, wellIndex);
        indexes.put(Index.WELL_SAMPLE_INDEX, wellSampleIndex);
        IObjectContainer o = this.getIObjectContainer(WellSample.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(WellSample.class, id, o);
    }

    public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex) {
        LSID key = new LSID(WellSample.class, new int[]{plateIndex, wellIndex, wellSampleIndex});
        this.addReference(key, new LSID(image));
    }

    public void setWellSampleIndex(NonNegativeInteger index, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.ignoreMissing("setWellSampleIndex", index, plateIndex, wellIndex, wellSampleIndex);
    }

    public void setWellSamplePositionX(Length positionX, int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSample o = this.getWellSample(plateIndex, wellIndex, wellSampleIndex);
        o.setPosX(UnitsFactory.convertLength(positionX));
    }

    public void setWellSamplePositionY(Length positionY, int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSample o = this.getWellSample(plateIndex, wellIndex, wellSampleIndex);
        o.setPosY(UnitsFactory.convertLength(positionY));
    }

    public void setWellSampleTimepoint(Timestamp timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        if (timepoint == null) {
            return;
        }
        WellSample o = this.getWellSample(plateIndex, wellIndex, wellSampleIndex);
        o.setTimepoint(this.toRType(timepoint));
    }

    private XmlAnnotation getXMLAnnotation(int XMLAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.XML_ANNOTATION_INDEX, XMLAnnotationIndex);
        return this.getSourceObject(XmlAnnotation.class, indexes);
    }

    public void setXMLAnnotationID(String id, int XMLAnnotationIndex) {
        this.checkDuplicateLSID(XmlAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.XML_ANNOTATION_INDEX, XMLAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(XmlAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(XmlAnnotation.class, id, o);
    }

    public void setXMLAnnotationNamespace(String namespace, int XMLAnnotationIndex) {
        XmlAnnotation o = this.getXMLAnnotation(XMLAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setXMLAnnotationValue(String value, int XMLAnnotationIndex) {
        XmlAnnotation o = this.getXMLAnnotation(XMLAnnotationIndex);
        o.setTextValue(this.toRType(value));
    }

    public void setXMLAnnotationAnnotator(String value, int index) {
        this.ignoreAnnotator("setXMLAnnotationAnnotator", value, index);
    }

    public void setXMLAnnotationAnnotationRef(String annotation, int XMLAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(XmlAnnotation.class, new int[]{XMLAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setXMLAnnotationDescription(String description, int XMLAnnotationIndex) {
        XmlAnnotation o = this.getXMLAnnotation(XMLAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setBooleanAnnotationAnnotationRef(String annotation, int booleanAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(BooleanAnnotation.class, new int[]{booleanAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setBooleanAnnotationDescription(String description, int booleanAnnotationIndex) {
        BooleanAnnotation o = this.getBooleanAnnotation(booleanAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setBooleanAnnotationAnnotator(String value, int index) {
        this.ignoreAnnotator("setBooleanAnnotationAnnotator", value, index);
    }

    public void setCommentAnnotationAnnotationRef(String annotation, int commentAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(CommentAnnotation.class, new int[]{commentAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setCommentAnnotationDescription(String description, int commentAnnotationIndex) {
        CommentAnnotation o = this.getCommentAnnotation(commentAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setDoubleAnnotationAnnotationRef(String annotation, int doubleAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(DoubleAnnotation.class, new int[]{doubleAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setDoubleAnnotationDescription(String description, int doubleAnnotationIndex) {
        DoubleAnnotation o = this.getDoubleAnnotation(doubleAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setDoubleAnnotationAnnotator(String value, int index) {
        this.ignoreAnnotator("setDoubleAnnotationAnnotator", value, index);
    }

    public void setFileAnnotationAnnotationRef(String annotation, int fileAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(FileAnnotation.class, new int[]{fileAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setFileAnnotationDescription(String description, int fileAnnotationIndex) {
        FileAnnotation o = this.getFileAnnotation(fileAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setFileAnnotationAnnotator(String value, int index) {
        this.ignoreAnnotator("setFileAnnotationAnnotator", value, index);
    }

    public void setListAnnotationDescription(String description, int listAnnotationIndex) {
        ListAnnotation o = this.getListAnnotation(listAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setListAnnotationAnnotator(String value, int index) {
        this.ignoreAnnotator("setListAnnotationAnnotator", value, index);
    }

    public void setLongAnnotationAnnotationRef(String annotation, int longAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(LongAnnotation.class, new int[]{longAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setLongAnnotationDescription(String description, int longAnnotationIndex) {
        LongAnnotation o = this.getLongAnnotation(longAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setLongAnnotationAnnotator(String value, int XMLAnnotationIndex) {
        this.ignoreAnnotator("setLongAnnotationAnnotator", value, XMLAnnotationIndex);
    }

    private MapAnnotation getMapAnnotation(int mapAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>(1);
        indexes.put(Index.MAP_ANNOTATION_INDEX, mapAnnotationIndex);
        return this.getSourceObject(MapAnnotation.class, indexes);
    }

    public void setMapAnnotationAnnotationRef(String annotation, int mapAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(MapAnnotation.class, new int[]{mapAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setMapAnnotationAnnotator(String annotator, int mapAnnotationIndex) {
        this.ignoreAnnotator("setMapAnnotationAnnotator", annotator, mapAnnotationIndex);
    }

    public void setMapAnnotationDescription(String description, int mapAnnotationIndex) {
        MapAnnotation o = this.getMapAnnotation(mapAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setMapAnnotationID(String id, int mapAnnotationIndex) {
        this.checkDuplicateLSID(MapAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>(1);
        indexes.put(Index.MAP_ANNOTATION_INDEX, mapAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(MapAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(MapAnnotation.class, id, o);
    }

    public void setMapAnnotationNamespace(String namespace, int mapAnnotationIndex) {
        MapAnnotation o = this.getMapAnnotation(mapAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setMapAnnotationValue(List<MapPair> value, int mapAnnotationIndex) {
        MapAnnotation o = this.getMapAnnotation(mapAnnotationIndex);
        o.setMapValue(IceMapper.convertMapPairs(value));
    }

    private TagAnnotation getTagAnnotation(int tagAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TAG_ANNOTATION_INDEX, tagAnnotationIndex);
        return this.getSourceObject(TagAnnotation.class, indexes);
    }

    public void setTagAnnotationAnnotationRef(String annotation, int tagAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(TagAnnotation.class, new int[]{tagAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setTagAnnotationDescription(String description, int tagAnnotationIndex) {
        TagAnnotation o = this.getTagAnnotation(tagAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setTagAnnotationID(String id, int tagAnnotationIndex) {
        this.checkDuplicateLSID(TagAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TAG_ANNOTATION_INDEX, tagAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(TagAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(TagAnnotation.class, id, o);
    }

    public void setTagAnnotationNamespace(String namespace, int tagAnnotationIndex) {
        TagAnnotation o = this.getTagAnnotation(tagAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setTagAnnotationAnnotator(String value, int index) {
        this.ignoreAnnotator("setTagAnnotationAnnotator", value, index);
    }

    public void setTagAnnotationValue(String value, int tagAnnotationIndex) {
        TagAnnotation o = this.getTagAnnotation(tagAnnotationIndex);
        o.setTextValue(this.toRType(value));
    }

    private TermAnnotation getTermAnnotation(int termAnnotationIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TERM_ANNOTATION_INDEX, termAnnotationIndex);
        return this.getSourceObject(TermAnnotation.class, indexes);
    }

    public void setTermAnnotationAnnotationRef(String annotation, int termAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(TermAnnotation.class, new int[]{termAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setTermAnnotationDescription(String description, int termAnnotationIndex) {
        TermAnnotation o = this.getTermAnnotation(termAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setTermAnnotationID(String id, int termAnnotationIndex) {
        this.checkDuplicateLSID(TermAnnotation.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.TERM_ANNOTATION_INDEX, termAnnotationIndex);
        IObjectContainer o = this.getIObjectContainer(TermAnnotation.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(TermAnnotation.class, id, o);
    }

    public void setTermAnnotationNamespace(String namespace, int termAnnotationIndex) {
        TermAnnotation o = this.getTermAnnotation(termAnnotationIndex);
        o.setNs(this.toRType(namespace));
    }

    public void setTermAnnotationAnnotator(String value, int index) {
        this.ignoreAnnotator("setTermAnnotationAnnotator", value, index);
    }

    public void setTermAnnotationValue(String value, int termAnnotationIndex) {
        TermAnnotation o = this.getTermAnnotation(termAnnotationIndex);
        o.setTermValue(this.toRType(value));
    }

    public void setTimestampAnnotationAnnotationRef(String annotation, int timestampAnnotationIndex, int annotationRefIndex) {
        LSID key = new LSID(TimestampAnnotation.class, new int[]{timestampAnnotationIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setTimestampAnnotationDescription(String description, int timestampAnnotationIndex) {
        TimestampAnnotation o = this.getTimestampAnnotation(timestampAnnotationIndex);
        o.setDescription(this.toRType(description));
    }

    public void setTimestampAnnotationAnnotator(String value, int index) {
        this.ignoreAnnotator("setTimestampAnnotationAnnotator", value, index);
    }

    public void setPlateFieldIndex(NonNegativeInteger fieldIndex, int plateIndex) {
        this.ignoreMissing("setPlateFieldIndex", fieldIndex, plateIndex);
    }

    public void setBinaryFileBinData(byte[] binData, int fileAnnotationIndex) {
        this.ignoreMissing("setBinaryFileBinData", fileAnnotationIndex);
    }

    public void setBinaryFileBinDataBigEndian(Boolean isBigEndian, int fileAnnotationIndex) {
        this.ignoreMissing("setBinaryFileBinDataBigEndian", isBigEndian, fileAnnotationIndex);
    }

    public void setBinaryFileBinDataCompression(Compression compression, int fileAnnotationIndex) {
        this.ignoreMissing("setBinaryFileBinDataCompression", compression, fileAnnotationIndex);
    }

    public void setBinaryFileBinDataLength(NonNegativeLong length, int fileAnnotationIndex) {
        this.ignoreMissing("setBinaryFileBinDataLength", length, fileAnnotationIndex);
    }

    public void setBinaryFileFileName(String fileName, int fileAnnotationIndex) {
        this.ignoreUnneeded("setBinaryFileFileName", fileName, fileAnnotationIndex);
    }

    public void setBinaryFileMIMEType(String mimeType, int fileAnnotationIndex) {
        this.ignoreUnneeded("setBinaryFileMIMEType", mimeType, fileAnnotationIndex);
    }

    public void setBinaryFileSize(NonNegativeLong size, int fileAnnotationIndex) {
        this.ignoreUnneeded("setBinaryFileSize", size, fileAnnotationIndex);
    }

    public void setDatasetImageRef(String image, int datasetIndex, int imageRefIndex) {
        this.ignoreUnsupported("setDatasetImageRef", image, datasetIndex, imageRefIndex);
    }

    public void setEllipseFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setFillRule(this.toRType(fillRule.getValue()));
    }

    public void setEllipseFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontFamily.getValue()));
    }

    public void setEllipseFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontStyle.getValue()));
    }

    public void setEllipseLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Ellipse o = this.getEllipse(ROIIndex, shapeIndex);
        o.setLocked(this.toRType(locked));
    }

    public void setExperimenterGroupAnnotationRef(String annotation, int experimenterGroupIndex, int annotationRefIndex) {
        this.ignoreInsecure("setExperimenterGroupAnnotationRef", annotation, experimenterGroupIndex, annotationRefIndex);
    }

    public void setExperimenterGroupExperimenterRef(String experimenter, int experimenterGroupIndex, int experimenterRefIndex) {
        this.ignoreInsecure("setExperimenterGroupExperimenterRef", experimenter, experimenterGroupIndex, experimenterRefIndex);
    }

    public void setLabelFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setFillRule(this.toRType(fillRule.getValue()));
    }

    public void setLabelFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontFamily.getValue()));
    }

    public void setLabelFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setFontStyle(this.toRType(fontStyle.getValue()));
    }

    public void setLabelLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Label o = this.getLabel(ROIIndex, shapeIndex);
        o.setLocked(this.toRType(locked));
    }

    public void setLineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setFillRule(this.toRType(fillRule.getValue()));
    }

    public void setLineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontFamily.getValue()));
    }

    public void setLineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontStyle.getValue()));
    }

    public void setLineLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Line o = this.getLine(ROIIndex, shapeIndex);
        o.setLocked(this.toRType(locked));
    }

    public void setLineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex) {
        Line line = this.getLine(ROIIndex, shapeIndex);
        line.setMarkerEnd(this.toRType(markerEnd.getValue()));
    }

    public void setLineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex) {
        Line line = this.getLine(ROIIndex, shapeIndex);
        line.setMarkerStart(this.toRType(markerStart.getValue()));
    }

    public void setMaskFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setFillRule(this.toRType(fillRule.getValue()));
    }

    public void setMaskFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontFamily.getValue()));
    }

    public void setMaskFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setFontStyle(this.toRType(fontStyle.getValue()));
    }

    public void setMaskLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Mask o = this.getMask(ROIIndex, shapeIndex);
        o.setLocked(this.toRType(locked));
    }

    public void setPointFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setFillRule(this.toRType(fillRule.getValue()));
    }

    public void setPointFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontFamily.getValue()));
    }

    public void setPointFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setFontStyle(this.toRType(fontStyle.getValue()));
    }

    public void setPointLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Point o = this.getPoint(ROIIndex, shapeIndex);
        o.setLocked(this.toRType(locked));
    }

    private Polygon getPolygon(int ROIIndex, int shapeIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        return this.getSourceObject(Polygon.class, indexes);
    }

    public void setPolygonFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setFillColor(this.toRType(fillColor));
    }

    public void setPolygonFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setFillRule(this.toRType(fillRule.getValue()));
    }

    public void setPolygonFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontFamily.getValue()));
    }

    public void setPolygonFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setFontSize(UnitsFactory.convertLength(fontSize));
    }

    public void setPolygonFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setFontStyle(this.toRType(fontStyle.getValue()));
    }

    public void setPolygonID(String id, int ROIIndex, int shapeIndex) {
        this.checkDuplicateLSID(Polygon.class, id);
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.ROI_INDEX, ROIIndex);
        indexes.put(Index.SHAPE_INDEX, shapeIndex);
        IObjectContainer o = this.getIObjectContainer(Polygon.class, indexes);
        o.LSID = id;
        this.addAuthoritativeContainer(Polygon.class, id, o);
    }

    public void setPolygonLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setLocked(this.toRType(locked));
    }

    public void setPolygonStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setStrokeColor(this.toRType(strokeColor));
    }

    public void setPolygonStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setStrokeDashArray(this.toRType(strokeDashArray));
    }

    public void setPolygonStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setStrokeWidth(UnitsFactory.convertLength(strokeWidth));
    }

    public void setPolygonText(String text, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setTextValue(this.toRType(text));
    }

    public void setPolygonTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setTheC(this.toRType(theC));
    }

    public void setPolygonTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setTheT(this.toRType((Integer)theT.getValue()));
    }

    public void setPolygonTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setTheZ(this.toRType((Integer)theZ.getValue()));
    }

    public void setPolygonTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setTransform(this.toRType(transform));
    }

    public void setPolygonPoints(String points, int ROIIndex, int shapeIndex) {
        Polygon o = this.getPolygon(ROIIndex, shapeIndex);
        o.setPoints(this.toRType(points));
    }

    public void setPolylineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setFillRule(this.toRType(fillRule.getValue()));
    }

    public void setPolylineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontFamily.getValue()));
    }

    public void setPolylineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setFontStyle(this.toRType(fontStyle.getValue()));
    }

    public void setPolylineLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Polyline o = this.getPolyline(ROIIndex, shapeIndex);
        o.setLocked(this.toRType(locked));
    }

    public void setPolylineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex) {
        Polyline polyline = this.getPolyline(ROIIndex, shapeIndex);
        polyline.setMarkerEnd(this.toRType(markerEnd.getValue()));
    }

    public void setPolylineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex) {
        Polyline polyline = this.getPolyline(ROIIndex, shapeIndex);
        polyline.setMarkerStart(this.toRType(markerStart.getValue()));
    }

    public void setProjectDatasetRef(String dataset, int projectIndex, int datasetRefIndex) {
        this.ignoreUnsupported("setProjectDatasetRef", dataset, projectIndex, datasetRefIndex);
    }

    public void setRectangleFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setFillRule(this.toRType(fillRule.getValue()));
    }

    public void setRectangleFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setFontFamily(this.toRType(fontFamily.getValue()));
    }

    public void setRectangleFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setFontStyle(this.toRType(fontStyle.getValue()));
    }

    public void setRectangleLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Rectangle o = this.getRectangle(ROIIndex, shapeIndex);
        o.setLocked(this.toRType(locked));
    }

    public void setWellType(String type, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setType(this.toRType(type));
    }

    public void setRightsRightsHeld(String value) {
        this.ignoreMissing("setRightsRightsHeld", value);
    }

    public void setRightsRightsHolder(String value) {
        this.ignoreMissing("setRightsRightsHolder", value);
    }

    public void setDetectorAnnotationRef(String annotation, int instrumentIndex, int detectorIndex, int annotationRefIndex) {
        LSID key = new LSID(Detector.class, new int[]{instrumentIndex, detectorIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setDichroicAnnotationRef(String annotation, int instrumentIndex, int dichroicIndex, int annotationRefIndex) {
        LSID key = new LSID(Dichroic.class, new int[]{instrumentIndex, dichroicIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setEllipseAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        LSID key = new LSID(Ellipse.class, new int[]{ROIIndex, shapeIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setFilamentAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        LSID key = new LSID(Filament.class, new int[]{instrumentIndex, lightSourceIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setFilterAnnotationRef(String annotation, int instrumentIndex, int filterIndex, int annotationRefIndex) {
        LSID key = new LSID(Filter.class, new int[]{instrumentIndex, filterIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setGenericExcitationSourceAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        LSID key = new LSID(GenericExcitationSource.class, new int[]{instrumentIndex, lightSourceIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setInstrumentAnnotationRef(String annotation, int instrumentIndex, int annotationRefIndex) {
        LSID key = new LSID(Instrument.class, new int[]{instrumentIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setLabelAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        LSID key = new LSID(Label.class, new int[]{ROIIndex, shapeIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setLaserAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        LSID key = new LSID(Laser.class, new int[]{instrumentIndex, lightSourceIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setLightEmittingDiodeAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        LSID key = new LSID(LightEmittingDiode.class, new int[]{instrumentIndex, lightSourceIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setLightPathAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        LSID key = new LSID(LightPath.class, new int[]{imageIndex, channelIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setLineAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        LSID key = new LSID(Line.class, new int[]{ROIIndex, shapeIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setMaskAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        LSID key = new LSID(Mask.class, new int[]{ROIIndex, shapeIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setObjectiveAnnotationRef(String annotation, int instrumentIndex, int objectiveIndex, int annotationRefIndex) {
        LSID key = new LSID(Objective.class, new int[]{instrumentIndex, objectiveIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPointAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        LSID key = new LSID(Point.class, new int[]{ROIIndex, shapeIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPolygonAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        LSID key = new LSID(Polygon.class, new int[]{ROIIndex, shapeIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setPolylineAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        LSID key = new LSID(Polyline.class, new int[]{ROIIndex, shapeIndex});
        this.addReference(key, new LSID(annotation));
    }

    public void setRectangleAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        LSID key = new LSID(Rectangle.class, new int[]{ROIIndex, shapeIndex});
        this.addReference(key, new LSID(annotation));
    }

    private String ignoreMessage(String reason, String method, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(reason);
        sb.append("Ignoring ");
        sb.append(method);
        sb.append("(");
        boolean added = false;
        for (int i = 0; i < args.length; ++i) {
            if (added) {
                sb.append(", ");
            } else {
                added = true;
            }
            sb.append("{}");
        }
        sb.append("(");
        return sb.toString();
    }

    protected void ignoreMissing(String method, Object ... args) {
        String msg = this.ignoreMessage("Unneeded in OMERO. ", method, args);
        this.log.warn(msg, args);
    }

    protected void ignoreUnneeded(String method, Object ... args) {
        String msg = this.ignoreMessage("Unneeded in OMERO. ", method, args);
        this.log.debug(msg, args);
    }

    protected void ignoreUnsupported(String method, Object ... args) {
        String msg = this.ignoreMessage("Unsupported in OMERO. ", method, args);
        this.log.warn(msg, args);
    }

    protected void ignoreInsecure(String method, Object ... args) {
        String msg = this.ignoreMessage("Disallowed in OMERO. ", method, args);
        this.log.debug(msg, args);
    }

    protected void ignoreAnnotator(String method, Object ... args) {
        String msg = this.ignoreMessage("No annotators linked. ", method, args);
        this.log.warn(msg, args);
    }
}

