/*
 * Decompiled with CFR 0.152.
 */
package loci.ome.io;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import loci.common.DateTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.formats.model.UnitsFactory;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.Timestamp;
import omero.RInt;
import omero.RString;
import omero.RTime;
import omero.ServerError;
import omero.api.IAdminPrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RoiOptions;
import omero.api.RoiResult;
import omero.api.ServiceFactoryPrx;
import omero.client;
import omero.model.Channel;
import omero.model.EllipseI;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.ExperimenterGroupI;
import omero.model.Image;
import omero.model.Label;
import omero.model.Length;
import omero.model.LineI;
import omero.model.LogicalChannel;
import omero.model.MaskI;
import omero.model.Pixels;
import omero.model.PointI;
import omero.model.PolygonI;
import omero.model.PolylineI;
import omero.model.RectangleI;
import omero.model.Roi;
import omero.model.Shape;
import omero.rtypes;
import omero.sys.EventContext;

@Deprecated
public class OmeroReader
extends FormatReader {
    public static final int DEFAULT_PORT = 4064;
    private String server;
    private String username;
    private String password;
    private int thePort = 4064;
    private String sessionID;
    private String group;
    private Long groupID = null;
    private boolean encrypted = true;
    private client secureClient;
    private client unsecureClient;
    private ServiceFactoryPrx serviceFactory;
    private Image img;
    private Pixels pix;

    private String formatId(String id) {
        String separator = "\n";
        StringBuilder buffer = new StringBuilder();
        Iterable sc = () -> new Scanner(id).useDelimiter(separator);
        for (String line : sc) {
            if (line.startsWith("pass=")) {
                line = "pass=****";
            }
            buffer.append(line);
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public OmeroReader() {
        super("OMERO", "*");
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(int port) {
        this.thePort = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public void setGroupName(String group) {
        this.group = group;
    }

    public void setGroupID(Long groupID) {
        this.groupID = groupID;
    }

    public boolean isThisType(String name, boolean open) {
        return name.startsWith("omero:");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] plane;
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        FormatTools.checkPlaneNumber((IFormatReader)this, (int)no);
        FormatTools.checkBufferSize((IFormatReader)this, (int)buf.length, (int)w, (int)h);
        int[] zct = FormatTools.getZCTCoords((IFormatReader)this, (int)no);
        RawPixelsStorePrx store = null;
        try {
            store = this.serviceFactory.createRawPixelsStore();
            store.setPixelsId(this.pix.getId().getValue(), false);
            plane = store.getTile(zct[0], zct[1], zct[2], x, y, w, h);
        }
        catch (ServerError e) {
            throw new FormatException((Throwable)((Object)e));
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (Exception ex) {
                    throw new FormatException((Throwable)ex);
                }
            }
        }
        System.arraycopy(plane, 0, buf, 0, plane.length);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.secureClient != null) {
                this.secureClient.closeSession();
            }
            if (this.unsecureClient != null) {
                this.unsecureClient.closeSession();
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] tokens;
        String formattedId = this.formatId(id);
        super.initFile(formattedId);
        if (!id.startsWith("omero:")) {
            throw new IllegalArgumentException("Not an OMERO id: " + formattedId);
        }
        LOGGER.info("Parsing credentials");
        String address = this.server;
        String user = this.username;
        String pass = this.password;
        int port = this.thePort;
        long iid = -1L;
        for (String token : tokens = id.substring(6).split("\n")) {
            int equals = token.indexOf("=");
            if (equals < 0) continue;
            String key = token.substring(0, equals);
            String val = token.substring(equals + 1);
            if (key.equals("server")) {
                address = val;
                continue;
            }
            if (key.equals("user")) {
                user = val;
                continue;
            }
            if (key.equals("pass")) {
                pass = val;
                continue;
            }
            if (key.equals("port")) {
                try {
                    port = Integer.parseInt(val);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (key.equals("session")) {
                this.sessionID = val;
                continue;
            }
            if (key.equals("groupName")) {
                this.group = val;
                continue;
            }
            if (key.equals("groupID")) {
                this.groupID = new Long(val);
                continue;
            }
            if (!key.equals("iid")) continue;
            try {
                iid = Long.parseLong(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (address == null) {
            throw new FormatException("Invalid server address");
        }
        if (user == null && this.sessionID == null) {
            throw new FormatException("Invalid username");
        }
        if (pass == null && this.sessionID == null) {
            throw new FormatException("Invalid password");
        }
        if (iid < 0L) {
            throw new FormatException("Invalid image ID");
        }
        try {
            List<Roi> rois;
            int n;
            ExperimenterGroup defaultGroup;
            LOGGER.info("Logging in");
            this.secureClient = new client(address, port);
            this.serviceFactory = null;
            this.serviceFactory = user != null && pass != null ? this.secureClient.createSession(user, pass) : this.secureClient.createSession(this.sessionID, this.sessionID);
            if (!this.encrypted) {
                this.unsecureClient = this.secureClient.createClient(false);
                this.serviceFactory = this.unsecureClient.getSession();
            }
            IAdminPrx iAdmin = this.serviceFactory.getAdminService();
            EventContext eventContext = iAdmin.getEventContext();
            if (!(this.group == null && this.groupID == null || (defaultGroup = iAdmin.getDefaultGroup(eventContext.userId)).getName().getValue().equals(this.group) || new Long(defaultGroup.getId().getValue()).equals(this.groupID))) {
                Experimenter exp = iAdmin.getExperimenter(eventContext.userId);
                List<Long> groupList = iAdmin.getMemberOfGroupIds(exp);
                Iterator<Long> i = groupList.iterator();
                Long g = null;
                boolean in = false;
                while (i.hasNext()) {
                    g = i.next();
                    if (!g.equals(this.groupID)) continue;
                    in = true;
                    this.groupID = g;
                    break;
                }
                if (in) {
                    iAdmin.setDefaultGroup(exp, iAdmin.getGroup(this.groupID));
                    this.serviceFactory.setSecurityContext(new ExperimenterGroupI(this.groupID, false));
                }
            }
            this.img = this.serviceFactory.getContainerService().getImages("Image", Arrays.asList(iid), null).get(0);
            if (this.img == null) {
                throw new FormatException("Could not find Image with ID=" + iid + " in group '" + this.group + "'.");
            }
            long pixelsId = this.img.getPixels(0).getId().getValue();
            this.pix = this.serviceFactory.getPixelsService().retrievePixDescription(pixelsId);
            int sizeX = this.pix.getSizeX().getValue();
            int sizeY = this.pix.getSizeY().getValue();
            int sizeZ = this.pix.getSizeZ().getValue();
            int sizeC = this.pix.getSizeC().getValue();
            int sizeT = this.pix.getSizeT().getValue();
            String pixelType = this.pix.getPixelsType().getValue().getValue();
            LOGGER.info("Populating metadata");
            CoreMetadata m = (CoreMetadata)this.core.get(0);
            m.sizeX = sizeX;
            m.sizeY = sizeY;
            m.sizeZ = sizeZ;
            m.sizeC = sizeC;
            m.sizeT = sizeT;
            m.rgb = false;
            m.littleEndian = false;
            m.dimensionOrder = "XYZCT";
            m.imageCount = sizeZ * sizeC * sizeT;
            m.pixelType = FormatTools.pixelTypeFromString((String)pixelType);
            Length x = this.pix.getPhysicalSizeX();
            Length y = this.pix.getPhysicalSizeY();
            Length z = this.pix.getPhysicalSizeZ();
            omero.model.Time t = this.pix.getTimeIncrement();
            Time t2 = UnitsFactory.convertTime(t);
            ome.units.quantity.Length px = UnitsFactory.convertLength(x);
            ome.units.quantity.Length py = UnitsFactory.convertLength(y);
            ome.units.quantity.Length pz = UnitsFactory.convertLength(z);
            RString imageName = this.img.getName();
            String name = imageName == null ? null : imageName.getValue();
            this.currentId = name != null ? name : "Image ID " + iid;
            RString imgDescription = this.img.getDescription();
            String description = imgDescription == null ? null : imgDescription.getValue();
            RTime date = this.img.getAcquisitionDate();
            MetadataStore store = this.getMetadataStore();
            MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
            store.setImageName(name, 0);
            store.setImageDescription(description, 0);
            if (date != null) {
                store.setImageAcquisitionDate(new Timestamp(DateTools.convertDate((long)date.getValue(), (int)0)), 0);
            }
            if (px != null && px.value().doubleValue() > 0.0) {
                store.setPixelsPhysicalSizeX(px, 0);
            }
            if (py != null && py.value().doubleValue() > 0.0) {
                store.setPixelsPhysicalSizeY(py, 0);
            }
            if (pz != null && pz.value().doubleValue() > 0.0) {
                store.setPixelsPhysicalSizeZ(pz, 0);
            }
            if (t2 != null) {
                store.setPixelsTimeIncrement(t2, 0);
            }
            List<Channel> channels = this.pix.copyChannels();
            for (int c = 0; c < channels.size(); ++c) {
                LogicalChannel channel = channels.get(c).getLogicalChannel();
                Length emWave = channel.getEmissionWave();
                Length exWave = channel.getExcitationWave();
                Length pinholeSize = channel.getPinHoleSize();
                RString cname = channel.getName();
                ome.units.quantity.Length emission = UnitsFactory.convertLength(emWave);
                ome.units.quantity.Length excitation = UnitsFactory.convertLength(exWave);
                String channelName = cname == null ? null : cname.getValue();
                ome.units.quantity.Length pinhole = UnitsFactory.convertLength(pinholeSize);
                if (channelName != null) {
                    store.setChannelName(channelName, 0, c);
                }
                if (pinholeSize != null) {
                    store.setChannelPinholeSize(pinhole, 0, c);
                }
                if (emission != null && emission.value().doubleValue() > 0.0) {
                    store.setChannelEmissionWavelength(emission, 0, c);
                }
                if (excitation == null || !(excitation.value().doubleValue() > 0.0)) continue;
                store.setChannelExcitationWavelength(excitation, 0, c);
            }
            RoiOptions options = new RoiOptions();
            options.userId = rtypes.rlong(iAdmin.getEventContext().userId);
            RoiResult r = this.serviceFactory.getRoiService().findByImage(this.img.getId().getValue(), new RoiOptions());
            if (r != null && (n = (rois = r.rois).size()) != 0) {
                OmeroReader.saveOmeroRoiToMetadataStore(rois, store);
            }
        }
        catch (CannotCreateSessionException | PermissionDeniedException | ServerError e) {
            throw new FormatException((Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        try (BufferedReader con = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
             OmeroReader omeroReader = new OmeroReader();){
            System.out.print("Server? ");
            String server = con.readLine();
            System.out.printf("Port [%d]? ", 4064);
            String portString = con.readLine();
            int port = portString.equals("") ? 4064 : Integer.parseInt(portString);
            System.out.print("Username? ");
            String user = con.readLine();
            System.out.print("Password? ");
            String pass = new String(con.readLine());
            System.out.print("Group? ");
            String group = con.readLine();
            System.out.print("Image ID? ");
            int imageId = Integer.parseInt(con.readLine());
            System.out.print("\n\n");
            String id = "omero:iid=" + imageId;
            omeroReader.setUsername(user);
            omeroReader.setPassword(pass);
            omeroReader.setServer(server);
            omeroReader.setPort(port);
            omeroReader.setGroupName(group);
            omeroReader.setId(id);
        }
    }

    public static void saveOmeroRoiToMetadataStore(List<Roi> rois, MetadataStore store) {
        int n = rois.size();
        for (int thisROI = 0; thisROI < n; ++thisROI) {
            Roi roi = rois.get(thisROI);
            int numShapes = roi.sizeOfShapes();
            int roiNum = thisROI;
            String roiID = MetadataTools.createLSID((String)"ROI", (int[])new int[]{roiNum, 0});
            for (int ns = 0; ns < numShapes; ++ns) {
                Shape shape = roi.getShape(ns);
                int shapeNum = ns;
                if (shape instanceof LineI) {
                    OmeroReader.storeOmeroLine(shape, store, roiNum, shapeNum);
                    continue;
                }
                if (shape instanceof PointI) {
                    OmeroReader.storeOmeroPoint(shape, store, roiNum, shapeNum);
                    continue;
                }
                if (shape instanceof EllipseI) {
                    OmeroReader.storeOmeroEllipse(shape, store, roiNum, shapeNum);
                    continue;
                }
                if (shape instanceof RectangleI) {
                    OmeroReader.storeOmeroRect(shape, store, roiNum, shapeNum);
                    continue;
                }
                if (shape instanceof PolygonI || shape instanceof PolylineI) {
                    OmeroReader.storeOmeroPolygon(shape, store, roiNum, shapeNum);
                    continue;
                }
                if (shape instanceof Label) {
                    OmeroReader.storeOmeroLabel(shape, store, roiNum, shapeNum);
                    continue;
                }
                if (!(shape instanceof MaskI)) continue;
                OmeroReader.storeOmeroMask(shape, store, roiNum, shapeNum);
            }
            if (roiID == null) continue;
            store.setROIID(roiID, roiNum);
            store.setImageROIRef(roiID, 0, roiNum);
        }
    }

    private static void storeOmeroLabel(Shape shape, MetadataStore store, int roiNum, int shapeNum) {
        Label shape1 = (Label)shape;
        String polylineID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{roiNum, shapeNum});
        store.setLabelID(polylineID, roiNum, shapeNum);
        if (shape1.getTextValue() != null) {
            store.setLabelText(shape1.getTextValue().getValue(), roiNum, shapeNum);
        }
        store.setLabelX(Double.valueOf(shape1.getX().getValue()), roiNum, shapeNum);
        store.setLabelY(Double.valueOf(shape1.getY().getValue()), roiNum, shapeNum);
        store.setLabelTheC(OmeroReader.unwrap(shape1.getTheC()), roiNum, shapeNum);
        store.setLabelTheZ(OmeroReader.unwrap(shape1.getTheZ()), roiNum, shapeNum);
        store.setLabelTheT(OmeroReader.unwrap(shape1.getTheT()), roiNum, shapeNum);
        if (shape1.getStrokeWidth() != null) {
            store.setLabelStrokeWidth(new ome.units.quantity.Length((Number)shape1.getStrokeWidth().getValue(), UNITS.PIXEL), roiNum, shapeNum);
        }
        if (shape1.getStrokeColor() != null) {
            store.setLabelStrokeColor(new Color(Integer.valueOf(shape1.getStrokeColor().getValue())), roiNum, shapeNum);
        }
        if (shape1.getFillColor() != null) {
            store.setLabelFillColor(new Color(Integer.valueOf(shape1.getFillColor().getValue())), roiNum, shapeNum);
        }
        if (shape1.getFontSize() != null) {
            ome.units.quantity.Length labelSize = new ome.units.quantity.Length((Number)shape1.getFontSize().getValue(), UNITS.PIXEL);
            store.setLabelFontSize(labelSize, roiNum, shapeNum);
        }
    }

    private static NonNegativeInteger unwrap(RInt r) {
        if (r == null) {
            return null;
        }
        return new NonNegativeInteger(Integer.valueOf(r.getValue()));
    }

    private static void storeOmeroRect(Shape shape, MetadataStore store, int roiNum, int shapeNum) {
        RectangleI shape1 = (RectangleI)shape;
        double x1 = shape1.getX().getValue();
        double y1 = shape1.getY().getValue();
        double width = shape1.getWidth().getValue();
        double height = shape1.getHeight().getValue();
        String polylineID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{roiNum, shapeNum});
        store.setRectangleID(polylineID, roiNum, shapeNum);
        store.setRectangleX(Double.valueOf(x1), roiNum, shapeNum);
        store.setRectangleY(Double.valueOf(y1), roiNum, shapeNum);
        store.setRectangleWidth(Double.valueOf(width), roiNum, shapeNum);
        store.setRectangleHeight(Double.valueOf(height), roiNum, shapeNum);
        store.setRectangleTheC(OmeroReader.unwrap(shape1.getTheC()), roiNum, shapeNum);
        store.setRectangleTheZ(OmeroReader.unwrap(shape1.getTheZ()), roiNum, shapeNum);
        store.setRectangleTheT(OmeroReader.unwrap(shape1.getTheT()), roiNum, shapeNum);
        if (shape1.getTextValue() != null) {
            store.setRectangleText(shape1.getTextValue().getValue(), roiNum, shapeNum);
        }
        if (shape1.getStrokeWidth() != null) {
            store.setRectangleStrokeWidth(new ome.units.quantity.Length((Number)shape1.getStrokeWidth().getValue(), UNITS.PIXEL), roiNum, shapeNum);
        }
        if (shape1.getStrokeColor() != null) {
            store.setRectangleStrokeColor(new Color(Integer.valueOf(shape1.getStrokeColor().getValue())), roiNum, shapeNum);
        }
        if (shape1.getFillColor() != null) {
            store.setRectangleFillColor(new Color(Integer.valueOf(shape1.getFillColor().getValue())), roiNum, shapeNum);
        }
    }

    private static void storeOmeroEllipse(Shape shape, MetadataStore store, int roiNum, int shapeNum) {
        EllipseI shape1 = (EllipseI)shape;
        double x1 = shape1.getX().getValue();
        double y1 = shape1.getY().getValue();
        double width = shape1.getRadiusX().getValue();
        double height = shape1.getRadiusY().getValue();
        String polylineID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{roiNum, shapeNum});
        store.setEllipseID(polylineID, roiNum, shapeNum);
        store.setEllipseX(Double.valueOf(x1), roiNum, shapeNum);
        store.setEllipseY(Double.valueOf(y1), roiNum, shapeNum);
        store.setEllipseRadiusX(Double.valueOf(width), roiNum, shapeNum);
        store.setEllipseRadiusY(Double.valueOf(height), roiNum, shapeNum);
        store.setEllipseTheC(OmeroReader.unwrap(shape1.getTheC()), roiNum, shapeNum);
        store.setEllipseTheZ(OmeroReader.unwrap(shape1.getTheZ()), roiNum, shapeNum);
        store.setEllipseTheT(OmeroReader.unwrap(shape1.getTheT()), roiNum, shapeNum);
        if (shape1.getTextValue() != null) {
            store.setEllipseText(shape1.getTextValue().getValue(), roiNum, shapeNum);
        }
        if (shape1.getStrokeWidth() != null) {
            store.setEllipseStrokeWidth(new ome.units.quantity.Length((Number)shape1.getStrokeWidth().getValue(), UNITS.PIXEL), roiNum, shapeNum);
        }
        if (shape1.getStrokeColor() != null) {
            store.setEllipseStrokeColor(new Color(Integer.valueOf(shape1.getStrokeColor().getValue())), roiNum, shapeNum);
        }
        if (shape1.getFillColor() != null) {
            store.setEllipseFillColor(new Color(Integer.valueOf(shape1.getFillColor().getValue())), roiNum, shapeNum);
        }
    }

    private static void storeOmeroPoint(Shape shape, MetadataStore store, int roiNum, int shapeNum) {
        PointI shape1 = (PointI)shape;
        double ox1 = shape1.getX().getValue();
        double oy1 = shape1.getY().getValue();
        String polylineID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{roiNum, shapeNum});
        store.setPointID(polylineID, roiNum, shapeNum);
        store.setPointX(Double.valueOf(ox1), roiNum, shapeNum);
        store.setPointY(Double.valueOf(oy1), roiNum, shapeNum);
        store.setPointTheC(OmeroReader.unwrap(shape1.getTheC()), roiNum, shapeNum);
        store.setPointTheZ(OmeroReader.unwrap(shape1.getTheZ()), roiNum, shapeNum);
        store.setPointTheT(OmeroReader.unwrap(shape1.getTheT()), roiNum, shapeNum);
        if (shape1.getTextValue() != null) {
            store.setPointText(shape1.getTextValue().getValue(), roiNum, shapeNum);
        }
        if (shape1.getStrokeWidth() != null) {
            store.setPointStrokeWidth(new ome.units.quantity.Length((Number)shape1.getStrokeWidth().getValue(), UNITS.PIXEL), roiNum, shapeNum);
        }
        if (shape1.getStrokeColor() != null) {
            store.setPointStrokeColor(new Color(Integer.valueOf(shape1.getStrokeColor().getValue())), roiNum, shapeNum);
        }
        if (shape1.getFillColor() != null) {
            store.setPointFillColor(new Color(Integer.valueOf(shape1.getFillColor().getValue())), roiNum, shapeNum);
        }
    }

    private static void storeOmeroLine(Shape shape, MetadataStore store, int roiNum, int shapeNum) {
        LineI shape1 = (LineI)shape;
        double x1 = shape1.getX1().getValue();
        double y1 = shape1.getY1().getValue();
        double x2 = shape1.getX2().getValue();
        double y2 = shape1.getY2().getValue();
        String polylineID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{roiNum, shapeNum});
        store.setLineID(polylineID, roiNum, shapeNum);
        store.setLineX1(new Double(x1), roiNum, shapeNum);
        store.setLineX2(new Double(x2), roiNum, shapeNum);
        store.setLineY1(new Double(y1), roiNum, shapeNum);
        store.setLineY2(new Double(y2), roiNum, shapeNum);
        store.setLineTheC(OmeroReader.unwrap(shape1.getTheC()), roiNum, shapeNum);
        store.setLineTheZ(OmeroReader.unwrap(shape1.getTheZ()), roiNum, shapeNum);
        store.setLineTheT(OmeroReader.unwrap(shape1.getTheT()), roiNum, shapeNum);
        if (shape1.getTextValue() != null) {
            store.setLineText(shape1.getTextValue().getValue(), roiNum, shapeNum);
        }
        if (shape1.getStrokeWidth() != null) {
            store.setLineStrokeWidth(new ome.units.quantity.Length((Number)shape1.getStrokeWidth().getValue(), UNITS.PIXEL), roiNum, shapeNum);
        }
        if (shape1.getStrokeColor() != null) {
            store.setLineStrokeColor(new Color(Integer.valueOf(shape1.getStrokeColor().getValue())), roiNum, shapeNum);
        }
        if (shape1.getFillColor() != null) {
            store.setLineFillColor(new Color(Integer.valueOf(shape1.getFillColor().getValue())), roiNum, shapeNum);
        }
    }

    private static void storeOmeroPolygon(Shape shape, MetadataStore store, int roiNum, int shapeNum) {
        String points = null;
        String polylineID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{roiNum, shapeNum});
        if (shape instanceof PolygonI) {
            PolygonI shape1 = (PolygonI)shape;
            points = shape1.getPoints().getValue();
            String points2d = OmeroReader.parsePoints(OmeroReader.convertPoints(points, "points"));
            store.setPolygonID(polylineID, roiNum, shapeNum);
            store.setPolygonPoints(points2d, roiNum, shapeNum);
            if (shape1.getTextValue() != null) {
                store.setPolygonText(shape1.getTextValue().getValue(), roiNum, shapeNum);
            }
            if (shape1.getStrokeWidth() != null) {
                store.setPolygonStrokeWidth(new ome.units.quantity.Length((Number)shape1.getStrokeWidth().getValue(), UNITS.PIXEL), roiNum, shapeNum);
            }
            if (shape1.getStrokeColor() != null) {
                store.setPolygonStrokeColor(new Color(Integer.valueOf(shape1.getStrokeColor().getValue())), roiNum, shapeNum);
            }
            if (shape1.getFillColor() != null) {
                store.setPolygonFillColor(new Color(Integer.valueOf(shape1.getFillColor().getValue())), roiNum, shapeNum);
            }
            store.setPolygonTheC(OmeroReader.unwrap(shape1.getTheC()), roiNum, shapeNum);
            store.setPolygonTheZ(OmeroReader.unwrap(shape1.getTheZ()), roiNum, shapeNum);
            store.setPolygonTheT(OmeroReader.unwrap(shape1.getTheT()), roiNum, shapeNum);
        } else {
            PolylineI shape1 = (PolylineI)shape;
            points = shape1.getPoints().getValue();
            String points2d = OmeroReader.parsePoints(OmeroReader.convertPoints(points, "points"));
            store.setPolylineID(polylineID, roiNum, shapeNum);
            store.setPolylinePoints(points2d, roiNum, shapeNum);
            if (shape1.getTextValue() != null) {
                store.setPolylineText(shape1.getTextValue().getValue(), roiNum, shapeNum);
            }
            if (shape1.getStrokeWidth() != null) {
                store.setPolylineStrokeWidth(new ome.units.quantity.Length((Number)shape1.getStrokeWidth().getValue(), UNITS.PIXEL), roiNum, shapeNum);
            }
            if (shape1.getStrokeColor() != null) {
                store.setPolylineStrokeColor(new Color(Integer.valueOf(shape1.getStrokeColor().getValue())), roiNum, shapeNum);
            }
            if (shape1.getFillColor() != null) {
                store.setPolylineFillColor(new Color(Integer.valueOf(shape1.getFillColor().getValue())), roiNum, shapeNum);
            }
            store.setPolylineTheC(OmeroReader.unwrap(shape1.getTheC()), roiNum, shapeNum);
            store.setPolylineTheZ(OmeroReader.unwrap(shape1.getTheZ()), roiNum, shapeNum);
            store.setPolylineTheT(OmeroReader.unwrap(shape1.getTheT()), roiNum, shapeNum);
        }
    }

    private static void storeOmeroMask(Shape shape, MetadataStore store, int roiNum, int shapeNum) {
        MaskI shape1 = (MaskI)shape;
        double x1 = shape1.getX().getValue();
        double y1 = shape1.getY().getValue();
        double width = shape1.getWidth().getValue();
        double height = shape1.getHeight().getValue();
        String maskID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{roiNum, shapeNum});
        store.setMaskID(maskID, roiNum, shapeNum);
        store.setMaskX(Double.valueOf(x1), roiNum, shapeNum);
        store.setMaskY(Double.valueOf(y1), roiNum, shapeNum);
        store.setMaskWidth(Double.valueOf(width), roiNum, shapeNum);
        store.setMaskHeight(Double.valueOf(height), roiNum, shapeNum);
        store.setMaskTheC(OmeroReader.unwrap(shape1.getTheC()), roiNum, shapeNum);
        store.setMaskTheZ(OmeroReader.unwrap(shape1.getTheZ()), roiNum, shapeNum);
        store.setMaskTheT(OmeroReader.unwrap(shape1.getTheT()), roiNum, shapeNum);
        if (shape1.getTextValue() != null) {
            store.setMaskText(shape1.getTextValue().getValue(), roiNum, shapeNum);
        }
        if (shape1.getStrokeWidth() != null) {
            store.setMaskStrokeWidth(new ome.units.quantity.Length((Number)shape1.getStrokeWidth().getValue(), UNITS.PIXEL), roiNum, shapeNum);
        }
        if (shape1.getStrokeColor() != null) {
            store.setMaskStrokeColor(new Color(Integer.valueOf(shape1.getStrokeColor().getValue())), roiNum, shapeNum);
        }
        if (shape1.getFillColor() != null) {
            store.setMaskFillColor(new Color(Integer.valueOf(shape1.getFillColor().getValue())), roiNum, shapeNum);
        }
    }

    protected static String parsePoints(String str) {
        int i;
        String points = null;
        if (str == null) {
            return points;
        }
        ArrayList<Float> x = new ArrayList<Float>();
        ArrayList<Float> y = new ArrayList<Float>();
        StringTokenizer tt = new StringTokenizer(str, " ");
        int numTokens = tt.countTokens();
        for (i = 0; i < numTokens; ++i) {
            StringTokenizer t = new StringTokenizer(tt.nextToken(), ",");
            int total = t.countTokens() / 2;
            for (int j = 0; j < total; ++j) {
                x.add(new Float(t.nextToken()));
                y.add(new Float(t.nextToken()));
            }
        }
        for (i = 0; i < x.size(); ++i) {
            points = i == 0 ? x.get(i) + "," + y.get(i) : points + " " + x.get(i) + "," + y.get(i);
        }
        return points.toString();
    }

    private static String convertPoints(String pts, String type) {
        if (pts.length() == 0) {
            return "";
        }
        if (!pts.contains(type)) {
            return pts;
        }
        String exp = type + '[';
        int typeStr = pts.indexOf(exp, 0);
        int start = pts.indexOf(91, typeStr);
        int end = pts.indexOf(93, start);
        return pts.substring(start + 1, end);
    }
}

