/*
 * Decompiled with CFR 0.152.
 */
package io.scif.cli.convert;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.Writer;
import io.scif.cli.AbstractReaderCommand;
import io.scif.cli.SCIFIOToolCommand;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.ReaderFilter;
import io.scif.formats.TIFFFormat;
import io.scif.services.InitializeService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.Interval;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=SCIFIOToolCommand.class)
public class Convert
extends AbstractReaderCommand {
    @Argument(metaVar="input", index=0, usage="input dataset path")
    private String in;
    @Argument(metaVar="output", index=1, usage="output dataset path")
    private String out;
    @Argument(index=2, multiValued=true)
    private final List<String> arguments = new ArrayList<String>();
    @Option(name="-b", aliases={"--bigtiff"}, usage="force BigTIFF files to be written")
    private Boolean bigTiff;
    @Option(name="-o", aliases={"--overwrite"}, usage="always overwrite the output file if it exists")
    private Boolean overwrite;
    @Option(name="-n", aliases={"--nooverwrite"}, usage="never overwrite the output file if it exists")
    private Boolean nooverwrite;
    @Option(name="-c", aliases={"--compression"}, metaVar="COMPRESSION_TYPE", usage="specify which codec to use when saving images")
    private String compression;
    @Parameter
    private InitializeService initializeService;
    @Parameter
    private LocationService locationService;
    @Parameter
    private DataHandleService dataHandleService;
    private Writer writer;

    @Override
    protected void run() throws CmdLineException {
        if (this.checkOverwrite()) {
            this.info(this.in);
            ReaderFilter reader = this.makeReader(this.in);
            this.writer = this.makeWriter(reader.getMetadata());
            try {
                this.info(reader.getFormat().getFormatName() + " -> " + this.writer.getFormat().getFormatName());
                this.read((Reader)reader);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.warn("Failed to close reader");
                    this.warn(e.getMessage());
                }
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    this.warn("Failed to close writer");
                    this.warn(e.getMessage());
                }
            }
        }
    }

    @Override
    protected String description() {
        return "command line tool for converting a dataset from one type to another";
    }

    @Override
    protected String getName() {
        return "convert";
    }

    @Override
    protected List<String> getExtraArguments() {
        return this.arguments;
    }

    @Override
    protected void validateParams() throws CmdLineException {
        if (this.in == null) {
            throw new CmdLineException(null, "Argument \"in\" is required");
        }
        if (this.out == null) {
            throw new CmdLineException(null, "Argument \"out\" is required");
        }
    }

    @Override
    protected Plane processPlane(Reader reader, Plane plane, int imageIndex, long planeIndex, long planeNo, Interval bounds) throws CmdLineException {
        if (planeNo < this.writer.getMetadata().get(imageIndex).getPlaneCount()) {
            try {
                plane = plane == null ? reader.openPlane(imageIndex, planeIndex, bounds, this.getConfig()) : reader.openPlane(imageIndex, planeIndex, plane, bounds, this.getConfig());
                this.writer.savePlane(imageIndex, planeNo, plane);
            }
            catch (FormatException e) {
                throw new CmdLineException(null, e.getMessage());
            }
            catch (IOException e) {
                throw new CmdLineException(null, e.getMessage());
            }
        }
        return plane;
    }

    @Override
    public String commandName() {
        return "convert";
    }

    private Writer makeWriter(Metadata sourceMeta) throws CmdLineException {
        Writer w;
        try {
            w = this.initializeService.initializeWriter(sourceMeta, this.location(this.out), new SCIFIOConfig().checkerSetOpen(false));
            if (w instanceof TIFFFormat.Writer && this.bigTiff != null) {
                ((TIFFFormat.Writer)w).setBigTiff(this.bigTiff.booleanValue());
            }
        }
        catch (FormatException e) {
            throw new CmdLineException(null, e.getMessage());
        }
        catch (IOException e) {
            throw new CmdLineException(null, e.getMessage());
        }
        return w;
    }

    private boolean checkOverwrite() throws CmdLineException {
        Location destination = this.location(this.out);
        boolean exists = false;
        try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)destination);){
            exists = handle.exists();
        }
        catch (IOException exc) {
            throw new CmdLineException(null, "Cannot query destination: " + this.out, (Throwable)exc);
        }
        if (exists) {
            if (this.nooverwrite == null) {
                if (this.overwrite == null) {
                    this.warn("Warning: destination " + this.out + " exists.");
                    this.warn("Do you want to overwrite it? ([y]/n)");
                    try {
                        BufferedReader r = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
                        String choice = r.readLine().trim().toLowerCase();
                        this.overwrite = !choice.startsWith("n");
                    }
                    catch (IOException e) {
                        throw new CmdLineException(null, e.getMessage());
                    }
                }
                this.nooverwrite = this.overwrite == false;
            }
            if (this.nooverwrite.booleanValue()) {
                this.err("Output file exists and no-overwrite flag was specified. Existing.");
                return false;
            }
        }
        return true;
    }
}

