/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.AuralAttributes;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.Soundscape;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.LeafState;

public class SoundscapeState
extends LeafState {
    private int boundingLeaf;
    private int auralAttributes;

    public SoundscapeState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.control.getSymbolTable().addReference(((Soundscape)this.node).getApplicationBoundingLeaf()));
        this.control.writeBounds(out, ((Soundscape)this.node).getApplicationBounds());
        out.writeInt(this.control.getSymbolTable().addReference(((Soundscape)this.node).getAuralAttributes()));
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.boundingLeaf = in.readInt();
        ((Soundscape)this.node).setApplicationBounds(this.control.readBounds(in));
        this.auralAttributes = in.readInt();
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.auralAttributes);
    }

    @Override
    public void buildGraph() {
        ((Soundscape)this.node).setApplicationBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        ((Soundscape)this.node).setAuralAttributes((AuralAttributes)this.control.getSymbolTable().getJ3dNode(this.auralAttributes));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Soundscape();
    }
}

