/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.transforms;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ScaleGet;
import net.imglib2.realtransform.TranslationGet;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.Common;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.TransformGraph;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.TransformPath;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AffineCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateFieldCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransformAdapter;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.DisplacementFieldCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.IdentityCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.InvertibleCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ParametrizedTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ReferencedCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ScaleCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.SequenceCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.TranslationCoordinateTransform;

public class NgffTransformations {
    public static <T extends RealTransform> T open(N5Reader n5, String dataset, String input, String output) {
        TransformGraph g = Common.openGraph((N5Reader)n5, (String)dataset);
        return (T)((TransformPath)g.path(input, output).get()).totalTransform(n5, g);
    }

    public static RealTransform open(String url) {
        Pair<CoordinateTransform<?>, N5Reader> pair = NgffTransformations.openTransformN5(url);
        return ((CoordinateTransform)pair.getA()).getTransform((N5Reader)pair.getB());
    }

    public static InvertibleRealTransform openInvertible(String url) {
        Pair<CoordinateTransform<?>, N5Reader> pair = NgffTransformations.openTransformN5(url);
        CoordinateTransform ct = (CoordinateTransform)pair.getA();
        if (ct instanceof InvertibleCoordinateTransform) {
            return ((InvertibleCoordinateTransform)ct).getInvertibleTransform((N5Reader)pair.getB());
        }
        return null;
    }

    public static RealTransform findFieldTransformFirst(N5Reader n5, String group) {
        String normGrp = N5URI.normalizeGroupPath((String)group);
        System.out.println("nnrmGrp: " + normGrp);
        CoordinateTransform[] transforms = (CoordinateTransform[])n5.getAttribute(group, "coordinateTransformations", CoordinateTransform[].class);
        if (transforms == null) {
            return null;
        }
        if (transforms.length == 1) {
            // empty if block
        }
        boolean found = false;
        for (CoordinateTransform ct : transforms) {
            System.out.println(ct);
            String nrmInput = N5URI.normalizeGroupPath((String)ct.getInput());
            System.out.println("nrmInput: " + nrmInput);
            if (!nrmInput.equals(normGrp)) continue;
            found = true;
            System.out.println("found: " + ct);
        }
        return null;
    }

    public static RealTransform findFieldTransformStrict(N5Reader n5, String group, String output) {
        String normGrp = N5URI.normalizeGroupPath((String)group);
        System.out.println("nnrmGrp: " + normGrp);
        CoordinateTransform[] transforms = (CoordinateTransform[])n5.getAttribute(group, "coordinateTransformations", CoordinateTransform[].class);
        if (transforms == null) {
            return null;
        }
        boolean found = false;
        for (CoordinateTransform ct : transforms) {
            System.out.println(ct);
            String nrmInput = N5URI.normalizeGroupPath((String)ct.getInput());
            System.out.println("nrmInput: " + nrmInput);
            if (!nrmInput.equals(normGrp) || !ct.getOutput().equals(output)) continue;
            System.out.println("found: " + ct);
            return ct.getTransform(n5);
        }
        return null;
    }

    public static String detectTransforms(String url) {
        N5URI uri;
        try {
            uri = new N5URI(url.trim());
        }
        catch (URISyntaxException e) {
            return null;
        }
        if (NgffTransformations.isValidTransformUri(url)) {
            return url;
        }
        if (!uri.getAttributePath().equals("coordinateTransformations[0]")) {
            try {
                String defaultUri = N5URI.from((String)uri.getContainerPath(), (String)uri.getGroupPath(), (String)"coordinateTransformations[0]").toString();
                if (NgffTransformations.isValidTransformUri(defaultUri)) {
                    return defaultUri;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isValidTransformUri(String uri) {
        Pair<CoordinateTransform<?>, N5Reader> out = NgffTransformations.openTransformN5(uri.trim());
        return out != null && out.getA() != null;
    }

    public static Pair<CoordinateTransform<?>, N5Reader> openTransformN5(String url) {
        if (url == null) {
            return null;
        }
        try {
            N5URI n5url = new N5URI(url);
            String loc = n5url.getContainerPath();
            if (loc.endsWith(".json")) {
                return new ValuePair(NgffTransformations.openJson(url), null);
            }
            N5Reader n5 = new N5Factory().gsonBuilder(NgffTransformations.gsonBuilder()).openReader(loc);
            String dataset = n5url.getGroupPath() != null ? n5url.getGroupPath() : "/";
            String attribute = n5url.getAttributePath();
            try {
                CoordinateTransform ct = (CoordinateTransform)n5.getAttribute(dataset, attribute, CoordinateTransform.class);
                NgffTransformations.resolveAbsolutePath(ct, dataset);
                return new ValuePair((Object)ct, (Object)n5);
            }
            catch (ClassCastException | N5Exception throwable) {
                try {
                    return NgffTransformations.openReference(url, n5, dataset, attribute);
                }
                catch (ClassCastException | N5Exception throwable2) {
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static void resolveAbsolutePath(CoordinateTransform<?> ct, String groupPath) {
        if (ct instanceof ParametrizedTransform) {
            ((ParametrizedTransform)ct).resolveAbsoluePath(groupPath);
        }
    }

    public static Pair<CoordinateTransform<?>, N5Reader> openReference(String url, N5Reader n5, String dataset, String attribute) {
        ReferencedCoordinateTransform ref = (ReferencedCoordinateTransform)n5.getAttribute(dataset, attribute, ReferencedCoordinateTransform.class);
        if (ref == null) {
            return null;
        }
        if (url != null && url.equals(ref.getUrl())) {
            return null;
        }
        return NgffTransformations.openTransformN5(ref.getUrl());
    }

    public static CoordinateTransform<?> openJson(String url) {
        String string;
        Path path = Paths.get(url, new String[0]);
        try {
            string = new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            return null;
        }
        Gson gson = NgffTransformations.gsonBuilder().create();
        JsonElement elem = (JsonElement)gson.fromJson(string, JsonElement.class);
        CoordinateTransform ct = (CoordinateTransform)gson.fromJson(elem, CoordinateTransform.class);
        if (ct != null) {
            CoordinateTransform nct = CoordinateTransform.create((CoordinateTransform)ct);
            return nct;
        }
        if (elem.isJsonObject()) {
            String refUrl = elem.getAsJsonObject().get("url").getAsString();
            if (url.equals(refUrl)) {
                return null;
            }
            return (CoordinateTransform)NgffTransformations.openTransformN5(refUrl).getA();
        }
        return null;
    }

    public static void save(String jsonFile, CoordinateTransform<?> transform) {
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeAdapter(CoordinateTransform.class, (Object)new CoordinateTransformAdapter());
        Gson gson = gb.create();
        try (FileWriter writer = new FileWriter(jsonFile);){
            gson.toJson(transform, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T extends NativeType<T> & RealType<T>> DisplacementFieldCoordinateTransform<?> save(N5Writer n5, String dataset, RandomAccessibleInterval<T> dfield, String inName, String outName, double[] spacing, double[] offset, String unit, int[] blockSize, Compression compression, int nThreads) {
        String[] stringArray;
        if (spacing.length == 2) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "x";
            stringArray = stringArray2;
            stringArray2[1] = "y";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "x";
            stringArray3[1] = "y";
            stringArray = stringArray3;
            stringArray3[2] = "z";
        }
        String[] axisNames = stringArray;
        CoordinateSystem inputCoordinates = new CoordinateSystem(inName, Axis.space((String)unit, (String[])axisNames));
        CoordinateSystem outputCoordinates = new CoordinateSystem(outName, Axis.space((String)unit, (String[])axisNames));
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        DisplacementFieldCoordinateTransform<?> ngffDfield = NgffTransformations.saveDisplacementFieldNgff(n5, dataset, "/", inputCoordinates, outputCoordinates, dfield, spacing, offset, blockSize, compression, threadPool);
        return ngffDfield;
    }

    public static void addCoordinateTransformations(N5Writer n5, String groupPath, CoordinateTransform<?> transform) {
        CoordinateTransform[] ctsOut;
        CoordinateTransform[] cts = (CoordinateTransform[])n5.getAttribute(groupPath, "coordinateTransformations", CoordinateTransform[].class);
        if (cts == null) {
            ctsOut = new CoordinateTransform[]{transform};
        } else {
            ctsOut = new CoordinateTransform[cts.length + 1];
            System.arraycopy(cts, 0, ctsOut, 0, cts.length);
            ctsOut[ctsOut.length - 1] = transform;
        }
        if (!n5.exists(groupPath)) {
            n5.createGroup(groupPath);
        }
        n5.setAttribute(groupPath, "coordinateTransformations", (Object)ctsOut);
    }

    public static final <T extends NativeType<T> & RealType<T>> AffineCoordinateTransform saveAffine(N5Writer n5Writer, String dataset, String metadataDataset, CoordinateSystem inputCoordinates, CoordinateSystem outputCoordinates, AffineGet affine, boolean flat, Compression compression) {
        if (flat) {
            return NgffTransformations.saveAffine(n5Writer, dataset, metadataDataset, inputCoordinates, outputCoordinates, affine.getRowPackedCopy(), compression);
        }
        int rows = affine.numTargetDimensions();
        int columns = affine.numSourceDimensions() + 1;
        int[] blockSize = new int[]{columns, rows};
        ArrayImg data = ArrayImgs.doubles((double[])affine.getRowPackedCopy(), (long[])new long[]{columns, rows});
        N5Utils.save((RandomAccessibleInterval)data, (N5Writer)n5Writer, (String)dataset, (int[])blockSize, (Compression)compression);
        String metapath = metadataDataset.equals(dataset) ? "." : metadataDataset;
        AffineCoordinateTransform ct = new AffineCoordinateTransform(null, metapath, inputCoordinates != null ? inputCoordinates.getName() : null, outputCoordinates != null ? outputCoordinates.getName() : null);
        NgffTransformations.addCoordinateTransformations(n5Writer, metadataDataset, ct);
        return ct;
    }

    public static final <T extends NativeType<T> & RealType<T>> AffineCoordinateTransform saveAffine(N5Writer n5Writer, String dataset, String metadataDataset, CoordinateSystem inputCoordinates, CoordinateSystem outputCoordinates, double[] affineParameters, Compression compression) {
        int[] blockSize = new int[]{affineParameters.length};
        ArrayImg data = ArrayImgs.doubles((double[])affineParameters, (long[])new long[]{affineParameters.length});
        N5Utils.save((RandomAccessibleInterval)data, (N5Writer)n5Writer, (String)dataset, (int[])blockSize, (Compression)compression);
        String metapath = metadataDataset.equals(dataset) ? "." : metadataDataset;
        AffineCoordinateTransform ct = new AffineCoordinateTransform(null, metapath, inputCoordinates != null ? inputCoordinates.getName() : null, outputCoordinates != null ? outputCoordinates.getName() : null);
        NgffTransformations.addCoordinateTransformations(n5Writer, metadataDataset, ct);
        return ct;
    }

    public static final <T extends NativeType<T> & RealType<T>> DisplacementFieldCoordinateTransform<?> saveDisplacementFieldNgff(N5Writer n5Writer, String dataset, String metadataDataset, CoordinateSystem inputCoordinates, CoordinateSystem outputCoordinates, RandomAccessibleInterval<T> field, double[] spacing, double[] offset, int[] blockSize, Compression compression, ExecutorService exec) {
        return (DisplacementFieldCoordinateTransform)NgffTransformations.saveFieldNgff(n5Writer, dataset, metadataDataset, inputCoordinates, outputCoordinates, TransformField.DISPLACEMENT, field, spacing, offset, blockSize, compression, exec);
    }

    public static final <T extends NativeType<T> & RealType<T>> CoordinateFieldCoordinateTransform<?> savePositionFieldNgff(N5Writer n5Writer, String dataset, String metadataDataset, CoordinateSystem inputCoordinates, CoordinateSystem outputCoordinates, RandomAccessibleInterval<T> field, double[] spacing, double[] offset, int[] blockSize, Compression compression, ExecutorService exec) {
        return (CoordinateFieldCoordinateTransform)NgffTransformations.saveFieldNgff(n5Writer, dataset, metadataDataset, inputCoordinates, outputCoordinates, TransformField.COORDINATE, field, spacing, offset, blockSize, compression, exec);
    }

    public static final <T extends NativeType<T> & RealType<T>> CoordinateTransform<?> saveFieldNgff(N5Writer n5Writer, String dataset, String metadataDataset, CoordinateSystem inputCoordinates, CoordinateSystem outputCoordinates, TransformField type, RandomAccessibleInterval<T> dfield, double[] spacing, double[] offset, int[] blockSize, Compression compression, ExecutorService exec) {
        int[] vecBlkSz;
        if (blockSize.length >= dfield.numDimensions()) {
            vecBlkSz = blockSize;
        } else {
            vecBlkSz = new int[blockSize.length + 1];
            vecBlkSz[0] = (int)dfield.dimension(0);
            for (int i = 1; i < vecBlkSz.length; ++i) {
                vecBlkSz[i] = blockSize[i - 1];
            }
        }
        try {
            N5Utils.save(dfield, (N5Writer)n5Writer, (String)dataset, (int[])vecBlkSz, (Compression)compression, (ExecutorService)exec);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        String vecFieldCsName = inputCoordinates.getName();
        CoordinateSystem[] cs = new CoordinateSystem[]{NgffTransformations.createVectorFieldCoordinateSystem(vecFieldCsName, inputCoordinates, type)};
        n5Writer.setAttribute(dataset, "coordinateSystems", (Object)cs);
        CoordinateTransform[] ct = new CoordinateTransform[]{NgffTransformations.createTransformation("", spacing, offset, dataset, cs[0])};
        n5Writer.setAttribute(dataset, "coordinateTransformations", (Object)ct);
        if (type.equals((Object)TransformField.DISPLACEMENT)) {
            return new DisplacementFieldCoordinateTransform("", dataset, "linear", inputCoordinates.getName(), outputCoordinates.getName());
        }
        return new CoordinateFieldCoordinateTransform("", dataset, "linear", inputCoordinates.getName(), outputCoordinates.getName());
    }

    public static CoordinateTransform<?> createTransformation(String name, double[] scale, double[] offset, String dataset, CoordinateSystem output) {
        Object ct = !(scale == null && !NgffTransformations.allOnes(scale) || offset == null && !NgffTransformations.allZeros(offset)) ? new SequenceCoordinateTransform(name, dataset, output.getName(), new CoordinateTransform[]{new ScaleCoordinateTransform(NgffTransformations.prepend(1.0, scale)), new TranslationCoordinateTransform(NgffTransformations.prepend(0.0, offset))}) : (offset != null || !NgffTransformations.allZeros(offset) ? new TranslationCoordinateTransform(name, dataset, output.getName(), NgffTransformations.prepend(0.0, offset)) : (scale != null || !NgffTransformations.allOnes(scale) ? new ScaleCoordinateTransform(name, dataset, output.getName(), NgffTransformations.prepend(1.0, scale)) : new IdentityCoordinateTransform(name, dataset, output.getName())));
        return ct;
    }

    private static boolean allZeros(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    private static boolean allOnes(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 1.0) continue;
            return false;
        }
        return true;
    }

    private static double[] prepend(double val, double[] array) {
        double[] out = new double[array.length + 1];
        out[0] = val;
        for (int i = 1; i < out.length; ++i) {
            out[i] = array[i - 1];
        }
        return out;
    }

    public static CoordinateSystem createVectorFieldCoordinateSystem(String name, CoordinateSystem input, TransformField type) {
        Axis[] vecAxes = new Axis[input.getAxes().length + 1];
        vecAxes[0] = type.equals((Object)TransformField.DISPLACEMENT) ? new Axis("displacement", "d", null, true) : new Axis("coordinate", "c", null, true);
        for (int i = 1; i < vecAxes.length; ++i) {
            vecAxes[i] = input.getAxes()[i - 1];
        }
        return new CoordinateSystem(name, vecAxes);
    }

    public static final int[] vectorAxisLastNgff(CoordinateSystem cs) throws Exception {
        int n;
        Axis[] axes = cs.getAxes();
        if (axes[(n = axes.length) - 1].getType().equals("displacement")) {
            return null;
        }
        int vecDim = -1;
        int[] permutation = new int[n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if (axes[i].getType().equals("displacement")) {
                vecDim = i;
                continue;
            }
            permutation[i] = k++;
        }
        if (vecDim < 0) {
            return null;
        }
        permutation[vecDim] = n - 1;
        return permutation;
    }

    public static final int[] vectorAxisLastNgff(N5Reader n5, String dataset) throws Exception {
        TransformGraph g = Common.openGraph((N5Reader)n5, (String)dataset);
        CoordinateSystem cs = (CoordinateSystem)g.getCoordinateSystems().getCollection().iterator().next();
        return NgffTransformations.vectorAxisLastNgff(cs);
    }

    public static GsonBuilder gsonBuilder() {
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeAdapter(CoordinateTransform.class, (Object)new CoordinateTransformAdapter());
        return gb;
    }

    public static CoordinateTransform<?> createAffine(AffineGet transform) {
        if (transform instanceof TranslationGet) {
            return new TranslationCoordinateTransform(((TranslationGet)transform).getTranslationCopy());
        }
        if (transform instanceof ScaleGet) {
            return new ScaleCoordinateTransform(((ScaleGet)transform).getScaleCopy());
        }
        return new AffineCoordinateTransform(transform.getRowPackedCopy());
    }

    public static enum TransformField {
        DISPLACEMENT,
        COORDINATE;

    }
}

