/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.source;

import bdv.viewer.SourceAndConverter;
import bigwarp.loader.ImagePlusLoader;
import java.util.function.Supplier;
import net.imglib2.realtransform.RealTransform;

public class SourceInfo {
    private SourceAndConverter<?> sourceAndConverter = null;
    private final int id;
    private String name;
    private Supplier<String> uriSupplier;
    private ImagePlusLoader.ColorSettings colorSettings = null;
    private final boolean moving;
    private RealTransform transform;
    private Supplier<String> transformUriSupplier;
    boolean serializable = false;

    public SourceInfo(int id, boolean moving) {
        this(id, moving, null, null, null);
    }

    public SourceInfo(int id, boolean moving, String name) {
        this(id, moving, name, () -> null, null);
    }

    public SourceInfo(int id, boolean moving, String name, Supplier<String> uriSupplier) {
        this(id, moving, name, uriSupplier, null);
    }

    public SourceInfo(int id, boolean moving, String name, Supplier<String> uriSupplier, RealTransform transform) {
        this.id = id;
        this.moving = moving;
        this.name = name;
        this.uriSupplier = uriSupplier;
        this.transform = transform;
    }

    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public String getUri() {
        return this.uriSupplier.get();
    }

    public void setUriSupplier(Supplier<String> getUri) {
        this.uriSupplier = getUri;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColorSettings(ImagePlusLoader.ColorSettings colorSettings) {
        this.colorSettings = colorSettings;
    }

    public ImagePlusLoader.ColorSettings getColorSettings() {
        return this.colorSettings;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setTransform(RealTransform transform, Supplier<String> transformUriSupplier) {
        this.transform = transform;
        this.transformUriSupplier = transformUriSupplier;
    }

    public RealTransform getTransform() {
        return this.transform;
    }

    public String getTransformUri() {
        if (this.transformUriSupplier != null) {
            return this.transformUriSupplier.get();
        }
        return null;
    }

    public SourceAndConverter<?> getSourceAndConverter() {
        return this.sourceAndConverter;
    }

    public void setSourceAndConverter(SourceAndConverter<?> sourceAndConverter) {
        this.sourceAndConverter = sourceAndConverter;
    }
}

