/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.source;

import net.imglib2.AbstractRealInterval;
import net.imglib2.AbstractRealLocalizable;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.inverse.DifferentiableRealTransform;
import net.imglib2.type.numeric.RealType;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class JacobianDeterminantRandomAccess<T extends RealType<T>>
extends AbstractRealLocalizable
implements RealRandomAccess<T> {
    protected DifferentiableRealTransform transform;
    private final T value;
    final double[] warpRes;

    protected JacobianDeterminantRandomAccess(double[] dimensions) {
        this(dimensions, null, null);
    }

    protected JacobianDeterminantRandomAccess(double[] dimensions, T value, DifferentiableRealTransform transform) {
        super(dimensions.length);
        this.setTransform(transform);
        this.value = value;
        this.warpRes = new double[this.numDimensions()];
    }

    public void setTransform(DifferentiableRealTransform transform) {
        if (transform != null) {
            this.transform = transform.copy();
        }
    }

    public T get() {
        RealType out = (RealType)this.value.copy();
        if (this.transform == null) {
            out.setZero();
            return (T)out;
        }
        double[] x = new double[this.numDimensions()];
        this.localize(x);
        AffineTransform jacobian = this.transform.jacobian(x);
        DMatrixRMaj jacMtx = new DMatrixRMaj();
        jacMtx.data = jacobian.getRowPackedCopy();
        out.setReal(CommonOps_DDRM.det((DMatrixRMaj)jacMtx));
        return (T)out;
    }

    public RealRandomAccess<T> copy() {
        return new JacobianDeterminantRandomAccess<RealType>(new double[this.position.length], (RealType)this.value.copy(), this.transform);
    }

    public RealRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    public RealRandomAccess<T> copyRealRandomAccess() {
        return this.copy();
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1.0;
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            int distance = localizable.getIntPosition(d);
            int n = d++;
            this.position[n] = this.position[n] + (double)distance;
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        localizable.localize(this.position);
    }

    public void setPosition(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
    }

    public void setPosition(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            int p = (int)pos[d];
            this.position[d] = p;
        }
    }

    public void setPosition(int pos, int d) {
        this.position[d] = pos;
    }

    public void setPosition(long pos, int d) {
        this.position[d] = (int)pos;
    }

    public void move(float distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(double distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    public void move(RealLocalizable localizable) {
        int d = 0;
        while (d < this.n) {
            double distance = localizable.getDoublePosition(d);
            int n = d++;
            this.position[n] = this.position[n] + distance;
        }
    }

    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    public void setPosition(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            double pos;
            this.position[d] = pos = localizable.getDoublePosition(d);
        }
    }

    public void setPosition(float[] p) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = p[d];
        }
    }

    public void setPosition(double[] p) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = p[d];
        }
    }

    public void setPosition(float p, int d) {
        this.position[d] = p;
    }

    public void setPosition(double p, int d) {
        this.position[d] = p;
    }

    public static class JacobianDeterminantRandomAccessibleInterval<T extends RealType<T>>
    extends AbstractRealInterval
    implements RealRandomAccessibleRealInterval<T> {
        protected final JacobianDeterminantRandomAccess<T> ra;

        public JacobianDeterminantRandomAccessibleInterval(Interval interval, T t, DifferentiableRealTransform warp) {
            super((RealInterval)interval);
            this.ra = new JacobianDeterminantRandomAccess<T>(new double[interval.numDimensions()], t, warp);
        }

        public RealRandomAccess<T> realRandomAccess() {
            return this.ra.copy();
        }

        public RealRandomAccess<T> realRandomAccess(RealInterval interval) {
            return this.realRandomAccess();
        }

        public void setTransform(DifferentiableRealTransform transform) {
            this.ra.setTransform(transform);
        }
    }
}

