/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.loader;

import bdv.img.imagestack.ImageStackImageLoader;
import bdv.img.virtualstack.VirtualStackImageLoader;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.SetupAssignments;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarpData;
import bigwarp.loader.Loader;
import bigwarp.source.SourceInfo;
import ij.ImagePlus;
import ij.process.LUT;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;

public class ImagePlusLoader
implements Loader {
    private final ImagePlus[] impList;
    private final int numSources;
    private int index;
    private boolean is3d;
    private boolean isMultiChannel;
    private boolean[] isComposite;
    private HashMap<Integer, ColorSettings> settingsMap;
    private final String[] names;

    public ImagePlusLoader(ImagePlus imp) {
        this(new ImagePlus[]{imp});
    }

    public ImagePlusLoader(ImagePlus[] impList) {
        this.impList = impList;
        int nc = 0;
        this.isComposite = new boolean[impList.length];
        for (ImagePlus ip : impList) {
            nc += ip.getNChannels();
        }
        this.names = new String[nc];
        int k = 0;
        for (ImagePlus ip : impList) {
            for (int i = 0; i < ip.getNChannels(); ++i) {
                this.names[k++] = ip.getTitle() + String.format("_ch-%d", i);
            }
        }
        this.numSources = nc;
        this.settingsMap = new HashMap();
    }

    @Deprecated
    public int numChannels() {
        return this.numSources;
    }

    @Override
    public int numSources() {
        return this.numSources;
    }

    @Override
    public String name(int i) {
        assert (i < this.numSources);
        return this.names[i];
    }

    public boolean is3d() {
        return this.is3d;
    }

    public boolean isMultiChannel() {
        return this.isMultiChannel;
    }

    public HashMap<Integer, ColorSettings> getSetupSettings() {
        return this.settingsMap;
    }

    public void update(BigWarpData<?> data) {
        for (Integer key : this.settingsMap.keySet()) {
            SourceAndConverter sac = data.sources.get(key);
            data.getSourceInfo(key).setColorSettings(this.settingsMap.get(key));
        }
    }

    public void update(SourceInfo sourceInfo) {
        sourceInfo.setColorSettings(this.settingsMap.get(sourceInfo.getId()));
    }

    public SpimDataMinimal[] load() {
        return this.loadAll(0);
    }

    public SpimDataMinimal[] loadAll(int startid) {
        SpimDataMinimal[] out = new SpimDataMinimal[this.impList.length];
        this.index = startid;
        for (int i = 0; i < this.impList.length; ++i) {
            out[i] = this.load(this.index, this.impList[i]);
            this.index += this.impList[i].getNChannels();
        }
        return out;
    }

    public static double sanitizeCalibration(double in, String dim) {
        if (Double.isNaN(in) || Double.isInfinite(in)) {
            System.err.println("WARNING: Check image calibration. dimension " + dim + " was " + in + " changing to 1.0");
            return 1.0;
        }
        return in;
    }

    public SpimDataMinimal load(int setupIdOffset, ImagePlus imp) {
        VirtualStackImageLoader imgLoader;
        double pw = ImagePlusLoader.sanitizeCalibration(imp.getCalibration().pixelWidth, "x");
        double ph = ImagePlusLoader.sanitizeCalibration(imp.getCalibration().pixelHeight, "y");
        double pd = ImagePlusLoader.sanitizeCalibration(imp.getCalibration().pixelDepth, "z");
        String punit = imp.getCalibration().getUnit();
        if (punit == null || punit.isEmpty()) {
            punit = "px";
        }
        FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(punit, new double[]{pw, ph, pd});
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getNSlices();
        int numTimepoints = imp.getNFrames();
        int numSetups = imp.getNChannels();
        FinalDimensions size = new FinalDimensions(new int[]{w, h, d});
        this.is3d = d > 1;
        boolean bl = this.isMultiChannel = numSetups > 1;
        if (imp.getStack().isVirtual()) {
            switch (imp.getType()) {
                case 0: {
                    imgLoader = VirtualStackImageLoader.createUnsignedByteInstance((ImagePlus)imp, (int)setupIdOffset);
                    break;
                }
                case 1: {
                    imgLoader = VirtualStackImageLoader.createUnsignedShortInstance((ImagePlus)imp, (int)setupIdOffset);
                    break;
                }
                case 2: {
                    imgLoader = VirtualStackImageLoader.createFloatInstance((ImagePlus)imp, (int)setupIdOffset);
                    break;
                }
                default: {
                    imgLoader = VirtualStackImageLoader.createARGBInstance((ImagePlus)imp, (int)setupIdOffset);
                    break;
                }
            }
        } else {
            switch (imp.getType()) {
                case 0: {
                    imgLoader = ImageStackImageLoader.createUnsignedByteInstance((ImagePlus)imp, (int)setupIdOffset);
                    break;
                }
                case 1: {
                    imgLoader = ImageStackImageLoader.createUnsignedShortInstance((ImagePlus)imp, (int)setupIdOffset);
                    break;
                }
                case 2: {
                    imgLoader = ImageStackImageLoader.createFloatInstance((ImagePlus)imp, (int)setupIdOffset);
                    break;
                }
                default: {
                    imgLoader = ImageStackImageLoader.createARGBInstance((ImagePlus)imp, (int)setupIdOffset);
                }
            }
        }
        File basePath = new File(".");
        HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>(numSetups);
        for (int s = 0; s < numSetups; ++s) {
            int id = setupIdOffset + s;
            String title = numSetups > 1 ? String.format("%s channel %d", imp.getTitle(), id + 1) : imp.getTitle();
            BasicViewSetup setup = new BasicViewSetup(setupIdOffset + s, title, (Dimensions)size, (VoxelDimensions)voxelSize);
            setup.setAttribute((Entity)new Channel(id + 1));
            setups.put(id, setup);
            this.settingsMap.put(id, ColorSettings.fromImagePlus(imp, id, s));
        }
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>(numTimepoints);
        for (int t = 0; t < numTimepoints; ++t) {
            timepoints.add(new TimePoint(t));
        }
        AffineTransform3D sourceTransform = new AffineTransform3D();
        sourceTransform.set(pw, 0.0, 0.0, 0.0, 0.0, ph, 0.0, 0.0, 0.0, 0.0, pd, 0.0);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (int t = 0; t < numTimepoints; ++t) {
            for (int s = 0; s < numSetups; ++s) {
                registrations.add(new ViewRegistration(t, setupIdOffset + s, sourceTransform));
            }
        }
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), setups, (BasicImgLoader)imgLoader, null);
        SpimDataMinimal spimData = new SpimDataMinimal(basePath, seq, new ViewRegistrations(registrations));
        WrapBasicImgLoader.wrapImgLoaderIfNecessary((AbstractSpimData)spimData);
        return spimData;
    }

    public static int[] range(int start, int length) {
        int[] out = new int[length];
        for (int i = 0; i < length; ++i) {
            out[i] = start + i;
        }
        return out;
    }

    public static int[] value(int value, int length) {
        int[] out = new int[length];
        Arrays.fill(out, value);
        return out;
    }

    public static class ColorSettings {
        public final int converterSetupIndex;
        public final double min;
        public final double max;
        public final ARGBType color;

        public ColorSettings(int converterSetupIndex, double min, double max, ARGBType color) {
            this.converterSetupIndex = converterSetupIndex;
            this.min = min;
            this.max = max;
            this.color = color;
        }

        public void updateSetup(SetupAssignments setups) {
            this.updateSetup((ConverterSetup)setups.getConverterSetups().get(this.converterSetupIndex));
        }

        public void updateSetup(ConverterSetup setup) {
            setup.setDisplayRange(this.min, this.max);
            if (this.color != null) {
                setup.setColor(this.color);
            }
        }

        public static ColorSettings fromImagePlus(ImagePlus imp, int converterSetupIndex, int channelOffset) {
            double min = imp.getDisplayRangeMin();
            double max = imp.getDisplayRangeMax();
            ARGBType color = null;
            LUT[] luts = imp.getLuts();
            if (luts != null && channelOffset < luts.length) {
                color = new ARGBType(luts[channelOffset].getRGB(255));
                min = luts[channelOffset].min;
                max = luts[channelOffset].max;
            }
            return new ColorSettings(converterSetupIndex, min, max, color);
        }
    }
}

