/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.landmarks;

import bdv.ij.ApplyBigwarpPlugin;
import bigwarp.BigWarp;
import bigwarp.landmarks.LandmarkTableModel;
import ij.gui.GenericDialog;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.iterator.RealIntervalIterator;
import net.imglib2.util.Intervals;

public class LandmarkGridGenerator {
    protected final double[] spacing;
    protected final RealInterval interval;

    public LandmarkGridGenerator(RealInterval interval, double[] spacing) {
        this.interval = interval;
        this.spacing = spacing;
    }

    public LandmarkGridGenerator(RealInterval interval, long[] number) {
        this.interval = interval;
        this.spacing = new double[interval.numDimensions()];
        for (int i = 0; i < interval.numDimensions(); ++i) {
            this.spacing[i] = (interval.realMax(i) - interval.realMin(i)) / (double)(number[i] - 1L);
        }
    }

    public double approxNumberOfPoints() {
        double total = 1.0;
        for (int i = 0; i < this.interval.numDimensions(); ++i) {
            total *= (this.interval.realMax(i) - this.interval.realMin(i)) / this.spacing[i] + 1.0;
        }
        return total;
    }

    public int fill(LandmarkTableModel ltm) {
        System.out.println("interval: " + Arrays.toString(Intervals.maxAsDoubleArray((RealInterval)this.interval)));
        System.out.println("spacing: " + Arrays.toString(this.spacing));
        int i = 0;
        double[] p = new double[this.interval.numDimensions()];
        RealIntervalIterator it = new RealIntervalIterator(this.interval, this.spacing);
        while (it.hasNext()) {
            it.fwd();
            it.localize(p);
            ltm.add(p, true);
            ltm.setPoint(ltm.getNextRow(false), false, p, null);
            ++i;
        }
        System.out.println("Added " + i + " pts");
        return i;
    }

    public static boolean fillFromDialog(BigWarp bw) {
        LandmarkTableModel ltm = bw.getLandmarkPanel().getTableModel();
        int nd = ltm.ndims;
        GenericDialog gd = new GenericDialog("Generate landmark grid.");
        gd.addMessage("Field of view and resolution:");
        gd.addMessage("Number of points per dimension (default)");
        gd.addNumericField("nx", 5.0, 2);
        gd.addNumericField("ny", 5.0, 2);
        if (nd > 2) {
            gd.addNumericField("nz", 5.0, 2);
        }
        gd.addMessage("Spacing");
        gd.addNumericField("sx", -1.0, 4);
        gd.addNumericField("sy", -1.0, 4);
        if (nd > 2) {
            gd.addNumericField("sz", -1.0, 4);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        double nx = gd.getNextNumber();
        double ny = gd.getNextNumber();
        double nz = -1.0;
        if (nd > 2) {
            nz = gd.getNextNumber();
        }
        double sx = gd.getNextNumber();
        double sy = gd.getNextNumber();
        double sz = 1.0;
        if (nd > 2) {
            sz = gd.getNextNumber();
        }
        double[] res = ApplyBigwarpPlugin.getResolution(bw.getData(), "Target", null);
        List<Interval> outputIntervalList = ApplyBigwarpPlugin.getPixelInterval(bw.getData(), bw.getLandmarkPanel().getTableModel(), null, "Target", null, null, null, null, res);
        Interval pixelInterval = outputIntervalList.get(0);
        double[] max = new double[nd];
        for (int i = 0; i < nd; ++i) {
            max[i] = res[i] * (double)pixelInterval.dimension(i);
        }
        FinalRealInterval interval = new FinalRealInterval(new double[nd], max);
        LandmarkGridGenerator gen = sx > 0.0 || sy > 0.0 || sz > 0.0 ? new LandmarkGridGenerator((RealInterval)interval, new double[]{sx, sy, sz}) : new LandmarkGridGenerator((RealInterval)interval, new long[]{(long)nx, (long)ny, (long)nz});
        double N = gen.approxNumberOfPoints();
        if (N > 1.0) {
            GenericDialog warningDialog = new GenericDialog("Warning");
            warningDialog.addMessage("You are about to add approximately\n" + Math.round(N) + "\npoints.");
            warningDialog.addMessage("This could cause Bigwarp to be slow or crash.");
            warningDialog.addMessage("Proceed?");
            warningDialog.showDialog();
            if (warningDialog.wasCanceled()) {
                return false;
            }
        }
        gen.fill(ltm);
        return true;
    }

    public static void main(String[] args) throws IOException {
        File f = new File("/home/john/landmarkGrid.csv");
        LandmarkGridGenerator grid = new LandmarkGridGenerator((RealInterval)new FinalRealInterval(new double[]{0.0, 0.0, 0.0}, new double[]{200.0, 100.0, 50.0}), new long[]{10L, 10L, 10L});
        LandmarkTableModel ltm = new LandmarkTableModel(3);
        grid.fill(ltm);
        ltm.save(f);
    }
}

