/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.gui.AutosaveOptionsPanel;
import bdv.gui.MaskOptionsPanel;
import bdv.gui.TransformGraphPanel;
import bdv.gui.TransformTypePanel;
import bdv.viewer.BigWarpViewerSettings;
import bigwarp.BigWarp;
import bigwarp.source.GridSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.miginfocom.swing.MigLayout;

public class WarpVisFrame
extends JDialog {
    private static final long serialVersionUID = 7561228647761694686L;
    private final BigWarp<?> bw;
    private final BigWarpViewerSettings settings;
    protected ButtonGroup visTypeGroup;
    protected JRadioButton setWarpVisOffButton;
    protected JRadioButton setWarpGridButton;
    protected JRadioButton setWarpMagButton;
    protected JRadioButton setJacobianDetButton;
    protected JLabel noOptionsLabel;
    protected final JButton landmarkColorButton;
    private final JColorChooser colorChooser;
    protected final JSlider landmarkSizeSlider;
    protected ButtonGroup warpMagButtons;
    protected JRadioButton warpMagAffineButton;
    protected JRadioButton warpMagSimilarityButton;
    protected JRadioButton warpMagRigidButton;
    protected ButtonGroup warpGridButtons;
    protected JRadioButton warpGridLineButton;
    protected JRadioButton warpGridModButton;
    protected JSlider gridSpacingSlider;
    protected JSlider gridWidthSlider;
    protected Component bigSpace;
    protected Component smallSpace;
    protected JLabel gridSpacingLabel;
    protected JLabel gridWidthLabel;
    final JSpinner toleranceSpinner;
    final JSpinner maxIterSpinner;
    final JComboBox bboxMethodDropdown;
    final JSpinner samplesPerDimSpinner;
    final MaskOptionsPanel maskOptionsPanel;
    final TransformTypePanel transformTypePanel;
    final TransformGraphPanel transformGraphPanel;
    private final AutosaveOptionsPanel autoSaveOptionsPanel;
    public static final int minGridSpacing = 5;
    public static final int maxGridSpacing = 400;
    public static final int defaultGridSpacing = 100;
    public static final int minGridWidth = 1;
    public static final int maxGridWidth = 50;
    public static final int defaultGridWidth = 5;

    public WarpVisFrame(Frame owner, final BigWarp<?> bw) {
        super(owner, "Bigwarp options", false);
        this.bw = bw;
        this.settings = bw.viewerSettings;
        Container content = this.getContentPane();
        this.setSize(500, 400);
        JPanel landmarkPointOptionsPanel = new JPanel();
        landmarkPointOptionsPanel.setLayout(new BoxLayout(landmarkPointOptionsPanel, 0));
        this.landmarkColorButton = new JButton(new ColorIcon(this.settings.getSpotColor()));
        this.colorChooser = new JColorChooser();
        this.landmarkSizeSlider = new JSlider();
        this.landmarkSizeSlider.setValue((int)this.settings.getSpotSize());
        this.landmarkSizeSlider.setMinimum(1);
        this.landmarkSizeSlider.setMaximum(96);
        landmarkPointOptionsPanel.add(this.landmarkColorButton);
        landmarkPointOptionsPanel.add(this.landmarkSizeSlider);
        landmarkPointOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "landmark size & color"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        JPanel visTypePanel = new JPanel();
        visTypePanel.setLayout(new BoxLayout(visTypePanel, 1));
        visTypePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "warp display"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        JPanel typeOptionPanel = new JPanel();
        typeOptionPanel.setLayout(new BoxLayout(typeOptionPanel, 1));
        typeOptionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "options"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        this.noOptionsLabel = new JLabel("None");
        this.visTypeGroup = new ButtonGroup();
        this.setWarpVisOffButton = new JRadioButton("Off");
        this.setWarpGridButton = new JRadioButton("Grid");
        this.setWarpMagButton = new JRadioButton("Magnitude");
        this.setJacobianDetButton = new JRadioButton("Jacobian Determinant");
        this.visTypeGroup.add(this.setWarpVisOffButton);
        this.visTypeGroup.add(this.setWarpGridButton);
        this.visTypeGroup.add(this.setWarpMagButton);
        this.visTypeGroup.add(this.setJacobianDetButton);
        this.setWarpVisOffButton.setSelected(true);
        visTypePanel.add(this.setWarpVisOffButton);
        visTypePanel.add(this.setWarpGridButton);
        visTypePanel.add(this.setWarpMagButton);
        visTypePanel.add(this.setJacobianDetButton);
        this.warpMagAffineButton = new JRadioButton("Affine baseline");
        this.warpMagSimilarityButton = new JRadioButton("Similarity baseline");
        this.warpMagRigidButton = new JRadioButton("Rigid baseline");
        this.warpMagButtons = new ButtonGroup();
        this.warpMagButtons.add(this.warpMagAffineButton);
        this.warpMagButtons.add(this.warpMagSimilarityButton);
        this.warpMagButtons.add(this.warpMagRigidButton);
        this.warpGridLineButton = new JRadioButton("Line grid ");
        this.warpGridModButton = new JRadioButton("Modulo grid");
        this.warpGridButtons = new ButtonGroup();
        this.warpGridButtons.add(this.warpGridLineButton);
        this.warpGridButtons.add(this.warpGridModButton);
        this.warpGridLineButton.setSelected(true);
        this.gridSpacingSlider = new JSlider(0, 5, 400, 100);
        this.gridWidthSlider = new JSlider(0, 1, 50, 5);
        this.gridSpacingLabel = new JLabel("Grid Spacing", 0);
        this.gridWidthLabel = new JLabel("Grid Width", 0);
        this.gridSpacingLabel.setAlignmentX(0.5f);
        this.gridWidthLabel.setAlignmentX(0.5f);
        this.bigSpace = Box.createVerticalStrut(20);
        this.smallSpace = Box.createVerticalStrut(10);
        typeOptionPanel.add(this.warpMagAffineButton);
        typeOptionPanel.add(this.warpMagSimilarityButton);
        typeOptionPanel.add(this.warpMagRigidButton);
        typeOptionPanel.add(this.warpGridLineButton);
        typeOptionPanel.add(this.warpGridModButton);
        typeOptionPanel.add(this.bigSpace);
        typeOptionPanel.add(this.gridSpacingLabel);
        typeOptionPanel.add(this.gridSpacingSlider);
        typeOptionPanel.add(this.smallSpace);
        typeOptionPanel.add(this.gridWidthLabel);
        typeOptionPanel.add(this.gridWidthSlider);
        typeOptionPanel.add(this.noOptionsLabel);
        JPanel inverseOptionsPanel = new JPanel();
        inverseOptionsPanel.setLayout(new BorderLayout(10, 10));
        inverseOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Inverse options"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        JPanel tolerancePanel = new JPanel();
        this.toleranceSpinner = new JSpinner();
        SpinnerNumberModel tolmodel = new SpinnerNumberModel(0.5, 0.001, 200.0, 0.1);
        this.toleranceSpinner.setModel(tolmodel);
        this.toleranceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                bw.getLandmarkPanel().getTableModel().setInverseThreshold((Double)WarpVisFrame.this.toleranceSpinner.getValue());
                bw.getBwTransform().setInverseTolerance((Double)WarpVisFrame.this.toleranceSpinner.getValue());
            }
        });
        tolerancePanel.add((Component)new JLabel("Inverse error", 0), "West");
        tolerancePanel.add((Component)this.toleranceSpinner, "East");
        JPanel maxIterPanel = new JPanel();
        this.maxIterSpinner = new JSpinner();
        SpinnerNumberModel itermodel = new SpinnerNumberModel(200, 1, 5000, 1);
        this.maxIterSpinner.setModel(itermodel);
        this.maxIterSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                bw.getLandmarkPanel().getTableModel().setMaxInverseIterations((Integer)WarpVisFrame.this.maxIterSpinner.getValue());
                bw.getBwTransform().setInverseMaxIterations((Integer)WarpVisFrame.this.maxIterSpinner.getValue());
            }
        });
        maxIterPanel.add((Component)new JLabel("Max iterations", 0), "West");
        maxIterPanel.add((Component)this.maxIterSpinner, "East");
        inverseOptionsPanel.add((Component)tolerancePanel, "North");
        inverseOptionsPanel.add((Component)maxIterPanel, "South");
        JPanel bboxPanel = new JPanel();
        bboxPanel.setLayout(new BorderLayout(10, 10));
        bboxPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Bounding box options"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        JPanel bboxMethodPanel = new JPanel();
        String[] methodStrings = new String[]{BoundingBoxEstimation.Method.CORNERS.toString(), BoundingBoxEstimation.Method.FACES.toString(), BoundingBoxEstimation.Method.VOLUME.toString()};
        this.bboxMethodDropdown = new JComboBox<String>(methodStrings);
        this.bboxMethodDropdown.setSelectedIndex(1);
        this.bboxMethodDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String methodString = (String)WarpVisFrame.this.bboxMethodDropdown.getSelectedItem();
                bw.getBoxEstimation().setMethod(methodString);
                bw.updateSourceBoundingBoxEstimators();
            }
        });
        bboxMethodPanel.add((Component)new JLabel("Estimation method", 0), "West");
        bboxMethodPanel.add((Component)this.bboxMethodDropdown, "East");
        JPanel samplerPerDimPanel = new JPanel();
        this.samplesPerDimSpinner = new JSpinner();
        SpinnerNumberModel samplesmodel = new SpinnerNumberModel(3, 1, 1000, 1);
        this.samplesPerDimSpinner.setModel(samplesmodel);
        this.samplesPerDimSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                bw.getBoxEstimation().setSamplesPerDim((Integer)WarpVisFrame.this.samplesPerDimSpinner.getValue());
                bw.updateSourceBoundingBoxEstimators();
            }
        });
        samplerPerDimPanel.add((Component)new JLabel("Num samples", 0), "West");
        samplerPerDimPanel.add((Component)this.samplesPerDimSpinner, "East");
        bboxPanel.add((Component)bboxMethodPanel, "North");
        bboxPanel.add((Component)samplerPerDimPanel, "South");
        this.maskOptionsPanel = new MaskOptionsPanel(bw);
        this.maskOptionsPanel.addActions();
        this.transformTypePanel = new TransformTypePanel(bw);
        this.transformGraphPanel = new TransformGraphPanel(bw, bw.viewerQ, content);
        this.autoSaveOptionsPanel = new AutosaveOptionsPanel(bw, content);
        content.setLayout(new GridBagLayout());
        GridBagConstraints gbcContent = new GridBagConstraints();
        gbcContent.gridx = 0;
        gbcContent.gridy = 0;
        gbcContent.gridwidth = 3;
        gbcContent.fill = 2;
        gbcContent.anchor = 10;
        gbcContent.weightx = 1.0;
        gbcContent.weighty = 1.0;
        gbcContent.insets = new Insets(1, 1, 1, 1);
        content.add((Component)this.transformTypePanel, gbcContent);
        gbcContent.gridx = 0;
        gbcContent.gridy = 1;
        content.add((Component)landmarkPointOptionsPanel, gbcContent);
        gbcContent.gridx = 0;
        gbcContent.gridy = 2;
        content.add((Component)this.transformGraphPanel, gbcContent);
        gbcContent.gridx = 0;
        gbcContent.gridy = 3;
        gbcContent.gridwidth = 1;
        gbcContent.anchor = 17;
        content.add((Component)visTypePanel, gbcContent);
        gbcContent.gridx = 1;
        gbcContent.gridwidth = 2;
        gbcContent.anchor = 13;
        content.add((Component)typeOptionPanel, gbcContent);
        gbcContent.gridx = 0;
        gbcContent.gridy = 4;
        gbcContent.gridwidth = 3;
        content.add((Component)inverseOptionsPanel, gbcContent);
        gbcContent.gridx = 0;
        gbcContent.gridy = 5;
        gbcContent.gridwidth = 3;
        content.add((Component)bboxPanel, gbcContent);
        gbcContent.gridy = 6;
        content.add((Component)this.maskOptionsPanel, gbcContent);
        gbcContent.gridy = 7;
        JPanel toggle2DPanel = new JPanel((LayoutManager)new MigLayout("", "[grow][][grow]"));
        JCheckBox toggle2D = new JCheckBox("Is 2D");
        toggle2DPanel.add((Component)toggle2D, "cell 1 0");
        toggle2D.addActionListener(e -> bw.changeDimensionality(toggle2D.isSelected()));
        content.add((Component)toggle2DPanel, gbcContent);
        gbcContent.gridy = 8;
        content.add((Component)this.getAutoSaveOptionsPanel(), gbcContent);
        this.setDefaultCloseOperation(1);
        this.addListeners();
        this.updateOptions();
    }

    public void setActions() {
        ActionMap actionMap = this.bw.getViewerFrameP().getKeybindings().getConcatenatedActionMap();
        this.landmarkColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarpVisFrame.this.colorChooser.setColor(WarpVisFrame.this.settings.getSpotColor());
                JDialog d = JColorChooser.createDialog(WarpVisFrame.this.landmarkColorButton, "Choose a color", true, WarpVisFrame.this.colorChooser, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Color c = WarpVisFrame.this.colorChooser.getColor();
                        if (c != null) {
                            WarpVisFrame.this.landmarkColorButton.setIcon(new ColorIcon(c));
                            WarpVisFrame.this.bw.setSpotColor(c);
                        }
                    }
                }, null);
                d.setVisible(true);
            }
        });
        this.landmarkSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() != WarpVisFrame.this.landmarkSizeSlider) {
                    return;
                }
                WarpVisFrame.this.settings.setSpotSize(WarpVisFrame.this.landmarkSizeSlider.getValue());
                ((WarpVisFrame)WarpVisFrame.this).bw.viewerP.requestRepaint();
                ((WarpVisFrame)WarpVisFrame.this).bw.viewerQ.requestRepaint();
            }
        });
        this.setWarpVisOffButton.setAction(actionMap.get(String.format("set warp vis type %s", new Object[]{BigWarp.WarpVisType.NONE})));
        this.setWarpGridButton.setAction(actionMap.get(String.format("set warp vis type %s", new Object[]{BigWarp.WarpVisType.GRID})));
        this.setWarpMagButton.setAction(actionMap.get(String.format("set warp vis type %s", new Object[]{BigWarp.WarpVisType.WARPMAG})));
        this.setJacobianDetButton.setAction(actionMap.get(String.format("set warp vis type %s", new Object[]{BigWarp.WarpVisType.JACDET})));
        this.setWarpVisOffButton.setText("Off");
        this.setWarpGridButton.setText("Grid");
        this.setWarpMagButton.setText("Magnitude");
        this.setJacobianDetButton.setText("Jacobian Determinant");
        this.warpMagAffineButton.setAction(actionMap.get(String.format("set warpmag base %s", this.bw.baseXfmList[0].getClass().getName())));
        this.warpMagSimilarityButton.setAction(actionMap.get(String.format("set warpmag base %s", this.bw.baseXfmList[1].getClass().getName())));
        this.warpMagRigidButton.setAction(actionMap.get(String.format("set warpmag base %s", this.bw.baseXfmList[2].getClass().getName())));
        this.warpMagAffineButton.setText("Affine");
        this.warpMagSimilarityButton.setText("Similarity");
        this.warpMagRigidButton.setText("Rigid");
        this.warpGridLineButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (WarpVisFrame.this.warpGridLineButton.isSelected()) {
                    WarpVisFrame.this.bw.setWarpVisGridType(GridSource.GRID_TYPE.LINE);
                }
            }
        });
        this.warpGridModButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (WarpVisFrame.this.warpGridModButton.isSelected()) {
                    WarpVisFrame.this.bw.setWarpVisGridType(GridSource.GRID_TYPE.MOD);
                }
            }
        });
        this.warpGridLineButton.setText("Line");
        this.warpGridModButton.setText("Modulo");
    }

    public void addListeners() {
        VisOptUiListener visOptListener = new VisOptUiListener();
        this.setWarpVisOffButton.addChangeListener(visOptListener);
        this.setWarpGridButton.addChangeListener(visOptListener);
        this.setWarpMagButton.addChangeListener(visOptListener);
        this.gridSpacingSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() != WarpVisFrame.this.gridSpacingSlider) {
                    return;
                }
                WarpVisFrame.this.bw.setWarpGridSpacing(WarpVisFrame.this.gridSpacingSlider.getValue());
            }
        });
        this.gridWidthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() != WarpVisFrame.this.gridWidthSlider) {
                    return;
                }
                WarpVisFrame.this.bw.setWarpGridWidth(WarpVisFrame.this.gridWidthSlider.getValue());
            }
        });
    }

    private void setGridOptionsVisibility(boolean isVisible) {
        Enumeration<AbstractButton> elems = this.warpGridButtons.getElements();
        while (elems.hasMoreElements()) {
            elems.nextElement().setVisible(isVisible);
        }
        this.gridSpacingSlider.setVisible(isVisible);
        this.gridWidthSlider.setVisible(isVisible);
        this.bigSpace.setVisible(isVisible);
        this.gridSpacingLabel.setVisible(isVisible);
        this.gridWidthLabel.setVisible(isVisible);
    }

    private void setMagOptionsVisibility(boolean isVisible) {
        Enumeration<AbstractButton> elems = this.warpMagButtons.getElements();
        while (elems.hasMoreElements()) {
            elems.nextElement().setVisible(isVisible);
        }
    }

    public synchronized void updateOptions() {
        if (this.setWarpVisOffButton.isSelected()) {
            this.noOptionsLabel.setVisible(true);
            this.setGridOptionsVisibility(false);
            this.setMagOptionsVisibility(false);
        } else if (this.setWarpGridButton.isSelected()) {
            this.noOptionsLabel.setVisible(false);
            this.setGridOptionsVisibility(true);
            this.setMagOptionsVisibility(false);
        } else if (this.setWarpMagButton.isSelected()) {
            this.noOptionsLabel.setVisible(false);
            this.setGridOptionsVisibility(false);
            this.setMagOptionsVisibility(true);
        }
        this.pack();
    }

    public boolean autoEstimateMask() {
        return this.maskOptionsPanel.getAutoEstimateMaskButton().isSelected();
    }

    public AutosaveOptionsPanel getAutoSaveOptionsPanel() {
        return this.autoSaveOptionsPanel;
    }

    private static class ColorIcon
    implements Icon {
        private final int size = 16;
        private final Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.color);
            g2d.fillOval(x, y, 16, 16);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    private class VisOptUiListener
    implements ChangeListener {
        private VisOptUiListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            WarpVisFrame.this.updateOptions();
        }
    }
}

