/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterConsole;
import bdv.img.WarpedSource;
import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarpARGBExporter;
import bigwarp.BigWarpData;
import bigwarp.BigWarpRealExporter;
import ij.IJ;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BigWarpExporter<T> {
    protected final List<SourceAndConverter<T>> sources;
    private List<ImagePlus> outputList;
    protected final BigWarpData<T> bwData;
    protected AffineTransform3D pixelRenderToPhysical;
    protected AffineTransform3D resolutionTransform;
    protected AffineTransform3D offsetTransform;
    protected Interval outputInterval;
    protected Interpolation interp;
    protected boolean isVirtual = false;
    protected int nThreads = 1;
    protected ExportThread exportThread;
    protected String nameSuffix = "";
    protected String unit = "pixel";
    protected ProgressWriter progress;
    public ParallelizationPolicy policy = ParallelizationPolicy.ITER;
    private ImagePlus result;
    private boolean showResult = true;
    protected static Logger logger = LoggerFactory.getLogger(BigWarpExporter.class);
    private String exportPath;

    public BigWarpExporter(BigWarpData<T> bwData, List<ConverterSetup> convSetups, Interpolation interp, ProgressWriter progress) {
        this.bwData = bwData;
        this.sources = new ArrayList<SourceAndConverter<T>>();
        for (SourceAndConverter sac : bwData.sources) {
            WarpedSource srcCopy = null;
            WarpedSource src = sac.getSpimSource();
            if (src instanceof WarpedSource) {
                WarpedSource ws = (WarpedSource)sac.getSpimSource();
                WarpedSource wsCopy = new WarpedSource(ws.getWrappedSource(), ws.getName());
                if (ws.getTransform() != null) {
                    wsCopy.updateTransform(ws.getTransform().copy());
                    wsCopy.setIsTransformed(true);
                }
                srcCopy = wsCopy;
            } else {
                srcCopy = src;
            }
            SourceAndConverter copy = new SourceAndConverter((Source)srcCopy, sac.getConverter());
            this.sources.add(copy);
        }
        this.progress = progress == null ? new ProgressWriterConsole() : progress;
        this.setInterp(interp);
        this.pixelRenderToPhysical = new AffineTransform3D();
        this.resolutionTransform = new AffineTransform3D();
        this.offsetTransform = new AffineTransform3D();
        try {
            this.unit = bwData.getTargetSource(0).getSpimSource().getVoxelDimensions().unit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract RandomAccessibleInterval<?> exportRai();

    public abstract ImagePlus export();

    public abstract boolean isRGB();

    public void showResult(boolean showResult) {
        this.showResult = showResult;
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    public void setOutputList(List<ImagePlus> outputList) {
        this.outputList = outputList;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setInterp(Interpolation interp) {
        this.interp = interp;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public void setParallelizationPolicy(ParallelizationPolicy policy) {
        this.policy = policy;
    }

    public void setNumThreads(int nThreads) {
        this.nThreads = nThreads;
    }

    public void setNameSuffix(String suffix) {
        this.nameSuffix = suffix;
    }

    public void setRenderResolution(double ... res) {
        for (int i = 0; i < res.length; ++i) {
            this.resolutionTransform.set(res[i], i, i);
        }
    }

    public void setOffset(double ... offset) {
        for (int i = 0; i < offset.length; ++i) {
            this.offsetTransform.set(offset[i], i, 3);
        }
    }

    public void buildTotalRenderTransform() {
        this.pixelRenderToPhysical.identity();
        this.pixelRenderToPhysical.concatenate(this.resolutionTransform);
        this.pixelRenderToPhysical.concatenate(this.offsetTransform);
    }

    public void setInterval(Interval outputInterval) {
        this.outputInterval = outputInterval;
    }

    public <T> RandomAccessibleInterval<T> exportSource(SourceAndConverter<T> src) {
        RealRandomAccessible raiRaw = src.getSpimSource().getInterpolatedSource(0, 0, this.interp);
        AffineRandomAccessible rai = RealViews.affine((RealRandomAccessible)raiRaw, (AffineGet)this.pixelRenderToPhysical.inverse());
        return Views.interval((RandomAccessible)Views.raster((RealRandomAccessible)rai), (Interval)this.outputInterval);
    }

    public static void updateBrightnessContrast(ImagePlus imp, List<ConverterSetup> convSetups, int[] indexList) {
        assert (imp.getNChannels() == indexList.length);
        for (int i = 0; i < indexList.length; ++i) {
            ConverterSetup setup = convSetups.get(indexList[i]);
            double rngmin = setup.getDisplayRangeMin();
            double rngmax = setup.getDisplayRangeMax();
            imp.setC(i + 1);
            imp.setDisplayRange(rngmin, rngmax);
            imp.updateAndDraw();
        }
    }

    public static void updateBrightnessContrast(ImagePlus imp, List<ConverterSetup> convSetups) {
        for (int i = 0; i < convSetups.size(); ++i) {
            ConverterSetup setup = convSetups.get(i);
            double rngmin = setup.getDisplayRangeMin();
            double rngmax = setup.getDisplayRangeMax();
            imp.setC(i + 1);
            imp.setDisplayRange(rngmin, rngmax);
            imp.updateAndDraw();
        }
    }

    public static void updateBrightnessContrast(ImagePlus imp, BigWarpData<?> bwdata, int[] indexList) {
        assert (imp.getNChannels() == indexList.length);
        for (int i = 0; i < indexList.length; ++i) {
            ConverterSetup setup = bwdata.converterSetups.get(indexList[i]);
            double rngmin = setup.getDisplayRangeMin();
            double rngmax = setup.getDisplayRangeMax();
            imp.setC(i + 1);
            imp.setDisplayRange(rngmin, rngmax);
            imp.updateAndDraw();
        }
    }

    public FinalInterval destinationIntervalFromLandmarks(ArrayList<Double[]> pts, boolean isMoving) {
        int nd = pts.get(0).length;
        long[] min = new long[nd];
        long[] max = new long[nd];
        Arrays.fill(min, Long.MAX_VALUE);
        Arrays.fill(max, Long.MIN_VALUE);
        for (Double[] pt : pts) {
            for (int d = 0; d < nd; ++d) {
                if (pt[d] > (double)max[d]) {
                    max[d] = (long)Math.ceil(pt[d]);
                }
                if (!(pt[d] < (double)min[d])) continue;
                min[d] = (long)Math.floor(pt[d]);
            }
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval getSubInterval(Interval interval, int d, long start, long end) {
        int nd = interval.numDimensions();
        long[] min = new long[nd];
        long[] max = new long[nd];
        for (int i = 0; i < nd; ++i) {
            if (i == d) {
                min[i] = start;
                max[i] = end - 1L;
                continue;
            }
            min[i] = interval.min(i);
            max[i] = interval.max(i);
        }
        return new FinalInterval(min, max);
    }

    public <T extends NumericType<T>> RandomAccessibleInterval<T> copyToImageStack(RandomAccessible<T> raible, Interval itvl, ImgFactory<T> factory, int nThreads) {
        Img target = factory.create((Dimensions)itvl);
        if (this.policy == ParallelizationPolicy.ITER) {
            return BigWarpExporter.copyToImageStackIterOrder(raible, itvl, target, nThreads, this.progress);
        }
        return BigWarpExporter.copyToImageStackBySlice(raible, itvl, target, nThreads, this.progress);
    }

    public static <T extends NumericType<T>> RandomAccessibleInterval<T> copyToImageStackBySlice(RandomAccessible<T> raible, Interval itvl, ImgFactory<T> factory, int nThreads, ProgressWriter progress) {
        Img target = factory.create((Dimensions)itvl);
        return BigWarpExporter.copyToImageStackBySlice(raible, itvl, target, nThreads, progress);
    }

    public static <T extends NumericType<T>> RandomAccessibleInterval<T> copyToImageStackBySlice(RandomAccessible<T> ra, Interval itvl, final RandomAccessibleInterval<T> target, int nThreads, final ProgressWriter progress) {
        int tmp;
        final MixedTransformView raible = Views.permute(ra, (int)2, (int)3);
        int nd = raible.numDimensions();
        for (tmp = nd - 1; tmp >= 0 && target.dimension(tmp) <= 1L; --tmp) {
        }
        final int dim2split = tmp;
        long[] splitPoints = new long[nThreads + 1];
        long N = target.dimension(dim2split);
        long del = N / (long)nThreads;
        splitPoints[0] = 0L;
        splitPoints[nThreads] = target.dimension(dim2split);
        for (int i = 1; i < nThreads; ++i) {
            splitPoints[i] = splitPoints[i - 1] + del;
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        LinkedList<1> jobs = new LinkedList<1>();
        for (int i = 0; i < nThreads; ++i) {
            final long start = splitPoints[i];
            final long end = splitPoints[i + 1];
            jobs.add(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        FinalInterval subItvl = BigWarpExporter.getSubInterval((Interval)target, dim2split, start, end);
                        IntervalView subTgt = Views.interval((RandomAccessible)target, (Interval)subItvl);
                        long N = Intervals.numElements((Dimensions)subTgt);
                        Cursor c = subTgt.cursor();
                        RandomAccess ra = raible.randomAccess();
                        long j = 0L;
                        while (c.hasNext()) {
                            c.fwd();
                            ra.setPosition((Localizable)c);
                            ((NumericType)c.get()).set((Type)ra.get());
                            if (start == 0L && j % 100000L == 0L) {
                                double ratio = 1.0 * (double)j / (double)N;
                                progress.setProgress(ratio);
                            }
                            ++j;
                        }
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            });
        }
        try {
            threadPool.invokeAll(jobs);
            threadPool.shutdown();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        progress.setProgress(1.0);
        return target;
    }

    public static <T extends NumericType<T>> RandomAccessibleInterval<T> copyToImageStackIterOrder(RandomAccessible<T> raible, Interval itvl, ImgFactory<T> factory, int nThreads, ProgressWriter progress) {
        Img target = factory.create((Dimensions)itvl);
        return BigWarpExporter.copyToImageStackIterOrder(raible, itvl, target, nThreads, progress);
    }

    public static <T extends NumericType<T>> RandomAccessibleInterval<T> copyToImageStackIterOrder(RandomAccessible<T> ra, Interval itvl, final RandomAccessibleInterval<T> target, final int nThreads, final ProgressWriter progress) {
        progress.setProgress(0.0);
        final MixedTransformView raible = Views.permute(ra, (int)2, (int)3);
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        LinkedList<2> jobs = new LinkedList<2>();
        int i = 0;
        while (i < nThreads) {
            final int offset = i++;
            jobs.add(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        IterableInterval it = Views.flatIterable((RandomAccessibleInterval)target);
                        RandomAccess access = raible.randomAccess();
                        long N = it.size();
                        Cursor c = it.cursor();
                        c.jumpFwd((long)(1 + offset));
                        for (long j = (long)offset; j < N; j += (long)nThreads) {
                            access.setPosition((Localizable)c);
                            ((NumericType)c.get()).set((Type)access.get());
                            c.jumpFwd((long)nThreads);
                            if (offset != 0 || j % (long)(nThreads * 100000) != 0L) continue;
                            double ratio = 1.0 * (double)j / (double)N;
                            progress.setProgress(ratio);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            });
        }
        try {
            threadPool.invokeAll(jobs);
            threadPool.shutdown();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        progress.setProgress(1.0);
        return target;
    }

    public static FinalInterval transformRealInterval(RealTransform xfm, RealInterval interval) {
        int d;
        int nd = interval.numDimensions();
        double[] pt = new double[nd];
        double[] ptxfm = new double[nd];
        long[] min = new long[nd];
        long[] max = new long[nd];
        for (d = 0; d < nd; ++d) {
            pt[d] = interval.realMin(d);
        }
        xfm.apply(pt, ptxfm);
        BigWarpExporter.copyToLongFloor(ptxfm, min);
        for (d = 0; d < nd; ++d) {
            pt[d] = interval.realMax(d);
        }
        xfm.apply(pt, ptxfm);
        BigWarpExporter.copyToLongCeil(ptxfm, max);
        return new FinalInterval(min, max);
    }

    public static FinalInterval transformIntervalMinMax(RealTransform xfm, Interval interval) {
        int d;
        int nd = interval.numDimensions();
        double[] pt = new double[nd];
        double[] ptxfm = new double[nd];
        long[] min = new long[nd];
        long[] max = new long[nd];
        for (d = 0; d < nd; ++d) {
            pt[d] = interval.min(d);
        }
        xfm.apply(pt, ptxfm);
        BigWarpExporter.copyToLongFloor(ptxfm, min);
        for (d = 0; d < nd; ++d) {
            pt[d] = interval.max(d);
        }
        xfm.apply(pt, ptxfm);
        BigWarpExporter.copyToLongCeil(ptxfm, max);
        return new FinalInterval(min, max);
    }

    public static void estimateAffineFromCorners(AffineTransform3D affine, RealTransform xfm, Interval interval) {
        AffineModel2D model;
        int N;
        if (xfm == null) {
            return;
        }
        int nd = interval.numDimensions();
        if (nd == 2) {
            N = 4;
            model = new AffineModel2D();
        } else {
            N = 8;
            model = new AffineModel3D();
        }
        double[][] mvgPts = new double[nd][N];
        double[][] tgtPts = new double[nd][N];
        double[] w = new double[N];
        Arrays.fill(w, 1.0);
        double[] pt = new double[nd];
        double[] ptxfm = new double[nd];
        long[] unitInterval = new long[nd];
        Arrays.fill(unitInterval, 2L);
        int i = 0;
        IntervalIterator it = new IntervalIterator(unitInterval);
        while (it.hasNext()) {
            int d;
            it.fwd();
            for (d = 0; d < nd; ++d) {
                pt[d] = it.getLongPosition(d) == 0L ? (double)interval.min(d) : (double)interval.max(d);
            }
            xfm.apply(pt, ptxfm);
            for (d = 0; d < nd; ++d) {
                mvgPts[d][i] = pt[d];
                tgtPts[d][i] = ptxfm[d];
            }
            ++i;
        }
        try {
            model.fit(mvgPts, tgtPts, w);
        }
        catch (Exception e) {
            affine.identity();
            return;
        }
        if (nd == 2) {
            double[] mat = new double[6];
            model.toArray(mat);
            affine.set(mat);
        } else {
            double[] mat = new double[12];
            ((AffineModel3D)model).getMatrix(mat);
            affine.set(mat);
        }
    }

    public static FinalInterval estimateBounds(RealTransform xfm, Interval interval) {
        if (xfm == null) {
            return new FinalInterval(Intervals.minAsLongArray((Interval)interval), Intervals.maxAsLongArray((Interval)interval));
        }
        int nd = interval.numDimensions();
        double[] pt = new double[nd];
        double[] ptxfm = new double[nd];
        long[] min = new long[nd];
        long[] max = new long[nd];
        Arrays.fill(min, Long.MAX_VALUE);
        Arrays.fill(max, Long.MIN_VALUE);
        long[] unitInterval = new long[nd];
        Arrays.fill(unitInterval, 2L);
        IntervalIterator it = new IntervalIterator(unitInterval);
        while (it.hasNext()) {
            int d;
            it.fwd();
            for (d = 0; d < nd; ++d) {
                pt[d] = it.getLongPosition(d) == 0L ? (double)interval.min(d) : (double)interval.max(d);
            }
            xfm.apply(pt, ptxfm);
            for (d = 0; d < nd; ++d) {
                long lo = (long)Math.floor(ptxfm[d]);
                long hi = (long)Math.ceil(ptxfm[d]);
                if (lo < min[d]) {
                    min[d] = lo;
                }
                if (hi <= max[d]) continue;
                max[d] = hi;
            }
        }
        return new FinalInterval(min, max);
    }

    public static void copyToLongFloor(double[] src, long[] dst) {
        for (int d = 0; d < src.length; ++d) {
            dst[d] = (long)Math.floor(src[d]);
        }
    }

    public static void copyToLongCeil(double[] src, long[] dst) {
        for (int d = 0; d < src.length; ++d) {
            dst[d] = (long)Math.floor(src[d]);
        }
    }

    public ImagePlus exportAsynch(boolean wait) {
        return this.exportAsynch(wait, true);
    }

    public ImagePlus exportAsynch(boolean wait, boolean show) {
        this.exportThread = new ExportThread(this, show);
        this.exportThread.start();
        if (wait) {
            try {
                this.exportThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.result;
    }

    public ImagePlus getResult() {
        return this.result;
    }

    public static <T> BigWarpExporter<?> getExporter(BigWarpData<T> bwData, List<SourceAndConverter<T>> transformedSources, Interpolation interp, ProgressWriter progressWriter) {
        List<Integer> movingSourceIndexList = bwData.getMovingSourceIndices();
        if (BigWarpRealExporter.isTypeListFullyConsistent(transformedSources, movingSourceIndexList)) {
            Object baseType = transformedSources.get(movingSourceIndexList.get(0)).getSpimSource().getType();
            if (baseType instanceof RealType) {
                return new BigWarpRealExporter<RealType>(bwData, bwData.converterSetups, interp, (RealType)baseType, progressWriter);
            }
            if (ARGBType.class.isInstance(baseType)) {
                return new BigWarpARGBExporter(bwData, bwData.converterSetups, interp, progressWriter);
            }
            System.err.println("Can't export type " + baseType.getClass());
        }
        return null;
    }

    public static class ExportThread
    extends Thread {
        final BigWarpExporter<?> exporter;
        final boolean show;

        public ExportThread(BigWarpExporter<?> exporter, boolean show) {
            this.exporter = exporter;
            this.show = show;
        }

        @Override
        public void run() {
            try {
                ((BigWarpExporter)this.exporter).result = this.exporter.export();
                if (this.show) {
                    ((BigWarpExporter)this.exporter).result.show();
                }
                if (((BigWarpExporter)this.exporter).outputList != null) {
                    ((BigWarpExporter)this.exporter).outputList.add(((BigWarpExporter)this.exporter).result);
                }
                if (((BigWarpExporter)this.exporter).result != null && ((BigWarpExporter)this.exporter).showResult && this.show && !this.exporter.isRGB()) {
                    BigWarpExporter.updateBrightnessContrast(((BigWarpExporter)this.exporter).result, this.exporter.bwData.getMovingConverterSetups());
                }
                if (((BigWarpExporter)this.exporter).exportPath != null && !((BigWarpExporter)this.exporter).exportPath.isEmpty()) {
                    try {
                        IJ.save((ImagePlus)((BigWarpExporter)this.exporter).result, (String)((BigWarpExporter)this.exporter).exportPath);
                    }
                    catch (Exception e) {
                        IJ.showMessage((String)("Failed to write : " + ((BigWarpExporter)this.exporter).exportPath));
                    }
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public static enum ParallelizationPolicy {
        SLICE,
        ITER;

    }
}

