/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.cache.CacheControl;
import bdv.gui.BigWarpViewerFrame;
import bdv.img.WarpedSource;
import bdv.tools.InitializeViewerState;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.transformation.TransformedSource;
import bdv.util.Bounds;
import bdv.viewer.ConverterSetups;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SynchronizedViewerState;
import bigwarp.BigWarpInit;
import bigwarp.source.SourceInfo;
import bigwarp.util.BigWarpUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.Wrapped2DTransformAs3D;

public class BigWarpData<T> {
    public List<SourceAndConverter<T>> sources;
    public final LinkedHashMap<Integer, SourceInfo> sourceInfos = new LinkedHashMap();
    public final List<ConverterSetup> converterSetups;
    public final CacheControl cache;

    public BigWarpData() {
        this(new ArrayList<SourceAndConverter<T>>(), new ArrayList<ConverterSetup>(), null);
    }

    public BigWarpData(List<SourceAndConverter<T>> sources, List<ConverterSetup> converterSetups, CacheControl cache, int[] movingIndexes, int[] targetIndexes) {
        this(sources, converterSetups, cache, BigWarpData.listOf(movingIndexes), BigWarpData.listOf(targetIndexes));
    }

    public BigWarpData(List<SourceAndConverter<T>> sources, List<ConverterSetup> converterSetups, CacheControl cache) {
        this(sources, null, converterSetups, cache);
    }

    public BigWarpData(List<SourceAndConverter<T>> sources, List<RealTransform> transforms, List<ConverterSetup> converterSetups, CacheControl cache) {
        this.sources = sources;
        this.converterSetups = converterSetups;
        this.cache = cache == null ? new CacheControl.Dummy() : cache;
    }

    public BigWarpData(List<SourceAndConverter<T>> sources, List<ConverterSetup> converterSetups, CacheControl cache, List<Integer> movingIndexes, List<Integer> targetIndexes) {
        this.sources = sources;
        this.converterSetups = converterSetups;
        for (int i = 0; i < sources.size(); ++i) {
            SourceAndConverter<T> sourceAndConverter = sources.get(i);
            SourceInfo sourceInfo = new SourceInfo(i, movingIndexes.contains(i), sourceAndConverter.getSpimSource().getName());
            sourceInfo.setSourceAndConverter(sourceAndConverter);
            this.sourceInfos.put(i, sourceInfo);
        }
        this.cache = cache == null ? new CacheControl.Dummy() : cache;
    }

    private static ArrayList<Integer> listOf(int[] x) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (int i : x) {
            out.add(i);
        }
        return out;
    }

    public int numMovingSources() {
        AtomicInteger movingCount = new AtomicInteger();
        this.sourceInfos.forEach((id, info) -> {
            if (info.isMoving()) {
                movingCount.incrementAndGet();
            }
        });
        return movingCount.get();
    }

    public SourceAndConverter<T> getMovingSource(int i) {
        int curIdx = 0;
        for (Map.Entry<Integer, SourceInfo> idToInfo : this.sourceInfos.entrySet()) {
            SourceInfo info = idToInfo.getValue();
            if (!info.isMoving()) continue;
            if (curIdx == i) {
                return info.getSourceAndConverter();
            }
            ++curIdx;
        }
        return null;
    }

    public int numTargetSources() {
        return this.sourceInfos.size() - this.numMovingSources();
    }

    public List<Integer> getMovingSourceIndices() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int idx = 0;
        for (SourceInfo sourceInfo : this.sourceInfos.values()) {
            if (sourceInfo.isMoving()) {
                indices.add(idx);
            }
            ++idx;
        }
        return indices;
    }

    public SourceAndConverter<T> getTargetSource(int i) {
        int curIdx = 0;
        for (Map.Entry<Integer, SourceInfo> idToInfo : this.sourceInfos.entrySet()) {
            SourceInfo info = idToInfo.getValue();
            if (info.isMoving()) continue;
            if (curIdx == i) {
                return info.getSourceAndConverter();
            }
            ++curIdx;
        }
        return null;
    }

    public List<ConverterSetup> getMovingConverterSetups() {
        ArrayList<ConverterSetup> out = new ArrayList<ConverterSetup>();
        SourceInfo[] infos = this.sourceInfos.values().toArray(new SourceInfo[0]);
        for (int i = 0; i < infos.length; ++i) {
            SourceInfo info = infos[i];
            if (!info.isMoving()) continue;
            out.add(this.converterSetups.get(i));
        }
        return out;
    }

    public List<ConverterSetup> getTargetConverterSetups() {
        ArrayList<ConverterSetup> out = new ArrayList<ConverterSetup>();
        SourceInfo[] infos = this.sourceInfos.values().toArray(new SourceInfo[0]);
        for (int i = 0; i < infos.length; ++i) {
            SourceInfo info = infos[i];
            if (info.isMoving()) continue;
            out.add(this.converterSetups.get(i));
        }
        return out;
    }

    public ConverterSetup getConverterSetup(int id) {
        SourceInfo[] infos = this.sourceInfos.values().toArray(new SourceInfo[0]);
        for (int i = 0; i < infos.length; ++i) {
            SourceInfo info = infos[i];
            if (info.getId() != id) continue;
            return this.converterSetups.get(i);
        }
        return null;
    }

    public SourceInfo getSourceInfo(int id) {
        return this.sourceInfos.get(id);
    }

    public SourceInfo getSourceInfo(SourceAndConverter<?> sac) {
        for (SourceInfo info : this.sourceInfos.values()) {
            if (info.getSourceAndConverter() != sac) continue;
            return info;
        }
        return null;
    }

    public boolean isMoving(SourceAndConverter<?> sac) {
        return this.getSourceInfo(sac).isMoving();
    }

    @Deprecated
    public void wrapUp() {
    }

    void addSource(Source<T> src, boolean isMoving) {
        this.addSource(src, isMoving, null);
    }

    void addSource(Source<T> src, boolean isMoving, RealTransform transform) {
        int id = 0;
        for (ConverterSetup cs : this.converterSetups) {
            if (id != cs.getSetupId()) continue;
            ++id;
        }
        this.addSource(id, src, isMoving, transform);
    }

    void addSource(int id, Source<T> src, boolean isMoving, RealTransform transform) {
        BigWarpInit.add(this, src, id, 0, isMoving, transform);
        SourceInfo sourceInfo = new SourceInfo(id, isMoving, src.getName(), null, transform);
        sourceInfo.setSourceAndConverter(this.sources.get(this.sources.size() - 1));
        this.sourceInfos.put(id, sourceInfo);
    }

    int remove(SourceInfo sourceInfo) {
        int idx = this.sources.indexOf(sourceInfo.getSourceAndConverter());
        this.remove(idx);
        return idx;
    }

    void remove(int i) {
        SourceAndConverter sac = this.sources.get(i);
        this.sourceInfos.entrySet().stream().filter(it -> ((SourceInfo)it.getValue()).getSourceAndConverter() == sac).map(Map.Entry::getKey).findFirst().ifPresent(sacId -> this.sourceInfos.remove(sacId));
        this.sources.remove(i);
        this.converterSetups.remove(i);
    }

    public static Source<?> unwrap(SourceInfo srcInfo) {
        Source src = srcInfo.getSourceAndConverter().getSpimSource();
        if (srcInfo.isMoving() && src instanceof WarpedSource) {
            src = ((WarpedSource)src).getWrappedSource();
        }
        if (srcInfo.getTransform() != null) {
            if (src instanceof WarpedSource) {
                src = ((WarpedSource)src).getWrappedSource();
            } else if (src instanceof TransformedSource) {
                src = ((TransformedSource)src).getWrappedSource();
            }
        }
        return src;
    }

    public void wrapMovingSources() {
        for (SourceInfo sourceInfo : this.sourceInfos.values()) {
            this.wrapMovingSources(sourceInfo);
        }
    }

    public void wrapMovingSources(SourceInfo sourceInfo) {
        if (sourceInfo.isMoving()) {
            SourceAndConverter<?> newSac = BigWarpData.wrapSourceAsTransformed(sourceInfo.getSourceAndConverter(), null);
            int sourceIdx = this.sources.indexOf(sourceInfo.getSourceAndConverter());
            sourceInfo.setSourceAndConverter(newSac);
            this.sources.set(sourceIdx, newSac);
        }
    }

    public List<SourceAndConverter<T>> wrapSourcesAsTransformed() {
        ArrayList<SourceAndConverter<T>> wrappedSource = new ArrayList<SourceAndConverter<T>>();
        int i = 0;
        for (SourceInfo sourceInfo : this.sourceInfos.values()) {
            if (sourceInfo.isMoving()) {
                SourceAndConverter<?> newSac = BigWarpData.wrapSourceAsTransformed(sourceInfo.getSourceAndConverter(), null);
                wrappedSource.add(newSac);
            } else {
                wrappedSource.add(sourceInfo.getSourceAndConverter());
            }
            ++i;
        }
        return wrappedSource;
    }

    private static <T> SourceAndConverter<T> wrapSourceAsTransformed(SourceAndConverter<T> src, String name) {
        if (src.asVolatile() == null) {
            return new SourceAndConverter(new WarpedSource(src.getSpimSource(), name), src.getConverter(), null);
        }
        return new SourceAndConverter(new WarpedSource(src.getSpimSource(), name), src.getConverter(), BigWarpData.wrapSourceAsTransformed(src.asVolatile(), name));
    }

    public void setSourceTransformation(int id, RealTransform transform, Supplier<String> uriSupplier) {
        this.setTransformation(this.sourceInfos.get(id), transform, uriSupplier);
    }

    public void setTransformation(SourceInfo srcInfo, RealTransform transform, Supplier<String> uriSupplier) {
        Source<?> unWrappedSource = BigWarpData.unwrap(srcInfo);
        srcInfo.setTransform(transform, uriSupplier);
        this.applyTransformation(srcInfo, unWrappedSource);
        if (srcInfo.isMoving()) {
            this.wrapMovingSources(srcInfo);
        }
    }

    public void applyTransformations() {
        int i = 0;
        for (SourceAndConverter<T> sac : this.sources) {
            SourceInfo info = this.getSourceInfo(sac);
            RealTransform transform = info.getTransform();
            if (transform != null) {
                SourceAndConverter<T> newSac = BigWarpData.inheritConverter(this.applyFixedTransform(sac.getSpimSource(), transform), sac);
                info.setSourceAndConverter(newSac);
                this.sources.set(i, newSac);
            }
            ++i;
        }
    }

    public void applyTransformation(SourceInfo info, Source<T> unWrappedSource) {
        RealTransform transform = info.getTransform();
        SourceAndConverter<?> sac = info.getSourceAndConverter();
        SourceAndConverter<T> newSac = BigWarpData.inheritConverter(transform != null ? this.applyFixedTransform(unWrappedSource, transform) : unWrappedSource, sac);
        info.setSourceAndConverter(newSac);
        this.sources.set(this.sources.indexOf(sac), newSac);
    }

    public static <T> SourceAndConverter<T> inheritConverter(Source<T> src, SourceAndConverter<T> sac) {
        if (sac.asVolatile() == null) {
            return new SourceAndConverter(src, sac.getConverter(), null);
        }
        System.err.println("Inherit Converter can't handle volatile");
        return null;
    }

    public void updateFixedTransform(Source<T> src, RealTransform transform) {
        RealTransform tform = transform;
        if (transform.numSourceDimensions() < 3) {
            tform = transform instanceof InvertibleRealTransform ? new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)transform) : new Wrapped2DTransformAs3D(transform);
        }
        if (!(src instanceof WarpedSource)) {
            return;
        }
        WarpedSource wsrc = (WarpedSource)src;
        wsrc.updateTransform(tform);
    }

    public <T> Source<T> applyFixedTransform(Source<T> src, RealTransform transform) {
        RealTransform tform = transform;
        if (transform.numSourceDimensions() < 3) {
            tform = transform instanceof InvertibleRealTransform ? new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)transform) : new Wrapped2DTransformAs3D(transform);
        }
        if (transform instanceof AffineGet) {
            AffineTransform3D affine3d;
            if (transform instanceof AffineTransform3D) {
                affine3d = (AffineTransform3D)transform;
            } else {
                affine3d = new AffineTransform3D();
                AffineGet transformTo3D = BigWarpUtils.toAffine3D((AffineGet)transform);
                affine3d.preConcatenate(transformTo3D);
            }
        }
        WarpedSource<T> wsrc = new WarpedSource<T>(src, null);
        wsrc.updateTransform(tform);
        wsrc.setIsTransformed(true);
        return wsrc;
    }

    public void updateEditableTransformation(RealTransform transform) {
        for (SourceInfo sourceInfo : this.sourceInfos.values()) {
            if (!sourceInfo.isMoving()) continue;
            SourceAndConverter<?> sac = sourceInfo.getSourceAndConverter();
            WarpedSource wsrc = (WarpedSource)sac.getSpimSource();
            wsrc.updateTransform(transform);
            if (sac.asVolatile() != null) {
                ((WarpedSource)sourceInfo.getSourceAndConverter().asVolatile().getSpimSource()).updateTransform(transform);
            }
            wsrc.updateTransform(transform);
        }
    }

    public void transferChannelSettings(BigWarpViewerFrame viewer) {
        SynchronizedViewerState state = viewer.getViewerPanel().state();
        ConverterSetups setups = viewer.getConverterSetups();
        for (Map.Entry<Integer, SourceInfo> infoEntry : this.sourceInfos.entrySet()) {
            int id = infoEntry.getKey();
            SourceInfo info = infoEntry.getValue();
            SourceAndConverter<?> sac = info.getSourceAndConverter();
            ConverterSetup cs = setups.getConverterSetup(sac);
            if (info.getColorSettings() == null) {
                int timepoint = state.getCurrentTimepoint();
                Bounds bounds = InitializeViewerState.estimateSourceRange((Source)sac.getSpimSource(), (int)timepoint, (double)0.001, (double)0.999);
                if (cs == null) continue;
                cs.setDisplayRange(bounds.getMinBound(), bounds.getMaxBound());
                continue;
            }
            info.getColorSettings().updateSetup(cs);
        }
    }
}

