/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.viewer.Interpolation;
import bigwarp.BigWarpBatchTransformFOV;
import bigwarp.BigWarpExporter;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.loader.ImagePlusLoader;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.real.FloatType;

public class BigWarpBatchTransform {
    public static void main(String[] args) throws IOException, FormatException {
        LandmarkTableModel ltm = new LandmarkTableModel(Integer.parseInt(args[0]));
        ltm.load(new File(args[1]));
        ThinPlateR2LogRSplineKernelTransform xfm = ltm.getTransform();
        String srcName = args[2];
        String template = args[3];
        String dstName = args[4];
        ImagePlus impP = IJ.openImage((String)srcName);
        ImageReader reader = new ImageReader();
        reader.setId(template);
        String[] names = new String[]{impP.getTitle(), "target_interval"};
        ImagePlusLoader loaderP = new ImagePlusLoader(impP);
        SpimDataMinimal[] spimDataP = loaderP.loadAll(0);
        int numMovingChannels = loaderP.numChannels();
        AbstractSpimData[] spimDataQ = new AbstractSpimData[]{BigWarpBatchTransform.createSpimData((IFormatReader)reader)};
        BigWarpExporter exporter = BigWarpBatchTransformFOV.applyBigWarpHelper(spimDataP, spimDataQ, impP, ltm, Interpolation.NLINEAR);
        ImagePlus ipout = exporter.export();
        IJ.save((ImagePlus)ipout, (String)dstName);
    }

    public static final SpimDataMinimal createSpimData(IFormatReader reader) {
        Hashtable gmeta = reader.getGlobalMetadata();
        System.out.println(gmeta);
        double pw = 1.0;
        double ph = 1.0;
        double pd = 1.0;
        if (gmeta.keySet().contains("XResolution")) {
            pw = (Double)gmeta.get("XResolution");
        }
        if (gmeta.keySet().contains("YResolution")) {
            ph = (Double)gmeta.get("YResolution");
        }
        if (gmeta.keySet().contains("Spacing")) {
            pd = (Double)gmeta.get("Spacing");
        }
        int numSetups = 1;
        int numTimepoints = 1;
        int[] ids = new int[]{349812342};
        File basePath = new File(".");
        String punit = "px";
        if (gmeta.keySet().contains("Unit")) {
            punit = (String)gmeta.get("Unit");
        }
        FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(punit, new double[]{pw, ph, pd});
        long w = (Long)gmeta.get("ImageWidth");
        long h = (Long)gmeta.get("ImageLength");
        long d = reader.getSizeZ();
        long[] dims = new long[]{w, h, d};
        FinalDimensions size = new FinalDimensions(new long[]{w, h, d});
        HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>(numSetups);
        for (int s = 0; s < numSetups; ++s) {
            BasicViewSetup setup = new BasicViewSetup(ids[s], String.format("channel %d", ids[s] + 1), (Dimensions)size, (VoxelDimensions)voxelSize);
            setup.setAttribute((Entity)new Channel(ids[s] + 1));
            setups.put(ids[s], setup);
        }
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>(numTimepoints);
        for (int t = 0; t < numTimepoints; ++t) {
            timepoints.add(new TimePoint(t));
        }
        AffineTransform3D sourceTransform = new AffineTransform3D();
        sourceTransform.set(1.0 / pw, 0.0, 0.0, 0.0, 0.0, 1.0 / ph, 0.0, 0.0, 0.0, 0.0, pd, 0.0);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (int t = 0; t < numTimepoints; ++t) {
            for (int s = 0; s < numSetups; ++s) {
                registrations.add(new ViewRegistration(t, ids[s], sourceTransform));
            }
        }
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), setups, new BigWarpBatchTransformFOV.DummyImageLoader<FloatType>(new FloatType(), dims), null);
        SpimDataMinimal spimData = new SpimDataMinimal(basePath, seq, new ViewRegistrations(registrations));
        if (WrapBasicImgLoader.wrapImgLoaderIfNecessary((AbstractSpimData)spimData)) {
            System.err.println("WARNING:\nOpening <SpimData> dataset that is not suited for interactive browsing.\nConsider resaving as HDF5 for better performance.");
        }
        return spimData;
    }
}

