/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.export.ProgressWriter;
import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarpData;
import bigwarp.BigWarpExporter;
import ij.IJ;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.img.planar.PlanarCursor;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;

public class BigWarpARGBExporter
extends BigWarpExporter<ARGBType> {
    private Interpolation interp;

    public BigWarpARGBExporter(BigWarpData<ARGBType> bwData, List<ConverterSetup> convSetups, Interpolation interp, ProgressWriter progress) {
        super(bwData, convSetups, interp, progress);
    }

    public static boolean isTypeListFullyConsistent(ArrayList<SourceAndConverter<?>> sources, int[] movingSourceIndexList) {
        for (int i = 0; i < movingSourceIndexList.length; ++i) {
            int idx = movingSourceIndexList[i];
            Object type = sources.get(idx).getSpimSource().getType();
            if (type.getClass().equals(ARGBType.class)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRGB() {
        return true;
    }

    @Override
    public RandomAccessibleInterval<ARGBType> exportRai() {
        ArrayList<IntervalView> raiList = new ArrayList<IntervalView>();
        this.buildTotalRenderTransform();
        AffineTransform3D srcXfm = new AffineTransform3D();
        int numChannels = this.bwData.numMovingSources();
        FinalVoxelDimensions voxdim = new FinalVoxelDimensions(this.unit, new double[]{this.resolutionTransform.get(0, 0), this.resolutionTransform.get(1, 1), this.resolutionTransform.get(2, 2)});
        for (int i = 0; i < numChannels; ++i) {
            Source src = this.bwData.getMovingSource(i).getSpimSource();
            src.getSourceTransform(0, 0, srcXfm);
            RealRandomAccessible raiRaw = src.getInterpolatedSource(0, 0, this.interp);
            AffineTransform3D pixelToPhysical = this.pixelRenderToPhysical.copy().inverse();
            pixelToPhysical.concatenate(srcXfm);
            AffineRandomAccessible rai = RealViews.affine((RealRandomAccessible)raiRaw, (AffineGet)pixelToPhysical);
            raiList.add(Views.interval((RandomAccessible)Views.raster((RealRandomAccessible)rai), (Interval)this.outputInterval));
        }
        RandomAccessibleInterval raiStack = Views.stack(raiList);
        return raiStack;
    }

    @Override
    public ImagePlus export() {
        this.buildTotalRenderTransform();
        int numChannels = this.bwData.numMovingSources();
        FinalVoxelDimensions voxdim = new FinalVoxelDimensions(this.unit, new double[]{this.resolutionTransform.get(0, 0), this.resolutionTransform.get(1, 1), this.resolutionTransform.get(2, 2)});
        RandomAccessibleInterval<ARGBType> raiStack = this.exportRai();
        ImagePlus ip = null;
        if (this.isVirtual) {
            ip = ImageJFunctions.wrap(raiStack, (String)"warped_moving_image");
        } else if (this.nThreads == 1) {
            ip = BigWarpARGBExporter.copyToImageStack(raiStack, raiStack);
        } else {
            ImagePlusImgFactory factory = new ImagePlusImgFactory((NativeType)new ARGBType());
            if (this.outputInterval.numDimensions() == 3) {
                long[] dimensions = new long[]{this.outputInterval.dimension(0), this.outputInterval.dimension(1), numChannels, this.outputInterval.dimension(2)};
                FinalInterval destIntervalPerm = new FinalInterval(dimensions);
                RandomAccessibleInterval<ARGBType> img = this.copyToImageStack(raiStack, (Interval)destIntervalPerm, factory, this.nThreads);
                ip = ((ImagePlusImg)img).getImagePlus();
            } else if (this.outputInterval.numDimensions() == 2) {
                long[] dimensions = new long[]{this.outputInterval.dimension(0), this.outputInterval.dimension(1), numChannels, 1L};
                FinalInterval destIntervalPerm = new FinalInterval(dimensions);
                RandomAccessibleInterval img = this.copyToImageStack(Views.addDimension((RandomAccessible)Views.extendMirrorDouble(raiStack)), (Interval)destIntervalPerm, factory, this.nThreads);
                ip = ((ImagePlusImg)img).getImagePlus();
            }
        }
        ip.getCalibration().pixelWidth = voxdim.dimension(0);
        ip.getCalibration().pixelHeight = voxdim.dimension(1);
        ip.getCalibration().pixelDepth = voxdim.dimension(2);
        ip.getCalibration().setUnit(voxdim.unit());
        if (this.offsetTransform != null) {
            ip.getCalibration().xOrigin = this.offsetTransform.get(0, 3);
            ip.getCalibration().yOrigin = this.offsetTransform.get(1, 3);
            ip.getCalibration().zOrigin = this.offsetTransform.get(2, 3);
        }
        ip.setTitle(this.bwData.getMovingSource(0).getSpimSource().getName() + this.nameSuffix);
        return ip;
    }

    public static ImagePlus copyToImageStack(RandomAccessible<ARGBType> rai, Interval itvl) {
        MixedTransformView raip = Views.permute(rai, (int)2, (int)3);
        long[] dimensions = new long[itvl.numDimensions()];
        for (int d = 0; d < itvl.numDimensions(); ++d) {
            dimensions[d] = d == 2 ? itvl.dimension(3) : (d == 3 ? itvl.dimension(2) : itvl.dimension(d));
        }
        ImagePlusImgFactory factory = new ImagePlusImgFactory((NativeType)new ARGBType());
        ImagePlusImg target = factory.create(dimensions);
        long[] dims = new long[target.numDimensions()];
        target.dimensions(dims);
        double k = 0.0;
        long N = 1L;
        for (int i = 0; i < itvl.numDimensions(); ++i) {
            N *= dimensions[i];
        }
        PlanarCursor c = target.cursor();
        RandomAccess ra = raip.randomAccess();
        while (c.hasNext()) {
            c.fwd();
            ra.setPosition((Localizable)c);
            ((ARGBType)c.get()).set((ARGBType)ra.get());
            if (k % 10000.0 == 0.0) {
                IJ.showProgress((double)(k / (double)N));
            }
            k += 1.0;
        }
        IJ.showProgress((double)1.1);
        try {
            return target.getImagePlus();
        }
        catch (ImgLibException e) {
            e.printStackTrace();
            return null;
        }
    }
}

