/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.BigDataViewer;
import bdv.TransformState;
import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterConsole;
import bdv.gui.BigWarpLandmarkPanel;
import bdv.gui.BigWarpMessageAnimator;
import bdv.gui.BigWarpViewerFrame;
import bdv.gui.BigWarpViewerOptions;
import bdv.gui.BigwarpLandmarkSelectionPanel;
import bdv.gui.ExportDisplacementFieldFrame;
import bdv.gui.LandmarkKeyboardProcessor;
import bdv.gui.MaskOptionsPanel;
import bdv.gui.MaskedSourceEditorMouseListener;
import bdv.gui.TransformTypeSelectDialog;
import bdv.ij.ApplyBigwarpPlugin;
import bdv.ij.util.ProgressWriterIJ;
import bdv.img.WarpedSource;
import bdv.tools.InitializeViewerState;
import bdv.tools.PreferencesDialog;
import bdv.tools.VisibilityAndGroupingDialog;
import bdv.tools.bookmarks.Bookmarks;
import bdv.tools.bookmarks.BookmarksEditor;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.SetupAssignments;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.appearance.AppearanceSettingsPage;
import bdv.ui.appearance.BwAppearanceManager;
import bdv.ui.keymap.AbstractKeymapManager;
import bdv.ui.keymap.Keymap;
import bdv.ui.keymap.KeymapSettingsPage;
import bdv.ui.settings.SettingsPage;
import bdv.util.BoundedRange;
import bdv.util.Bounds;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.BigWarpDragOverlay;
import bdv.viewer.BigWarpLandmarkFrame;
import bdv.viewer.BigWarpOverlay;
import bdv.viewer.BigWarpViewerPanel;
import bdv.viewer.BigWarpViewerSettings;
import bdv.viewer.ConverterSetups;
import bdv.viewer.DisplayMode;
import bdv.viewer.Interpolation;
import bdv.viewer.LandmarkPointMenu;
import bdv.viewer.MultiBoxOverlay2d;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerOptions;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import bdv.viewer.WarpNavigationActions;
import bdv.viewer.animate.AbstractTransformAnimator;
import bdv.viewer.animate.SimilarityModel3D;
import bdv.viewer.animate.TranslationAnimator;
import bdv.viewer.overlay.BigWarpMaskSphereOverlay;
import bdv.viewer.overlay.BigWarpSourceOverlayRenderer;
import bdv.viewer.overlay.MultiBoxOverlayRenderer;
import bigwarp.BigWarpActions;
import bigwarp.BigWarpAutoSaver;
import bigwarp.BigWarpData;
import bigwarp.BigWarpInit;
import bigwarp.BigwarpSettings;
import bigwarp.HelpDialog;
import bigwarp.SourceInfoDialog;
import bigwarp.WarpVisFrame;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.source.GridSource;
import bigwarp.source.JacobianDeterminantSource;
import bigwarp.source.PlateauSphericalMaskRealRandomAccessible;
import bigwarp.source.PlateauSphericalMaskSource;
import bigwarp.source.SourceInfo;
import bigwarp.source.WarpMagnitudeSource;
import bigwarp.transforms.AbstractTransformSolver;
import bigwarp.transforms.BigWarpTransform;
import bigwarp.transforms.MaskedSimRotTransformSolver;
import bigwarp.transforms.WrappedCoordinateTransform;
import bigwarp.transforms.io.TransformWriterJson;
import bigwarp.ui.keymap.KeymapManager;
import bigwarp.ui.keymap.NavigationKeys;
import bigwarp.util.BigWarpUtils;
import com.formdev.flatlaf.util.UIScale;
import com.google.gson.stream.JsonReader;
import dev.dirs.ProjectDirectories;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import mpicbg.models.AbstractModel;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.RigidModel2D;
import mpicbg.models.RigidModel3D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.converter.Converter;
import net.imglib2.display.RealARGBColorConverter;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.inverse.DifferentiableRealTransform;
import net.imglib2.realtransform.inverse.RealTransformFiniteDerivatives;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.TransformGraph;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.TransformPath;
import org.janelia.utility.geom.BoundingSphereRitter;
import org.janelia.utility.geom.Sphere;
import org.janelia.utility.ui.RepeatingReleasedEventsFixer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Actions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigWarp<T> {
    public static String configDir = ProjectDirectories.from((String)"sc", (String)"fiji", (String)"bigwarp").configDir;
    protected static final int DEFAULT_WIDTH = 400;
    protected static final int DEFAULT_HEIGHT = 300;
    public static final int GRID_SOURCE_ID = 1696993146;
    public static final int WARPMAG_SOURCE_ID = 956736363;
    public static final int JACDET_SOURCE_ID = 1006827158;
    public static final int TRANSFORM_MASK_SOURCE_ID = 33872301;
    protected BigWarpViewerOptions options;
    protected BigWarpData<T> data;
    protected final SetupAssignments setupAssignments;
    protected final WarpVisFrame warpVisDialog;
    protected final HelpDialog helpDialog;
    private final KeymapManager keymapManager;
    private final AppearanceManager appearanceManager;
    protected final SourceInfoDialog sourceInfoDialog;
    protected final VisibilityAndGroupingDialog activeSourcesDialogP;
    protected final VisibilityAndGroupingDialog activeSourcesDialogQ;
    protected final PreferencesDialog preferencesDialog;
    final AffineTransform3D fixedViewXfm;
    private Bookmarks bookmarks;
    protected final BookmarksEditor bookmarkEditorP;
    protected final BookmarksEditor bookmarkEditorQ;
    private final BigWarpViewerFrame viewerFrameP;
    private final BigWarpViewerFrame viewerFrameQ;
    protected final BigWarpViewerPanel viewerP;
    protected final BigWarpViewerPanel viewerQ;
    protected final BigWarpActions tableActions;
    protected AffineTransform3D initialViewP;
    protected AffineTransform3D initialViewQ;
    private JMenuItem toggleAlwaysWarpMenuP;
    private JMenuItem toggleAlwaysWarpMenuQ;
    protected BigWarpLandmarkPanel landmarkPanel;
    protected LandmarkPointMenu landmarkPopupMenu;
    protected BigWarpLandmarkFrame landmarkFrame;
    protected final BigWarpViewerSettings viewerSettings;
    protected final BigWarpOverlay overlayP;
    protected final BigWarpOverlay overlayQ;
    protected final BigWarpDragOverlay dragOverlayP;
    protected final BigWarpDragOverlay dragOverlayQ;
    protected RealPoint currentLandmark;
    protected LandmarkTableModel landmarkModel;
    protected InvertibleRealTransform currentTransform;
    protected JTable landmarkTable;
    protected LandmarkTableListener landmarkModellistener;
    protected MouseLandmarkListener landmarkClickListenerP;
    protected MouseLandmarkListener landmarkClickListenerQ;
    protected MouseLandmarkTableListener landmarkTableListener;
    protected MaskedSourceEditorMouseListener maskSourceMouseListenerP;
    protected MaskedSourceEditorMouseListener maskSourceMouseListenerQ;
    protected BigWarpMessageAnimator message;
    protected final Set<KeyEventPostProcessor> keyEventPostProcessorSet = new HashSet<KeyEventPostProcessor>();
    private final RepeatingReleasedEventsFixer repeatedKeyEventsFixer;
    protected GridSource gridSource;
    protected WarpMagnitudeSource<FloatType> warpMagSource;
    protected JacobianDeterminantSource<FloatType> jacDetSource;
    protected SourceAndConverter<? extends RealType<?>> transformMaskSource;
    protected Source<? extends RealType<?>> transformMask;
    protected PlateauSphericalMaskSource plateauTransformMask;
    protected final AbstractModel<?>[] baseXfmList;
    private final double[] ptBack;
    private SolveThread solverThread;
    private BigWarpTransform bwTransform;
    protected SourceGroup mvgGrp;
    protected SourceGroup tgtGrp;
    private BoundingBoxEstimation bboxOptions;
    private long keyClickMaxLength = 250L;
    protected TransformTypeSelectDialog transformSelector;
    protected AffineTransform3D tmpTransform = new AffineTransform3D();
    protected boolean inLandmarkMode;
    protected int baselineModelIndex;
    protected JFrame fileFrame;
    protected FileDialog fileDialog;
    final JFileChooser fileChooser;
    protected File autoSaveDirectory;
    protected File lastDirectory;
    protected File lastLandmarks;
    protected BigWarpAutoSaver autoSaver;
    protected boolean updateWarpOnPtChange = false;
    protected boolean firstWarpEstimation = true;
    JMenu fileMenu;
    final ProgressWriter progressWriter;
    private static ImageJ ij;
    protected static Logger logger;
    private SpimData movingSpimData;
    private File movingImageXml;
    private CopyOnWriteArrayList<TransformListener<InvertibleRealTransform>> transformListeners = new CopyOnWriteArrayList();
    int ndims;

    @Deprecated
    public BigWarp(BigWarpData<T> data, String windowTitle, ProgressWriter progressWriter) throws SpimDataException {
        this(data, BigWarpViewerOptions.options().is2D(BigWarp.detectNumDims(data.sources) == 2), progressWriter);
    }

    @Deprecated
    public BigWarp(BigWarpData<T> data, String windowTitle, BigWarpViewerOptions options, ProgressWriter progressWriter) throws SpimDataException {
        this(data, options, progressWriter);
    }

    public BigWarp(BigWarpData<T> data, ProgressWriter progressWriter) throws SpimDataException {
        this(data, BigWarpViewerOptions.options().is2D(BigWarp.detectNumDims(data.sources) == 2), progressWriter);
    }

    public BigWarp(BigWarpData<T> data, BigWarpViewerOptions options, ProgressWriter progressWriter) throws SpimDataException {
        Class<ViewerPanel> c_vp;
        KeymapManager optionsKeymapManager = options.getValues().getKeymapManager();
        AppearanceManager optionsAppearanceManager = options.values.getAppearanceManager();
        this.keymapManager = optionsKeymapManager != null ? optionsKeymapManager : new KeymapManager(configDir);
        this.appearanceManager = optionsAppearanceManager != null ? optionsAppearanceManager : new BwAppearanceManager(configDir);
        InputTriggerConfig inputTriggerConfig = options.values.getInputTriggerConfig();
        Keymap keymap = this.keymapManager.getForwardSelectedKeymap();
        if (inputTriggerConfig == null) {
            inputTriggerConfig = keymap.getConfig();
        }
        this.repeatedKeyEventsFixer = RepeatingReleasedEventsFixer.installAnyTime();
        ij = IJ.getInstance();
        this.progressWriter = progressWriter == null ? new ProgressWriterConsole() : progressWriter;
        this.data = data;
        this.options = options;
        this.ptBack = new double[3];
        this.ndims = options.values.is2D() ? 2 : 3;
        this.setupLandmarkFrame();
        this.baseXfmList = new AbstractModel[3];
        this.setupWarpMagBaselineOptions((CoordinateTransform[])this.baseXfmList, this.ndims);
        this.fixedViewXfm = new AffineTransform3D();
        this.viewerSettings = new BigWarpViewerSettings();
        InputTriggerConfig keyProperties = BigDataViewer.getInputTriggerConfig((ViewerOptions)options);
        options = options.inputTriggerConfig(keyProperties);
        int width = UIScale.scale((int)400);
        int height = UIScale.scale((int)300);
        List<SourceAndConverter<?>> srcs = data.sources;
        this.viewerFrameP = new BigWarpViewerFrame(this, width, height, srcs, data.converterSetups, this.viewerSettings, data.cache, this.keymapManager, this.appearanceManager, options, "BigWarp moving image", true);
        this.viewerP = this.getViewerFrameP().getViewerPanel();
        this.viewerFrameQ = new BigWarpViewerFrame(this, width, height, srcs, data.converterSetups, this.viewerSettings, data.cache, this.keymapManager, this.appearanceManager, options, "BigWarp fixed image", false);
        this.viewerQ = this.getViewerFrameQ().getViewerPanel();
        this.message = options.getMessageAnimator();
        this.message.setViewers(this.viewerP, this.viewerQ);
        this.landmarkModel.setMessage(this.message);
        if (options.values.is2D()) {
            c_vp = ViewerPanel.class;
            try {
                Field overlayRendererField = c_vp.getDeclaredField("multiBoxOverlayRenderer");
                overlayRendererField.setAccessible(true);
                MultiBoxOverlayRenderer overlayRenderP = new MultiBoxOverlayRenderer(400, 300);
                MultiBoxOverlayRenderer overlayRenderQ = new MultiBoxOverlayRenderer(400, 300);
                Field boxField = overlayRenderP.getClass().getDeclaredField("box");
                boxField.setAccessible(true);
                boxField.set(overlayRenderP, (Object)new MultiBoxOverlay2d());
                boxField.set(overlayRenderQ, (Object)new MultiBoxOverlay2d());
                boxField.setAccessible(false);
                overlayRendererField.set((Object)this.viewerP, overlayRenderP);
                overlayRendererField.set((Object)this.viewerQ, overlayRenderQ);
                overlayRendererField.setAccessible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            c_vp = ViewerPanel.class;
            Field sourceInfoOverlayRendererField = c_vp.getDeclaredField("sourceInfoOverlayRenderer");
            sourceInfoOverlayRendererField.setAccessible(true);
            sourceInfoOverlayRendererField.set((Object)this.viewerP, (Object)new BigWarpSourceOverlayRenderer());
            sourceInfoOverlayRendererField.set((Object)this.viewerQ, (Object)new BigWarpSourceOverlayRenderer());
            sourceInfoOverlayRendererField.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.viewerP.setNumDim(this.ndims);
        this.viewerQ.setNumDim(this.ndims);
        this.activeSourcesDialogP = new VisibilityAndGroupingDialog((Frame)this.viewerFrameP, this.viewerP.getVisibilityAndGrouping());
        this.activeSourcesDialogP.setTitle("visibility and grouping ( moving )");
        this.activeSourcesDialogQ = new VisibilityAndGroupingDialog((Frame)this.viewerFrameQ, this.viewerQ.getVisibilityAndGrouping());
        this.activeSourcesDialogQ.setTitle("visibility and grouping ( fixed )");
        this.overlayP = new BigWarpOverlay(this.viewerP, this.landmarkPanel);
        this.overlayQ = new BigWarpOverlay(this.viewerQ, this.landmarkPanel);
        this.viewerP.addOverlay(this.overlayP);
        this.viewerQ.addOverlay(this.overlayQ);
        this.bwTransform = new BigWarpTransform(this.landmarkModel);
        this.bwTransform.initializeInverseParameters(data);
        this.solverThread = new SolveThread(this);
        this.solverThread.start();
        this.bboxOptions = new BoundingBoxEstimation(BoundingBoxEstimation.Method.FACES, 5);
        this.dragOverlayP = new BigWarpDragOverlay(this, this.viewerP, this.solverThread);
        this.dragOverlayQ = new BigWarpDragOverlay(this, this.viewerQ, this.solverThread);
        this.viewerP.addDragOverlay(this.dragOverlayP);
        this.viewerQ.addDragOverlay(this.dragOverlayQ);
        this.landmarkPopupMenu = new LandmarkPointMenu(this);
        this.landmarkPopupMenu.setupListeners();
        this.setupAssignments = new SetupAssignments(new ArrayList<ConverterSetup>(data.converterSetups), 0.0, 65535.0);
        this.helpDialog = new HelpDialog(this.landmarkFrame);
        this.sourceInfoDialog = new SourceInfoDialog((Frame)this.landmarkFrame, data);
        this.transformSelector = new TransformTypeSelectDialog((Frame)this.landmarkFrame, this);
        this.warpVisDialog = new WarpVisFrame((Frame)this.viewerFrameQ, this);
        this.preferencesDialog = new PreferencesDialog((Frame)this.landmarkFrame, keymap, new String[]{"bigwarp", "navigation", "bw-table"});
        this.preferencesDialog.addPage((SettingsPage)new AppearanceSettingsPage("Appearance", this.appearanceManager));
        this.preferencesDialog.addPage((SettingsPage)new KeymapSettingsPage("Keymap", (AbstractKeymapManager)this.keymapManager, (AbstractKeymapManager)new KeymapManager(), this.keymapManager.getCommandDescriptions()));
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "xml files";
            }

            @Override
            public boolean accept(File f) {
                String s;
                int i;
                if (f.isDirectory()) {
                    return true;
                }
                if (f.isFile() && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
                    String ext = s.substring(i + 1).toLowerCase();
                    return ext.equals("xml");
                }
                return false;
            }
        });
        this.appearanceManager.appearance().updateListeners().add(this.viewerFrameP::repaint);
        this.appearanceManager.appearance().updateListeners().add(this.viewerFrameQ::repaint);
        this.appearanceManager.appearance().updateListeners().add(this.landmarkFrame::repaint);
        this.appearanceManager.addLafComponent((Component)this.fileChooser);
        SwingUtilities.invokeLater(() -> this.appearanceManager.updateLookAndFeel());
        Actions navigationActionsP = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"navigationMvg"});
        navigationActionsP.install(this.getViewerFrameP().getKeybindings(), "navigationMvg");
        NavigationKeys.install(navigationActionsP, (AbstractViewerPanel)this.getViewerFrameP().getViewerPanel(), options.values.is2D());
        Actions navigationActionsQ = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"navigationFix"});
        navigationActionsQ.install(this.getViewerFrameQ().getKeybindings(), "navigationFix");
        NavigationKeys.install(navigationActionsQ, (AbstractViewerPanel)this.getViewerFrameQ().getViewerPanel(), options.values.is2D());
        BigWarpActions bwActionsP = new BigWarpActions((KeyStrokeAdder.Factory)inputTriggerConfig, "bigwarpMvg");
        BigWarpActions.installViewerActions(bwActionsP, this.getViewerFrameP(), this);
        BigWarpActions bwActionsQ = new BigWarpActions((KeyStrokeAdder.Factory)inputTriggerConfig, "bigwarpFix");
        BigWarpActions.installViewerActions(bwActionsQ, this.getViewerFrameQ(), this);
        this.tableActions = new BigWarpActions((KeyStrokeAdder.Factory)inputTriggerConfig, "bw-table");
        BigWarpActions.installTableActions(this.tableActions, this.getLandmarkFrame().getKeybindings(), this);
        keymap.updateListeners().add(() -> {
            bwActionsP.updateKeyConfig(keymap.getConfig());
            bwActionsQ.updateKeyConfig(keymap.getConfig());
            this.tableActions.updateKeyConfig(keymap.getConfig());
            this.viewerFrameP.getTransformBehaviours().updateKeyConfig(keymap.getConfig());
            this.viewerFrameQ.getTransformBehaviours().updateKeyConfig(keymap.getConfig());
        });
        this.warpVisDialog.setActions();
        this.warpVisDialog.toleranceSpinner.setValue(this.bwTransform.getInverseTolerance());
        this.setUpViewerMenu(this.viewerFrameP);
        this.setUpViewerMenu(this.viewerFrameQ);
        this.setUpLandmarkMenus();
        this.viewerFrameP.setLocation(0, 0);
        this.viewerFrameP.setSize(width, height);
        this.viewerFrameQ.setLocation(width, 0);
        this.viewerFrameQ.setSize(width, height);
        this.landmarkFrame.setLocation(2 * width, 0);
        this.landmarkClickListenerP = new MouseLandmarkListener(this.viewerP);
        this.landmarkClickListenerQ = new MouseLandmarkListener(this.viewerQ);
        this.currentLandmark = new RealPoint(3);
        this.inLandmarkMode = false;
        this.setupKeyListener();
        this.initialViewP = new AffineTransform3D();
        this.initialViewQ = new AffineTransform3D();
        this.viewerP.state().getViewerTransform(this.initialViewP);
        this.viewerQ.state().getViewerTransform(this.initialViewQ);
        this.checkBoxInputMaps();
        this.lastDirectory = ij == null || IJ.getDirectory((String)"current") == null ? new File(System.getProperty("user.home")) : new File(IJ.getDirectory((String)"current"));
        this.bookmarks = new Bookmarks();
        this.bookmarkEditorP = new BookmarksEditor((AbstractViewerPanel)this.viewerP, this.viewerFrameP.getKeybindings(), this.bookmarks);
        this.bookmarkEditorQ = new BookmarksEditor((AbstractViewerPanel)this.viewerQ, this.viewerFrameQ.getKeybindings(), this.bookmarks);
        this.baselineModelIndex = 0;
        if (data.sources.size() > 0) {
            this.initialize();
        }
        this.createMovingTargetGroups();
        this.viewerP.state().setCurrentGroup(this.mvgGrp);
        this.viewerQ.state().setCurrentGroup(this.tgtGrp);
        SwingUtilities.invokeLater(() -> {
            this.viewerFrameP.setVisible(true);
            this.viewerFrameQ.setVisible(true);
            this.landmarkFrame.setVisible(true);
            this.fileFrame = new JFrame("Select File");
            this.fileDialog = new FileDialog(this.fileFrame);
            this.fileFrame.setVisible(false);
        });
    }

    public void changeDimensionality(boolean is2D) {
        if (this.options.values.is2D() == is2D) {
            return;
        }
        this.options.is2D(is2D);
        this.ndims = this.options.values.is2D() ? 2 : 3;
        this.landmarkModel = new LandmarkTableModel(this.ndims);
        this.landmarkModel.addTableModelListener(this.landmarkModellistener);
        this.addTransformListener(this.landmarkModel);
        this.landmarkModel.setMessage(this.message);
        this.landmarkPanel.setTableModel(this.landmarkModel);
        this.setupLandmarkFrame();
        this.landmarkPopupMenu = new LandmarkPointMenu(this);
        this.landmarkPopupMenu.setupListeners();
        BigWarpActions.installTableActions(this.tableActions, this.getLandmarkFrame().getKeybindings(), this);
        this.setupWarpMagBaselineOptions((CoordinateTransform[])this.baseXfmList, this.ndims);
        Class<ViewerPanel> c_vp = ViewerPanel.class;
        try {
            Field transformEventHandlerField = c_vp.getDeclaredField("transformEventHandler");
            transformEventHandlerField.setAccessible(true);
            transformEventHandlerField.set((Object)this.viewerP, this.options.values.getTransformEventHandlerFactory().create(TransformState.from(arg_0 -> ((SynchronizedViewerState)this.viewerP.state()).getViewerTransform(arg_0), arg_0 -> ((SynchronizedViewerState)this.viewerP.state()).setViewerTransform(arg_0))));
            transformEventHandlerField.set((Object)this.viewerQ, this.options.values.getTransformEventHandlerFactory().create(TransformState.from(arg_0 -> ((SynchronizedViewerState)this.viewerQ.state()).getViewerTransform(arg_0), arg_0 -> ((SynchronizedViewerState)this.viewerQ.state()).setViewerTransform(arg_0))));
            transformEventHandlerField.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.viewerFrameP.updateTransformBehaviors(this.options);
        this.viewerFrameQ.updateTransformBehaviors(this.options);
        if (this.options.values.is2D()) {
            try {
                Field overlayRendererField = c_vp.getDeclaredField("multiBoxOverlayRenderer");
                overlayRendererField.setAccessible(true);
                MultiBoxOverlayRenderer overlayRenderP = new MultiBoxOverlayRenderer(400, 300);
                MultiBoxOverlayRenderer overlayRenderQ = new MultiBoxOverlayRenderer(400, 300);
                Field boxField = overlayRenderP.getClass().getDeclaredField("box");
                boxField.setAccessible(true);
                boxField.set(overlayRenderP, (Object)new MultiBoxOverlay2d());
                boxField.set(overlayRenderQ, (Object)new MultiBoxOverlay2d());
                boxField.setAccessible(false);
                overlayRendererField.set((Object)this.viewerP, overlayRenderP);
                overlayRendererField.set((Object)this.viewerQ, overlayRenderQ);
                overlayRendererField.setAccessible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.viewerP.setNumDim(this.ndims);
        this.viewerQ.setNumDim(this.ndims);
        this.bwTransform = new BigWarpTransform(this.landmarkModel);
        this.bwTransform.initializeInverseParameters(this.data);
        this.transformSelector = new TransformTypeSelectDialog((Frame)this.landmarkFrame, this);
        InputTriggerConfig keyProperties = BigDataViewer.getInputTriggerConfig((ViewerOptions)this.options);
        WarpNavigationActions.installActionBindings(this.getViewerFrameP().getKeybindings(), this.viewerFrameP, (KeyStrokeAdder.Factory)keyProperties, this.ndims == 2);
        BigWarpActions.installActionBindings(this.getViewerFrameP().getKeybindings(), this, (KeyStrokeAdder.Factory)keyProperties);
        WarpNavigationActions.installActionBindings(this.getViewerFrameQ().getKeybindings(), this.viewerFrameQ, (KeyStrokeAdder.Factory)keyProperties, this.ndims == 2);
        BigWarpActions.installActionBindings(this.getViewerFrameQ().getKeybindings(), this, (KeyStrokeAdder.Factory)keyProperties);
        BigWarpActions.installLandmarkPanelActionBindings(this.landmarkFrame.getKeybindings(), this, this.landmarkTable, (KeyStrokeAdder.Factory)keyProperties);
        this.warpVisDialog.toleranceSpinner.setValue(this.bwTransform.getInverseTolerance());
        SwingUtilities.invokeLater(() -> this.landmarkFrame.setVisible(true));
    }

    public void initialize() {
        BigWarp.wrapMovingSources(this.ndims, this.data);
        if (this.data.numTargetSources() > 0) {
            this.data.getTargetSource(0).getSpimSource().getSourceTransform(0, 0, this.fixedViewXfm);
        }
        this.synchronizeSources();
        this.data.transferChannelSettings(this.viewerFrameP);
        this.data.transferChannelSettings(this.viewerFrameQ);
        this.updateSourceBoundingBoxEstimators();
        this.setAllSourcesActiveInFused();
        this.createMovingTargetGroups();
        this.viewerP.state().setCurrentGroup(this.mvgGrp);
        this.viewerP.state().setCurrentGroup(this.tgtGrp);
        if (this.data.numMovingSources() == 1) {
            this.viewerP.state().setCurrentSource(this.data.getMovingSource(0));
        } else {
            this.viewerP.state().setDisplayMode(DisplayMode.GROUP);
            this.viewerP.state().setCurrentGroup(this.mvgGrp);
        }
        if (this.data.numTargetSources() == 1) {
            this.viewerQ.state().setCurrentSource(this.data.getTargetSource(0));
        } else {
            this.viewerQ.state().setDisplayMode(DisplayMode.GROUP);
            this.viewerQ.state().setCurrentGroup(this.tgtGrp);
        }
        InitializeViewerState.initTransform((AbstractViewerPanel)this.viewerP);
        InitializeViewerState.initTransform((AbstractViewerPanel)this.viewerQ);
        this.initialViewP = new AffineTransform3D();
        this.initialViewQ = new AffineTransform3D();
        this.viewerP.state().getViewerTransform(this.initialViewP);
        this.viewerQ.state().getViewerTransform(this.initialViewQ);
    }

    protected void setupLandmarkFrame() {
        Point loc = null;
        Dimension sz = null;
        if (this.landmarkFrame != null) {
            loc = this.landmarkFrame.getLocation();
            sz = this.landmarkFrame.getSize();
            this.landmarkModel = null;
            this.landmarkFrame.setVisible(false);
            this.landmarkFrame.dispose();
            this.landmarkFrame = null;
            this.landmarkPanel = null;
        }
        this.landmarkModel = new LandmarkTableModel(this.ndims);
        this.landmarkModellistener = new LandmarkTableListener();
        this.landmarkModel.addTableModelListener(this.landmarkModellistener);
        this.addTransformListener(this.landmarkModel);
        this.landmarkPanel = new BigWarpLandmarkPanel(this.landmarkModel);
        this.landmarkPanel.setOpaque(true);
        this.landmarkTable = this.landmarkPanel.getJTable();
        this.landmarkTable.setDefaultRenderer(Object.class, new WarningTableCellRenderer());
        this.addDefaultTableMouseListener();
        this.landmarkFrame = new BigWarpLandmarkFrame("Landmarks", this.landmarkPanel, this, this.keymapManager);
        this.landmarkPopupMenu = new LandmarkPointMenu(this);
        this.landmarkPopupMenu.setupListeners();
        if (this.overlayP != null) {
            this.overlayP.setLandmarkPanel(this.landmarkPanel);
        }
        if (this.overlayQ != null) {
            this.overlayQ.setLandmarkPanel(this.landmarkPanel);
        }
        if (loc != null) {
            this.landmarkFrame.setLocation(loc);
        }
        if (sz != null) {
            this.landmarkFrame.setSize(sz);
        }
        SwingUtilities.invokeLater(() -> {
            this.setUpLandmarkMenus();
            this.landmarkFrame.pack();
        });
    }

    public void synchronizeSources() {
        SynchronizedViewerState pState = this.viewerP.state();
        SynchronizedViewerState qState = this.viewerQ.state();
        HashSet activeSourcesP = new HashSet(pState.getActiveSources());
        HashSet activeSourcesQ = new HashSet(qState.getActiveSources());
        pState.clearSources();
        qState.clearSources();
        ArrayList<ConverterSetup> converterSetupsToRemove = new ArrayList<ConverterSetup>(this.setupAssignments.getConverterSetups());
        converterSetupsToRemove.forEach(arg_0 -> ((SetupAssignments)this.setupAssignments).removeSetup(arg_0));
        for (int i = 0; i < this.data.sources.size(); ++i) {
            SourceAndConverter sac = this.data.sources.get(i);
            pState.addSource(sac);
            if (activeSourcesP.contains(sac)) {
                pState.setSourceActive(sac, true);
            }
            qState.addSource(sac);
            if (activeSourcesQ.contains(sac)) {
                qState.setSourceActive(sac, true);
            }
            ConverterSetup setup = this.data.converterSetups.get(i);
            this.viewerFrameP.getConverterSetups().put(sac, setup);
            this.viewerFrameQ.getConverterSetups().put(sac, setup);
            this.setupAssignments.addSetup(setup);
        }
    }

    protected void setAllSourcesActiveInFused() {
        this.viewerP.state().setSourcesActive(this.data.sources, true);
        this.viewerQ.state().setSourcesActive(this.data.sources, true);
    }

    public void createMovingTargetGroups() {
        this.mvgGrp = new SourceGroup();
        this.tgtGrp = new SourceGroup();
        SynchronizedViewerState pState = this.viewerP.state();
        pState.addGroup(this.mvgGrp);
        pState.addGroup(this.tgtGrp);
        pState.setGroupName(this.mvgGrp, "moving images");
        pState.setGroupName(this.tgtGrp, "target images");
        SynchronizedViewerState qState = this.viewerQ.state();
        qState.addGroup(this.mvgGrp);
        qState.addGroup(this.tgtGrp);
        qState.setGroupName(this.mvgGrp, "moving images");
        qState.setGroupName(this.tgtGrp, "target images");
        for (SourceAndConverter sac : this.data.sources) {
            if (this.data.isMoving(sac)) {
                this.viewerP.state().addSourceToGroup(sac, this.mvgGrp);
                this.viewerQ.state().addSourceToGroup(sac, this.mvgGrp);
                continue;
            }
            this.viewerP.state().addSourceToGroup(sac, this.tgtGrp);
            this.viewerQ.state().addSourceToGroup(sac, this.tgtGrp);
        }
    }

    public int numDimensions() {
        return this.ndims;
    }

    @Deprecated
    public static void initBrightness(double cumulativeMinCutoff, double cumulativeMaxCutoff, ViewerState state, ConverterSetups converterSetups) {
        SourceAndConverter current = state.getCurrentSource();
        if (current == null) {
            return;
        }
        Source source = current.getSpimSource();
        int timepoint = state.getCurrentTimepoint();
        Bounds bounds = InitializeViewerState.estimateSourceRange((Source)source, (int)timepoint, (double)cumulativeMinCutoff, (double)cumulativeMaxCutoff);
        ConverterSetup setup = converterSetups.getConverterSetup(current);
        setup.setDisplayRange(bounds.getMinBound(), bounds.getMaxBound());
    }

    public void addSources(LinkedHashMap<Source<T>, SourceInfo> sources) {
        BigWarpInit.add(this.data, sources);
        this.synchronizeSources();
    }

    public void addSource(Source<T> source, boolean moving) {
        this.data.addSource(source, moving);
        this.synchronizeSources();
    }

    public void addSource(Source<T> source) {
        this.addSource(source, false);
    }

    public int removeSource(SourceInfo info) {
        int removedIdx = this.data.remove(info);
        this.synchronizeSources();
        return removedIdx;
    }

    public void removeSource(int i) {
        this.data.remove(i);
        this.synchronizeSources();
    }

    public void addKeyEventPostProcessor(KeyEventPostProcessor ke) {
        this.keyEventPostProcessorSet.add(ke);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(ke);
    }

    public void removeKeyEventPostProcessor(KeyEventPostProcessor ke) {
        this.keyEventPostProcessorSet.remove(ke);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(ke);
    }

    public void closeAll() {
        ArrayList<KeyEventPostProcessor> ks = new ArrayList<KeyEventPostProcessor>(this.keyEventPostProcessorSet);
        for (KeyEventPostProcessor ke : ks) {
            this.removeKeyEventPostProcessor(ke);
        }
        this.repeatedKeyEventsFixer.remove();
        this.viewerFrameP.setVisible(false);
        this.viewerFrameQ.setVisible(false);
        this.landmarkFrame.setVisible(false);
        this.viewerFrameP.getViewerPanel().stop();
        this.viewerFrameQ.getViewerPanel().stop();
        this.viewerFrameP.dispose();
        this.viewerFrameQ.dispose();
        this.landmarkFrame.dispose();
    }

    public void setUpdateWarpOnChange(boolean updateWarpOnPtChange) {
        this.updateWarpOnPtChange = updateWarpOnPtChange;
    }

    public void toggleUpdateWarpOnChange() {
        boolean bl = this.updateWarpOnPtChange = !this.updateWarpOnPtChange;
        if (this.updateWarpOnPtChange) {
            this.message.showMessage("Always estimate transform on change");
        } else {
            this.message.showMessage("Estimate transform on request only");
        }
    }

    public boolean isUpdateWarpOnChange() {
        return this.updateWarpOnPtChange;
    }

    public void invertPointCorrespondences() {
        this.landmarkModel = this.landmarkModel.invert();
        this.landmarkPanel.setTableModel(this.landmarkModel);
    }

    public File getLastDirectory() {
        return this.lastDirectory;
    }

    public void setLastDirectory(File dir) {
        this.lastDirectory = dir;
    }

    public void setSpotColor(Color c) {
        this.viewerSettings.setSpotColor(c);
        this.viewerP.requestRepaint();
        this.viewerQ.requestRepaint();
    }

    protected void setUpViewerMenu(BigWarpViewerFrame vframe) {
        ActionMap actionMap = vframe.getKeybindings().getConcatenatedActionMap();
        JMenuBar viewerMenuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        viewerMenuBar.add(fileMenu);
        JMenuItem loadProject = new JMenuItem(actionMap.get("load project"));
        loadProject.setText("Load project");
        fileMenu.add(loadProject);
        JMenuItem saveProject = new JMenuItem(actionMap.get("save project"));
        saveProject.setText("Save project");
        fileMenu.add(saveProject);
        fileMenu.addSeparator();
        JMenuItem openItem = new JMenuItem(actionMap.get("load landmarks"));
        openItem.setText("Import landmarks");
        fileMenu.add(openItem);
        JMenuItem saveItem = new JMenuItem(actionMap.get("save landmarks"));
        saveItem.setText("Export landmarks");
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        JMenuItem openMask = new JMenuItem(actionMap.get("import mask"));
        openMask.setText("Import mask");
        fileMenu.add(openMask);
        JMenuItem removeMask = new JMenuItem(actionMap.get("remove mask"));
        removeMask.setText("Remove mask");
        fileMenu.add(removeMask);
        fileMenu.addSeparator();
        JMenuItem miLoadSettings = new JMenuItem(actionMap.get("load settings"));
        miLoadSettings.setText("Load settings");
        fileMenu.add(miLoadSettings);
        JMenuItem miSaveSettings = new JMenuItem(actionMap.get("save settings"));
        miSaveSettings.setText("Save settings");
        fileMenu.add(miSaveSettings);
        fileMenu.addSeparator();
        JMenuItem exportToImagePlus = new JMenuItem(actionMap.get("export image"));
        exportToImagePlus.setText("Export moving image");
        fileMenu.add(exportToImagePlus);
        JMenuItem exportWarpField = new JMenuItem(actionMap.get("export warp field"));
        exportWarpField.setText("Export transformation");
        fileMenu.add(exportWarpField);
        JMenu settingsMenu = new JMenu("Settings");
        viewerMenuBar.add(settingsMenu);
        JMenuItem toggleAlwaysWarpMenu = vframe.isMoving() ? (this.toggleAlwaysWarpMenuP = new JMenuItem((Action)((Object)new BigWarpActions.ToggleAlwaysEstimateTransformAction("", vframe)))) : (this.toggleAlwaysWarpMenuQ = new JMenuItem((Action)((Object)new BigWarpActions.ToggleAlwaysEstimateTransformAction("", vframe))));
        toggleAlwaysWarpMenu.setText("Toggle warp on drag");
        settingsMenu.add(toggleAlwaysWarpMenu);
        JMenuItem transformTypeMenu = new JMenuItem(actionMap.get("transform type"));
        transformTypeMenu.setText("Transformation Options");
        settingsMenu.add(transformTypeMenu);
        JMenuItem warpVisMenu = new JMenuItem(actionMap.get("show warp vis dialog"));
        warpVisMenu.setText("BigWarp Options");
        settingsMenu.add(warpVisMenu);
        vframe.setJMenuBar(viewerMenuBar);
        JMenu helpMenu = new JMenu("Help");
        viewerMenuBar.add(helpMenu);
        JMenuItem miHelp = new JMenuItem(actionMap.get("help"));
        miHelp.setText("Show Help Menu");
        helpMenu.add(miHelp);
        JMenuItem miSrcInfo = new JMenuItem(actionMap.get("show source info"));
        miSrcInfo.setText("Show source information");
        helpMenu.add(miSrcInfo);
    }

    protected void setupImageJExportOption() {
        ActionMap actionMap = this.landmarkFrame.getKeybindings().getConcatenatedActionMap();
        JMenuItem exportToImagePlus = new JMenuItem(actionMap.get("export image"));
        exportToImagePlus.setText("Export moving image");
        this.fileMenu.add(exportToImagePlus);
        JMenuItem exportWarpField = new JMenuItem(actionMap.get("export warp field"));
        exportWarpField.setText("Export warp field");
        this.fileMenu.add(exportWarpField);
    }

    public void exportAsImagePlus(boolean virtual) {
        this.exportAsImagePlus(virtual, "");
    }

    @Deprecated
    public void saveMovingImageToFile() {
        JFileChooser fileChooser = new JFileChooser(this.getLastDirectory());
        File proposedFile = new File(this.data.getMovingSource(0).getSpimSource().getName());
        fileChooser.setSelectedFile(proposedFile);
        int returnVal = fileChooser.showSaveDialog(null);
        if (returnVal == 0) {
            proposedFile = fileChooser.getSelectedFile();
            try {
                this.exportAsImagePlus(false, proposedFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public File saveMovingImageXml() {
        return this.saveMovingImageXml(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File saveMovingImageXml(String proposedFilePath) {
        File proposedFile;
        if (this.movingSpimData == null) {
            IJ.log((String)"Cannot save warped moving image XML, because the input image was not a BDV/XML.");
            return null;
        }
        AffineTransform3D bigWarpTransform = this.getMovingToFixedTransformAsAffineTransform3D();
        System.out.println("bigWarp transform as affine 3d: " + bigWarpTransform.toString());
        this.movingSpimData.getViewRegistrations().getViewRegistration(0, 0).preconcatenateTransform((ViewTransform)new ViewTransformAffine("Big Warp: " + this.bwTransform.getTransformType(), bigWarpTransform));
        if (proposedFilePath == null) {
            JFileChooser fileChooser = new JFileChooser(this.movingImageXml.getParent());
            proposedFile = new File(this.movingImageXml.getName().replace(".xml", "-bigWarp.xml"));
            fileChooser.setSelectedFile(proposedFile);
            int returnVal = fileChooser.showSaveDialog(null);
            if (returnVal != 0) return null;
            proposedFile = fileChooser.getSelectedFile();
        } else {
            proposedFile = new File(proposedFilePath);
        }
        try {
            new XmlIoSpimData().save((AbstractSpimData)this.movingSpimData, proposedFile.getAbsolutePath());
            return proposedFile;
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
        return proposedFile;
    }

    public AffineTransform3D getMovingToFixedTransformAsAffineTransform3D() {
        double[][] affine3DMatrix = new double[3][4];
        double[][] affine2DMatrix = new double[2][3];
        if (this.currentTransform == null) {
            return null;
        }
        InvertibleCoordinateTransform transform = ((WrappedCoordinateTransform)this.currentTransform).getTransform().createInverse();
        if (transform instanceof AffineModel3D) {
            ((AffineModel3D)transform).toMatrix(affine3DMatrix);
        } else if (transform instanceof SimilarityModel3D) {
            ((SimilarityModel3D)transform).toMatrix(affine3DMatrix);
        } else if (transform instanceof RigidModel3D) {
            ((RigidModel3D)transform).toMatrix(affine3DMatrix);
        } else if (transform instanceof TranslationModel3D) {
            ((TranslationModel3D)transform).toMatrix(affine3DMatrix);
        } else if (transform instanceof AffineModel2D) {
            ((AffineModel2D)transform).toMatrix(affine2DMatrix);
            this.affineMatrix2DtoAffineMatrix3D(affine2DMatrix, affine3DMatrix);
        } else if (transform instanceof SimilarityModel2D) {
            ((SimilarityModel2D)transform).toMatrix(affine2DMatrix);
            this.affineMatrix2DtoAffineMatrix3D(affine2DMatrix, affine3DMatrix);
        } else if (transform instanceof RigidModel2D) {
            ((RigidModel2D)transform).toMatrix(affine2DMatrix);
            this.affineMatrix2DtoAffineMatrix3D(affine2DMatrix, affine3DMatrix);
        } else if (transform instanceof TranslationModel2D) {
            ((TranslationModel2D)transform).toMatrix(affine2DMatrix);
            this.affineMatrix2DtoAffineMatrix3D(affine2DMatrix, affine3DMatrix);
        } else {
            IJ.error((String)("Cannot convert transform of type " + transform.getClass().toString() + "\nto an 3D affine tranform."));
            return null;
        }
        AffineTransform3D bigWarpTransform = new AffineTransform3D();
        bigWarpTransform.set(affine3DMatrix);
        return bigWarpTransform;
    }

    private void affineMatrix2DtoAffineMatrix3D(double[][] affine2DMatrix, double[][] affine3DMatrix) {
        for (int d = 0; d < 2; ++d) {
            affine3DMatrix[d][0] = affine2DMatrix[d][0];
            affine3DMatrix[d][1] = affine2DMatrix[d][1];
            affine3DMatrix[d][3] = affine2DMatrix[d][2];
        }
    }

    public void exportAsImagePlus(boolean virtual, String path) {
        if (ij == null) {
            return;
        }
        GenericDialogPlus gd = new GenericDialogPlus("Apply Big Warp transform");
        gd.addMessage("Field of view and resolution:");
        gd.addChoice("Resolution", new String[]{"Target", "Moving", "Specified"}, "Target");
        gd.addChoice("Field of view", new String[]{"Target", "Moving (warped)", "Union of Target and warped moving image", "Landmark points", "Landmark point cube (pixel units)", "Landmark point cube (physical units)", "Specified (pixel units)", "Specified (physical units)"}, "Target");
        gd.addStringField("point filter", "");
        gd.addMessage("Resolution");
        gd.addNumericField("x", 1.0, 4);
        gd.addNumericField("y", 1.0, 4);
        gd.addNumericField("z", 1.0, 4);
        gd.addMessage("Offset");
        gd.addNumericField("x", 0.0, 4);
        gd.addNumericField("y", 0.0, 4);
        gd.addNumericField("z", 0.0, 4);
        gd.addMessage("Field of view");
        gd.addNumericField("x", -1.0, 0);
        gd.addNumericField("y", -1.0, 0);
        gd.addNumericField("z", -1.0, 0);
        gd.addMessage("Other Output options");
        gd.addChoice("Interpolation", new String[]{"Nearest Neighbor", "Linear"}, "Linear");
        gd.addMessage("Virtual: fast to display,\nlow memory requirements,\nbut slow to navigate");
        gd.addCheckbox("virtual?", false);
        int defaultCores = (int)Math.ceil(Runtime.getRuntime().availableProcessors() / 4);
        gd.addNumericField("threads", (double)defaultCores, 0);
        gd.addMessage("Writing options (leave empty to opena new image window)");
        gd.addDirectoryOrFileField("File or n5 root", "");
        gd.addStringField("n5 dataset", "");
        gd.addStringField("n5 block size", "32");
        gd.addChoice("n5 compression", new String[]{"gzip", "raw", "lz4", "xz", "blosc"}, "gzip");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String resolutionOption = gd.getNextChoice();
        final String fieldOfViewOption = gd.getNextChoice();
        String fieldOfViewPointFilter = gd.getNextString();
        double[] resolutionSpec = new double[]{gd.getNextNumber(), gd.getNextNumber(), gd.getNextNumber()};
        final double[] offsetSpec = new double[]{gd.getNextNumber(), gd.getNextNumber(), gd.getNextNumber()};
        double[] fovSpec = new double[]{gd.getNextNumber(), gd.getNextNumber(), gd.getNextNumber()};
        String interpType = gd.getNextChoice();
        boolean isVirtual = gd.getNextBoolean();
        final int nThreads = (int)gd.getNextNumber();
        String fileOrN5Root = gd.getNextString();
        String n5Dataset = gd.getNextString();
        String blockSizeString = gd.getNextString();
        String compressionString = gd.getNextChoice();
        int[] blockSize = ApplyBigwarpPlugin.parseBlockSize(blockSizeString, this.ndims);
        Compression compression = ApplyBigwarpPlugin.getCompression(compressionString);
        final ApplyBigwarpPlugin.WriteDestinationOptions writeOpts = new ApplyBigwarpPlugin.WriteDestinationOptions(fileOrN5Root, n5Dataset, blockSize, compression);
        final Interpolation interp = interpType.equals("Nearest Neighbor") ? Interpolation.NEARESTNEIGHBOR : Interpolation.NLINEAR;
        final double[] res = ApplyBigwarpPlugin.getResolution(this.data, resolutionOption, resolutionSpec);
        final List<Interval> outputIntervalList = ApplyBigwarpPlugin.getPixelInterval(this.data, this.landmarkModel, this.currentTransform, fieldOfViewOption, fieldOfViewPointFilter, this.bboxOptions, fovSpec, offsetSpec, res);
        ArrayList<String> matchedPtNames = new ArrayList<String>();
        if (outputIntervalList.size() > 1) {
            ApplyBigwarpPlugin.fillMatchedPointNames(matchedPtNames, this.getLandmarkPanel().getTableModel(), fieldOfViewPointFilter);
        }
        if (matchedPtNames.size() > 0) {
            BigwarpLandmarkSelectionPanel<T> bigwarpLandmarkSelectionPanel = new BigwarpLandmarkSelectionPanel<T>(this.data, this.data.sources, fieldOfViewOption, outputIntervalList, matchedPtNames, interp, offsetSpec, res, isVirtual, nThreads, this.progressWriter);
        } else if (writeOpts.n5Dataset != null && !writeOpts.n5Dataset.isEmpty()) {
            final String unit = ApplyBigwarpPlugin.getUnit(this.data, resolutionOption);
            new Thread(){

                @Override
                public void run() {
                    BigWarp.this.progressWriter.setProgress(0.01);
                    ApplyBigwarpPlugin.runN5Export(BigWarp.this.data, BigWarp.this.data.sources, fieldOfViewOption, (Interval)outputIntervalList.get(0), interp, offsetSpec, res, unit, BigWarp.this.progressWriter, writeOpts, Executors.newFixedThreadPool(nThreads));
                    BigWarp.this.progressWriter.setProgress(1.0);
                }
            }.start();
        } else {
            boolean show = writeOpts.pathOrN5Root == null || writeOpts.pathOrN5Root.isEmpty();
            ApplyBigwarpPlugin.runExport(this.data, this.data.sources, fieldOfViewOption, outputIntervalList, matchedPtNames, interp, offsetSpec, res, isVirtual, nThreads, this.progressWriter, show, false, writeOpts);
        }
    }

    public void exportWarpField() {
        ExportDisplacementFieldFrame.createAndShow(this);
    }

    protected void setUpLandmarkMenus() {
        ActionMap actionMap = this.landmarkFrame.getKeybindings().getConcatenatedActionMap();
        JMenuBar landmarkMenuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        JMenuItem openItem = new JMenuItem(actionMap.get("load landmarks"));
        openItem.setText("Import landmarks");
        this.fileMenu.add(openItem);
        JMenuItem saveItem = new JMenuItem(actionMap.get("save landmarks"));
        saveItem.setText("Export landmarks");
        this.fileMenu.add(saveItem);
        this.fileMenu.addSeparator();
        JMenuItem exportImageItem = new JMenuItem("Export Moving Image");
        landmarkMenuBar.add(this.fileMenu);
        this.landmarkFrame.setJMenuBar(landmarkMenuBar);
        JMenuItem saveExport = new JMenuItem(actionMap.get("save warped"));
        saveExport.setText("Save warped image");
        this.fileMenu.add(saveExport);
        JMenu landmarkMenu = new JMenu("Landmarks");
        JMenuItem landmarkGridItem = new JMenuItem(actionMap.get("landmark grid dialog"));
        landmarkGridItem.setText("Build landmark grid");
        landmarkMenu.add(landmarkGridItem);
        landmarkMenuBar.add(landmarkMenu);
        if (ij != null) {
            this.setupImageJExportOption();
        }
    }

    public Bookmarks getBookmarks() {
        return this.bookmarks;
    }

    public BigWarpViewerFrame getViewerFrameP() {
        return this.viewerFrameP;
    }

    public BigWarpViewerFrame getViewerFrameQ() {
        return this.viewerFrameQ;
    }

    public BigWarpOverlay getOverlayP() {
        return this.overlayP;
    }

    public BigWarpOverlay getOverlayQ() {
        return this.overlayQ;
    }

    public SetupAssignments getSetupAssignments() {
        return this.setupAssignments;
    }

    public BigWarpData<T> getData() {
        return this.data;
    }

    public List<SourceAndConverter<T>> getSources() {
        return this.data.sources;
    }

    public BigWarpLandmarkFrame getLandmarkFrame() {
        return this.landmarkFrame;
    }

    public BigWarpLandmarkPanel getLandmarkPanel() {
        return this.landmarkPanel;
    }

    public boolean isInLandmarkMode() {
        return this.inLandmarkMode;
    }

    public void toggleInLandmarkMode() {
        this.setInLandmarkMode(!this.inLandmarkMode);
    }

    public void setInLandmarkMode(boolean inLmMode) {
        if (this.inLandmarkMode == inLmMode) {
            return;
        }
        if (inLmMode) {
            this.disableTransformHandlers();
            this.message.showMessage("Landmark mode on");
            this.viewerFrameP.setCursor(Cursor.getPredefinedCursor(1));
            this.viewerFrameQ.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.enableTransformHandlers();
            this.message.showMessage("Landmark mode off");
            this.viewerFrameP.setCursor(Cursor.getPredefinedCursor(0));
            this.viewerFrameQ.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.inLandmarkMode = inLmMode;
    }

    public void updatePointLocation(double[] ptarray, boolean isMoving, int selectedPointIndex, BigWarpViewerPanel viewer) {
        boolean isMovingViewerXfm = viewer.getOverlay().getIsTransformed();
        if (this.landmarkModel.getTransform() == null || !isMovingViewerXfm) {
            this.landmarkModel.setPoint(selectedPointIndex, isMoving, ptarray, false, (RealTransform)this.currentTransform);
            if (!isMoving && !this.landmarkModel.isWarped(selectedPointIndex).booleanValue()) {
                this.landmarkModel.updateWarpedPoint(selectedPointIndex, ptarray);
            }
        } else {
            this.landmarkModel.getTransform().apply(ptarray, this.ptBack);
            this.landmarkModel.updateWarpedPoint(selectedPointIndex, ptarray);
        }
        if (this.landmarkFrame.isVisible()) {
            this.landmarkFrame.repaint();
            viewer.requestRepaint();
        }
    }

    public void updatePointLocation(double[] ptarray, boolean isMoving, int selectedPointIndex) {
        if (isMoving) {
            this.updatePointLocation(ptarray, isMoving, selectedPointIndex, this.viewerP);
        } else {
            this.updatePointLocation(ptarray, isMoving, selectedPointIndex, this.viewerQ);
        }
    }

    public int updateWarpedPoint(double[] ptarray, boolean isMoving) {
        int selectedPointIndex = this.selectedLandmark(ptarray, isMoving);
        if (selectedPointIndex >= 0 && !isMoving && this.landmarkModel.getTransform() != null) {
            this.landmarkModel.updateWarpedPoint(selectedPointIndex, ptarray);
        }
        return selectedPointIndex;
    }

    public void updateRowSelection(boolean isMoving, int lastRowEdited) {
        BigWarp.updateRowSelection(this.landmarkModel, this.landmarkTable, isMoving, lastRowEdited);
        this.landmarkPanel.repaint();
    }

    public static void updateRowSelection(LandmarkTableModel landmarkModel, JTable table, boolean isMoving, int lastRowEdited) {
        int i = landmarkModel.getNextRow(isMoving);
        if (i < table.getRowCount()) {
            table.setRowSelectionInterval(i, i);
        } else if (lastRowEdited >= 0 && lastRowEdited < table.getRowCount()) {
            table.setRowSelectionInterval(lastRowEdited, lastRowEdited);
        }
    }

    public int getSelectedUnpairedRow(boolean isMoving) {
        int row = this.landmarkTable.getSelectedRow();
        if (row >= 0 && (isMoving ? !this.landmarkModel.isMovingPoint(row) : !this.landmarkModel.isFixedPoint(row))) {
            return row;
        }
        return -1;
    }

    public String addPoint(double[] ptarray, boolean isMoving, BigWarpViewerPanel viewer) {
        boolean isViewerTransformed = viewer.getOverlay().getIsTransformed();
        if (!isMoving && viewer.getIsMoving() && !isViewerTransformed) {
            return "Adding a fixed point in moving image space not supported";
        }
        this.addPoint(ptarray, isMoving);
        return "";
    }

    public boolean addPoint(double[] ptarray, boolean isMoving) {
        boolean isWarped = isMoving && this.landmarkModel.getTransform() != null && this.isMovingDisplayTransformed();
        InvertibleRealTransform transform = this.options.values.is2D() && this.currentTransform != null ? ((InvertibleWrapped2DTransformAs3D)this.currentTransform).getTransform() : this.currentTransform;
        boolean didAdd = this.landmarkModel.pointEdit(-1, ptarray, false, isMoving, isWarped, true, (RealTransform)transform);
        if (this.landmarkFrame.isVisible()) {
            this.landmarkFrame.repaint();
        }
        return didAdd;
    }

    protected int selectedLandmark(double[] pt, boolean isMoving) {
        return this.selectedLandmark(pt, isMoving, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int selectedLandmark(double[] pt, boolean isMoving, boolean selectInTable) {
        if (this.landmarkModel == null) {
            return -1;
        }
        double radsq = this.viewerSettings.getSpotSize() * this.viewerSettings.getSpotSize() + 5.0;
        AffineTransform3D viewerXfm = new AffineTransform3D();
        if (isMoving) {
            this.viewerP.state().getViewerTransform(viewerXfm);
            radsq = this.viewerP.getSettings().getSpotSize();
        } else {
            this.viewerQ.state().getViewerTransform(viewerXfm);
            radsq = this.viewerQ.getSettings().getSpotSize();
        }
        radsq *= radsq;
        double scale = BigWarp.computeScaleAssumeRigid(viewerXfm);
        double dist = 0.0;
        int bestIdx = -1;
        double smallestDist = Double.MAX_VALUE;
        LandmarkTableModel landmarkTableModel = this.landmarkModel;
        synchronized (landmarkTableModel) {
            int N = this.landmarkModel.getRowCount();
            for (int n = 0; n < N; ++n) {
                Double[] lmpt = isMoving && this.landmarkModel.isWarped(n) != false && this.isMovingDisplayTransformed() ? this.landmarkModel.getWarpedPoints().get(n) : (isMoving && this.isMovingDisplayTransformed() ? this.landmarkModel.getPoints(false).get(n) : this.landmarkModel.getPoints(isMoving).get(n));
                dist = 0.0;
                for (int i = 0; i < this.landmarkModel.getNumdims(); ++i) {
                    dist += (pt[i] - lmpt[i]) * (pt[i] - lmpt[i]);
                }
                if (!((dist *= scale * scale) < radsq) || !(dist < smallestDist)) continue;
                smallestDist = dist;
                bestIdx = n;
            }
            if (selectInTable && this.landmarkFrame.isVisible()) {
                if (this.landmarkTable.isEditing()) {
                    this.landmarkTable.getCellEditor().stopCellEditing();
                }
                this.landmarkTable.setEditingRow(bestIdx);
                this.landmarkFrame.repaint();
            }
        }
        return bestIdx;
    }

    public void selectAllLandmarks() {
        this.getLandmarkPanel().getJTable().selectAll();
    }

    public static double computeScaleAssumeRigid(AffineTransform3D xfm) {
        return xfm.get(0, 0) + xfm.get(0, 1) + xfm.get(0, 2);
    }

    protected void disableTransformHandlers() {
        this.viewerFrameP.setTransformEnabled(false);
        this.viewerFrameQ.setTransformEnabled(false);
    }

    protected void enableTransformHandlers() {
        this.viewerFrameP.setTransformEnabled(true);
        this.viewerFrameQ.setTransformEnabled(true);
    }

    private void printSourceTransforms() {
        AffineTransform3D xfm = new AffineTransform3D();
        for (SourceAndConverter sac : this.data.sources) {
            sac.getSpimSource().getSourceTransform(0, 0, xfm);
            double det = BigWarpUtils.det(xfm);
            System.out.println("source xfm ( " + sac.getSpimSource().getName() + " ) : " + xfm);
            System.out.println("    det = " + det);
        }
    }

    private void printViewerTransforms() {
        AffineTransform3D xfm = new AffineTransform3D();
        this.viewerP.state().getViewerTransform(xfm);
        System.out.println("mvg viewer xfm: " + xfm);
        System.out.println("    det   = " + BigWarpUtils.det(xfm));
        System.out.println("    dotxy = " + BigWarpUtils.dotXy(xfm));
        this.viewerQ.state().getViewerTransform(xfm);
        System.out.println("tgt viewer xfm: " + xfm);
        System.out.println("    det   = " + BigWarpUtils.det(xfm));
        System.out.println("    dotxy = " + BigWarpUtils.dotXy(xfm));
    }

    protected void alignActive(AbstractViewerPanel.AlignPlane plane) {
        if (this.viewerFrameP.isActive()) {
            this.viewerFrameP.getViewerPanel().align(plane);
        } else if (this.viewerFrameQ.isActive()) {
            this.viewerFrameQ.getViewerPanel().align(plane);
        }
    }

    protected void matchWindowTransforms(BigWarpViewerPanel panelToChange, BigWarpViewerPanel panelToMatch) {
        panelToChange.showMessage("Aligning");
        panelToMatch.showMessage("Matching alignment");
        AffineTransform3D viewXfm = new AffineTransform3D();
        panelToMatch.state().getViewerTransform(viewXfm);
        panelToChange.animateTransformation(viewXfm);
    }

    public void matchOtherViewerPanelToActive() {
        BigWarpViewerPanel panelToMatch;
        BigWarpViewerPanel panelToChange;
        if (this.inLandmarkMode) {
            this.message.showMessage("Can't move viewer in landmark mode.");
            return;
        }
        if (this.viewerFrameP.isActive()) {
            panelToChange = this.viewerQ;
            panelToMatch = this.viewerP;
        } else if (this.viewerFrameQ.isActive()) {
            panelToChange = this.viewerP;
            panelToMatch = this.viewerQ;
        } else {
            return;
        }
        this.matchWindowTransforms(panelToChange, panelToMatch);
    }

    public void matchActiveViewerPanelToOther() {
        BigWarpViewerPanel panelToMatch;
        BigWarpViewerPanel panelToChange;
        if (this.inLandmarkMode) {
            this.message.showMessage("Can't move viewer in landmark mode.");
            return;
        }
        if (this.viewerFrameP.isActive()) {
            panelToChange = this.viewerP;
            panelToMatch = this.viewerQ;
        } else if (this.viewerFrameQ.isActive()) {
            panelToChange = this.viewerQ;
            panelToMatch = this.viewerP;
        } else {
            return;
        }
        this.matchWindowTransforms(panelToChange, panelToMatch);
    }

    public void jumpToLandmarkRelative(int inc) {
        int[] selectedRows = this.getLandmarkPanel().getJTable().getSelectedRows();
        int row = 0;
        if (selectedRows.length > 0) {
            row = selectedRows[selectedRows.length - 1];
        }
        if ((row += inc) >= this.getLandmarkPanel().getTableModel().getRowCount()) {
            row = 0;
        } else if (row < 0) {
            row = this.getLandmarkPanel().getTableModel().getRowCount() - 1;
        }
        this.getLandmarkPanel().getJTable().setRowSelectionInterval(row, row);
        if (this.getViewerFrameP().isActive()) {
            this.jumpToLandmark(row, this.getViewerFrameP().getViewerPanel());
        } else {
            this.jumpToLandmark(row, this.getViewerFrameQ().getViewerPanel());
        }
    }

    public void jumpToNextLandmark() {
        this.jumpToLandmarkRelative(1);
    }

    public void jumpToPrevLandmark() {
        this.jumpToLandmarkRelative(-1);
    }

    public void jumpToNearestLandmark() {
        if (this.getViewerFrameP().isActive()) {
            this.jumpToNearestLandmark(this.getViewerFrameP().getViewerPanel());
        } else {
            this.jumpToNearestLandmark(this.getViewerFrameQ().getViewerPanel());
        }
    }

    public void jumpToNearestLandmark(BigWarpViewerPanel viewer) {
        if (this.inLandmarkMode) {
            this.message.showMessage("Can't move viewer in landmark mode.");
            return;
        }
        RealPoint mousePt = new RealPoint(3);
        viewer.getGlobalMouseCoordinates((RealPositionable)mousePt);
        this.jumpToLandmark(this.landmarkModel.getIndexNearestTo((RealLocalizable)mousePt, viewer.getIsMoving()), viewer);
    }

    public void jumpToSelectedLandmark() {
        int[] selectedRows = this.getLandmarkPanel().getJTable().getSelectedRows();
        int row = 0;
        if (selectedRows.length > 0) {
            row = selectedRows[0];
        }
        if (this.getViewerFrameP().isActive()) {
            this.jumpToLandmark(row, this.getViewerFrameP().getViewerPanel());
        } else {
            this.jumpToLandmark(row, this.getViewerFrameQ().getViewerPanel());
        }
    }

    public void jumpToLandmark(int row, BigWarpViewerPanel viewer) {
        if (this.inLandmarkMode) {
            this.message.showMessage("Can't move viewer in landmark mode.");
            return;
        }
        if (this.landmarkModel.getRowCount() < 1) {
            this.message.showMessage("No landmarks found.");
            return;
        }
        int offset = 0;
        int ndims = this.landmarkModel.getNumdims();
        double[] pt = null;
        if (viewer.getIsMoving() && viewer.getOverlay().getIsTransformed()) {
            if (this.landmarkModel.isWarped(row).booleanValue()) {
                pt = LandmarkTableModel.toPrimitive(this.landmarkModel.getWarpedPoints().get(row));
            } else {
                offset = ndims;
            }
        } else if (!viewer.getIsMoving()) {
            offset = ndims;
        }
        if (pt == null) {
            pt = ndims == 3 ? new double[]{(Double)this.landmarkModel.getValueAt(row, offset + 2), (Double)this.landmarkModel.getValueAt(row, offset + 3), (Double)this.landmarkModel.getValueAt(row, offset + 4)} : new double[]{(Double)this.landmarkModel.getValueAt(row, offset + 2), (Double)this.landmarkModel.getValueAt(row, offset + 3), 0.0};
        }
        if (Double.isInfinite((double)pt[0])) {
            return;
        }
        AffineTransform3D startTransform = viewer.state().getViewerTransform();
        AffineTransform3D destinationTransform = startTransform.copy();
        destinationTransform.set(0.0, 0, 3);
        destinationTransform.set(0.0, 1, 3);
        destinationTransform.set(0.0, 2, 3);
        double[] center = new double[]{viewer.getWidth() / 2, viewer.getHeight() / 2, 0.0};
        double[] ptxfm = new double[3];
        destinationTransform.apply(pt, ptxfm);
        this.landmarkTable.setRowSelectionInterval(row, row);
        double[] translation = ndims == 2 ? new double[]{center[0] - ptxfm[0], center[1] - ptxfm[1], startTransform.get(2, 3)} : new double[]{center[0] - ptxfm[0], center[1] - ptxfm[1], -ptxfm[2]};
        TranslationAnimator animator = new TranslationAnimator(startTransform, translation, 300L);
        viewer.setTransformAnimator((AbstractTransformAnimator)animator);
    }

    public void goToBookmark() {
        if (this.viewerFrameP.isActive()) {
            this.bookmarkEditorP.initGoToBookmark();
        } else if (this.viewerFrameQ.isActive()) {
            this.bookmarkEditorQ.initGoToBookmark();
        }
    }

    public void goToBookmarkRotation() {
        if (this.getViewerFrameP().isActive()) {
            this.bookmarkEditorP.initGoToBookmarkRotation();
        } else if (this.getViewerFrameP().isActive()) {
            this.bookmarkEditorQ.initGoToBookmarkRotation();
        }
    }

    public void setBookmark() {
        if (this.getViewerFrameP().isActive()) {
            this.bookmarkEditorP.initSetBookmark();
        } else if (this.getViewerFrameQ().isActive()) {
            this.bookmarkEditorQ.initSetBookmark();
        }
    }

    public void resetView() {
        RandomAccessibleInterval interval = this.getSources().get(1).getSpimSource().getSource(0, 0);
        AffineTransform3D viewXfm = new AffineTransform3D();
        viewXfm.identity();
        viewXfm.set((double)(-interval.min(2)), 2, 3);
        if (this.viewerFrameP.isActive()) {
            if (this.viewerP.getOverlay().getIsTransformed()) {
                this.viewerP.animateTransformation(this.initialViewQ);
            } else {
                this.viewerP.animateTransformation(this.initialViewP);
            }
        } else if (this.viewerFrameQ.isActive()) {
            this.viewerQ.animateTransformation(this.initialViewQ);
        }
    }

    public void toggleNameVisibility() {
        this.viewerSettings.toggleNamesVisible();
        this.viewerP.requestRepaint();
        this.viewerQ.requestRepaint();
    }

    public void togglePointVisibility() {
        this.viewerSettings.togglePointsVisible();
        this.viewerP.requestRepaint();
        this.viewerQ.requestRepaint();
    }

    public boolean toggleMovingImageDisplay() {
        boolean newState;
        boolean success = this.restimateTransformation();
        if (!success) {
            this.message.showMessage("Require at least 4 points to estimate a transformation");
            return false;
        }
        boolean bl = newState = !this.getOverlayP().getIsTransformed();
        if (newState) {
            this.message.showMessage("Displaying warped");
        } else {
            this.message.showMessage("Displaying raw");
        }
        this.setIsMovingDisplayTransformed(newState);
        return success;
    }

    public void toggleMaskOverlayVisibility() {
        BigWarpMaskSphereOverlay overlay = this.getViewerFrameQ().getViewerPanel().getMaskOverlay();
        if (overlay != null) {
            overlay.toggleVisible();
        }
    }

    public void setMaskOverlayVisibility(boolean visible) {
        BigWarpMaskSphereOverlay overlay = this.getViewerFrameQ().getViewerPanel().getMaskOverlay();
        if (overlay != null) {
            overlay.setVisible(visible);
        }
    }

    protected void addDefaultTableMouseListener() {
        this.landmarkTableListener = new MouseLandmarkTableListener();
        this.landmarkPanel.getJTable().addMouseListener(this.landmarkTableListener);
    }

    protected void addMaskMouseListener() {
        Color[] maskColors = new Color[]{Color.ORANGE, Color.YELLOW};
        this.viewerQ.setMaskOverlay(new BigWarpMaskSphereOverlay(this.viewerQ, maskColors, this.numDimensions() == 3));
        this.maskSourceMouseListenerQ = new MaskedSourceEditorMouseListener(this.getLandmarkPanel().getTableModel().getNumdims(), this, this.viewerQ);
        this.maskSourceMouseListenerQ.setActive(false);
        this.maskSourceMouseListenerQ.setMask(this.plateauTransformMask.getRandomAccessible());
        this.plateauTransformMask.getRandomAccessible().setOverlays(Arrays.asList(this.viewerQ.getMaskOverlay()));
    }

    public void setGridType(GridSource.GRID_TYPE method) {
        this.gridSource.setMethod(method);
    }

    public void transformationsFromCoordinateSystem() {
        System.out.println("transformationsFromCoordinateSystem");
        TransformGraph graph = this.warpVisDialog.transformGraphPanel.getGraph();
        if (graph == null) {
            return;
        }
        String destCsName = this.warpVisDialog.transformGraphPanel.getCoordinateSystem();
        boolean isDefault = destCsName.equals("<DEFAULT>");
        System.out.println("  : " + destCsName);
        boolean anyUpdated = false;
        for (SourceInfo srcInfo : this.data.sourceInfos.values()) {
            String csName = srcInfo.getSourceAndConverter().getSpimSource().getName();
            Optional p = graph.path(destCsName, csName);
            if (isDefault || csName.equals(destCsName)) {
                this.data.setTransformation(srcInfo, null, null);
                anyUpdated = true;
                continue;
            }
            if (!p.isPresent()) {
                System.err.println(String.format("WARNING: no suitable transformation found from %s to %s", csName, destCsName));
                continue;
            }
            if (csName.equals(destCsName)) continue;
            RealTransform tform = ((TransformPath)p.get()).totalTransform(this.warpVisDialog.transformGraphPanel.getN5());
            this.data.setTransformation(srcInfo, tform, null);
            anyUpdated = true;
        }
        if (anyUpdated) {
            this.synchronizeSources();
        }
    }

    public static <T> void wrapMovingSources(int ndims, BigWarpData<T> data) {
        data.wrapMovingSources();
    }

    public static <T> void wrapMovingSources(int ndims, BigWarpData<T> data, int id) {
        data.wrapMovingSources(data.getSourceInfo(id));
    }

    public static <T> List<SourceAndConverter<T>> wrapSourcesAsTransformed(LinkedHashMap<Integer, SourceInfo> sources, int ndims, BigWarpData<T> data) {
        return data.wrapSourcesAsTransformed();
    }

    private static <T> JacobianDeterminantSource addJacobianDeterminantSource(int ndims, BigWarpData<T> data, String name) {
        JacobianDeterminantSource<FloatType> jdSource = new JacobianDeterminantSource<FloatType>(name, data, new FloatType());
        LinkedHashMap infos = BigWarpInit.createSources(data, jdSource, 1006827158, false);
        LinkedHashMap<Integer, SourceInfo> id2Info = new LinkedHashMap<Integer, SourceInfo>(1);
        id2Info.put(1006827158, infos.get(jdSource));
        BigWarpInit.add(data, infos);
        data.getConverterSetup(1006827158).setDisplayRange(-1.0, 2.0);
        return jdSource;
    }

    private static <T> WarpMagnitudeSource addWarpMagnitudeSource(BigWarpData<T> data, boolean is2D, String name) {
        WarpMagnitudeSource<FloatType> magSource = new WarpMagnitudeSource<FloatType>(name, data, new FloatType());
        LinkedHashMap infos = BigWarpInit.createSources(data, magSource, 956736363, false);
        LinkedHashMap<Integer, SourceInfo> id2Info = new LinkedHashMap<Integer, SourceInfo>(1);
        id2Info.put(956736363, infos.get(magSource));
        BigWarpInit.add(data, infos);
        return magSource;
    }

    private static <T> GridSource addGridSource(int ndims, BigWarpData<T> data, String name, boolean isTransformed) {
        GridSource<FloatType> gridSource = new GridSource<FloatType>(name, data, new FloatType(), null);
        gridSource.setMethod(GridSource.GRID_TYPE.LINE);
        LinkedHashMap infos = BigWarpInit.createSources(data, gridSource, 1696993146, true);
        LinkedHashMap<Integer, SourceInfo> id2Info = new LinkedHashMap<Integer, SourceInfo>(1);
        id2Info.put(1696993146, infos.get(gridSource));
        BigWarpInit.add(data, infos);
        BigWarp.wrapMovingSources(ndims, data, 1696993146);
        SourceAndConverter<?> sourceAndConverter = data.sourceInfos.get(1696993146).getSourceAndConverter();
        ((WarpedSource)sourceAndConverter.getSpimSource()).setIsTransformed(isTransformed);
        return gridSource;
    }

    public void updateTransformMask() {
        MaskOptionsPanel maskOpts = this.warpVisDialog.maskOptionsPanel;
        String type = maskOpts.getType();
        boolean masked = maskOpts.isMask();
        if (masked && this.transformMaskSource == null) {
            this.addTransformMaskSource();
        }
        boolean isVirtualMask = this.isVirtualMask();
        this.getBwTransform().setMaskInterpolationType(type);
        this.setMaskOverlayVisibility(maskOpts.showMaskOverlay() && masked && isVirtualMask);
        if (masked && isVirtualMask) {
            this.autoEstimateMask();
        }
        this.restimateTransformation();
        this.getViewerFrameQ().getViewerPanel().requestRepaint();
        this.getViewerFrameP().getViewerPanel().requestRepaint();
    }

    private boolean isVirtualMask() {
        return this.plateauTransformMask == this.transformMask;
    }

    public void refreshTransformMask() {
        this.getBwTransform().setLambda(this.transformMaskSource.getSpimSource().getInterpolatedSource(0, 0, Interpolation.NLINEAR));
    }

    public void setTransformMaskRange(double min, double max) {
        this.getBwTransform().setMaskIntensityBounds(min, max);
        this.warpVisDialog.maskOptionsPanel.getMaskRangeSlider().setRange(new BoundedRange(min, max, min, max));
    }

    public void setTransformMaskType(String maskInterpolationType) {
        this.getBwTransform().setMaskInterpolationType(maskInterpolationType);
        this.warpVisDialog.maskOptionsPanel.getMaskTypeDropdown().setSelectedItem(maskInterpolationType);
    }

    public void setTransformMaskProperties(PlateauSphericalMaskRealRandomAccessible.FalloffShape falloffShape, double squaredRadius, double[] center) {
        this.warpVisDialog.maskOptionsPanel.getMaskFalloffTypeDropdown().setSelectedItem((Object)falloffShape);
        PlateauSphericalMaskRealRandomAccessible mask = this.getTransformPlateauMaskSource().getRandomAccessible();
        mask.setFalloffShape(falloffShape);
        mask.setSquaredRadius(squaredRadius);
        mask.setCenter(center);
    }

    public void setTransformMaskProperties(PlateauSphericalMaskRealRandomAccessible.FalloffShape falloffShape, double squaredRadius, double squaredSigma, double[] center) {
        this.warpVisDialog.maskOptionsPanel.getMaskFalloffTypeDropdown().setSelectedItem((Object)falloffShape);
        PlateauSphericalMaskRealRandomAccessible mask = this.getTransformPlateauMaskSource().getRandomAccessible();
        mask.setFalloffShape(falloffShape);
        mask.setSquaredRadius(squaredRadius);
        mask.setSquaredSigma(squaredSigma);
        mask.setCenter(center);
    }

    public void importTransformMaskSourceDialog() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(2);
        fileChooser.setCurrentDirectory(this.lastDirectory);
        int ret = fileChooser.showOpenDialog(this.landmarkFrame);
        if (ret == 0) {
            File selection = fileChooser.getSelectedFile();
            this.importTransformMaskSource(selection.getAbsolutePath());
        }
    }

    public void importTransformMaskSource(String uri) {
        SourceInfo srcInfo = this.data.sourceInfos.get(33872301);
        if (srcInfo != null) {
            this.removeSource(srcInfo);
        }
        try {
            LinkedHashMap<Source<T>, SourceInfo> infos = BigWarpInit.createSources(this.data, uri, 33872301, false);
            BigWarpInit.add(this.data, infos, null, null);
            infos.entrySet().stream().map(e -> (Source)e.getKey()).findFirst().ifPresent(x -> {
                this.transformMask = x;
            });
            this.synchronizeSources();
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        catch (SpimDataException e4) {
            e4.printStackTrace();
        }
        this.bwTransform.setLambda(this.transformMask.getInterpolatedSource(0, 0, Interpolation.NLINEAR));
        this.updateTransformMask();
        RealType type = (RealType)this.transformMask.getType();
        if (!(type instanceof DoubleType) && !(type instanceof FloatType)) {
            double min = type.getMinValue();
            double max = type.getMaxValue();
            this.bwTransform.setMaskIntensityBounds(min, max);
            this.warpVisDialog.maskOptionsPanel.getMaskRangeSlider().setRange(new BoundedRange(min, max, min, max));
        }
    }

    public void connectMaskSource() {
        this.transformMask = this.data.sourceInfos.get(33872301).getSourceAndConverter().getSpimSource();
        this.bwTransform.setLambda(this.transformMask.getInterpolatedSource(0, 0, Interpolation.NLINEAR));
    }

    public void removeMaskSource() {
        SourceInfo srcInfo = this.data.sourceInfos.get(33872301);
        if (srcInfo != null) {
            this.removeSource(srcInfo);
        }
        this.transformMask = null;
        this.transformMaskSource = null;
        this.bwTransform.setLambda(null);
        this.bwTransform.setMaskInterpolationType("NONE");
        this.warpVisDialog.maskOptionsPanel.getMaskTypeDropdown().setSelectedItem("NONE");
        BigWarpMaskSphereOverlay overlay = this.getViewerFrameQ().getViewerPanel().getMaskOverlay();
        if (overlay != null) {
            overlay.setVisible(false);
        }
        this.updateTransformMask();
        this.restimateTransformation();
    }

    public <T extends RealType<T>> SourceAndConverter<T> addTransformMaskSource() {
        if (this.warpVisDialog == null) {
            return null;
        }
        if (this.transformMask != null) {
            return this.data.getSourceInfo(33872301).getSourceAndConverter();
        }
        BoundingBoxEstimation bbe = new BoundingBoxEstimation();
        AffineTransform3D affine = new AffineTransform3D();
        this.data.getTargetSource(0).getSpimSource().getSourceTransform(0, 0, affine);
        Interval itvl = bbe.estimatePixelInterval((RealTransform)affine, (Interval)this.data.getTargetSource(0).getSpimSource().getSource(0, 0));
        this.plateauTransformMask = PlateauSphericalMaskSource.build(new RealPoint(3), itvl);
        this.transformMask = this.plateauTransformMask;
        RealARGBColorConverter converter = RealARGBColorConverter.create((RealType)((RealType)this.plateauTransformMask.getType()), (double)0.0, (double)1.0);
        converter.setColor(new ARGBType(-1));
        SourceAndConverter soc = new SourceAndConverter(this.transformMask, (Converter)converter, null);
        this.data.converterSetups.add(BigDataViewer.createConverterSetup((SourceAndConverter)soc, (int)33872301));
        this.data.sources.add(soc);
        SourceInfo sourceInfo = new SourceInfo(33872301, false, this.transformMask.getName(), null, null);
        sourceInfo.setSourceAndConverter(soc);
        this.data.sourceInfos.put(33872301, sourceInfo);
        this.warpVisDialog.maskOptionsPanel.setMask(this.plateauTransformMask);
        this.addMaskMouseListener();
        this.bwTransform.setLambda(this.plateauTransformMask.getRandomAccessible());
        this.bwTransform.setMaskIntensityBounds(0.0, 1.0);
        ArrayList<BigWarpMaskSphereOverlay> overlayList = new ArrayList<BigWarpMaskSphereOverlay>();
        BigWarpMaskSphereOverlay overlay = new BigWarpMaskSphereOverlay(this.viewerQ, this.ndims == 3);
        overlayList.add(overlay);
        this.getViewerFrameQ().getViewerPanel().setMaskOverlay(overlay);
        this.plateauTransformMask.getRandomAccessible().setOverlays(overlayList);
        this.synchronizeSources();
        this.transformMaskSource = soc;
        return soc;
    }

    public Source<? extends RealType<?>> getTansformMaskSource() {
        return this.transformMask;
    }

    public PlateauSphericalMaskSource getTransformPlateauMaskSource() {
        return this.plateauTransformMask;
    }

    public void setupKeyListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new LandmarkKeyboardProcessor(this));
    }

    public void setWarpVisGridType(GridSource.GRID_TYPE type) {
        this.gridSource.setMethod(type);
        this.viewerP.requestRepaint();
        this.viewerQ.requestRepaint();
    }

    public void setWarpGridWidth(double width) {
        this.gridSource.setGridWidth(width);
        this.viewerP.requestRepaint();
        this.viewerQ.requestRepaint();
    }

    public void setWarpGridSpacing(double spacing) {
        this.gridSource.setGridSpacing(spacing);
        this.viewerP.requestRepaint();
        this.viewerQ.requestRepaint();
    }

    public void setAutoSaver(BigWarpAutoSaver autoSaver) {
        this.autoSaver = autoSaver;
    }

    protected void setupWarpMagBaselineOptions(CoordinateTransform[] xfm, int ndim) {
        if (ndim == 2) {
            xfm[0] = new AffineModel2D();
            xfm[1] = new SimilarityModel2D();
            xfm[2] = new RigidModel2D();
        } else {
            xfm[0] = new AffineModel3D();
            xfm[1] = new SimilarityModel3D();
            xfm[2] = new RigidModel3D();
        }
    }

    public void setWarpMagBaselineIndex(int index) {
        this.baselineModelIndex = index;
        this.fitBaselineWarpMagModel();
    }

    protected void fitBaselineWarpMagModel() {
        int numActive = this.landmarkModel.numActive();
        if (numActive < 4) {
            return;
        }
        int ndims = this.landmarkModel.getNumdims();
        double[][] p = new double[ndims][numActive];
        double[][] q = new double[ndims][numActive];
        double[] w = new double[numActive];
        this.landmarkModel.copyLandmarks(p, q);
        Arrays.fill(w, 1.0);
        if (this.warpMagSource != null) {
            try {
                AbstractModel<?> baseline = this.baseXfmList[this.baselineModelIndex];
                baseline.fit(p, q, w);
                WrappedCoordinateTransform baselineTransform = new WrappedCoordinateTransform((InvertibleCoordinateTransform)baseline, ndims);
                this.warpMagSource.setBaseline((RealTransform)baselineTransform.inverse());
            }
            catch (IllDefinedDataPointsException | NotEnoughDataPointsException e) {
                e.printStackTrace();
            }
            this.getViewerFrameP().getViewerPanel().requestRepaint();
            this.getViewerFrameQ().getViewerPanel().requestRepaint();
        }
    }

    public void setMovingSpimData(SpimData movingSpimData, File movingImageXml) {
        this.movingSpimData = movingSpimData;
        this.movingImageXml = movingImageXml;
    }

    public void setBookmarks(Bookmarks bookmarks) {
        this.bookmarks = bookmarks;
    }

    public void setAutoEstimateMask(boolean selected) {
        this.warpVisDialog.maskOptionsPanel.getAutoEstimateMaskButton().setSelected(selected);
    }

    public void autoEstimateMask() {
        if (this.landmarkModel.numActive() < 4) {
            return;
        }
        if (this.warpVisDialog.autoEstimateMask() && this.bwTransform.isMasked() && this.transformMask instanceof PlateauSphericalMaskSource) {
            Sphere sph = BoundingSphereRitter.boundingSphere(this.landmarkModel.getFixedPointsCopy());
            this.plateauTransformMask.getRandomAccessible().setCenter((RealLocalizable)sph.getCenter());
            this.plateauTransformMask.getRandomAccessible().setRadius(sph.getRadius());
            AbstractTransformSolver<?> solver = this.getBwTransform().getSolver();
            if (solver instanceof MaskedSimRotTransformSolver) {
                ((MaskedSimRotTransformSolver)solver).setCenter((RealLocalizable)sph.getCenter());
            }
        }
    }

    @Deprecated
    public void setWarpVisMode(WarpVisType type, BigWarpViewerFrame viewerFrame, boolean both) {
        this.setWarpVisMode(type);
    }

    protected void setWarpVisMode(WarpVisType type) {
        BigWarpViewerFrame viewerFrame = this.viewerFrameP.isActive() ? this.viewerFrameP : this.viewerFrameQ;
        if (this.currentTransform == null) {
            this.message.showMessage("No warp - estimate warp first.");
            return;
        }
        SynchronizedViewerState state = viewerFrame.getViewerPanel().state();
        switch (type) {
            case JACDET: {
                if (this.jacDetSource == null) {
                    this.jacDetSource = BigWarp.addJacobianDeterminantSource(this.ndims, this.data, "Jacobian determinant");
                    this.updateJacobianTransformation(this.currentTransform);
                    this.synchronizeSources();
                }
                this.showSourceFused(viewerFrame, 1006827158);
                viewerFrame.getViewerPanel().showMessage("Displaying Jacobian Determinant");
                break;
            }
            case WARPMAG: {
                if (this.warpMagSource == null) {
                    this.warpMagSource = BigWarp.addWarpMagnitudeSource(this.data, this.ndims == 2, "Warp magnitude");
                    this.synchronizeSources();
                }
                this.showSourceFused(viewerFrame, 956736363);
                viewerFrame.getViewerPanel().showMessage("Displaying Warp Magnitude");
                break;
            }
            case GRID: {
                if (this.gridSource == null) {
                    this.gridSource = BigWarp.addGridSource(this.ndims, this.data, "Transform grid", this.isMovingDisplayTransformed());
                    this.setTransform(this.data.sourceInfos.get(1696993146), this.currentTransform);
                    this.synchronizeSources();
                    this.data.getConverterSetup(1696993146).setDisplayRange(0.0, 512.0);
                }
                this.showSourceFused(viewerFrame, 1696993146);
                viewerFrame.getViewerPanel().showMessage("Displaying Warp Grid");
                break;
            }
            default: {
                if (this.warpMagSource != null) {
                    state.setSourceActive(this.data.getSourceInfo(956736363).getSourceAndConverter(), false);
                }
                if (this.gridSource != null) {
                    state.setSourceActive(this.data.getSourceInfo(1696993146).getSourceAndConverter(), false);
                }
                this.message.showMessage("Turning off warp vis");
            }
        }
    }

    public void toggleWarpVisMode(BigWarpViewerFrame viewerFrame) {
        SourceAndConverter<?> wmSac;
        if (viewerFrame == null) {
            if (this.viewerFrameP.isActive()) {
                viewerFrame = this.viewerFrameP;
            } else if (this.viewerFrameQ.isActive()) {
                viewerFrame = this.viewerFrameQ;
            } else {
                return;
            }
        }
        if (this.getBwTransform().getTransformation() == null) {
            this.message.showMessage("No warp - estimate warp first.");
            return;
        }
        SynchronizedViewerState state = viewerFrame.getViewerPanel().state();
        if (state.isSourceActive(wmSac = this.data.getSourceInfo(956736363).getSourceAndConverter())) {
            state.setSourceActive(wmSac, false);
            state.setDisplayMode(state.getDisplayMode().withFused(false));
            this.message.showMessage("Removing Warp Magnitude");
        } else {
            state.setSourceActive(wmSac, true);
            state.setDisplayMode(state.getDisplayMode().withFused(false));
            this.message.showMessage("Displaying Warp Magnitude");
        }
        viewerFrame.getViewerPanel().requestRepaint();
    }

    private void showSourceFused(BigWarpViewerFrame viewerFrame, int sourceId) {
        if (viewerFrame == null) {
            if (this.viewerFrameP.isActive()) {
                viewerFrame = this.viewerFrameP;
            } else if (this.viewerFrameQ.isActive()) {
                viewerFrame = this.viewerFrameQ;
            } else {
                return;
            }
        }
        if (this.getBwTransform().getTransformation() == null) {
            this.message.showMessage("No warp - estimate warp first.");
            return;
        }
        SourceAndConverter<?> newSrc = this.data.getSourceInfo(sourceId).getSourceAndConverter();
        SynchronizedViewerState state = viewerFrame.getViewerPanel().state();
        if (!state.getDisplayMode().equals((Object)DisplayMode.FUSED)) {
            SourceAndConverter currentSource = state.getCurrentSource();
            Iterator iterator = state.getSources().iterator();
            while (iterator.hasNext()) {
                SourceAndConverter src;
                state.setSourceActive(src, (src = (SourceAndConverter)iterator.next()) == currentSource || src == newSrc);
            }
        } else {
            SourceInfo warpMagSrcInfo = this.data.getSourceInfo(956736363);
            SourceInfo gridSrcInfo = this.data.getSourceInfo(1696993146);
            SourceInfo jacDetSrcInfo = this.data.getSourceInfo(1006827158);
            if (warpMagSrcInfo != null) {
                state.setSourceActive(warpMagSrcInfo.getSourceAndConverter(), false);
            }
            if (gridSrcInfo != null) {
                state.setSourceActive(gridSrcInfo.getSourceAndConverter(), false);
            }
            if (jacDetSrcInfo != null) {
                state.setSourceActive(jacDetSrcInfo.getSourceAndConverter(), false);
            }
            state.setSourceActive(newSrc, true);
        }
        state.setDisplayMode(DisplayMode.FUSED);
    }

    private void setTransformationMovingSourceOnly(InvertibleRealTransform transform) {
        this.currentTransform = transform;
        this.data.sourceInfos.values().forEach(sourceInfo -> this.setTransform((SourceInfo)sourceInfo, transform));
    }

    private void setTransform(SourceInfo sourceInfo, InvertibleRealTransform transform) {
        if (sourceInfo.isMoving()) {
            SourceAndConverter<?> sac = sourceInfo.getSourceAndConverter();
            WarpedSource wsrc = (WarpedSource)sac.getSpimSource();
            wsrc.updateTransform((RealTransform)transform);
            if (sac.asVolatile() != null) {
                ((WarpedSource)sourceInfo.getSourceAndConverter().asVolatile().getSpimSource()).updateTransform((RealTransform)transform);
            }
        }
    }

    public void updateSourceBoundingBoxEstimators() {
        this.data.sourceInfos.values().forEach(sourceInfo -> {
            if (sourceInfo.isMoving()) {
                ((WarpedSource)sourceInfo.getSourceAndConverter().getSpimSource()).setBoundingBoxEstimator(this.bboxOptions.copy());
                if (this.data.sources.get(0).asVolatile() != null) {
                    ((WarpedSource)sourceInfo.getSourceAndConverter().asVolatile().getSpimSource()).setBoundingBoxEstimator(this.bboxOptions.copy());
                }
            }
        });
    }

    private synchronized void notifyTransformListeners() {
        for (TransformListener<InvertibleRealTransform> l : this.transformListeners) {
            l.transformChanged((Object)this.currentTransform);
        }
    }

    private void updateJacobianTransformation(InvertibleRealTransform transform) {
        if (transform instanceof ThinplateSplineTransform) {
            this.jacDetSource.setTransform((DifferentiableRealTransform)((ThinplateSplineTransform)transform));
        } else if (transform instanceof WrappedIterativeInvertibleRealTransform) {
            RealTransform xfm = ((WrappedIterativeInvertibleRealTransform)transform).getTransform();
            if (xfm instanceof ThinplateSplineTransform) {
                this.jacDetSource.setTransform((DifferentiableRealTransform)((ThinplateSplineTransform)xfm));
            } else {
                this.jacDetSource.setTransform((DifferentiableRealTransform)new RealTransformFiniteDerivatives(xfm));
            }
        } else if (transform instanceof InvertibleWrapped2DTransformAs3D) {
            this.updateJacobianTransformation(((InvertibleWrapped2DTransformAs3D)transform).getTransform());
        } else {
            this.jacDetSource.setTransform(null);
        }
    }

    private void setTransformationAll(InvertibleRealTransform transform) {
        this.setTransformationMovingSourceOnly(transform);
        if (this.warpMagSource != null) {
            this.warpMagSource.setWarp((RealTransform)transform);
            this.fitBaselineWarpMagModel();
        }
        if (this.jacDetSource != null) {
            this.updateJacobianTransformation(transform);
        }
    }

    public boolean restimateTransformation() {
        if (this.landmarkModel.getActiveRowCount() < 4) {
            return false;
        }
        this.solverThread.requestResolve(true, -1, null);
        if (this.firstWarpEstimation) {
            this.setUpdateWarpOnChange(true);
            this.firstWarpEstimation = false;
        }
        this.viewerP.requestRepaint();
        this.viewerQ.requestRepaint();
        this.notifyTransformListeners();
        return true;
    }

    public synchronized void setIsMovingDisplayTransformed(boolean isTransformed) {
        this.data.sourceInfos.values().forEach(sourceInfo -> {
            if (sourceInfo.isMoving()) {
                SourceAndConverter<?> sourceAndConverter = sourceInfo.getSourceAndConverter();
                ((WarpedSource)sourceAndConverter.getSpimSource()).setIsTransformed(isTransformed);
                if (sourceAndConverter.asVolatile() != null) {
                    ((WarpedSource)sourceAndConverter.asVolatile().getSpimSource()).setIsTransformed(isTransformed);
                }
            }
        });
        this.overlayP.setIsTransformed(isTransformed);
        this.viewerP.requestRepaint();
        if (this.viewerQ.state().getDisplayMode().hasFused()) {
            this.viewerQ.requestRepaint();
        }
    }

    public boolean isRowIncomplete() {
        LandmarkTableModel ltm = this.landmarkPanel.getTableModel();
        return ltm.isPointUpdatePending() || ltm.isPointUpdatePendingMoving();
    }

    public boolean isMovingDisplayTransformed() {
        if (this.data.sources.size() <= 0) {
            return true;
        }
        if (this.data.numMovingSources() > 0) {
            return ((WarpedSource)this.data.getMovingSource(0).getSpimSource()).isTransformed();
        }
        return false;
    }

    protected int detectNumDims() {
        return BigWarp.detectNumDims(this.data.sources);
    }

    public static <T> int detectNumDims(List<SourceAndConverter<T>> sources) {
        if (sources.size() == 0) {
            return 3;
        }
        boolean isAnySource3d = false;
        for (SourceAndConverter<T> sac : sources) {
            long[] dims = new long[sac.getSpimSource().getSource(0, 0).numDimensions()];
            sac.getSpimSource().getSource(0, 0).dimensions(dims);
            if (sac.getSpimSource().getSource(0, 0).dimension(2) <= 1L) continue;
            isAnySource3d = true;
            break;
        }
        int ndims = 2;
        if (isAnySource3d) {
            ndims = 3;
        }
        return ndims;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        new ImageJ();
        String fnP = "";
        String fnQ = "";
        String fnLandmarks = "";
        int i = 0;
        if (args.length >= 2) {
            fnP = args[i++];
            fnQ = args[i++];
        }
        if (args.length > i) {
            fnLandmarks = args[i++];
        }
        boolean doInverse = false;
        if (args.length > i) {
            try {
                doInverse = Boolean.parseBoolean(args[i++]);
                System.out.println("parsed inverse param: " + doInverse);
            }
            catch (Exception e) {
                System.err.println("Warning: Failed to parse inverse parameter.");
            }
        }
        try {
            BigWarp bw;
            block17: {
                System.setProperty("apple.laf.useScreenMenuBar", "false");
                ProgressWriterIJ progress = new ProgressWriterIJ();
                if (fnP.endsWith("xml") && fnQ.endsWith("xml")) {
                    BigWarpData bwdata = BigWarpInit.createBigWarpDataFromXML(fnP, fnQ);
                    bw = new BigWarp(bwdata, (ProgressWriter)progress);
                } else if (fnP.endsWith("xml") && !fnQ.endsWith("xml")) {
                    ImagePlus impQ = IJ.openImage((String)fnQ);
                    BigWarpData bwdata = BigWarpInit.createBigWarpDataFromXMLImagePlus(fnP, impQ);
                    bw = new BigWarp(bwdata, (ProgressWriter)progress);
                } else if (!fnP.endsWith("xml") && fnQ.endsWith("xml")) {
                    ImagePlus impP = IJ.openImage((String)fnP);
                    BigWarpData bwdata = BigWarpInit.createBigWarpDataFromImagePlusXML(impP, fnQ);
                    bw = new BigWarp(bwdata, (ProgressWriter)progress);
                } else {
                    if (!fnP.isEmpty() && !fnQ.isEmpty()) {
                        ImagePlus impP = IJ.openImage((String)fnP);
                        ImagePlus impQ = IJ.openImage((String)fnQ);
                        if (impP != null && impQ != null) {
                            BigWarpData bwdata = BigWarpInit.createBigWarpDataFromImages(impP, impQ);
                            bw = new BigWarp(bwdata, (ProgressWriter)progress);
                            break block17;
                        } else {
                            System.err.println("Error reading images");
                            return;
                        }
                    }
                    bw = new BigWarp(new BigWarpData(), (ProgressWriter)progress);
                }
            }
            if (!fnLandmarks.isEmpty()) {
                bw.loadLandmarks(fnLandmarks);
            }
            if (!doInverse) return;
            bw.invertPointCorrespondences();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void viewerXfmTest() {
        AffineTransform3D srcTransform0 = new AffineTransform3D();
        this.data.sources.get(0).getSpimSource().getSourceTransform(0, 0, srcTransform0);
        AffineTransform3D srcTransform1 = new AffineTransform3D();
        this.data.sources.get(1).getSpimSource().getSourceTransform(0, 0, srcTransform1);
        AffineTransform3D viewerTransformM = new AffineTransform3D();
        this.viewerP.state().getViewerTransform(viewerTransformM);
        AffineTransform3D viewerTransformT = new AffineTransform3D();
        this.viewerQ.state().getViewerTransform(viewerTransformT);
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("srcXfm 0 " + srcTransform0);
        System.out.println("srcXfm 1 " + srcTransform1);
        System.out.println("viewerXfm M " + viewerTransformM);
        System.out.println("viewerXfm T " + viewerTransformT);
        System.out.println(" ");
        System.out.println(" ");
    }

    public void checkBoxInputMaps() {
        TableCellEditor celled = this.landmarkTable.getCellEditor(0, 1);
        Component c = celled.getTableCellEditorComponent(this.landmarkTable, Boolean.TRUE, true, 0, 1);
        InputMap parentInputMap = ((JCheckBox)c).getInputMap().getParent();
        parentInputMap.clear();
        KeyStroke enterDownKS = KeyStroke.getKeyStroke("pressed ENTER");
        KeyStroke enterUpKS = KeyStroke.getKeyStroke("released ENTER");
        parentInputMap.put(enterDownKS, "pressed");
        parentInputMap.put(enterUpKS, "released");
    }

    public void setTransformType(String type) {
        this.updateTransformTypePanel(type);
        this.updateTransformTypeDialog(type);
        this.bwTransform.setTransformType(type);
        this.restimateTransformation();
    }

    public void setTransformTypeUpdateUI(String type) {
        this.setTransformType(type);
        this.updateTransformTypeDialog(type);
        this.updateTransformTypePanel(type);
    }

    public void updateTransformTypeDialog(String type) {
        this.transformSelector.deactivate();
        this.transformSelector.setTransformType(type);
        this.transformSelector.activate();
    }

    public void updateTransformTypePanel(String type) {
        this.warpVisDialog.transformTypePanel.deactivate();
        this.warpVisDialog.transformTypePanel.setType(type);
        this.warpVisDialog.transformTypePanel.activate();
    }

    public String getTransformType() {
        return this.bwTransform.getTransformType();
    }

    public BigWarpTransform getBwTransform() {
        return this.bwTransform;
    }

    public BoundingBoxEstimation getBoxEstimation() {
        return this.bboxOptions;
    }

    @Deprecated
    public ThinPlateR2LogRSplineKernelTransform getTransform() {
        return this.landmarkPanel.getTableModel().getTransform();
    }

    public synchronized void addTransformListener(TransformListener<InvertibleRealTransform> listener) {
        this.transformListeners.add(listener);
    }

    public void autoSaveLandmarks() {
        File baseFolder = this.autoSaver.autoSaveDirectory != null ? this.autoSaver.autoSaveDirectory : this.getBigwarpSettingsFolder();
        File proposedLandmarksFile = new File(baseFolder.getAbsolutePath() + File.separator + "bigwarp_landmarks_" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(Calendar.getInstance().getTime()) + ".csv");
        try {
            this.saveLandmarks(proposedLandmarksFile.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void quickSaveLandmarks() {
        if (this.lastLandmarks != null) {
            try {
                this.saveLandmarks(this.lastLandmarks.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.autoSaveLandmarks();
            return;
        }
    }

    public File getBigwarpSettingsFolder() {
        File hiddenFolder = new File(System.getProperty("user.home") + File.separator + ".bigwarp");
        boolean exists = hiddenFolder.isDirectory();
        if (!exists) {
            exists = hiddenFolder.mkdir();
        }
        if (exists) {
            return hiddenFolder;
        }
        return null;
    }

    public BigWarpAutoSaver getAutoSaver() {
        return this.autoSaver;
    }

    public void stopAutosave() {
        if (this.autoSaver != null) {
            this.autoSaver.stop();
            this.autoSaver = null;
        }
    }

    protected void saveLandmarks() {
        JFileChooser fileChooser = new JFileChooser(this.getLastDirectory());
        File proposedLandmarksFile = this.lastLandmarks != null ? this.lastLandmarks : new File("landmarks.csv");
        fileChooser.setSelectedFile(proposedLandmarksFile);
        int returnVal = fileChooser.showSaveDialog(null);
        if (returnVal == 0) {
            proposedLandmarksFile = fileChooser.getSelectedFile();
            try {
                this.saveLandmarks(proposedLandmarksFile.getCanonicalPath());
                this.lastLandmarks = proposedLandmarksFile;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void saveLandmarks(String filename) throws IOException {
        if (filename.endsWith("csv")) {
            this.landmarkModel.save(new File(filename));
        } else if (filename.endsWith("json")) {
            TransformWriterJson.write(this.landmarkModel, this.bwTransform, new File(filename));
        }
    }

    protected void loadLandmarks() {
        JFileChooser fileChooser = new JFileChooser(this.getLastDirectory());
        File proposedLandmarksFile = new File("landmarks.csv");
        fileChooser.setSelectedFile(proposedLandmarksFile);
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal == 0) {
            proposedLandmarksFile = fileChooser.getSelectedFile();
            try {
                this.loadLandmarks(proposedLandmarksFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadLandmarks(String filename) {
        boolean didCompute;
        String filenameTrim;
        String name = filenameTrim = filename.trim();
        try {
            URI uri = new URI(filenameTrim);
            if (uri != null && uri.getScheme() != null) {
                name = uri.getSchemeSpecificPart();
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        File file = new File(name);
        this.setLastDirectory(file.getParentFile());
        if (name.endsWith("csv")) {
            try {
                this.landmarkModel.load(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (name.endsWith("json")) {
            TransformWriterJson.read(file, this);
        }
        if (!(didCompute = this.restimateTransformation())) {
            this.setIsMovingDisplayTransformed(false);
        }
        this.autoEstimateMask();
        this.viewerP.requestRepaint();
        this.viewerQ.requestRepaint();
        this.landmarkFrame.repaint();
    }

    protected void saveSettings() {
        File proposedSettingsFile = new File("bigwarp.settings.xml");
        this.saveSettingsOrProject(proposedSettingsFile);
    }

    protected void saveProject() {
        File proposedSettingsFile = new File("bigwarp-project.json");
        this.saveSettingsOrProject(proposedSettingsFile);
    }

    protected void saveSettingsOrProject(File proposedFile) {
        JFileChooser fileChooser = new JFileChooser(this.getLastDirectory());
        fileChooser.setSelectedFile(proposedFile);
        int returnVal = fileChooser.showSaveDialog(null);
        if (returnVal == 0) {
            File settingsFile = fileChooser.getSelectedFile();
            try {
                String canonicalPath = settingsFile.getCanonicalPath();
                if (canonicalPath.endsWith(".xml")) {
                    this.saveSettings(canonicalPath);
                } else {
                    this.saveSettingsJson(canonicalPath);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void saveSettings(String xmlFilename) throws IOException {
        Element root = new Element("Settings");
        Element viewerPNode = new Element("viewerP");
        Element viewerQNode = new Element("viewerQ");
        root.addContent((Content)viewerPNode);
        root.addContent((Content)viewerQNode);
        viewerPNode.addContent((Content)this.viewerP.stateToXml());
        viewerQNode.addContent((Content)this.viewerQ.stateToXml());
        root.addContent((Content)this.setupAssignments.toXml());
        root.addContent((Content)this.bookmarks.toXml());
        Element autoSaveNode = new Element("autosave");
        Element autoSaveLocation = new Element("location");
        if (this.autoSaver != null && this.autoSaver.autoSaveDirectory != null) {
            autoSaveLocation.setText(this.autoSaver.autoSaveDirectory.getAbsolutePath());
        } else {
            autoSaveLocation.setText(this.getBigwarpSettingsFolder().getAbsolutePath());
        }
        Element autoSavePeriod = new Element("period");
        String periodString = this.autoSaver == null ? "-1" : Long.toString(this.autoSaver.getPeriod());
        autoSavePeriod.setText(periodString);
        autoSaveNode.addContent((Content)autoSaveLocation);
        autoSaveNode.addContent((Content)autoSavePeriod);
        root.addContent((Content)autoSaveNode);
        if (this.transformMask != null) {
            root.addContent((Content)this.plateauTransformMask.getRandomAccessible().toXml());
        }
        Document doc = new Document(root);
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        xout.output(doc, (Writer)new FileWriter(xmlFilename));
    }

    protected void saveSettingsJson(String jsonFilename) throws IOException {
        BigwarpSettings settings = this.getSettings();
        settings.serialize(jsonFilename);
    }

    public BigwarpSettings getSettings() {
        return new BigwarpSettings(this, this.viewerP, this.viewerQ, this.setupAssignments, this.bookmarks, this.autoSaver, this.landmarkModel, this.bwTransform, this.data.sourceInfos);
    }

    protected void loadSettings() {
        this.loadSettingsOrProject(new File("bigwarp.settings.xml"));
    }

    protected void loadProject() {
        this.loadSettingsOrProject(new File("bigwarp-project.json"));
    }

    protected void loadSettingsOrProject(File f) {
        JFileChooser fileChooser = new JFileChooser(this.getLastDirectory());
        fileChooser.setSelectedFile(f);
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal == 0) {
            File settingsFile = fileChooser.getSelectedFile();
            try {
                this.loadSettings(settingsFile.getCanonicalPath(), true);
            }
            catch (IOException | JDOMException e) {
                e.printStackTrace();
            }
        }
    }

    private void addInternalSource(int id) {
        boolean sourceWithIdPresent = this.data.sources.stream().map(it -> it.getConverter()).filter(it -> it instanceof ConverterSetup).filter(it -> ((ConverterSetup)it).getSetupId() == id).findAny().isPresent();
        if (sourceWithIdPresent) {
            return;
        }
        switch (id) {
            case 1696993146: {
                this.gridSource = BigWarp.addGridSource(this.ndims, this.data, "GridSource", this.isMovingDisplayTransformed());
                this.setGridType(GridSource.GRID_TYPE.LINE);
                break;
            }
            case 956736363: {
                this.warpMagSource = BigWarp.addWarpMagnitudeSource(this.data, this.ndims == 2, "Warp magnitude");
                break;
            }
            case 1006827158: {
                this.jacDetSource = BigWarp.addJacobianDeterminantSource(this.ndims, this.data, "Jacobian determinant");
                break;
            }
            case 33872301: {
                this.updateTransformMask();
                break;
            }
        }
    }

    public void loadSettings(String jsonOrXmlFilename) throws IOException, JDOMException {
        this.loadSettings(jsonOrXmlFilename, false);
    }

    public void loadSettings(String jsonOrXmlFilename, boolean overwriteSources) throws IOException, JDOMException {
        String filenameTrim;
        String name = filenameTrim = jsonOrXmlFilename.trim();
        try {
            URI uri = new URI(filenameTrim);
            if (uri != null && uri.getScheme() != null) {
                name = uri.getSchemeSpecificPart();
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        if (name.endsWith(".xml")) {
            SAXBuilder sax = new SAXBuilder();
            Document doc = sax.build(name);
            Element root = doc.getRootElement();
            List converterSetups = root.getChild("SetupAssignments").getChild("ConverterSetups").getChildren("ConverterSetup");
            for (Element converterSetup : converterSetups) {
                int id = Integer.parseInt(converterSetup.getChild("id").getText());
                this.addInternalSource(id);
            }
            this.synchronizeSources();
            this.viewerP.stateFromXml(root.getChild("viewerP"));
            this.viewerQ.stateFromXml(root.getChild("viewerQ"));
            this.setupAssignments.restoreFromXml(root);
            this.bookmarks.restoreFromXml(root);
            this.activeSourcesDialogP.update();
            this.activeSourcesDialogQ.update();
            Element autoSaveElem = root.getChild("autosave");
            String autoSavePath = autoSaveElem.getChild("location").getText();
            long autoSavePeriod = Integer.parseInt(autoSaveElem.getChild("period").getText());
            BigWarpAutoSaver.setAutosaveOptions(this, autoSavePeriod, autoSavePath);
            Element maskSettings = root.getChild("transform-mask");
            if (maskSettings != null) {
                this.plateauTransformMask.getRandomAccessible().fromXml(maskSettings);
            }
        } else {
            BigwarpSettings settings = this.getSettings();
            settings.setOverwriteSources(overwriteSources);
            settings.read(new JsonReader((Reader)new FileReader(name)));
            this.activeSourcesDialogP.update();
            this.activeSourcesDialogQ.update();
        }
        this.viewerFrameP.repaint();
        this.viewerFrameQ.repaint();
    }

    static {
        logger = LoggerFactory.getLogger(BigWarp.class);
    }

    public static class SolveThread
    extends Thread {
        private boolean pleaseResolve;
        private BigWarp<?> bw;
        private boolean isMoving;
        private int index;
        private double[] pt;

        public SolveThread(BigWarp<?> bw) {
            this.bw = bw;
            this.pleaseResolve = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                boolean b;
                SolveThread solveThread = this;
                synchronized (solveThread) {
                    b = this.pleaseResolve;
                    this.pleaseResolve = false;
                }
                if (b) {
                    try {
                        InvertibleRealTransform invXfm = ((BigWarp)this.bw).bwTransform.getTransformation(this.index);
                        if (invXfm == null) {
                            return;
                        }
                        if (this.index < 0) {
                            this.bw.landmarkModel.resetWarpedPoints();
                            this.bw.landmarkModel.updateAllWarpedPoints(this.bw.currentTransform);
                            ((BigWarp)this.bw).setTransformationAll(invXfm);
                            this.bw.fitBaselineWarpMagModel();
                        } else {
                            ((BigWarp)this.bw).setTransformationAll(invXfm);
                        }
                        if (!this.isMoving) {
                            this.bw.getLandmarkPanel().getTableModel().setPoint(this.index, this.isMoving, this.pt, false, (RealTransform)this.bw.currentTransform);
                        }
                        this.bw.getViewerFrameP().getViewerPanel().requestRepaint();
                        this.bw.getViewerFrameQ().getViewerPanel().requestRepaint();
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
                solveThread = this;
                synchronized (solveThread) {
                    block16: {
                        try {
                            if (this.pleaseResolve) break block16;
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestResolve(boolean isMoving, int index, double[] newpt) {
            SolveThread solveThread = this;
            synchronized (solveThread) {
                this.pleaseResolve = true;
                this.isMoving = isMoving;
                this.index = index;
                if (newpt != null) {
                    this.pt = Arrays.copyOf(newpt, newpt.length);
                }
                this.notify();
            }
        }
    }

    public class MouseLandmarkTableListener
    implements MouseListener {
        boolean wasDoubleClick = false;
        Timer timer;

        @Override
        public void mouseClicked(MouseEvent e) {
            int ndims = BigWarp.this.landmarkModel.getNumdims();
            if (e.getClickCount() == 2) {
                boolean moving;
                BigWarpViewerPanel viewer;
                JTable target = (JTable)e.getSource();
                int row = target.getSelectedRow();
                int column = target.getSelectedColumn();
                if (row < 0) {
                    return;
                }
                if (column >= 2 + ndims) {
                    viewer = BigWarp.this.viewerQ;
                    moving = false;
                } else if (column >= 2 && column < 2 + ndims) {
                    viewer = BigWarp.this.viewerP;
                    moving = true;
                } else {
                    boolean moving2 = true;
                    return;
                }
                LandmarkTableModel ltm = BigWarp.this.landmarkModel;
                if (moving && !ltm.isMovingPoint(row)) {
                    return;
                }
                if (!moving && !ltm.isFixedPoint(row)) {
                    return;
                }
                BigWarp.this.jumpToLandmark(row, viewer);
            } else {
                JTable target = (JTable)e.getSource();
                int row = target.rowAtPoint(e.getPoint());
                if (row < 0 && target.getRowCount() > 0) {
                    target.removeRowSelectionInterval(0, target.getRowCount() - 1);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public class LandmarkTableListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getColumn() == 1) {
                BigWarp.this.restimateTransformation();
                BigWarp.this.landmarkPanel.repaint();
            }
            BigWarp.this.autoEstimateMask();
        }
    }

    public class WarningTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 7836269349663370123L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            LandmarkTableModel model = (LandmarkTableModel)table.getModel();
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (model.rowNeedsWarning(row)) {
                c.setBackground(LandmarkTableModel.WARNINGBGCOLOR);
            } else {
                c.setBackground(LandmarkTableModel.DEFAULTBGCOLOR);
            }
            return c;
        }
    }

    protected class MouseLandmarkListener
    implements MouseListener,
    MouseMotionListener {
        int selectedPointIndex = -1;
        double[] ptarrayLoc = new double[3];
        double[] ptBackLoc = new double[3];
        private BigWarpViewerPanel thisViewer;
        private boolean isMoving;
        private long pressTime;
        private RealPoint hoveredPoint;
        private double[] hoveredArray;

        protected MouseLandmarkListener(BigWarpViewerPanel thisViewer) {
            this.setViewer(thisViewer);
            thisViewer.getDisplay().addHandler((Object)this);
            this.isMoving = thisViewer == BigWarp.this.viewerP;
            this.hoveredArray = new double[3];
            this.hoveredPoint = RealPoint.wrap((double[])this.hoveredArray);
        }

        protected void setViewer(BigWarpViewerPanel thisViewer) {
            this.thisViewer = thisViewer;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressTime = System.currentTimeMillis();
            if (e.isShiftDown()) {
                return;
            }
            if (BigWarp.this.isInLandmarkMode()) {
                this.thisViewer.getGlobalMouseCoordinates((RealPositionable)BigWarp.this.currentLandmark);
                BigWarp.this.currentLandmark.localize(this.ptarrayLoc);
                this.selectedPointIndex = BigWarp.this.selectedLandmark(this.ptarrayLoc, this.isMoving);
                if (this.selectedPointIndex >= 0) {
                    BigWarp.this.landmarkTable.setRowSelectionInterval(this.selectedPointIndex, this.selectedPointIndex);
                    BigWarp.this.landmarkFrame.repaint();
                    BigWarp.this.landmarkModel.setLastPoint(this.selectedPointIndex, this.isMoving);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            long clickLength = System.currentTimeMillis() - this.pressTime;
            if (clickLength < BigWarp.this.keyClickMaxLength && this.selectedPointIndex != -1) {
                return;
            }
            boolean isMovingLocal = this.isMoving;
            if (e.isShiftDown() && e.isControlDown()) {
                isMovingLocal = !this.isMoving;
            } else {
                if (e.isShiftDown()) {
                    return;
                }
                if (e.isControlDown()) {
                    if (BigWarp.this.isInLandmarkMode() && this.selectedPointIndex < 0) {
                        this.thisViewer.getGlobalMouseCoordinates((RealPositionable)BigWarp.this.currentLandmark);
                        this.addFixedPoint(BigWarp.this.currentLandmark, isMovingLocal);
                    }
                    return;
                }
            }
            boolean wasNewRowAdded = false;
            if (BigWarp.this.isInLandmarkMode()) {
                this.thisViewer.getGlobalMouseCoordinates((RealPositionable)BigWarp.this.currentLandmark);
                BigWarp.this.currentLandmark.localize(this.ptarrayLoc);
                if (this.selectedPointIndex == -1) {
                    wasNewRowAdded = BigWarp.this.addPoint(this.ptarrayLoc, isMovingLocal);
                } else {
                    boolean isWarped = isMovingLocal && BigWarp.this.landmarkModel.getTransform() != null && BigWarp.this.isMovingDisplayTransformed();
                    wasNewRowAdded = BigWarp.this.landmarkModel.pointEdit(this.selectedPointIndex, this.ptarrayLoc, false, isMovingLocal, isWarped, true, (RealTransform)BigWarp.this.currentTransform);
                }
                if (BigWarp.this.updateWarpOnPtChange && !wasNewRowAdded) {
                    BigWarp.this.restimateTransformation();
                }
                if (wasNewRowAdded) {
                    BigWarp.this.updateRowSelection(isMovingLocal, BigWarp.this.landmarkModel.getRowCount() - 1);
                } else {
                    BigWarp.this.updateRowSelection(isMovingLocal, this.selectedPointIndex);
                }
            }
            BigWarp.this.landmarkModel.resetLastPoint();
            this.selectedPointIndex = -1;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.isShiftDown()) {
                return;
            }
            if (BigWarp.this.isInLandmarkMode() && this.selectedPointIndex >= 0) {
                this.thisViewer.getGlobalMouseCoordinates((RealPositionable)BigWarp.this.currentLandmark);
                BigWarp.this.currentLandmark.localize(this.ptarrayLoc);
                if (BigWarp.this.isMovingDisplayTransformed() && this.thisViewer.doUpdateOnDrag() && BigWarp.this.landmarkModel.isActive(this.selectedPointIndex)) {
                    BigWarp.this.solverThread.requestResolve(this.isMoving, this.selectedPointIndex, this.ptarrayLoc);
                } else if (this.isMoving && BigWarp.this.isMovingDisplayTransformed()) {
                    BigWarp.this.landmarkModel.pointEdit(this.selectedPointIndex, BigWarp.this.landmarkModel.getTransform().apply(this.ptarrayLoc), false, this.isMoving, this.ptarrayLoc, false);
                    this.thisViewer.requestRepaint();
                } else {
                    BigWarp.this.landmarkModel.pointEdit(this.selectedPointIndex, this.ptarrayLoc, false, this.isMoving, false, false, (RealTransform)BigWarp.this.currentTransform);
                    this.thisViewer.requestRepaint();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.thisViewer.getGlobalMouseCoordinates((RealPositionable)this.hoveredPoint);
            int hoveredIndex = BigWarp.this.selectedLandmark(this.hoveredArray, this.isMoving, false);
            this.thisViewer.setHoveredIndex(hoveredIndex);
        }

        public void addFixedPoint(RealPoint pt, boolean isMovingImage) {
            if (isMovingImage && BigWarp.this.viewerP.getTransformEnabled()) {
                BigWarp.this.currentLandmark.localize(this.ptarrayLoc);
                BigWarp.this.addPoint(this.ptarrayLoc, true, BigWarp.this.viewerP);
                BigWarp.this.addPoint(this.ptarrayLoc, false, BigWarp.this.viewerQ);
            } else {
                BigWarp.this.currentLandmark.localize(this.ptarrayLoc);
                BigWarp.this.addPoint(this.ptarrayLoc, true, BigWarp.this.viewerP);
                BigWarp.this.addPoint(this.ptarrayLoc, false, BigWarp.this.viewerQ);
            }
            if (BigWarp.this.updateWarpOnPtChange) {
                BigWarp.this.restimateTransformation();
            }
        }
    }

    protected class LandmarkModeListener
    implements KeyEventPostProcessor {
        protected LandmarkModeListener() {
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent ke) {
            if (ke.isConsumed()) {
                return false;
            }
            if (ke.getKeyCode() == 32) {
                if (ke.getID() == 401) {
                    BigWarp.this.setInLandmarkMode(true);
                    return false;
                }
                if (ke.getID() == 402) {
                    BigWarp.this.setInLandmarkMode(false);
                    return false;
                }
            }
            return false;
        }
    }

    public static enum WarpVisType {
        NONE,
        WARPMAG,
        JACDET,
        GRID;

    }
}

