/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.gui.ExportDisplacementFieldFrame;
import bdv.img.WarpedSource;
import bdv.viewer.Source;
import bigwarp.BigWarp;
import bigwarp.BigWarpData;
import bigwarp.BigWarpExporter;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.source.SourceInfo;
import bigwarp.transforms.BigWarpTransform;
import bigwarp.transforms.NgffTransformations;
import bigwarp.transforms.SlicerTransformations;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.RigidModel2D;
import mpicbg.models.RigidModel3D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.SimilarityModel3D;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.RealFloatConverter;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.FloatImagePlus;
import net.imglib2.img.imageplus.ImagePlusImgs;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.parallel.TaskExecutors;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.DisplacementFieldTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.InvertibleWrapped2DIntermediate3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.GenericComposite;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.Lz4Compression;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.XzCompression;
import org.janelia.saalfeldlab.n5.blosc.BloscCompression;
import org.janelia.saalfeldlab.n5.imglib2.N5DisplacementField;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AffineCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.DisplacementFieldCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ReferencedCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.SequenceCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ThinPlateSplineCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.TranslationCoordinateTransform;

public class BigWarpToDeformationFieldPlugIn
implements PlugIn {
    public static final String[] compressionOptions = new String[]{"raw", "gzip", "lz4", "xz", "blosc"};
    public static final String flattenOption = "Flat";
    public static final String sequenceOption = "Sequence";

    public static void main(String[] args) {
        new ImageJ();
        new Recorder();
        Recorder.record = true;
        ImagePlus imp = IJ.openImage((String)"/home/john/tmp/mri-stack.tif");
        imp.show();
        new BigWarpToDeformationFieldPlugIn().run(null);
    }

    public <T> void runFromBigWarpInstance(BigWarp<?> bw) {
        ExportDisplacementFieldFrame.createAndShow(bw);
    }

    public static void runFromParameters(DeformationFieldExportParameters params, BigWarpData<?> data, LandmarkTableModel landmarkModel, BigWarpTransform bwTransform) {
        LandmarkTableModel ltm;
        String unit = "pixel";
        if (landmarkModel == null) {
            if (params.landmarkPath == null || params.landmarkPath.isEmpty()) {
                IJ.showMessage((String)"Must provide landmark file.");
                return;
            }
            try {
                ltm = LandmarkTableModel.loadFromCsv(new File(params.landmarkPath), false);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        } else {
            ltm = landmarkModel;
        }
        int ndims = ltm.getNumdims();
        double[] spacing = new double[ndims];
        double[] offset = new double[ndims];
        long[] dims = new long[ndims];
        if (params.spacing != null) {
            spacing = params.spacing;
        }
        if (params.offset != null) {
            offset = params.offset;
        }
        if (params.size != null) {
            dims = params.size;
        }
        ImagePlus imp = null;
        if (params.n5Base.isEmpty()) {
            if (!bwTransform.isNonlinear()) {
                IJ.showMessage((String)"unsupported at the moment");
            } else if (params.inverseOption.equals(INVERSE_OPTIONS.BOTH.toString())) {
                imp = BigWarpToDeformationFieldPlugIn.toImagePlus(data, ltm, bwTransform, params.ignoreAffine, params.flatten(), false, params.virtual, params.size, params.spacing, params.nThreads);
                imp = BigWarpToDeformationFieldPlugIn.toImagePlus(data, ltm, bwTransform, params.ignoreAffine, params.flatten(), true, params.virtual, params.size, params.spacing, params.nThreads);
            } else {
                boolean inverse = params.inverseOption.equals(INVERSE_OPTIONS.INVERSE.toString());
                imp = BigWarpToDeformationFieldPlugIn.toImagePlus(data, ltm, bwTransform, params.ignoreAffine, params.flatten(), inverse, params.virtual, params.size, params.spacing, params.nThreads);
            }
            if (imp != null) {
                imp.show();
            }
        } else if (!bwTransform.isNonlinear()) {
            BigWarpToDeformationFieldPlugIn.writeAffineN5(params.n5Base, params.n5Dataset, data, bwTransform);
        } else if (params.format.equals("TPS")) {
            BigWarpToDeformationFieldPlugIn.writeTpsN5(params.n5Base, params.n5Dataset, data, bwTransform);
        } else if (params.inverseOption.equals(INVERSE_OPTIONS.BOTH.toString())) {
            BigWarpToDeformationFieldPlugIn.writeN5(params.n5Base, params.n5Dataset + "/dfield", ltm, bwTransform, data, dims, spacing, offset, "pixel", params.blockSize, params.compression, params.nThreads, params.format, params.ignoreAffine, params.flatten(), params.dataType, params.maxQuantizationError, false, params.inverseTolerance, params.inverseMaxIterations);
            BigWarpToDeformationFieldPlugIn.writeN5(params.n5Base, params.n5Dataset + "/invdfield", ltm, bwTransform, data, dims, spacing, offset, "pixel", params.blockSize, params.compression, params.nThreads, params.format, params.ignoreAffine, params.flatten(), params.dataType, params.maxQuantizationError, true, params.inverseTolerance, params.inverseMaxIterations);
        } else {
            boolean inverse = params.inverseOption.equals(INVERSE_OPTIONS.INVERSE.toString());
            BigWarpToDeformationFieldPlugIn.writeN5(params.n5Base, params.n5Dataset, ltm, bwTransform, data, dims, spacing, offset, "pixel", params.blockSize, params.compression, params.nThreads, params.format, params.ignoreAffine, params.flatten(), params.dataType, params.maxQuantizationError, inverse, params.inverseTolerance, params.inverseMaxIterations);
        }
    }

    public void run(String args) {
        boolean isMacro;
        if (IJ.versionLessThan((String)"1.40")) {
            return;
        }
        String macroOptions = Macro.getOptions();
        String options = args;
        if (options == null || options.isEmpty()) {
            options = macroOptions;
        }
        boolean bl = isMacro = options != null && !options.isEmpty();
        if (isMacro) {
            ExportDisplacementFieldFrame.runMacro(macroOptions);
        } else {
            ExportDisplacementFieldFrame.createAndShow();
        }
    }

    public static ImagePlus toImagePlus(BigWarpData<?> data, LandmarkTableModel ltm, BigWarpTransform bwTransform, boolean splitAffine, boolean flatten, boolean inverse, boolean virtual, long[] dims, double[] spacing, int nThreads) {
        double[] offset = new double[spacing.length];
        return BigWarpToDeformationFieldPlugIn.toImagePlus(data, ltm, bwTransform, splitAffine, flatten, inverse, virtual, dims, spacing, offset, nThreads);
    }

    public static ImagePlus toImagePlus(BigWarpData<?> data, LandmarkTableModel ltm, BigWarpTransform bwTransform, boolean splitAffine, boolean flatten, boolean inverse, boolean virtual, long[] dims, double[] spacing, double[] offset, int nThreads) {
        ImagePlus dfieldIp;
        InvertibleRealTransform transform;
        BigWarpTransform bwXfm = bwTransform == null ? new BigWarpTransform(ltm, "Thin Plate Spline") : bwTransform;
        InvertibleRealTransform fwdTransform = BigWarpToDeformationFieldPlugIn.getTransformation(data, bwXfm, flatten, splitAffine);
        InvertibleRealTransform startingTransform = inverse ? fwdTransform.inverse() : fwdTransform;
        int nd = ltm.getNumdims();
        long[] ipDims = null;
        if (nd == 2) {
            ipDims = new long[]{dims[0], dims[1], 2L, 1L};
            transform = bwXfm.isMasked() ? new InvertibleWrapped2DIntermediate3D(startingTransform) : startingTransform;
        } else if (nd == 3) {
            ipDims = new long[]{dims[0], dims[1], 3L, dims[2]};
            transform = startingTransform;
        } else {
            return null;
        }
        RandomAccessibleInterval dfieldVirt = DisplacementFieldTransform.createDisplacementField((RealTransform)transform, (Interval)new FinalInterval(dims), (double[])spacing, (double[])offset);
        if (virtual) {
            RealFloatConverter conv = new RealFloatConverter();
            RandomAccessibleInterval dfieldF = Views.moveAxis((RandomAccessibleInterval)Converters.convert2((RandomAccessibleInterval)dfieldVirt, (Converter)conv, FloatType::new), (int)0, (int)2);
            dfieldIp = ImageJFunctions.wrap((RandomAccessibleInterval)dfieldF, (String)"");
        } else {
            FloatImagePlus dfield = ImagePlusImgs.floats((long[])ipDims);
            RandomAccessibleInterval dfieldImpPerm = Views.dropSingletonDimensions((RandomAccessibleInterval)Views.moveAxis((RandomAccessibleInterval)dfield, (int)2, (int)0));
            LoopBuilder.setImages((RandomAccessibleInterval)dfieldVirt, (RandomAccessibleInterval)dfieldImpPerm).multiThreaded(TaskExecutors.fixedThreadPool((int)nThreads)).forEachPixel((x, y) -> y.setReal(x.get()));
            dfieldIp = dfield.getImagePlus();
        }
        String title = "bigwarp dfield";
        if (splitAffine) {
            title = title + " (no affine)";
        }
        dfieldIp.setTitle(title);
        dfieldIp.getCalibration().pixelWidth = spacing[0];
        dfieldIp.getCalibration().pixelHeight = spacing[1];
        dfieldIp.getCalibration().xOrigin = offset[0];
        dfieldIp.getCalibration().yOrigin = offset[1];
        if (spacing.length > 2) {
            dfieldIp.getCalibration().pixelDepth = spacing[2];
            dfieldIp.getCalibration().zOrigin = offset[2];
        }
        return dfieldIp;
    }

    public static InvertibleRealTransform getTransformation(BigWarpData<?> data, BigWarpTransform transform, boolean concatPreTransforms, boolean ignoreAffine) {
        InvertibleRealTransform startingTransform;
        InvertibleRealTransform tps = transform.getTransformation(false);
        AffineGet affine = null;
        if (ignoreAffine) {
            affine = transform.affinePartOfTps();
        }
        if (!(ignoreAffine || data != null && concatPreTransforms)) {
            return tps;
        }
        InvertibleRealTransform preTransform = null;
        if (data != null && concatPreTransforms) {
            for (Map.Entry<Integer, SourceInfo> entry : data.sourceInfos.entrySet()) {
                if (entry.getValue().getTransform() == null) continue;
                RealTransform tform = entry.getValue().getTransform();
                if (tform instanceof InvertibleRealTransform) {
                    preTransform = (InvertibleRealTransform)tform;
                    break;
                }
                WrappedIterativeInvertibleRealTransform ixfm = new WrappedIterativeInvertibleRealTransform(tform);
                ixfm.getOptimzer().setMaxIters(transform.getInverseMaxIterations());
                ixfm.getOptimzer().setTolerance(transform.getInverseTolerance());
                preTransform = ixfm;
                break;
            }
        }
        if (preTransform != null || affine != null) {
            InvertibleRealTransformSequence seq = new InvertibleRealTransformSequence();
            seq.add((RealTransform)tps);
            if (affine != null) {
                seq.add((RealTransform)affine.inverse());
            }
            if (preTransform != null) {
                seq.add(preTransform);
            }
            startingTransform = seq;
        } else {
            startingTransform = tps;
        }
        return startingTransform;
    }

    public static void writeTpsN5(String n5BasePath, String n5Dataset, BigWarpData<?> data, BigWarpTransform bwTransform) {
        if (!bwTransform.getTransformType().equals("Thin Plate Spline")) {
            System.err.println(String.format("Can not write tranform type (%s) as Bigwarp Thin-plate-spline", bwTransform.getTransformType()));
            return;
        }
        String mvgSpaceName = data != null && data.numMovingSources() > 0 ? data.getMovingSource(0).getSpimSource().getName() : "moving";
        String tgtSpaceName = data != null && data.numTargetSources() > 0 ? data.getTargetSource(0).getSpimSource().getName() : "target";
        String input = mvgSpaceName;
        String output = tgtSpaceName;
        String name = input + " to " + output;
        String dataset = n5Dataset == null ? "" : n5Dataset;
        N5Factory factory = new N5Factory().gsonBuilder(NgffTransformations.gsonBuilder());
        N5Writer n5 = factory.openWriter(n5BasePath);
        ThinPlateSplineCoordinateTransform ct = new ThinPlateSplineCoordinateTransform(name, input, output, bwTransform.getTpsBase());
        NgffTransformations.addCoordinateTransformations(n5, dataset, ct);
        NgffTransformations.addCoordinateTransformations(n5, "", ct);
    }

    public static void writeAffineN5(String n5BasePath, String n5Dataset, BigWarpData<?> data, BigWarpTransform bwTransform) {
        String mvgSpaceName = data != null && data.numMovingSources() > 0 ? data.getMovingSource(0).getSpimSource().getName() : "moving";
        String tgtSpaceName = data != null && data.numTargetSources() > 0 ? data.getTargetSource(0).getSpimSource().getName() : "target";
        String input = mvgSpaceName;
        String output = tgtSpaceName;
        String name = input + " to " + output;
        TranslationCoordinateTransform ct = null;
        InvertibleCoordinateTransform tform = bwTransform.getCoordinateTransform();
        switch (bwTransform.getTransformType()) {
            case "Translation": {
                if (tform instanceof TranslationModel2D) {
                    ct = new TranslationCoordinateTransform(name, output, input, ((TranslationModel2D)tform).getTranslation());
                    break;
                }
                if (!(tform instanceof TranslationModel3D)) break;
                ct = new TranslationCoordinateTransform(name, output, input, ((TranslationModel3D)tform).getTranslation());
                break;
            }
            case "Similarity": {
                double[] simparams;
                if (tform instanceof SimilarityModel2D) {
                    simparams = bwTransform.toImglib2((Model<?>)((SimilarityModel2D)tform)).getRowPackedCopy();
                    ct = new AffineCoordinateTransform(name, output, input, simparams);
                    ((AffineCoordinateTransform)ct).serializeAsFlatArray();
                    break;
                }
                if (!(tform instanceof SimilarityModel3D)) break;
                simparams = bwTransform.toImglib2((Model<?>)((SimilarityModel3D)tform)).getRowPackedCopy();
                ct = new AffineCoordinateTransform(name, output, input, simparams);
                ((AffineCoordinateTransform)ct).serializeAsFlatArray();
                break;
            }
            case "Rotation": {
                if (tform instanceof RigidModel2D) {
                    double[] rotparams = bwTransform.toImglib2((Model<?>)((RigidModel2D)tform)).getRowPackedCopy();
                    ct = new AffineCoordinateTransform(name, output, input, rotparams);
                    ((AffineCoordinateTransform)ct).serializeAsFlatArray();
                    break;
                }
                if (!(tform instanceof RigidModel3D)) break;
                double[] rotparams = bwTransform.toImglib2((Model<?>)((RigidModel3D)tform)).getRowPackedCopy();
                ct = new AffineCoordinateTransform(name, output, input, rotparams);
                ((AffineCoordinateTransform)ct).serializeAsFlatArray();
                break;
            }
            case "Affine": {
                if (tform instanceof AffineModel2D) {
                    double[] affparams = bwTransform.toImglib2((Model<?>)((AffineModel2D)tform)).getRowPackedCopy();
                    ct = new AffineCoordinateTransform(name, output, input, affparams);
                    ((AffineCoordinateTransform)ct).serializeAsFlatArray();
                    break;
                }
                if (!(tform instanceof AffineModel3D)) break;
                double[] affparams = bwTransform.toImglib2((Model<?>)((AffineModel3D)tform)).getRowPackedCopy();
                ct = new AffineCoordinateTransform(name, output, input, affparams);
                ((AffineCoordinateTransform)ct).serializeAsFlatArray();
            }
        }
        if (ct == null) {
            return;
        }
        String dataset = n5Dataset == null ? "" : n5Dataset;
        N5Factory factory = new N5Factory().gsonBuilder(NgffTransformations.gsonBuilder());
        N5Writer n5 = factory.openWriter(n5BasePath);
        NgffTransformations.addCoordinateTransformations(n5, dataset, ct);
        n5.close();
    }

    public static void writeN5(String n5BasePath, LandmarkTableModel ltm, BigWarpTransform bwTransform, BigWarpData<?> data, long[] dims, double[] spacing, double[] offset, String unit, int[] spatialBlockSize, Compression compression, int nThreads, String format, boolean flatten, boolean inverse, double invTolerance, int invMaxIters) throws IOException {
        BigWarpToDeformationFieldPlugIn.writeN5(n5BasePath, "dfield", ltm, bwTransform, data, dims, spacing, offset, unit, spatialBlockSize, compression, nThreads, format, flatten, ExportDisplacementFieldFrame.DTYPE.FLOAT, 0.01, inverse, invTolerance, invMaxIters);
    }

    public static <T extends NativeType<T> & RealType<T>, Q extends NativeType<Q> & IntegerType<Q>> void writeN5(String n5BasePath, String n5Dataset, LandmarkTableModel ltm, BigWarpTransform bwTransform, BigWarpData<?> data, long[] dims, double[] spacing, double[] offset, String unit, int[] spatialBlockSize, Compression compression, int nThreads, String format, boolean flatten, ExportDisplacementFieldFrame.DTYPE dtype, double maxError, boolean inverse, double invTolerance, int invMaxIters) throws IOException {
        BigWarpToDeformationFieldPlugIn.writeN5(n5BasePath, n5Dataset, ltm, bwTransform, data, dims, spacing, offset, unit, spatialBlockSize, compression, nThreads, format, false, flatten, dtype, maxError, inverse, invTolerance, invMaxIters);
    }

    public static <T extends NativeType<T> & RealType<T>, Q extends NativeType<Q> & IntegerType<Q>> void writeN5(String n5BasePath, String n5Dataset, LandmarkTableModel ltm, BigWarpTransform bwTransform, BigWarpData<?> data, long[] dims, double[] spacing, double[] offset, String unit, int[] spatialBlockSizeArg, Compression compression, int nThreads, String format, boolean splitAffine, boolean flatten, ExportDisplacementFieldFrame.DTYPE dtype, double maxError, boolean inverse, double invTolerance, int invMaxIters) {
        RandomAccessibleInterval<T> dfield;
        String outputSpace;
        String inputSpace;
        String dataset = n5Dataset == null || n5Dataset.isEmpty() ? "dfield" : n5Dataset;
        String mvgSpaceName = BigWarpToDeformationFieldPlugIn.getMovingName(data);
        String tgtSpaceName = BigWarpToDeformationFieldPlugIn.getTargetName(data);
        if (inverse) {
            inputSpace = mvgSpaceName;
            outputSpace = tgtSpaceName;
        } else {
            inputSpace = tgtSpaceName;
            outputSpace = mvgSpaceName;
        }
        BigWarpTransform bwXfm = bwTransform == null ? new BigWarpTransform(ltm, "Thin Plate Spline") : bwTransform;
        bwXfm.setInverseMaxIterations(invMaxIters);
        bwXfm.setInverseTolerance(invTolerance);
        InvertibleRealTransform fwdTransform = BigWarpToDeformationFieldPlugIn.getTransformation(data, bwXfm, flatten, splitAffine);
        InvertibleRealTransform totalTransform = inverse ? fwdTransform.inverse() : fwdTransform;
        InvertibleRealTransform transform = totalTransform.numSourceDimensions() == 2 && bwXfm.isMasked() ? new InvertibleWrapped2DIntermediate3D(totalTransform) : totalTransform;
        int[] spatialBlockSize = BigWarpToDeformationFieldPlugIn.fillBlockSize(spatialBlockSizeArg, ltm.getNumdims());
        int[] blockSize = new int[spatialBlockSize.length + 1];
        blockSize[0] = spatialBlockSize.length;
        System.arraycopy(spatialBlockSize, 0, blockSize, 1, spatialBlockSize.length);
        N5Factory factory = new N5Factory().gsonBuilder(NgffTransformations.gsonBuilder());
        N5Writer n5 = factory.openWriter(n5BasePath);
        ReferencedCoordinateTransform refCt = null;
        if (!flatten) {
            for (Map.Entry<Integer, SourceInfo> e : data.sourceInfos.entrySet()) {
                SourceInfo i = e.getValue();
                if (!i.isMoving() || i.getTransformUri() == null || i.getTransformUri().isEmpty()) continue;
                refCt = new ReferencedCoordinateTransform(i.getTransformUri());
                break;
            }
        }
        if (splitAffine) {
            AffineGet affine = bwXfm.affinePartOfTps();
            AffineCoordinateTransform ngffAffine = new AffineCoordinateTransform(affine.getRowPackedCopy());
            dfield = BigWarpToDeformationFieldPlugIn.buildDisplacementField(dtype, (RealTransform)transform, (Interval)new FinalInterval(dims), spacing, offset);
            if (format.equals("Slicer")) {
                ThreadPoolExecutor exec = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
                SlicerTransformations.saveDisplacementField(n5, dataset, dfield, blockSize, compression, exec);
                SlicerTransformations.saveAffine(n5, dataset, affine);
            } else if (format.equals("N5")) {
                Q q = BigWarpToDeformationFieldPlugIn.getQuantizedDataType(dtype);
                if (q == null) {
                    N5DisplacementField.save((N5Writer)n5, (String)dataset, (AffineGet)affine, dfield, (double[])spacing, (double[])offset, (int[])blockSize, (Compression)compression);
                } else {
                    N5DisplacementField.save((N5Writer)n5, (String)dataset, (AffineGet)affine, dfield, (double[])spacing, (double[])offset, (int[])blockSize, (Compression)compression, q, (double)maxError);
                }
            } else {
                CoordinateTransform[] coordinateTransformArray;
                DisplacementFieldCoordinateTransform<?> dfieldTform = NgffTransformations.save(n5, dataset, dfield, inputSpace, outputSpace, spacing, offset, unit, blockSize, compression, nThreads);
                if (refCt == null) {
                    CoordinateTransform[] coordinateTransformArray2 = new CoordinateTransform[2];
                    coordinateTransformArray2[0] = dfieldTform;
                    coordinateTransformArray = coordinateTransformArray2;
                    coordinateTransformArray2[1] = ngffAffine;
                } else {
                    CoordinateTransform[] coordinateTransformArray3 = new CoordinateTransform[3];
                    coordinateTransformArray3[0] = dfieldTform;
                    coordinateTransformArray3[1] = ngffAffine;
                    coordinateTransformArray = coordinateTransformArray3;
                    coordinateTransformArray3[2] = refCt;
                }
                CoordinateTransform[] ctList = coordinateTransformArray;
                SequenceCoordinateTransform totalTform = new SequenceCoordinateTransform(inputSpace, outputSpace, ctList);
                NgffTransformations.addCoordinateTransformations(n5, "/", totalTform);
            }
        } else {
            dfield = BigWarpToDeformationFieldPlugIn.buildDisplacementField(dtype, (RealTransform)transform, (Interval)new FinalInterval(dims), spacing, offset);
            if (format.equals("Slicer")) {
                ThreadPoolExecutor exec = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
                SlicerTransformations.saveDisplacementField(n5, dataset, dfield, blockSize, compression, exec);
                SlicerTransformations.saveAffine(n5, dataset, (AffineGet)new ScaleAndTranslation(spacing, offset));
            } else if (format.equals("N5")) {
                Q q = BigWarpToDeformationFieldPlugIn.getQuantizedDataType(dtype);
                if (q == null) {
                    N5DisplacementField.save((N5Writer)n5, (String)dataset, null, dfield, (double[])spacing, (double[])offset, (int[])blockSize, (Compression)compression);
                } else {
                    N5DisplacementField.save((N5Writer)n5, (String)dataset, null, dfield, (double[])spacing, (double[])offset, (int[])blockSize, (Compression)compression, q, (double)maxError);
                }
            } else {
                SequenceCoordinateTransform dfieldTform = NgffTransformations.save(n5, dataset, dfield, inputSpace, outputSpace, spacing, offset, unit, blockSize, compression, nThreads);
                SequenceCoordinateTransform ngffTform = refCt == null ? dfieldTform : new SequenceCoordinateTransform(refCt.getInput(), dfieldTform.getOutput(), new CoordinateTransform[]{dfieldTform, refCt});
                NgffTransformations.addCoordinateTransformations(n5, "/", ngffTform);
            }
        }
        n5.close();
    }

    private static <T extends NativeType<T> & RealType<T>> RandomAccessibleInterval<T> buildDisplacementField(ExportDisplacementFieldFrame.DTYPE dtype, RealTransform transform, Interval interval, double[] spacing, double[] offset) {
        if (ExportDisplacementFieldFrame.DTYPE.FLOAT.equals((Object)dtype)) {
            return BigWarpToDeformationFieldPlugIn.buildDisplacementFieldFloat(transform, interval, spacing, offset);
        }
        return BigWarpToDeformationFieldPlugIn.buildDisplacementFieldDouble(transform, interval, spacing, offset);
    }

    private static RandomAccessibleInterval<DoubleType> buildDisplacementFieldDouble(RealTransform transform, Interval interval, double[] spacing, double[] offset) {
        return DisplacementFieldTransform.createDisplacementField((RealTransform)transform, (Interval)interval, (double[])spacing, (double[])offset, () -> DoubleType.createVector((int)transform.numTargetDimensions()));
    }

    private static RandomAccessibleInterval<FloatType> buildDisplacementFieldFloat(RealTransform transform, Interval interval, double[] spacing, double[] offset) {
        return DisplacementFieldTransform.createDisplacementField((RealTransform)transform, (Interval)interval, (double[])spacing, (double[])offset, () -> FloatType.createVector((int)transform.numTargetDimensions()));
    }

    private static <Q extends NativeType<Q>> Q getQuantizedDataType(ExportDisplacementFieldFrame.DTYPE dtype) {
        switch (dtype) {
            case BYTE: {
                return (Q)new ByteType();
            }
            case SHORT: {
                return (Q)new ShortType();
            }
        }
        return null;
    }

    private static String getMovingName(BigWarpData data) {
        if (data != null && data.numMovingSources() > 0) {
            Source src = data.getMovingSource(0).getSpimSource();
            if (src instanceof WarpedSource) {
                return ((WarpedSource)src).getOriginalName();
            }
            return src.getName();
        }
        return "moving";
    }

    private static String getTargetName(BigWarpData data) {
        if (data != null && data.numTargetSources() > 0) {
            Source src = data.getTargetSource(0).getSpimSource();
            if (src instanceof WarpedSource) {
                return ((WarpedSource)src).getOriginalName();
            }
            return src.getName();
        }
        return "target";
    }

    private static int[] fillBlockSize(int[] blockSize, int N) {
        if (blockSize.length >= N) {
            return blockSize;
        }
        int[] out = new int[N];
        int j = blockSize.length - 1;
        for (int i = 0; i < N; ++i) {
            out[i] = i < blockSize.length ? blockSize[i] : blockSize[j];
        }
        return out;
    }

    private static RealTransform getTpsAffineToggle(BigWarpTransform bwXfm, boolean splitAffine) {
        if (splitAffine) {
            ThinPlateR2LogRSplineKernelTransform tps = bwXfm.getTpsBase();
            return new ThinplateSplineTransform(new ThinPlateR2LogRSplineKernelTransform(tps.getSourceLandmarks(), (double[][])null, null, tps.getKnotWeights()));
        }
        return bwXfm.getTransformation(false);
    }

    @Deprecated
    public static AffineGet toAffine(ThinPlateR2LogRSplineKernelTransform tps) {
        double[] affineFlat = BigWarpToDeformationFieldPlugIn.toFlatAffine(tps);
        if (affineFlat.length == 6) {
            AffineTransform2D affine = new AffineTransform2D();
            affine.set(affineFlat);
            return affine;
        }
        if (affineFlat.length == 12) {
            AffineTransform3D affine = new AffineTransform3D();
            affine.set(affineFlat);
            return affine;
        }
        return null;
    }

    public static double[] toFlatAffine(ThinPlateR2LogRSplineKernelTransform tps) {
        double[][] tpsAffine = tps.getAffine();
        double[] translation = tps.getTranslation();
        double[] affine = tps.getNumDims() == 2 ? new double[]{1.0 + tpsAffine[0][0], tpsAffine[0][1], translation[0], tpsAffine[1][0], 1.0 + tpsAffine[1][1], translation[1]} : new double[]{1.0 + tpsAffine[0][0], tpsAffine[0][1], tpsAffine[0][2], translation[0], tpsAffine[1][0], 1.0 + tpsAffine[1][1], tpsAffine[1][2], translation[1], tpsAffine[2][0], tpsAffine[2][1], 1.0 + tpsAffine[2][2], translation[2]};
        return affine;
    }

    public static long[] dimensionsFromImagePlus(ImagePlus ref_imp) {
        long[] dims = ref_imp.getNSlices() < 2 ? new long[]{ref_imp.getWidth(), ref_imp.getHeight()} : new long[]{ref_imp.getWidth(), ref_imp.getHeight(), ref_imp.getNSlices()};
        return dims;
    }

    @Deprecated
    public static FloatImagePlus<FloatType> convertToDeformationField(long[] dims, RealTransform transform, AffineGet pixToPhysical, int nThreads) {
        FloatImagePlus deformationField;
        FloatImagePlus dfieldPermuted = deformationField = ImagePlusImgs.floats((long[])dims);
        if (dims.length == 4) {
            dfieldPermuted = Views.permute((RandomAccessibleInterval)deformationField, (int)2, (int)3);
        }
        if (nThreads <= 1) {
            BigWarpToDeformationFieldPlugIn.fromRealTransform(transform, pixToPhysical, dfieldPermuted);
        } else {
            BigWarpToDeformationFieldPlugIn.fromRealTransform(transform, pixToPhysical, dfieldPermuted, nThreads);
        }
        return deformationField;
    }

    public static boolean areTransformsTheSame(RealTransform xfm1, RealTransform xfm2, Interval itvl, double EPS) {
        double[] pArray = new double[3];
        double[] qArray = new double[3];
        RealPoint p = RealPoint.wrap((double[])pArray);
        RealPoint q = RealPoint.wrap((double[])qArray);
        IntervalIterator c = new IntervalIterator(itvl);
        while (c.hasNext()) {
            c.fwd();
            xfm1.apply((RealLocalizable)c, (RealPositionable)p);
            xfm2.apply((RealLocalizable)c, (RealPositionable)q);
            for (int d = 0; d < itvl.numDimensions(); ++d) {
                if (!(Math.abs(p.getDoublePosition(d) - q.getDoublePosition(d)) > EPS)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static <T extends RealType<T>> void fromRealTransform(RealTransform transform, AffineGet pixelToPhysical, RandomAccessibleInterval<T> deformationField) {
        assert (deformationField.numDimensions() == transform.numSourceDimensions() + 1);
        assert (deformationField.dimension(deformationField.numDimensions() - 1) >= (long)transform.numSourceDimensions());
        int N = transform.numSourceDimensions();
        RealPoint p = new RealPoint(transform.numTargetDimensions());
        RealPoint q = new RealPoint(transform.numTargetDimensions());
        CompositeIntervalView col = Views.collapse(deformationField);
        Cursor c = Views.flatIterable((RandomAccessibleInterval)col).cursor();
        while (c.hasNext()) {
            GenericComposite displacementVector = (GenericComposite)c.next();
            pixelToPhysical.apply((RealLocalizable)c, (RealPositionable)p);
            transform.apply((RealLocalizable)p, (RealPositionable)q);
            for (int i = 0; i < N; ++i) {
                ((RealType)displacementVector.get((long)i)).setReal(q.getDoublePosition(i) - p.getDoublePosition(i));
            }
        }
    }

    @Deprecated
    public static <T extends RealType<T>> void fromRealTransform(final RealTransform transform, AffineGet pixelToPhysical, final RandomAccessibleInterval<T> deformationField, int nThreads) {
        int dim2split;
        long N;
        assert (deformationField.numDimensions() == transform.numSourceDimensions() + 1);
        assert (deformationField.dimension(deformationField.numDimensions() - 1) >= (long)transform.numSourceDimensions());
        int ndims = transform.numSourceDimensions();
        long[] splitPoints = new long[nThreads + 1];
        if (ndims == 2) {
            N = deformationField.dimension(1);
            dim2split = 1;
        } else {
            N = deformationField.dimension(2);
            dim2split = 2;
        }
        long del = N / (long)nThreads;
        splitPoints[0] = 0L;
        splitPoints[nThreads] = deformationField.dimension(dim2split);
        for (int i = 1; i < nThreads; ++i) {
            splitPoints[i] = splitPoints[i - 1] + del;
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        LinkedList<1> jobs = new LinkedList<1>();
        for (int i = 0; i < nThreads; ++i) {
            final long start = splitPoints[i];
            final long end = splitPoints[i + 1];
            RealTransform transformCopy = transform.copy();
            AffineGet toPhysicalCopy = pixelToPhysical.copy();
            jobs.add(new Callable<Boolean>((RealTransform)toPhysicalCopy, transformCopy, ndims){
                final /* synthetic */ RealTransform val$toPhysicalCopy;
                final /* synthetic */ RealTransform val$transformCopy;
                final /* synthetic */ int val$ndims;
                {
                    this.val$toPhysicalCopy = realTransform2;
                    this.val$transformCopy = realTransform3;
                    this.val$ndims = n2;
                }

                @Override
                public Boolean call() {
                    try {
                        RealPoint p = new RealPoint(transform.numTargetDimensions());
                        RealPoint q = new RealPoint(transform.numTargetDimensions());
                        FinalInterval subItvl = BigWarpExporter.getSubInterval((Interval)deformationField, dim2split, start, end);
                        CompositeIntervalView col = Views.collapse((RandomAccessibleInterval)deformationField);
                        IntervalView subTgt = Views.interval((RandomAccessible)col, (Interval)subItvl);
                        Cursor c = Views.flatIterable((RandomAccessibleInterval)subTgt).cursor();
                        while (c.hasNext()) {
                            GenericComposite displacementVector = (GenericComposite)c.next();
                            this.val$toPhysicalCopy.apply((RealLocalizable)c, (RealPositionable)p);
                            this.val$transformCopy.apply((RealLocalizable)p, (RealPositionable)q);
                            for (int i = 0; i < this.val$ndims; ++i) {
                                ((RealType)displacementVector.get((long)i)).setReal(q.getDoublePosition(i) - p.getDoublePosition(i));
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            });
        }
        try {
            List futures = threadPool.invokeAll(jobs);
            for (Future f : futures) {
                f.get();
            }
            threadPool.shutdown();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static Compression getCompression(String compressionArg) {
        switch (compressionArg) {
            case "gzip": {
                return new GzipCompression();
            }
            case "lz4": {
                return new Lz4Compression();
            }
            case "xz": {
                return new XzCompression();
            }
            case "raw": {
                return new RawCompression();
            }
            case "blosc": {
                return new BloscCompression();
            }
        }
        return new RawCompression();
    }

    public static class DeformationFieldExportParameters {
        public final String landmarkPath;
        public final boolean ignoreAffine;
        public final String option;
        public final String inverseOption;
        public final boolean virtual;
        public final int nThreads;
        public final String format;
        public final long[] size;
        public final double[] spacing;
        public final double[] offset;
        public final String unit;
        public final String n5Base;
        public final String n5Dataset;
        public final Compression compression;
        public final int[] blockSize;
        public final ExportDisplacementFieldFrame.DTYPE dataType;
        public final double maxQuantizationError;
        public final double inverseTolerance;
        public final int inverseMaxIterations;

        public DeformationFieldExportParameters(String landmarkPath, boolean ignoreAffine, String option, ExportDisplacementFieldFrame.DTYPE dataType, double maxQuantizationError, String inverseOption, double inverseTolerance, int inverseMaxIterations, boolean virtual, int nThreads, String format, long[] size, double[] spacing, double[] offset, String unit, String n5Base, String n5Dataset, int[] blockSize, Compression compression) {
            this.landmarkPath = landmarkPath;
            this.ignoreAffine = ignoreAffine;
            this.option = option;
            this.dataType = dataType;
            this.maxQuantizationError = maxQuantizationError;
            this.inverseOption = inverseOption;
            this.inverseTolerance = inverseTolerance;
            this.inverseMaxIterations = inverseMaxIterations;
            this.virtual = virtual;
            this.nThreads = nThreads;
            this.format = format;
            this.size = size;
            this.spacing = spacing;
            this.offset = offset;
            this.unit = unit;
            this.n5Base = n5Base;
            this.n5Dataset = n5Dataset;
            this.blockSize = blockSize;
            this.compression = compression;
        }

        public boolean flatten() {
            return this.option.equals(BigWarpToDeformationFieldPlugIn.flattenOption);
        }

        public static DeformationFieldExportParameters fromDialog(boolean promptLandmarks, boolean promptReference) {
            Object offset;
            Object spacing;
            long[] size;
            int idx;
            GenericDialogPlus gd = new GenericDialogPlus("BigWarp to Deformation");
            gd.addMessage("Deformation field export:");
            if (promptLandmarks) {
                gd.addFileField("landmarks_image_file", "");
            }
            gd.addCheckbox("Split affine part", false);
            String[] choices = new String[]{BigWarpToDeformationFieldPlugIn.flattenOption, BigWarpToDeformationFieldPlugIn.sequenceOption};
            gd.addChoice("type", choices, BigWarpToDeformationFieldPlugIn.flattenOption);
            String[] dataTypeChoices = new String[]{ExportDisplacementFieldFrame.DTYPE.BYTE.toString(), ExportDisplacementFieldFrame.DTYPE.SHORT.toString(), ExportDisplacementFieldFrame.DTYPE.FLOAT.toString(), ExportDisplacementFieldFrame.DTYPE.DOUBLE.toString()};
            gd.addChoice("dataType", dataTypeChoices, ExportDisplacementFieldFrame.DTYPE.FLOAT.toString());
            gd.addNumericField("quantizationError", 0.01);
            String[] invChoices = new String[]{INVERSE_OPTIONS.FORWARD.toString(), INVERSE_OPTIONS.INVERSE.toString(), INVERSE_OPTIONS.BOTH.toString()};
            gd.addChoice("direction", invChoices, INVERSE_OPTIONS.FORWARD.toString());
            gd.addCheckbox("virtual", false);
            gd.addNumericField("threads", 1.0, 0);
            gd.addStringField("format", "NGFF");
            gd.addMessage("Size and spacing");
            int[] ids = WindowManager.getIDList();
            if (promptReference) {
                String[] titles = new String[ids.length + 1];
                for (int i = 0; i < ids.length; ++i) {
                    titles[i] = WindowManager.getImage((int)ids[i]).getTitle();
                }
                titles[ids.length] = "None";
                String current = WindowManager.getCurrentImage().getTitle();
                gd.addChoice("reference_image", titles, current);
            }
            gd.addStringField("output size", "");
            gd.addStringField("output spacing", "");
            gd.addStringField("output offset", "");
            gd.addStringField("output unit", "pixel");
            gd.addMessage("Leave n5 path empty to export as ImagePlus");
            gd.addDirectoryOrFileField("n5 root path", "");
            gd.addStringField("n5 dataset", "dfield");
            gd.addStringField("n5 block size", "32,32,32");
            gd.addChoice("n5 compression", compressionOptions, "gzip");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            String landmarkPath = null;
            if (promptLandmarks) {
                landmarkPath = gd.getNextString();
            }
            boolean ignoreAffine = gd.getNextBoolean();
            String option = gd.getNextChoice();
            ExportDisplacementFieldFrame.DTYPE dataType = ExportDisplacementFieldFrame.DTYPE.valueOf(gd.getNextChoice());
            double maxQuantizationError = gd.getNextNumber();
            String direction = gd.getNextChoice();
            boolean virtual = gd.getNextBoolean();
            int nThreads = (int)gd.getNextNumber();
            String format = gd.getNextString();
            ImagePlus ref_imp = null;
            if (promptReference && (idx = ids[gd.getNextChoiceIndex()]) < ids.length) {
                ref_imp = WindowManager.getImage((int)idx);
            }
            String sizeString = gd.getNextString();
            String spacingString = gd.getNextString();
            String offsetString = gd.getNextString();
            String unitString = gd.getNextString();
            String n5Base = gd.getNextString();
            String n5Dataset = gd.getNextString();
            String n5BlockSizeString = gd.getNextString();
            String n5CompressionString = gd.getNextChoice();
            Compression compression = BigWarpToDeformationFieldPlugIn.getCompression(n5CompressionString);
            int[] blockSize = n5BlockSizeString.isEmpty() ? null : Arrays.stream(n5BlockSizeString.split(",")).mapToInt(Integer::parseInt).toArray();
            String unit = "pixel";
            if (ref_imp == null) {
                size = !sizeString.isEmpty() ? Arrays.stream(sizeString.split(",")).mapToLong(Long::parseLong).toArray() : null;
                spacing = !spacingString.isEmpty() ? Arrays.stream(spacingString.split(",")).mapToDouble(Double::parseDouble).toArray() : null;
                offset = !offsetString.isEmpty() ? Arrays.stream(offsetString.split(",")).mapToDouble(Double::parseDouble).toArray() : null;
                if (!unitString.isEmpty()) {
                    unit = unitString;
                }
            } else {
                int nd = 2;
                if (ref_imp.getNSlices() > 1) {
                    nd = 3;
                }
                spacing = new double[nd];
                offset = new double[nd];
                spacing[0] = ref_imp.getCalibration().pixelWidth;
                spacing[1] = ref_imp.getCalibration().pixelHeight;
                offset[0] = ref_imp.getCalibration().xOrigin;
                offset[1] = ref_imp.getCalibration().yOrigin;
                if (nd > 2) {
                    spacing[2] = ref_imp.getCalibration().pixelDepth;
                    offset[2] = ref_imp.getCalibration().zOrigin;
                }
                size = BigWarpToDeformationFieldPlugIn.dimensionsFromImagePlus(ref_imp);
            }
            return new DeformationFieldExportParameters(landmarkPath, ignoreAffine, option, dataType, maxQuantizationError, direction, 0.5, 200, virtual, nThreads, format, size, (double[])spacing, (double[])offset, unit, n5Base, n5Dataset, blockSize, compression);
        }

        public JFrame makeDialog() {
            ExportDisplacementFieldFrame frame = new ExportDisplacementFieldFrame(null);
            return frame;
        }
    }

    public static enum INVERSE_OPTIONS {
        FORWARD,
        INVERSE,
        BOTH;

    }
}

