/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.export.ProgressWriter;
import bdv.ij.util.ProgressWriterIJ;
import bdv.img.WarpedSource;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarp;
import bigwarp.BigWarpData;
import bigwarp.BigWarpExporter;
import bigwarp.BigWarpInit;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.transforms.BigWarpTransform;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineRandomAccessible;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.Lz4Compression;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.XzCompression;
import org.janelia.saalfeldlab.n5.blosc.BloscCompression;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataParser;

public class ApplyBigwarpPlugin
implements PlugIn {
    public static final String TARGET = "Target";
    public static final String MOVING = "Moving";
    public static final String MOVING_WARPED = "Moving (warped)";
    public static final String UNION_TARGET_MOVING = "Union of Target and warped moving image";
    public static final String SPECIFIED = "Specified";
    public static final String SPECIFIED_PHYSICAL = "Specified (physical units)";
    public static final String SPECIFIED_PIXEL = "Specified (pixel units)";
    public static final String LANDMARK_POINTS = "Landmark points";
    public static final String LANDMARK_POINT_CUBE_PHYSICAL = "Landmark point cube (physical units)";
    public static final String LANDMARK_POINT_CUBE_PIXEL = "Landmark point cube (pixel units)";

    public static void main(String[] args) {
        new ImageJ();
        new ApplyBigwarpPlugin().run("");
    }

    public static boolean validateInput(ImagePlus movingIp, ImagePlus targetIp, LandmarkTableModel landmarks, String fieldOfViewOption, String resolutionOption, double[] resolutionSpec, double[] fovSpec, double[] offsetSpec, Interpolation interp, boolean isVirtual, int nThreads) {
        if (targetIp == movingIp) {
            if (fieldOfViewOption.equals(TARGET)) {
                return false;
            }
            if (resolutionOption.equals(TARGET)) {
                return false;
            }
        }
        return true;
    }

    public static double[] getResolution(Source<?> source, String resolutionOption, double[] resolutionSpec) {
        if (source == null) {
            System.err.println("Requested target resolution but target image is missing.");
            return null;
        }
        double[] res = ApplyBigwarpPlugin.resolutionFromSource(source);
        return res;
    }

    public static String getUnit(BigWarpData<?> bwData, String resolutionOption) {
        boolean doTargetImagesExist;
        String unit = "pix";
        boolean bl = doTargetImagesExist = bwData.numTargetSources() > 0;
        if (resolutionOption.equals(MOVING) || resolutionOption.equals(MOVING_WARPED) || !doTargetImagesExist) {
            VoxelDimensions mvgVoxDims = bwData.getMovingSource(0).getSpimSource().getVoxelDimensions();
            if (mvgVoxDims != null) {
                unit = mvgVoxDims.unit();
            }
        } else {
            VoxelDimensions tgtVoxDims = bwData.getTargetSource(0).getSpimSource().getVoxelDimensions();
            if (tgtVoxDims != null) {
                unit = tgtVoxDims.unit();
            }
        }
        return unit;
    }

    public static double[] getResolution(BigWarpData<?> bwData, String resolutionOption, double[] resolutionSpec) {
        if (resolutionOption.equals(TARGET)) {
            if (bwData.numTargetSources() <= 0) {
                return null;
            }
            Source spimSource = bwData.getTargetSource(0).getSpimSource();
            return ApplyBigwarpPlugin.getResolution(spimSource, resolutionOption, resolutionSpec);
        }
        if (resolutionOption.equals(MOVING)) {
            if (bwData.numTargetSources() <= 0) {
                return null;
            }
            Source spimSource = bwData.getMovingSource(0).getSpimSource();
            return ApplyBigwarpPlugin.getResolution(spimSource, resolutionOption, resolutionSpec);
        }
        if (resolutionOption.equals(SPECIFIED)) {
            if (resolutionSpec == null) {
                System.err.println("Requested moving resolution but moving image is missing.");
                return null;
            }
            double[] res = new double[3];
            System.arraycopy(resolutionSpec, 0, res, 0, resolutionSpec.length);
            return res;
        }
        return null;
    }

    public static double[] getResolution(ImagePlus movingIp, ImagePlus targetIp, String resolutionOption, double[] resolutionSpec) {
        if (resolutionOption.equals(TARGET)) {
            if (targetIp == null) {
                System.err.println("Requested target resolution but target image is missing.");
                return null;
            }
            double[] res = new double[]{targetIp.getCalibration().pixelWidth, targetIp.getCalibration().pixelHeight, targetIp.getCalibration().pixelDepth};
            return res;
        }
        if (resolutionOption.equals(MOVING)) {
            if (movingIp == null) {
                System.err.println("Requested moving resolution but moving image is missing.");
                return null;
            }
            double[] res = new double[]{movingIp.getCalibration().pixelWidth, movingIp.getCalibration().pixelHeight, movingIp.getCalibration().pixelDepth};
            return res;
        }
        if (resolutionOption.equals(SPECIFIED)) {
            if (resolutionSpec == null) {
                System.err.println("Requested moving resolution but moving image is missing.");
                return null;
            }
            double[] res = new double[3];
            System.arraycopy(resolutionSpec, 0, res, 0, resolutionSpec.length);
            return res;
        }
        System.err.println("Invalid resolution option: " + resolutionOption);
        return null;
    }

    public static List<Interval> getPixelInterval(ImagePlus movingIp, ImagePlus targetIp, LandmarkTableModel landmarks, InvertibleRealTransform transform, String fieldOfViewOption, String fieldOfViewPointFilter, double[] fovSpec, double[] offsetSpec, double[] outputResolution) {
        BoundingBoxEstimation bboxEst = new BoundingBoxEstimation();
        BigWarpData bwData = BigWarpInit.createBigWarpDataFromImages(movingIp, targetIp);
        return ApplyBigwarpPlugin.getPixelInterval(bwData, landmarks, transform, fieldOfViewOption, fieldOfViewPointFilter, bboxEst, fovSpec, offsetSpec, outputResolution);
    }

    public static List<Interval> getPixelInterval(ImagePlus movingIp, ImagePlus targetIp, LandmarkTableModel landmarks, InvertibleRealTransform transform, String fieldOfViewOption, String fieldOfViewPointFilter, BoundingBoxEstimation bboxEst, double[] fovSpec, double[] offsetSpec, double[] outputResolution) {
        BigWarpData bwData = BigWarpInit.createBigWarpDataFromImages(movingIp, targetIp);
        return ApplyBigwarpPlugin.getPixelInterval(bwData, landmarks, transform, fieldOfViewOption, fieldOfViewPointFilter, bboxEst, fovSpec, offsetSpec, outputResolution);
    }

    public static Interval getPixelInterval(Source<?> source, LandmarkTableModel landmarks, InvertibleRealTransform transform, String fieldOfViewOption, double[] outputResolution) {
        return ApplyBigwarpPlugin.getPixelInterval(source, landmarks, transform, fieldOfViewOption, new BoundingBoxEstimation(), outputResolution);
    }

    public static Interval getPixelInterval(Source<?> source, LandmarkTableModel landmarks, InvertibleRealTransform transform, String fieldOfViewOption, BoundingBoxEstimation bboxEst, double[] outputResolution) {
        RandomAccessibleInterval rai = source.getSource(0, 0);
        if (fieldOfViewOption.equals(TARGET)) {
            double[] inputres = ApplyBigwarpPlugin.resolutionFromSource(source);
            int N = outputResolution.length <= rai.numDimensions() ? outputResolution.length : rai.numDimensions();
            long[] max = new long[rai.numDimensions()];
            for (int d = 0; d < N; ++d) {
                max[d] = (long)Math.ceil(inputres[d] * (double)rai.dimension(d) / outputResolution[d]);
            }
            return new FinalInterval(max);
        }
        if (fieldOfViewOption.equals(MOVING_WARPED)) {
            RandomAccessibleInterval raiSrc = ((WarpedSource)source).getWrappedSource().getSource(0, 0);
            FinalInterval interval = new FinalInterval(Intervals.minAsLongArray((Interval)raiSrc), Intervals.maxAsLongArray((Interval)raiSrc));
            if (transform == null) {
                return interval;
            }
            double[] movingRes = ApplyBigwarpPlugin.resolutionFromSource(source);
            int ndims = transform.numSourceDimensions();
            AffineTransform movingPixelToPhysical = new AffineTransform(ndims);
            movingPixelToPhysical.set(movingRes[0], 0, 0);
            movingPixelToPhysical.set(movingRes[1], 1, 1);
            if (ndims > 2) {
                movingPixelToPhysical.set(movingRes[2], 2, 2);
            }
            AffineTransform outputResolution2Pixel = new AffineTransform(ndims);
            outputResolution2Pixel.set(outputResolution[0], 0, 0);
            outputResolution2Pixel.set(outputResolution[1], 1, 1);
            if (ndims > 2) {
                outputResolution2Pixel.set(outputResolution[2], 2, 2);
            }
            RealTransformSequence seq = new RealTransformSequence();
            seq.add((RealTransform)movingPixelToPhysical);
            seq.add((RealTransform)transform.inverse());
            seq.add((RealTransform)outputResolution2Pixel.inverse());
            return bboxEst.estimatePixelInterval((RealTransform)seq, (Interval)interval);
        }
        if (fieldOfViewOption.equals(UNION_TARGET_MOVING)) {
            Interval movingWarpedInterval = ApplyBigwarpPlugin.getPixelInterval(source, landmarks, transform, MOVING_WARPED, bboxEst, outputResolution);
            Interval targetInterval = ApplyBigwarpPlugin.getPixelInterval(source, landmarks, transform, TARGET, bboxEst, outputResolution);
            return Intervals.union((Interval)movingWarpedInterval, (Interval)targetInterval);
        }
        return null;
    }

    public static double[] resolutionFromSource(Source<?> src) {
        double[] res = new double[3];
        AffineTransform3D xfm = new AffineTransform3D();
        src.getSourceTransform(0, 0, xfm);
        res[0] = xfm.get(0, 0);
        res[1] = xfm.get(1, 1);
        res[2] = xfm.get(2, 2);
        return res;
    }

    public static List<Interval> getPixelInterval(BigWarpData<?> bwData, LandmarkTableModel landmarks, InvertibleRealTransform transform, String fieldOfViewOption, String fieldOfViewPointFilter, double[] fovSpec, double[] offsetSpec, double[] outputResolution) {
        return ApplyBigwarpPlugin.getPixelInterval(bwData, landmarks, transform, fieldOfViewOption, fieldOfViewPointFilter, new BoundingBoxEstimation(), fovSpec, offsetSpec, outputResolution);
    }

    public static List<Interval> getPixelInterval(BigWarpData<?> bwData, LandmarkTableModel landmarks, InvertibleRealTransform transform, String fieldOfViewOption, String fieldOfViewPointFilter, BoundingBoxEstimation bboxEst, double[] fovSpec, double[] offsetSpec, double[] outputResolution) {
        if (fieldOfViewOption.equals(TARGET)) {
            if (bwData.numTargetSources() <= 0) {
                System.err.println("Requested target fov but target image is missing.");
                return null;
            }
            return Stream.of(ApplyBigwarpPlugin.getPixelInterval(bwData.getTargetSource(0).getSpimSource(), landmarks, transform, fieldOfViewOption, bboxEst, outputResolution)).collect(Collectors.toList());
        }
        if (fieldOfViewOption.equals(MOVING_WARPED)) {
            return Stream.of(ApplyBigwarpPlugin.getPixelInterval(bwData.getMovingSource(0).getSpimSource(), landmarks, transform, fieldOfViewOption, bboxEst, outputResolution)).collect(Collectors.toList());
        }
        if (fieldOfViewOption.equals(UNION_TARGET_MOVING)) {
            return Stream.of(ApplyBigwarpPlugin.getPixelInterval(bwData.getMovingSource(0).getSpimSource(), landmarks, transform, fieldOfViewOption, bboxEst, outputResolution)).collect(Collectors.toList());
        }
        if (fieldOfViewOption.equals(SPECIFIED_PIXEL)) {
            if (fovSpec.length == 2) {
                long[] min = new long[]{(long)Math.floor(offsetSpec[0]), (long)Math.floor(offsetSpec[1])};
                long[] max = new long[]{(long)Math.ceil(offsetSpec[0] + fovSpec[0]), (long)Math.ceil(offsetSpec[0] + fovSpec[1])};
                ArrayList<Interval> out = new ArrayList<Interval>();
                out.add((Interval)new FinalInterval(min, max));
                return out;
            }
            if (fovSpec.length == 3) {
                long[] min = new long[]{(long)Math.floor(offsetSpec[0]), (long)Math.floor(offsetSpec[1]), (long)Math.floor(offsetSpec[2])};
                long[] max = new long[]{(long)Math.ceil(offsetSpec[0] + fovSpec[0]), (long)Math.ceil(offsetSpec[1] + fovSpec[1]), (long)Math.ceil(offsetSpec[2] + fovSpec[2])};
                ArrayList<Interval> out = new ArrayList<Interval>();
                out.add((Interval)new FinalInterval(min, max));
                return out;
            }
            System.out.println("Invalid fov spec, length : " + fovSpec.length);
            return null;
        }
        if (fieldOfViewOption.equals(SPECIFIED_PHYSICAL)) {
            if (fovSpec.length == 2) {
                long[] min = new long[]{(long)Math.floor(offsetSpec[0] / outputResolution[0]), (long)Math.floor(offsetSpec[1] / outputResolution[1])};
                long[] max = new long[]{(long)Math.floor((offsetSpec[0] + fovSpec[0]) / outputResolution[0]), (long)Math.floor((offsetSpec[1] + fovSpec[1]) / outputResolution[1])};
                ArrayList<Interval> out = new ArrayList<Interval>();
                out.add((Interval)new FinalInterval(min, max));
                return out;
            }
            if (fovSpec.length == 3) {
                long[] min = new long[]{(long)Math.floor(offsetSpec[0] / outputResolution[0]), (long)Math.floor(offsetSpec[1] / outputResolution[1]), (long)Math.floor(offsetSpec[2] / outputResolution[2])};
                long[] max = new long[]{(long)Math.floor((offsetSpec[0] + fovSpec[0]) / outputResolution[0]), (long)Math.floor((offsetSpec[0] + fovSpec[1]) / outputResolution[1]), (long)Math.floor((offsetSpec[2] + fovSpec[2]) / outputResolution[2])};
                ArrayList<Interval> out = new ArrayList<Interval>();
                out.add((Interval)new FinalInterval(min, max));
                return out;
            }
            System.out.println("Invalid fov spec, length : " + fovSpec.length);
            return null;
        }
        if (fieldOfViewOption.equals(LANDMARK_POINTS)) {
            List<Double[]> matchedLandmarks = ApplyBigwarpPlugin.getMatchedPoints(landmarks, fieldOfViewPointFilter);
            long[] min = new long[landmarks.getNumdims()];
            long[] max = new long[landmarks.getNumdims()];
            Arrays.fill(min, Long.MAX_VALUE);
            Arrays.fill(max, Long.MIN_VALUE);
            int numPoints = 0;
            for (int i = 0; i < matchedLandmarks.size(); ++i) {
                Double[] pt = matchedLandmarks.get(i);
                for (int d = 0; d < pt.length; ++d) {
                    long lo = (long)Math.floor(pt[d] / outputResolution[d]);
                    long hi = (long)Math.ceil(pt[d] / outputResolution[d]);
                    if (lo < min[d]) {
                        min[d] = lo;
                    }
                    if (hi <= max[d]) continue;
                    max[d] = hi;
                }
                ++numPoints;
            }
            System.out.println("Estimated field of view using " + numPoints + " landmarks.");
            for (int d = 0; d < min.length; ++d) {
                if (min[d] == Long.MAX_VALUE) {
                    System.err.println("Problem generating field of view from landmarks");
                    return null;
                }
                if (max[d] != Long.MIN_VALUE) continue;
                System.err.println("Problem generating field of view from landmarks");
                return null;
            }
            ArrayList<Interval> out = new ArrayList<Interval>();
            out.add((Interval)new FinalInterval(min, max));
            return out;
        }
        if (fieldOfViewOption.equals(LANDMARK_POINT_CUBE_PHYSICAL) || fieldOfViewOption.equals(LANDMARK_POINT_CUBE_PIXEL)) {
            List<Double[]> matchedLandmarks = ApplyBigwarpPlugin.getMatchedPoints(landmarks, fieldOfViewPointFilter);
            if (matchedLandmarks.isEmpty()) {
                System.err.println("No matching point found");
                return null;
            }
            int nd = landmarks.getNumdims();
            ArrayList<Interval> out = new ArrayList<Interval>();
            for (int i = 0; i < matchedLandmarks.size(); ++i) {
                int d;
                Double[] pt = matchedLandmarks.get(i);
                long[] min = new long[nd];
                long[] max = new long[nd];
                if (fieldOfViewOption.equals(LANDMARK_POINT_CUBE_PHYSICAL)) {
                    for (d = 0; d < nd; ++d) {
                        min[d] = (long)Math.floor(pt[d] / outputResolution[d] - fovSpec[d] / outputResolution[d]);
                        max[d] = (long)Math.ceil(pt[d] / outputResolution[d] + fovSpec[d] / outputResolution[d]);
                    }
                } else {
                    for (d = 0; d < nd; ++d) {
                        min[d] = (long)Math.floor(pt[d] / outputResolution[d] - fovSpec[d]) + 1L;
                        max[d] = (long)Math.ceil(pt[d] / outputResolution[d] + fovSpec[d]) - 1L;
                    }
                }
                out.add((Interval)new FinalInterval(min, max));
            }
            return out;
        }
        System.err.println("Invalid field of view option: ( " + fieldOfViewOption + " )");
        return null;
    }

    public static void fillMatchedPointNames(List<String> ptList, LandmarkTableModel landmarks, String fieldOfViewPointFilter) {
        Pattern r = null;
        if (!fieldOfViewPointFilter.isEmpty()) {
            r = Pattern.compile(fieldOfViewPointFilter);
        }
        for (int i = 0; i < landmarks.getRowCount(); ++i) {
            Double[] pt;
            if (r != null && !r.matcher(landmarks.getNames().get(i)).matches() || Double.isInfinite((pt = landmarks.getFixedPoint(i))[0])) continue;
            ptList.add(landmarks.getNames().get(i));
        }
    }

    public static List<Double[]> getMatchedPoints(LandmarkTableModel landmarks, String fieldOfViewPointFilter) {
        ArrayList<Double[]> ptList = new ArrayList<Double[]>();
        Pattern r = null;
        if (!fieldOfViewPointFilter.isEmpty()) {
            r = Pattern.compile(fieldOfViewPointFilter);
        }
        for (int i = 0; i < landmarks.getRowCount(); ++i) {
            Double[] pt;
            if (r != null && !r.matcher(landmarks.getNames().get(i)).matches() || Double.isInfinite((pt = landmarks.getFixedPoint(i))[0])) continue;
            ptList.add(pt);
            System.out.println("Using point with name : " + landmarks.getNames().get(i));
        }
        return ptList;
    }

    public static double[] getPixelOffset(String fieldOfViewOption, double[] offsetSpec, double[] outputResolution, Interval outputInterval) {
        double[] offset = new double[3];
        if (fieldOfViewOption.equals(SPECIFIED_PIXEL)) {
            System.arraycopy(offsetSpec, 0, offset, 0, offset.length);
            return offset;
        }
        if (fieldOfViewOption.equals(SPECIFIED_PHYSICAL)) {
            for (int d = 0; d < outputInterval.numDimensions(); ++d) {
                offset[d] = offsetSpec[d] / outputResolution[d];
            }
            return offset;
        }
        for (int d = 0; d < outputInterval.numDimensions(); ++d) {
            offset[d] = outputInterval.realMin(d);
        }
        return offset;
    }

    public static List<ImagePlus> apply(ImagePlus movingIp, ImagePlus targetIp, LandmarkTableModel landmarks, String tranformTypeOption, String fieldOfViewOption, String fieldOfViewPointFilter, String resolutionOption, double[] resolutionSpec, double[] fovSpec, double[] offsetSpec, Interpolation interp, boolean isVirtual, boolean wait, int nThreads) {
        BoundingBoxEstimation bboxEst = new BoundingBoxEstimation(BoundingBoxEstimation.Method.CORNERS);
        return ApplyBigwarpPlugin.apply(movingIp, targetIp, landmarks, tranformTypeOption, fieldOfViewOption, fieldOfViewPointFilter, bboxEst, resolutionOption, resolutionSpec, fovSpec, offsetSpec, interp, isVirtual, nThreads, wait, null);
    }

    public static List<ImagePlus> apply(ImagePlus movingIp, ImagePlus targetIp, LandmarkTableModel landmarks, String tranformTypeOption, String fieldOfViewOption, String fieldOfViewPointFilter, BoundingBoxEstimation bboxEst, String resolutionOption, double[] resolutionSpec, double[] fovSpec, double[] offsetSpec, Interpolation interp, boolean isVirtual, boolean wait, int nThreads) {
        return ApplyBigwarpPlugin.apply(movingIp, targetIp, landmarks, tranformTypeOption, fieldOfViewOption, fieldOfViewPointFilter, bboxEst, resolutionOption, resolutionSpec, fovSpec, offsetSpec, interp, isVirtual, nThreads, wait, null);
    }

    public static List<ImagePlus> apply(ImagePlus movingIp, ImagePlus targetIp, LandmarkTableModel landmarks, String tranformTypeOption, String fieldOfViewOption, String fieldOfViewPointFilter, BoundingBoxEstimation bboxEst, String resolutionOption, double[] resolutionSpec, double[] fovSpec, double[] offsetSpec, Interpolation interp, boolean isVirtual, int nThreads, boolean wait, WriteDestinationOptions writeOpts) {
        BigWarpData bwData = BigWarpInit.createBigWarpDataFromImages(movingIp, targetIp);
        return ApplyBigwarpPlugin.apply(bwData, landmarks, tranformTypeOption, fieldOfViewOption, fieldOfViewPointFilter, bboxEst, resolutionOption, resolutionSpec, fovSpec, offsetSpec, interp, isVirtual, nThreads, wait, writeOpts);
    }

    public static <T> List<ImagePlus> apply(BigWarpData<T> bwData, LandmarkTableModel landmarks, String tranformTypeOption, String fieldOfViewOption, String fieldOfViewPointFilter, String resolutionOption, double[] resolutionSpec, double[] fovSpec, double[] offsetSpec, Interpolation interp, boolean isVirtual, int nThreads, boolean wait, WriteDestinationOptions writeOpts) {
        BoundingBoxEstimation bboxEst = new BoundingBoxEstimation(BoundingBoxEstimation.Method.CORNERS);
        return ApplyBigwarpPlugin.apply(bwData, landmarks, tranformTypeOption, fieldOfViewOption, fieldOfViewPointFilter, bboxEst, resolutionOption, resolutionSpec, fovSpec, offsetSpec, interp, isVirtual, nThreads, wait, writeOpts);
    }

    public static <T> List<ImagePlus> apply(BigWarpData<T> bwData, LandmarkTableModel landmarks, String tranformTypeOption, String fieldOfViewOption, String fieldOfViewPointFilter, BoundingBoxEstimation bboxEst, String resolutionOption, double[] resolutionSpec, double[] fovSpec, double[] offsetSpec, Interpolation interp, boolean isVirtual, int nThreads, boolean wait, WriteDestinationOptions writeOpts) {
        int numChannels = bwData.numMovingSources();
        InvertibleRealTransform invXfm = new BigWarpTransform(landmarks, tranformTypeOption).getTransformation();
        for (int i = 0; i < numChannels; ++i) {
            SourceAndConverter<T> movingSource = bwData.getMovingSource(i);
            ((WarpedSource)movingSource.getSpimSource()).updateTransform((RealTransform)invXfm);
            ((WarpedSource)movingSource.getSpimSource()).setIsTransformed(true);
        }
        ProgressWriterIJ progressWriter = new ProgressWriterIJ();
        double[] res = ApplyBigwarpPlugin.getResolution(bwData, resolutionOption, resolutionSpec);
        List<Interval> outputIntervalList = ApplyBigwarpPlugin.getPixelInterval(bwData, landmarks, invXfm, fieldOfViewOption, fieldOfViewPointFilter, bboxEst, fovSpec, offsetSpec, res);
        ArrayList<String> matchedPtNames = new ArrayList<String>();
        if (outputIntervalList.size() > 1) {
            ApplyBigwarpPlugin.fillMatchedPointNames(matchedPtNames, landmarks, fieldOfViewPointFilter);
        }
        double[] offset = ApplyBigwarpPlugin.getPixelOffset(fieldOfViewOption, offsetSpec, res, outputIntervalList.get(0));
        if (writeOpts != null && writeOpts.n5Dataset != null && !writeOpts.n5Dataset.isEmpty()) {
            String unit = ApplyBigwarpPlugin.getUnit(bwData, resolutionOption);
            ApplyBigwarpPlugin.runN5Export(bwData, bwData.sources, fieldOfViewOption, outputIntervalList.get(0), interp, offset, res, unit, (ProgressWriter)progressWriter, writeOpts, Executors.newFixedThreadPool(nThreads));
            return null;
        }
        boolean show = writeOpts == null || writeOpts.pathOrN5Root == null || writeOpts.pathOrN5Root.isEmpty();
        return ApplyBigwarpPlugin.runExport(bwData, bwData.sources, fieldOfViewOption, outputIntervalList, matchedPtNames, interp, offset, res, isVirtual, nThreads, (ProgressWriter)progressWriter, show, wait, writeOpts);
    }

    public static <T> List<ImagePlus> runExport(BigWarpData<T> data, List<SourceAndConverter<T>> sources, String fieldOfViewOption, List<Interval> outputIntervalList, List<String> matchedPtNames, Interpolation interp, double[] offsetIn, double[] resolution, boolean isVirtual, int nThreads, ProgressWriter progressWriter, boolean show, boolean wait, WriteDestinationOptions writeOpts) {
        ArrayList<ImagePlus> ipList = new ArrayList<ImagePlus>();
        int i = 0;
        for (Interval outputInterval : outputIntervalList) {
            double[] offset = ApplyBigwarpPlugin.getPixelOffset(fieldOfViewOption, offsetIn, resolution, outputIntervalList.get(i));
            BigWarpExporter<?> exporter = BigWarpExporter.getExporter(data, sources, interp, progressWriter);
            exporter.setOutputList(ipList);
            exporter.setRenderResolution(resolution);
            exporter.setOffset(offset);
            exporter.setVirtual(isVirtual);
            exporter.setNumThreads(nThreads);
            if (writeOpts != null && writeOpts.pathOrN5Root != null) {
                exporter.setExportPath(writeOpts.pathOrN5Root);
            }
            exporter.setInterval(outputInterval);
            if (matchedPtNames.size() > 0) {
                exporter.setNameSuffix(matchedPtNames.get(i));
            }
            exporter.exportAsynch(wait, show);
            ++i;
        }
        return ipList;
    }

    private static double[] limit(int N, double[] x) {
        if (x.length <= N) {
            return x;
        }
        double[] out = new double[N];
        System.arraycopy(x, 0, out, 0, N);
        return out;
    }

    private static double[] physicalOffsetFromPixelInterval(RealInterval interval, double[] resolution) {
        int N = Math.min(interval.numDimensions(), resolution.length);
        double[] out = new double[N];
        for (int i = 0; i < N; ++i) {
            out[i] = resolution[i] * interval.realMin(i);
        }
        return out;
    }

    public static <S, T extends NativeType<T> & NumericType<T>> void runN5Export(BigWarpData<S> data, List<SourceAndConverter<S>> sources, String fieldOfViewOption, Interval outputInterval, Interpolation interp, double[] offsetArg, double[] resolutionArg, String unit, ProgressWriter progressWriter, WriteDestinationOptions writeOpts, ExecutorService exec) {
        String[] stringArray;
        N5Writer n5;
        int nd = BigWarp.detectNumDims(data.sources);
        double[] resolution = ApplyBigwarpPlugin.limit(nd, resolutionArg);
        double[] offset = ApplyBigwarpPlugin.physicalOffsetFromPixelInterval((RealInterval)outputInterval, resolution);
        String dataset = writeOpts.n5Dataset;
        int[] blockSize = writeOpts.blockSize;
        Compression compression = writeOpts.compression;
        if (dataset == null || dataset.isEmpty()) {
            System.err.println("Problem with n5 dataset path: " + dataset);
            return;
        }
        try {
            n5 = new N5Factory().openWriter(writeOpts.pathOrN5Root);
        }
        catch (RuntimeException e1) {
            System.err.println("Could not create n5 writer for: " + writeOpts.pathOrN5Root);
            e1.printStackTrace();
            return;
        }
        OmeNgffMetadataParser parser = new OmeNgffMetadataParser();
        if (nd == 2) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "x";
            stringArray = stringArray2;
            stringArray2[1] = "y";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "x";
            stringArray3[1] = "y";
            stringArray = stringArray3;
            stringArray3[2] = "z";
        }
        String[] axesLabels = stringArray;
        Axis[] axes = new Axis[nd];
        for (int i = 0; i < nd; ++i) {
            axes[i] = new Axis("space", axesLabels[i], unit);
        }
        AffineTransform3D resolutionTransform = new AffineTransform3D();
        resolutionTransform.set(resolution[0], 0, 0);
        resolutionTransform.set(resolution[1], 1, 1);
        if (resolution.length > 2) {
            resolutionTransform.set(resolution[2], 2, 2);
        }
        AffineTransform3D offsetTransform = new AffineTransform3D();
        offsetTransform.set(offset[0], 0, 3);
        offsetTransform.set(offset[1], 1, 3);
        if (resolution.length > 2) {
            offsetTransform.set(offset[2], 2, 3);
        }
        AffineTransform3D pixelRenderToPhysical = new AffineTransform3D();
        pixelRenderToPhysical.concatenate(resolutionTransform);
        pixelRenderToPhysical.concatenate(offsetTransform);
        int N = data.numMovingSources();
        for (int i = 0; i < N; ++i) {
            SourceAndConverter<S> originalMovingSource = data.getMovingSource(i);
            int movingSourceIndex = data.sources.indexOf(originalMovingSource);
            RealRandomAccessible raiRaw = sources.get(movingSourceIndex).getSpimSource().getInterpolatedSource(0, 0, interp);
            AffineRandomAccessible rai = RealViews.affine((RealRandomAccessible)raiRaw, (AffineGet)pixelRenderToPhysical.inverse());
            IntervalView img = Views.interval((RandomAccessible)Views.raster((RealRandomAccessible)rai), (Interval)Intervals.zeroMin((Interval)outputInterval));
            String srcName = originalMovingSource.getSpimSource().getName();
            String destDataset = dataset;
            if (N > 1) {
                destDataset = dataset + String.format("/%s", srcName.replace(" ", "_"));
            }
            IntervalView imgToWrite = nd == 2 ? Views.hyperSlice((RandomAccessibleInterval)img, (int)2, (long)0L) : img;
            String name = originalMovingSource.getSpimSource().getName();
            OmeNgffMetadata metadata = OmeNgffMetadata.buildForWriting((int)nd, (String)name, (Axis[])axes, (String[])new String[]{"s0"}, (double[][])new double[][]{resolution}, (double[][])new double[][]{offset});
            try {
                N5Utils.save((RandomAccessibleInterval)imgToWrite, (N5Writer)n5, (String)(destDataset + "/s0"), (int[])blockSize, (Compression)compression, (ExecutorService)exec);
                if (parser != null && metadata != null) {
                    parser.writeMetadata(metadata, n5, destDataset);
                }
                n5.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            progressWriter.setProgress((double)(i + 1) / (double)N);
        }
        progressWriter.setProgress(1.0);
    }

    public void run(String arg) {
        if (IJ.versionLessThan((String)"1.40")) {
            return;
        }
        int[] ids = WindowManager.getIDList();
        int N = ids == null ? 0 : ids.length;
        String[] titles = new String[N + 1];
        for (int i = 0; i < N; ++i) {
            titles[i] = WindowManager.getImage((int)ids[i]).getTitle();
        }
        titles[N] = "<None>";
        GenericDialogPlus gd = new GenericDialogPlus("Apply Big Warp transform");
        gd.addMessage("File Selection:");
        gd.addFileField("landmarks_image_file", "");
        ImagePlus currimg = WindowManager.getCurrentImage();
        String current = titles[N];
        if (currimg != null) {
            current = currimg.getTitle();
        }
        gd.addChoice("moving_image", titles, current);
        if (titles.length > 1) {
            gd.addChoice("target_image", titles, current.equals(titles[0]) ? titles[1] : titles[0]);
        } else {
            gd.addChoice("target_image", titles, titles[0]);
        }
        gd.addMessage("\nN5/Zarr/HDF5/BDV-XML");
        gd.addDirectoryOrFileField(MOVING, "");
        gd.addStringField("Moving_dataset", "");
        gd.addDirectoryOrFileField(TARGET, "");
        gd.addStringField("Target_dataset", "");
        gd.addChoice("Transform type", new String[]{"Thin Plate Spline", "Affine", "Similarity", "Rotation", "Translation"}, "Thin Plate Spline");
        gd.addMessage("Field of view and resolution:");
        gd.addChoice("Resolution", new String[]{TARGET, MOVING, SPECIFIED}, TARGET);
        gd.addChoice("Field of view", new String[]{TARGET, MOVING_WARPED, LANDMARK_POINTS, SPECIFIED_PIXEL, SPECIFIED_PHYSICAL}, TARGET);
        gd.addChoice("Bounding box estimation", new String[]{BoundingBoxEstimation.Method.CORNERS.toString(), BoundingBoxEstimation.Method.FACES.toString(), BoundingBoxEstimation.Method.VOLUME.toString()}, BoundingBoxEstimation.Method.FACES.toString());
        gd.addNumericField("samples per dimension", 5.0, 0);
        gd.addStringField("point filter", "");
        gd.addMessage("Resolution");
        gd.addNumericField("x", 1.0, 4);
        gd.addNumericField("y", 1.0, 4);
        gd.addNumericField("z", 1.0, 4);
        gd.addMessage("Offset");
        gd.addNumericField("x", 0.0, 4);
        gd.addNumericField("y", 0.0, 4);
        gd.addNumericField("z", 0.0, 4);
        gd.addMessage("Field of view");
        gd.addNumericField("x", -1.0, 0);
        gd.addNumericField("y", -1.0, 0);
        gd.addNumericField("z", -1.0, 0);
        gd.addMessage("Output options");
        gd.addChoice("Interpolation", new String[]{"Nearest Neighbor", "Linear"}, "Linear");
        gd.addCheckbox("virtual?", false);
        gd.addNumericField("threads", 4.0, 0);
        gd.addMessage("Writing options (leave empty to opena new image window)");
        gd.addDirectoryOrFileField("File_or_n5_root", "");
        gd.addStringField("n5_dataset", "");
        gd.addStringField("n5_block_size", "32");
        gd.addChoice("n5_compression", new String[]{"gzip", "raw", "lz4", "xz", "blosc"}, "gzip");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String landmarksPath = gd.getNextString();
        ImagePlus movingIp = null;
        ImagePlus targetIp = null;
        int mvgImgIdx = gd.getNextChoiceIndex();
        int tgtImgIdx = gd.getNextChoiceIndex();
        movingIp = mvgImgIdx < N ? WindowManager.getImage((int)ids[mvgImgIdx]) : null;
        targetIp = tgtImgIdx < N ? WindowManager.getImage((int)ids[tgtImgIdx]) : null;
        String mvgRoot = gd.getNextString();
        String mvgDataset = gd.getNextString();
        String tgtRoot = gd.getNextString();
        String tgtDataset = gd.getNextString();
        String transformTypeOption = gd.getNextChoice();
        String resOption = gd.getNextChoice();
        String fovOption = gd.getNextChoice();
        String bboxOption = gd.getNextChoice();
        int bboxSamples = (int)gd.getNextNumber();
        String fovPointFilter = gd.getNextString();
        double[] resolutions = new double[]{gd.getNextNumber(), gd.getNextNumber(), gd.getNextNumber()};
        double[] offset = new double[]{gd.getNextNumber(), gd.getNextNumber(), gd.getNextNumber()};
        double[] fov = new double[]{gd.getNextNumber(), gd.getNextNumber(), gd.getNextNumber()};
        String interpType = gd.getNextChoice();
        boolean isVirtual = gd.getNextBoolean();
        int nThreads = (int)gd.getNextNumber();
        String fileOrN5Root = gd.getNextString();
        String n5Dataset = gd.getNextString();
        String blockSizeString = gd.getNextString();
        String compressionString = gd.getNextChoice();
        BigWarpData bigwarpdata = BigWarpInit.initData();
        int id = 0;
        if (movingIp != null) {
            id += BigWarpInit.add(bigwarpdata, movingIp, id, 0, true);
        } else if (mvgDataset != null && !mvgDataset.isEmpty()) {
            BigWarpInit.addToData(bigwarpdata, true, id, mvgRoot, mvgDataset);
            ++id;
        } else if (mvgRoot != null && !mvgRoot.isEmpty()) {
            try {
                ImagePlus movingFromFile = IJ.openImage((String)mvgRoot);
                id += BigWarpInit.add(bigwarpdata, movingFromFile, id, 0, true);
            }
            catch (Exception e) {
                IJ.showMessage((String)("could not read from file: " + mvgRoot));
                return;
            }
        }
        if (targetIp != null) {
            id += BigWarpInit.add(bigwarpdata, targetIp, id, 0, false);
        } else if (tgtDataset != null && !tgtDataset.isEmpty()) {
            BigWarpInit.addToData(bigwarpdata, false, id, tgtRoot, tgtDataset);
            ++id;
        } else if (tgtRoot != null && !tgtRoot.isEmpty()) {
            try {
                ImagePlus targetFromFile = IJ.openImage((String)tgtRoot);
                id += BigWarpInit.add(bigwarpdata, targetFromFile, id, 0, false);
            }
            catch (Exception targetFromFile) {
                // empty catch block
            }
        }
        int nd = BigWarp.detectNumDims(bigwarpdata.sources);
        BigWarp.wrapMovingSources(nd, bigwarpdata);
        int[] blockSize = ApplyBigwarpPlugin.parseBlockSize(blockSizeString, nd);
        Compression compression = ApplyBigwarpPlugin.getCompression(compressionString);
        WriteDestinationOptions writeOpts = new WriteDestinationOptions(fileOrN5Root, n5Dataset, blockSize, compression);
        LandmarkTableModel ltm = new LandmarkTableModel(nd);
        try {
            ltm.load(new File(landmarksPath));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Interpolation interp = interpType.equals("Nearest Neighbor") ? Interpolation.NEARESTNEIGHBOR : Interpolation.NLINEAR;
        BoundingBoxEstimation bboxEst = new BoundingBoxEstimation(BoundingBoxEstimation.Method.valueOf(bboxOption), bboxSamples);
        List<ImagePlus> warpedIpList = ApplyBigwarpPlugin.apply(bigwarpdata, ltm, transformTypeOption, fovOption, fovPointFilter, bboxEst, resOption, resolutions, fov, offset, interp, isVirtual, nThreads, false, writeOpts);
    }

    public static int[] parseBlockSize(String blockSizeArg, int nd) {
        int i;
        if (blockSizeArg.isEmpty()) {
            return null;
        }
        int[] blockSize = new int[nd];
        String[] blockArgList = blockSizeArg.split(",");
        for (i = 0; i < blockArgList.length && i < nd; ++i) {
            blockSize[i] = Integer.parseInt(blockArgList[i]);
        }
        int N = blockArgList.length - 1;
        while (i < nd) {
            blockSize[i] = blockSize[N];
            ++i;
        }
        return blockSize;
    }

    public static Compression getCompression(String compressionArg) {
        switch (compressionArg) {
            case "gzip": {
                return new GzipCompression();
            }
            case "lz4": {
                return new Lz4Compression();
            }
            case "xz": {
                return new XzCompression();
            }
            case "raw": {
                return new RawCompression();
            }
            case "blosc": {
                return new BloscCompression();
            }
        }
        return new RawCompression();
    }

    public static class WriteDestinationOptions {
        public final String pathOrN5Root;
        public final String n5Dataset;
        public final int[] blockSize;
        public final Compression compression;

        public WriteDestinationOptions(String pathOrN5Root, String n5Dataset, int[] blockSize, Compression compression) {
            this.pathOrN5Root = pathOrN5Root;
            this.n5Dataset = n5Dataset;
            this.blockSize = blockSize;
            this.compression = compression;
        }
    }
}

