/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bdv.util.Affine3DHelpers;
import bdv.viewer.BigWarpViewerPanel;
import bdv.viewer.overlay.BigWarpMaskSphereOverlay;
import bigwarp.BigWarp;
import bigwarp.source.PlateauSphericalMaskRealRandomAccessible;
import bigwarp.transforms.AbstractTransformSolver;
import bigwarp.transforms.MaskedSimRotTransformSolver;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;

public class MaskedSourceEditorMouseListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected PlateauSphericalMaskRealRandomAccessible mask;
    protected BigWarpViewerPanel viewer;
    protected List<BigWarpMaskSphereOverlay> overlays;
    private boolean active;
    private boolean dragged = false;
    private RealPoint p;
    private RealPoint c;
    private RealPoint pressPt;
    private BigWarp<?> bw;
    private static final double fastSpeed = 10.0;
    private static final double slowSpeed = 0.1;

    public MaskedSourceEditorMouseListener(int nd, BigWarp<?> bw, BigWarpViewerPanel viewer) {
        this.bw = bw;
        this.viewer = viewer;
        this.viewer.getDisplay().addMouseListener((MouseListener)this);
        this.viewer.getDisplay().addMouseWheelListener((MouseWheelListener)this);
        this.viewer.getDisplay().addMouseMotionListener((MouseMotionListener)this);
        this.overlays = new ArrayList<BigWarpMaskSphereOverlay>();
        this.overlays.add(bw.getViewerFrameP().getViewerPanel().getMaskOverlay());
        this.overlays.add(bw.getViewerFrameQ().getViewerPanel().getMaskOverlay());
        this.p = new RealPoint(3);
        this.c = new RealPoint(3);
        this.pressPt = new RealPoint(3);
        this.active = false;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.bw.getViewerFrameP().setTransformEnabled(!active);
        this.bw.getViewerFrameQ().setTransformEnabled(!active);
        String msg = active ? "Mask Edit On" : "Mask Edit Off";
        this.bw.getViewerFrameP().getViewerPanel().showMessage(msg);
        this.bw.getViewerFrameQ().getViewerPanel().showMessage(msg);
    }

    public void toggleActive() {
        this.setActive(!this.active);
    }

    public void setMask(PlateauSphericalMaskRealRandomAccessible mask) {
        this.mask = mask;
    }

    public PlateauSphericalMaskRealRandomAccessible getMask() {
        return this.mask;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.active) {
            return;
        }
        this.dragged = false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.active) {
            return;
        }
        if (!this.dragged) {
            this.mask.getCenter().localize((RealPositionable)this.c);
            this.viewer.getGlobalMouseCoordinates((RealPositionable)this.pressPt);
            this.dragged = true;
        }
        this.viewer.getGlobalMouseCoordinates((RealPositionable)this.p);
        this.bw.setAutoEstimateMask(false);
        if (e.isControlDown()) {
            this.mask.getCenter().localize((RealPositionable)this.c);
            double d = PlateauSphericalMaskRealRandomAccessible.squaredDistance((RealLocalizable)this.p, (RealLocalizable)this.c);
            PlateauSphericalMaskRealRandomAccessible plateauSphericalMaskRealRandomAccessible = this.mask;
            synchronized (plateauSphericalMaskRealRandomAccessible) {
                this.mask.setSquaredRadius(d);
            }
        }
        if (e.isShiftDown()) {
            this.mask.getCenter().localize((RealPositionable)this.c);
            double d = Math.sqrt(PlateauSphericalMaskRealRandomAccessible.squaredDistance((RealLocalizable)this.p, (RealLocalizable)this.c));
            PlateauSphericalMaskRealRandomAccessible plateauSphericalMaskRealRandomAccessible = this.mask;
            synchronized (plateauSphericalMaskRealRandomAccessible) {
                this.mask.setSigma(d - Math.sqrt(this.mask.getSquaredRadius()));
            }
        }
        for (int i = 0; i < this.p.numDimensions(); ++i) {
            this.p.setPosition(this.c.getDoublePosition(i) + this.p.getDoublePosition(i) - this.pressPt.getDoublePosition(i), i);
        }
        PlateauSphericalMaskRealRandomAccessible i = this.mask;
        synchronized (i) {
            this.mask.setCenter((RealLocalizable)this.p);
        }
        AbstractTransformSolver<?> solver = this.bw.getBwTransform().getSolver();
        if (solver instanceof MaskedSimRotTransformSolver) {
            ((MaskedSimRotTransformSolver)solver).setCenter((RealLocalizable)this.p);
        }
        this.bw.getViewerFrameP().getViewerPanel().requestRepaint();
        this.bw.getViewerFrameQ().getViewerPanel().requestRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.active) {
            return;
        }
        if (e.isControlDown() || e.isShiftDown()) {
            return;
        }
        if (!this.dragged) {
            this.viewer.getGlobalMouseCoordinates((RealPositionable)this.pressPt);
            PlateauSphericalMaskRealRandomAccessible plateauSphericalMaskRealRandomAccessible = this.mask;
            synchronized (plateauSphericalMaskRealRandomAccessible) {
                this.mask.setCenter((RealLocalizable)this.pressPt);
            }
            this.bw.setAutoEstimateMask(false);
            this.bw.getViewerFrameP().getViewerPanel().requestRepaint();
            this.bw.getViewerFrameQ().getViewerPanel().requestRepaint();
        } else {
            this.dragged = false;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.active) {
            return;
        }
        this.bw.setAutoEstimateMask(false);
        AffineTransform3D transform = this.viewer.state().getViewerTransform();
        double scale = 1.0 / (Affine3DHelpers.extractScale((AffineTransform3D)transform, (int)0) + 1.0E-9) + 1.0E-6;
        int sign = e.getWheelRotation();
        if (e.isShiftDown()) {
            this.mask.incSquaredSigma((double)sign * scale * scale * 10.0 * 10.0);
        } else if (e.isControlDown()) {
            this.mask.incSquaredSigma((double)sign * scale * scale * 0.1 * 0.1);
        } else {
            this.mask.incSquaredSigma((double)sign * scale * scale);
        }
        this.bw.getViewerFrameP().getViewerPanel().requestRepaint();
        this.bw.getViewerFrameQ().getViewerPanel().requestRepaint();
    }
}

