/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bdv.gui.ImprovedFormattedTextField;
import bdv.ij.ApplyBigwarpPlugin;
import bigwarp.BigWarpData;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.transforms.BigWarpTransform;
import com.formdev.flatlaf.util.UIScale;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.imglib2.Interval;
import net.imglib2.realtransform.BoundingBoxEstimation;

public class FieldOfViewPanel
extends JPanel {
    private static final long serialVersionUID = 1719652204751351335L;
    private static final int DEFAULT_OUTER_PAD = 8;
    private static final int DEFAULT_BUTTON_PAD = 3;
    private static final int DEFAULT_MID_PAD = 5;
    private BigWarpData<?> data;
    private LandmarkTableModel ltm;
    private BigWarpTransform bwTransform;
    private String unit;
    private int ndims;
    private int textFieldWidth;
    private double[] initMin;
    private double[] initSpacing;
    private long[] initPixsize;
    private double[] min;
    private double[] spacing;
    private double[] size;
    private long[] pixSize;
    private JComboBox<String> referenceComboBox;
    private JTextField unitField;
    private JLabel sizeLabel;
    private ImprovedFormattedTextField[] minFields;
    private ImprovedFormattedTextField[] sizeFields;
    private ImprovedFormattedTextField[] spacingFields;
    private ImprovedFormattedTextField[] pixelFields;

    public FieldOfViewPanel(LandmarkTableModel ltm, BigWarpTransform bwTransform, String unit, int textFieldWidth, double[] initMin, double[] initSpacing, long[] initPixsize) {
        this(null, ltm, bwTransform, unit, textFieldWidth, initMin, initSpacing, initPixsize);
    }

    public FieldOfViewPanel(BigWarpData<?> data, LandmarkTableModel ltm, BigWarpTransform bwTransform, String unit, int textFieldWidth, double[] initMin, double[] initSpacing, long[] initPixsize) {
        this.data = data;
        this.ltm = ltm;
        this.bwTransform = bwTransform;
        this.ndims = ltm != null ? ltm.getNumdims() : 3;
        this.unit = unit;
        this.textFieldWidth = textFieldWidth;
        this.initMin = initMin;
        this.initSpacing = initSpacing;
        this.initPixsize = initPixsize;
        this.min = new double[this.ndims];
        System.arraycopy(initMin, 0, this.min, 0, this.ndims);
        this.spacing = new double[this.ndims];
        System.arraycopy(initSpacing, 0, this.spacing, 0, this.ndims);
        this.pixSize = new long[this.ndims];
        System.arraycopy(initPixsize, 0, this.pixSize, 0, this.ndims);
        this.size = new double[this.ndims];
        for (int i = 0; i < this.ndims; ++i) {
            this.size[i] = this.spacing[i] * (double)this.pixSize[i];
        }
        this.create();
    }

    public double[] getMin() {
        return this.min;
    }

    public void setMin(double[] newMin) {
        int N = newMin.length > this.min.length ? this.min.length : newMin.length;
        for (int i = 0; i < N; ++i) {
            this.minFields[i].setValue(new Double(newMin[i]), false);
            this.min[i] = newMin[i];
        }
    }

    public double[] getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double[] newSpacing) {
        int N = newSpacing.length > this.spacing.length ? this.spacing.length : newSpacing.length;
        for (int i = 0; i < N; ++i) {
            this.spacingFields[i].setValue(new Double(newSpacing[i]), false);
            this.spacing[i] = newSpacing[i];
        }
    }

    public double[] getPhysicalSize() {
        return this.size;
    }

    public long[] getPixelSize() {
        return this.pixSize;
    }

    public void setPixelSize(long[] newSize) {
        int N = newSize.length > this.pixSize.length ? this.pixSize.length : newSize.length;
        for (int i = 0; i < N; ++i) {
            this.pixelFields[i].setValue(new Long(newSize[i]), false);
            this.pixSize[i] = newSize[i];
        }
    }

    public String getUnit() {
        return this.unitField.getText();
    }

    public void setUnit(String unit) {
        this.unitField.setText(unit);
        this.updateSizeLabel();
    }

    private void updateSizeLabel() {
        this.sizeLabel.setText(String.format("size (%s)", this.unitField.getText()));
    }

    public void create() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 8, 5, 3);
        int j = 1;
        if (this.data != null) {
            this.add((Component)new JLabel("reference:"), gbc);
            String[] fovOpts = new String[]{"Specified", "Target", "Moving (warped)", "Landmark points"};
            this.referenceComboBox = new JComboBox<String>(fovOpts);
            this.referenceComboBox.setSelectedItem("Moving (warped)");
            this.referenceComboBox.addActionListener(e -> this.updateFieldsFromReference());
            gbc.gridx = 1;
            this.add(this.referenceComboBox, gbc);
            j = 2;
        } else if (IJ.getInstance() != null) {
            this.add((Component)new JLabel("reference:"), gbc);
            String[] impTitles = this.getImagePlusTitles();
            int numImp = 0;
            if (impTitles != null) {
                numImp = impTitles.length;
            }
            String[] fovOpts = new String[numImp + 1];
            fovOpts[0] = "Specified";
            for (int i = 0; i < numImp; ++i) {
                fovOpts[i + 1] = impTitles[i];
            }
            this.referenceComboBox = new JComboBox<String>(fovOpts);
            if (impTitles.length > 0) {
                this.referenceComboBox.setSelectedIndex(1);
            }
            this.referenceComboBox.addActionListener(e -> this.updateFieldsFromImageJReference());
            gbc.gridx = 1;
            this.add(this.referenceComboBox, gbc);
            j = 2;
        }
        JLabel unitLabel = new JLabel("units:");
        gbc.gridx = 2;
        gbc.anchor = 22;
        this.add((Component)unitLabel, gbc);
        gbc.gridx = 3;
        gbc.fill = 2;
        gbc.anchor = 10;
        this.unitField = new JTextField("pixel");
        this.unitField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FieldOfViewPanel.this.updateSizeLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FieldOfViewPanel.this.updateSizeLabel();
            }
        });
        this.add((Component)this.unitField, gbc);
        JLabel minLabel = new JLabel(String.format("min (%s)", this.unit));
        this.sizeLabel = new JLabel(String.format("size (%s)", this.unit));
        JLabel spacingLabel = new JLabel(String.format("spacing (%s/px)", this.unit));
        JLabel pixelLabel = new JLabel("size (px)");
        ++gbc.gridy;
        gbc.gridx = 1;
        this.add((Component)minLabel, gbc);
        gbc.gridx = 2;
        this.add((Component)this.sizeLabel, gbc);
        gbc.gridx = 3;
        this.add((Component)spacingLabel, gbc);
        gbc.gridx = 4;
        this.add((Component)pixelLabel, gbc);
        JLabel yLabel = new JLabel("y");
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 22;
        JLabel xLabel = new JLabel("x");
        this.add((Component)xLabel, gbc);
        ++gbc.gridy;
        this.add((Component)yLabel, gbc);
        if (this.ndims >= 3) {
            ++gbc.gridy;
            JLabel zLabel = new JLabel("z");
            this.add((Component)zLabel, gbc);
        }
        this.minFields = new ImprovedFormattedTextField[this.ndims];
        this.sizeFields = new ImprovedFormattedTextField[this.ndims];
        this.spacingFields = new ImprovedFormattedTextField[this.ndims];
        this.pixelFields = new ImprovedFormattedTextField[this.ndims];
        gbc.fill = 2;
        int textWidthScaled = UIScale.scale((int)this.textFieldWidth);
        int textHeight = UIScale.scale((int)20);
        Dimension textFieldSize = new Dimension(textWidthScaled, textHeight);
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(8);
        for (int i = 0; i < this.ndims; ++i) {
            gbc.gridy = i + j;
            gbc.gridx = 1;
            this.minFields[i] = new ImprovedFormattedTextField(decimalFormat);
            this.minFields[i].setPreferredSize(textFieldSize);
            this.minFields[i].setHorizontalAlignment(4);
            this.minFields[i].setValueNoCallback(new Double(this.initMin[i]));
            this.add((Component)this.minFields[i], gbc);
            gbc.gridx = 2;
            this.sizeFields[i] = new ImprovedFormattedTextField(decimalFormat);
            this.sizeFields[i].setPreferredSize(textFieldSize);
            this.sizeFields[i].setHorizontalAlignment(4);
            this.sizeFields[i].setValueNoCallback(new Double(this.initSpacing[i] * (double)this.initPixsize[i]));
            this.add((Component)this.sizeFields[i], gbc);
            gbc.gridx = 3;
            this.spacingFields[i] = new ImprovedFormattedTextField(decimalFormat);
            this.spacingFields[i].setPreferredSize(textFieldSize);
            this.spacingFields[i].setHorizontalAlignment(4);
            this.spacingFields[i].setValueNoCallback(new Double(this.initSpacing[i]));
            this.add((Component)this.spacingFields[i], gbc);
            gbc.gridx = 4;
            this.pixelFields[i] = new ImprovedFormattedTextField(NumberFormat.getIntegerInstance());
            this.pixelFields[i].setPreferredSize(textFieldSize);
            this.pixelFields[i].setHorizontalAlignment(4);
            this.pixelFields[i].setValueNoCallback(new Long(this.initPixsize[i]));
            this.add((Component)this.pixelFields[i], gbc);
            int idx = i;
            this.minFields[i].setCallback(() -> {
                try {
                    this.min[idx] = Double.parseDouble(this.minFields[idx].getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.sizeFields[i].setCallback(() -> {
                try {
                    this.size[idx] = Double.parseDouble(this.sizeFields[idx].getText());
                    this.updatePixelsFromSize(idx);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.spacingFields[i].setCallback(() -> {
                try {
                    this.spacing[idx] = Double.parseDouble(this.spacingFields[idx].getText());
                    this.updateSize(idx);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.pixelFields[i].setCallback(() -> {
                try {
                    this.pixSize[idx] = Long.parseLong(this.pixelFields[idx].getText());
                    this.updateSize(idx);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }
    }

    protected void updatePixelsFromSize(int i) {
        this.pixSize[i] = (long)Math.ceil(this.size[i] / this.spacing[i]);
        SwingUtilities.invokeLater(() -> this.pixelFields[i].setValueNoCallback(new Double(this.pixSize[i])));
    }

    protected void updatePixelsFromSpacing(int i) {
        this.pixSize[i] = (long)Math.floor(this.size[i] / this.spacing[i]);
        SwingUtilities.invokeLater(() -> this.pixelFields[i].setValueNoCallback(new Long(this.pixSize[i])));
    }

    protected void updateSpacingFromPixels(int i) {
        this.spacing[i] = this.size[i] / (double)this.pixSize[i];
        SwingUtilities.invokeLater(() -> this.spacingFields[i].setValueNoCallback(new Double(this.spacing[i])));
    }

    protected void updateSize(int i) {
        this.size[i] = this.spacing[i] * (double)this.pixSize[i];
        SwingUtilities.invokeLater(() -> this.sizeFields[i].setValueNoCallback(new Double(this.size[i])));
    }

    protected void updateFieldsFromReference() {
        if (this.data == null || this.bwTransform == null) {
            return;
        }
        String referenceOption = (String)this.referenceComboBox.getSelectedItem();
        if (referenceOption.equals("Specified")) {
            return;
        }
        double[] res = ApplyBigwarpPlugin.getResolution(this.data, referenceOption, null);
        if (res != null) {
            this.setSpacing(res);
        }
        List<Interval> itvl = ApplyBigwarpPlugin.getPixelInterval(this.data, this.ltm, this.bwTransform.getTransformation(false), referenceOption, "", new BoundingBoxEstimation(), null, null, this.getSpacing());
        double[] offset = ApplyBigwarpPlugin.getPixelOffset(referenceOption, null, res, itvl.get(0));
        this.setPixelSize(itvl.get(0).dimensionsAsLongArray());
        this.setMin(offset);
        this.setUnit(ApplyBigwarpPlugin.getUnit(this.data, referenceOption));
        for (int i = 0; i < this.size.length; ++i) {
            this.updateSize(i);
        }
    }

    protected String[] getImagePlusTitles() {
        if (IJ.getInstance() != null) {
            return WindowManager.getImageTitles();
        }
        return null;
    }

    protected void updateFieldsFromImageJReference() {
        String referenceOption = (String)this.referenceComboBox.getSelectedItem();
        if (referenceOption.equals("Specified")) {
            return;
        }
        if (IJ.getInstance() != null) {
            ImagePlus refImp = WindowManager.getImage((String)((String)this.referenceComboBox.getSelectedItem()));
            this.setSpacing(new double[]{refImp.getCalibration().pixelWidth, refImp.getCalibration().pixelHeight, refImp.getCalibration().pixelDepth});
            this.setMin(new double[]{refImp.getCalibration().xOrigin, refImp.getCalibration().yOrigin, refImp.getCalibration().zOrigin});
            this.setPixelSize(new long[]{refImp.getWidth(), refImp.getHeight(), refImp.getNSlices()});
            this.setUnit(refImp.getCalibration().getUnit());
        }
    }
}

