/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.json;

import com.azul.crs.json.JSONSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DummyJSONSerializer
implements JSONSerializer {
    private boolean doFormat = Boolean.getBoolean("com.azul.crs.client.enablePrettyPrint");
    private int level = 0;
    private int tabs = 2;
    private static final String escape3Text = "\"\\/\b\f\n\r\t";
    private static final Pattern escape3Pattern = Pattern.compile("[\"\\\\/\b\f\n\r\t\u0000-\u001f]");
    private static final String[] escape3Replacement = new String[]{"\\\\\"", "\\\\\\\\", "\\\\/", "\\\\b", "\\\\f", "\\\\n", "\\\\r", "\\\\t"};

    public DummyJSONSerializer() {
    }

    public DummyJSONSerializer(boolean bl) {
        this.doFormat |= bl;
    }

    void formatEnter(StringBuilder stringBuilder) {
        if (!this.doFormat) {
            return;
        }
        ++this.level;
    }

    void formatMid(StringBuilder stringBuilder) {
        if (!this.doFormat) {
            return;
        }
        stringBuilder.append("\n");
        for (int i = 0; i < this.tabs * this.level; ++i) {
            stringBuilder.append(' ');
        }
    }

    void formatLeave(StringBuilder stringBuilder) {
        if (!this.doFormat) {
            return;
        }
        --this.level;
    }

    private static boolean fieldFilter(Field field) {
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        return !"hash".equals(field.getName()) || !"java.lang.String".equals(field.getDeclaringClass().getName());
    }

    StringBuilder serializeEnum(StringBuilder stringBuilder, Enum enum_) {
        return stringBuilder.append('\"').append(enum_.name()).append('\"');
    }

    private static boolean isNumberOrBoolean(Object object) {
        return object instanceof Number || object instanceof Boolean;
    }

    StringBuilder serializeNumberOrBoolean(StringBuilder stringBuilder, Object object) {
        return stringBuilder.append(object.toString());
    }

    StringBuilder serializeString(StringBuilder stringBuilder, String string) {
        StringBuffer stringBuffer = new StringBuffer((int)((float)string.length() * 1.1f) + 2);
        Matcher matcher = escape3Pattern.matcher(string);
        stringBuffer.append('\"');
        while (matcher.find()) {
            char c = matcher.group().charAt(0);
            int n = escape3Text.indexOf(c);
            matcher.appendReplacement(stringBuffer, n >= 0 ? escape3Replacement[n] : String.format("\\\\u%04x", c));
        }
        matcher.appendTail(stringBuffer);
        stringBuffer.append('\"');
        return stringBuilder.append(stringBuffer.toString());
    }

    StringBuilder serializeMap(StringBuilder stringBuilder, Map map) {
        stringBuilder.append('{');
        this.formatEnter(stringBuilder);
        int n = 0;
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            if (v == null) continue;
            if (n > 0) {
                stringBuilder.append(',');
            }
            this.formatMid(stringBuilder);
            ++n;
            this.serialize(stringBuilder, k).append(':');
            this.serialize(stringBuilder, v);
        }
        this.formatLeave(stringBuilder);
        if (n > 0) {
            this.formatMid(stringBuilder);
        }
        return stringBuilder.append('}');
    }

    StringBuilder serializeCollection(StringBuilder stringBuilder, Collection collection) {
        stringBuilder.append('[');
        this.formatEnter(stringBuilder);
        int n = 0;
        for (Object e : collection) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            this.formatMid(stringBuilder);
            ++n;
            this.serialize(stringBuilder, e);
        }
        this.formatLeave(stringBuilder);
        if (n > 0) {
            this.formatMid(stringBuilder);
        }
        return stringBuilder.append(']');
    }

    private StringBuilder printFieldName(StringBuilder stringBuilder, Field field) {
        return this.serializeString(stringBuilder, field.getName());
    }

    StringBuilder serializeObject(StringBuilder stringBuilder, Object object) {
        if (null == object) {
            return stringBuilder.append("null");
        }
        stringBuilder.append('{');
        this.formatEnter(stringBuilder);
        Class<?> clazz = object.getClass();
        int n = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (!DummyJSONSerializer.fieldFilter(field)) continue;
            field.setAccessible(true);
            Object object2 = null;
            try {
                object2 = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                throw new RuntimeException("Tykwa: ", illegalAccessException);
            }
            if (object2 == null) continue;
            if (n > 0) {
                stringBuilder.append(',');
            }
            this.formatMid(stringBuilder);
            this.printFieldName(stringBuilder, field).append(':');
            this.serialize(stringBuilder, object2);
            ++n;
        }
        this.formatLeave(stringBuilder);
        if (n > 0) {
            this.formatMid(stringBuilder);
        }
        return stringBuilder.append('}');
    }

    @Override
    public StringBuilder serialize(StringBuilder stringBuilder, Object object) {
        if (null == object) {
            return null;
        }
        if (object instanceof String) {
            return this.serializeString(stringBuilder, (String)object);
        }
        if (object instanceof Enum) {
            return this.serializeEnum(stringBuilder, (Enum)object);
        }
        if (DummyJSONSerializer.isNumberOrBoolean(object)) {
            return this.serializeNumberOrBoolean(stringBuilder, object);
        }
        if (object instanceof Map) {
            return this.serializeMap(stringBuilder, (Map)object);
        }
        if (object instanceof Collection) {
            return this.serializeCollection(stringBuilder, (Collection)object);
        }
        return this.serializeObject(stringBuilder, object);
    }

    @Override
    public String serialize(Object object) {
        return this.serialize(new StringBuilder(), object).toString();
    }
}

